#include "stdafx.h"
#include "FindWin.h"

#define _MAX_COUNT_WINDOW_ 5000

struct strFindWin
{
	TCHAR fCaption[255];
	TCHAR fClass[255];
	int fWidth;
	int fHeight;
	HWND fHWND;
	int CountFind;
	HWND fmasHWND[_MAX_COUNT_WINDOW_];
};

HWND FindWin (TCHAR *WinClass, TCHAR *WinTitle, int wWidth, int wHeight)
{
	int i;
	static strFindWin sFindWin;

	wcscpy_s(sFindWin.fCaption, 255, WinTitle);
	wcscpy_s(sFindWin.fClass, 255, WinClass);
	sFindWin.fWidth = wWidth;
	sFindWin.fHeight = wHeight;
	sFindWin.fHWND = NULL;
	sFindWin.CountFind=0;
	EnumWindows((WNDENUMPROC)EnumWinProc, (LPARAM)&sFindWin);
	if (sFindWin.fHWND != NULL)
		return sFindWin.fHWND;
	else
	{
		i=0;
		while ( (i<sFindWin.CountFind) && (sFindWin.fHWND == NULL) && (sFindWin.CountFind < _MAX_COUNT_WINDOW_) )
			EnumChildWindows(sFindWin.fmasHWND[i++], (WNDENUMPROC)EnumWinProc, (LPARAM)&sFindWin);
	}
	return sFindWin.fHWND;
}

HWND FindWin(TCHAR *WinClass, TCHAR *WinTitle)
{
	return FindWin(WinClass, WinTitle, -1, -1);
}

BOOL CALLBACK EnumWinProc(HWND hwnd, LPARAM lParam)
{
	BOOL CaptionFound = FALSE;
	BOOL ClassFound = FALSE;
	BOOL WidthFound = FALSE;
	BOOL HeightFound = FALSE;
	TCHAR lStr[255];
	RECT rc;

	if ( ((strFindWin*)lParam)->CountFind > _MAX_COUNT_WINDOW_ ) 
	{
		((strFindWin*)lParam)->fHWND = NULL;
		return FALSE;
	}

	((strFindWin*)lParam)->fmasHWND[(((strFindWin*)lParam)->CountFind)++] = hwnd;

	//  
	if (wcslen(((strFindWin*)lParam)->fCaption) > 0)
	{
		::GetWindowText(hwnd, lStr, 255);
		if (FindStr(lStr, ((strFindWin*)lParam)->fCaption))
			CaptionFound = TRUE;
	}
	else
	{
		CaptionFound = TRUE;
	}

	//  
	if (wcslen(((strFindWin*)lParam)->fClass) > 0)
	{
		::GetClassName(hwnd, lStr, 255);
		if (FindStr(lStr, ((strFindWin*)lParam)->fClass))
			ClassFound = TRUE;
	}
	else
	{
		ClassFound = TRUE;
	}

	::GetWindowRect(hwnd, &rc);
	//  
	if (((strFindWin*)lParam)->fWidth > 0)
	{
		if (((strFindWin*)lParam)->fWidth == (rc.right - rc.left))
			WidthFound = TRUE;
	}
	else
	{
		WidthFound = TRUE;
	}

	//  
	if (((strFindWin*)lParam)->fHeight > 0)
	{
		if (((strFindWin*)lParam)->fHeight == (rc.bottom - rc.top))
			HeightFound = TRUE;
	}
	else
	{
		HeightFound = TRUE;
	}

	if (ClassFound && CaptionFound && WidthFound && HeightFound)
	{
		((strFindWin*)lParam)->fHWND = hwnd;
		return FALSE;
	}
	else
	{
		((strFindWin*)lParam)->fHWND = NULL;
		return TRUE;
	}
}

BOOL FindStr(TCHAR *gde, TCHAR *chto)
{
	while (*gde!=0)
	{
		if(wcsncmp(gde,chto,wcslen(chto)) == 0) return TRUE;
		gde++;
	}
	return FALSE;
}
