//   12F629  12F675,  HI-TECH,
//     ,     9600
//                       _______  _______
//                      |       \/       |
//                +5V --+ 1           8  +-- GND
//                      |                |
//             GP5/TX --+ 2           7  +-- GP0/BUTTON
//                      |                |
//             GP4/RX --+ 3           6  +-- GP1/LED
//                      |                |
//                GP3 --+ 4           5  +-- GP2/IR
//                      |                |
//                      +----------------+

#include <pic.h> 
__CONFIG(MCLRDIS&INTIO&PWRTEN&WDTDIS);			//:  ,  ,   ,    
#define	BUTTON		GPIO0						//   ,      
#define	LED			GPIO1						//   WOL  WOR       ...
#define	IR			GPIO2						//    
#define	RX			GPIO4						//   (   100    ) 
#define	TX			GPIO5						//   ( RX ) 
static char resive[7];							//     (     1  6 ,   )
static char send[7]; 							//    
static char count,i;							//        
static bit pre_button, on, off, singl;			//    ,     (,   )
 
void putch(char c);								//     
//char getch(void);								//    
void shift(void);								//        
void save(unsigned char addr, unsigned char data){EEPROM_WRITE(addr, data);}	//   EEPROM
unsigned char load(unsigned char adr){while(WR);return EEPROM_READ(adr);}		//   EEPROM
 
void main(void){ 
// 
	OSCCAL=(*(unsigned char(*)())0x3FF)();		//   
	CMCON = 7;									// 
	ANSEL = 0;									//  
	TRISIO = 0b11011101;						// TX  LED - ,  -  	TX = 0; 
	LED=0;										//  
	OPTION = 0b00000011;						//  ,  TMR0   /16
	WPU = 0b00000101;									//     BUTTON  IR
// 
	for(;;){
		for(i=6;i>0;i--) resive[i]=0;			//  
		while(IR){								//        . :
			if(RX){for(count=2;count>0;count--); putch('O'), putch('K');}	//   ,   2     "" (  :)
			if(TMR0&0x80){						// 2 :
				if(count<128) count++, TMR0=0;	//     256 
				else{							//  256 :
					send[1]=send[2]=send[3]=send[4]=send[5]=send[6]=0;	//  
					if(singl) LED=0;			//     ,     LED
				}
			} 
			if(BUTTON != pre_button){			//    , 
				pre_button = BUTTON;			//   
				if(!pre_button){for(i=6;i>0;i--) save(i,0), save(8+i,0);} //  ,   2  EEPROM
			} 
		} 
		while(!IR);								//       
		while(IR);								//    
		for(;;){								//   
			TMR0 = 0;							// 
			while(!IR);							//  
			shift();							//""    (0  1)     
			TMR0 = 0;							//  
			while(IR)if(TMR0&0x80) goto end_loop;	//  ,    2  
			shift();							//""    (0  1)     
		} 
		end_loop:
/*     .  ,      . 
      ,   .     ,  
  .   ,          .
   :       8 ,        ,
      (<256 )     .*/
		if((resive[2]|resive[3]|resive[4]|resive[5]|resive[6]) && (count>64)){ //, ,    
			count = 0; 							//  
			on=off=singl=1; 					//   
			for(i=6;i>0;i--){ 					// 1  6  :
				send[i]=resive[i]; 				//      
/*        */
				if(load(i) != resive[i]) off=0; //       EEPROM,    
				if(load(i+8) != resive[i]) on=0;//       EEPROM,    
				if(load(i+8) > 0) singl=0;		//   EEPROM  ,    
/*        :
	1.            ,    
		 LED    1    ,  256     
		LED   0.
	2.       ,         
		  LED    ( 0  1,   1  0)
	3.    2  ,      LED  1,    0.
*  .. 2  3      ,     */
				if(!pre_button) save(i+8, load(i)), save(i, resive[i]);	//   ,     EEPROM  ,      
			} 
			if(on & off) LED^=1; 				// 2  
			if(on & !off) LED=1;				// 3     
			if(!on & off) LED=0;				// 3     
			if(off & singl) LED=1;				// 1  
		} 
		if(send[1]|send[2]|send[3]|send[4]|send[5]|send[6]){	//  6     , 
			for(i=6;i>0;i--) putch(send[i]); 					//   
			count=0;											//    
		} 
	} 
} 
 
void shift(void){ 
	#asm				//      1 
	rlf		_resive+1 
	rlf		_resive+2 
	rlf		_resive+3 
	rlf		_resive+4 
	rlf		_resive+5 
	rlf		_resive+6 
	#endasm 
	resive[1]^=((TMR0&0x40)>>5);	//        (    1  2 ,  1,  0)
} 

void putch(char c){			//     9600
#define	XTAL		4000000	//  
#define	BRATE		9600	// 
#define	DLY			3
#define	TX_OHEAD	7
#define	DELAY(ohead)	(((XTAL/4/BRATE)-(ohead))/DLY) 
	char dly, bitno; 
	TX = 1;
	bitno = 12; 
	do { 
		dly = DELAY(TX_OHEAD);
		do; while(--dly); 
		if(c & 1) TX = 0; 
		if(!(c & 1)) TX = 1; 
		c = (c >> 1) | 0x80; 
	} while(--bitno); 
} 

//char getch(void){			//     9600 
//#define	RX_OHEAD	5 
//	char	c, bitno, dly; 
//	for(;;) { 
//		while(!RX) continue; 
//		dly = DELAY(3)/2; 
//		do;	while(--dly); 
//		if(!RX) continue;
//		bitno = 8; 
//		c = 0; 
//		do{ 
//			dly = DELAY(RX_OHEAD); 
//			do;	while(--dly); 
//			c = (c >> 1) | (!RX << 7); 
//			} while(--bitno); 
//		return c; 
//	} 
//} 
