//****************** Здесь необходимо указать свои значения *************** 

int analogPin=0; // пин для подключения кнопок, по умолчанию A0 

int release_button = 1023; // значение при отпущенных кнопках 
int button_release_range = 50; // диапазон значения + - при отпущенных кнопках 
int button_range = 5; // диапазон значения нажатых кнопок + - 
int time_holding = 500; // время для удержания кнопок в миллисекундах 
int time_tinkling = 30; // время исключающее дребезг контактов в миллисекундах 
int vol_up = 111; // значение кнопки увеличить громкость 
int vol_down = 222; // значение кнопки уменьшить громкость 
int alt_tab = 333; // значение кнопки которая будет работать как Alt + Tab 
int next = 444; // значение кнопки которая будет работать как Next при коротком нажатии и Fast Forward при удержании 
int previous = 555; // значение кнопки которая будет работать как Previous при коротком нажатии и Rewind при удержании 
int play_pause = 777; // значение кнопки которая будет работать как Play/Pause при коротком нажатии и Mute при удержании 

//************************************************************************** 

int data;  
unsigned long flag = 0;  
unsigned long eventTime = 0;  
unsigned long pauseMillis = 0; 

void setup()  
{ 
analogReference(DEFAULT); // подключение внутреннего напряжение AVCC к выводу AREF (опорное напряжение) 
Keyboard.begin();  
}  

void loop()  
{  
data=analogRead(analogPin);  
if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 0)  
{  
eventTime=millis();  
}  

//********************** Громкость ************************************ 

if(millis()-eventTime<time_tinkling && millis()-eventTime<time_holding-1 && data >= vol_up - button_range && data <= vol_up + button_range && flag == 0) 
{   
Remote.increase();  
flag = 5;  
delay(10);  
Remote.clear();  
}  

if(millis()-eventTime>time_holding && data >= vol_up - button_range && data <= vol_up + button_range && flag == 5 || data >= vol_up - button_range && data <= vol_up + button_range && flag && flag == 3)  
{   
Remote.increase(); 
flag = 3;  
Remote.clear();  
delay(100);  
}  

if(millis()-eventTime<time_tinkling && millis()-eventTime<time_holding-1 && data >= vol_down - button_range && data <= vol_down + button_range && flag == 0)  
{   
Remote.decrease();  
flag = 6;  
delay(10);  
Remote.clear();  
}  

if(millis()-eventTime>time_holding && data >= vol_down - button_range && data <= vol_down + button_range && flag == 6 || data >= vol_down - button_range && data <= vol_down + button_range && flag == 3)  
{   
Remote.decrease();  
flag = 3;  
Remote.clear();  
delay(100);  
}  

//********************** AltTab + Ещё что то ************************************   

if(millis()-eventTime<time_tinkling && millis()-eventTime<time_holding-1 && data >= alt_tab - button_range && data <= alt_tab + button_range)  
{   
flag = 1;  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 1 && pauseMillis == 0)  
{  
Keyboard.press(KEY_LEFT_ALT);  
Keyboard.press(KEY_TAB);  
Keyboard.release(KEY_TAB);  
Keyboard.press(KEY_TAB);  
Keyboard.release(KEY_TAB);  
flag = 0;  
pauseMillis = millis();  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 1 && pauseMillis != 0)  
{  
Keyboard.press(KEY_TAB);  
Keyboard.release(KEY_TAB);  
flag = 0;  
pauseMillis = millis();  
}  

if(pauseMillis && millis()-pauseMillis >= 800 && data>=release_button - button_release_range && data<=release_button + button_release_range)  
{  
flag = 0;  
pauseMillis = 0;  
Keyboard.releaseAll();  
}  

if(millis()-eventTime>time_holding && data >= alt_tab - button_range && data <= alt_tab + button_range && flag == 1)  
{   
flag = 0;  
}  
//********************** Next и Fast Forward ************************************   

if(millis()-eventTime<time_tinkling && millis()-eventTime<time_holding-1 && data >= next - button_range && data <= next + button_range)  
{   
flag = 2;  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 2)  
{  
Remote.next();  
flag = 0;  
delay(10);  
Remote.clear();  
}  

if(millis()-eventTime>time_holding && data >= next - button_range && data <= next + button_range && flag == 2 || data >= next - button_range && data <= next + button_range && flag == 3)  
{   
Remote.forward();  
flag = 3;  
Remote.clear();  
delay(100);  
}  
//********************** Previous и Rewind ************************************   

if(millis()-eventTime<time_tinkling && millis()-eventTime<time_holding-1 && data >= previous - button_range && data <= previous + button_range)  
{   
flag = 4;  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 4)  
{  
Remote.previous();  
flag = 0;  
delay(10);  
Remote.clear();  
}  

if(millis()-eventTime>time_holding && data >= previous - button_range && data <= previous + button_range && flag == 4 || data >= previous - button_range && data <= previous + button_range && flag == 3)  
{   
Remote.rewind(); 
flag = 3;  
Remote.clear();  
delay(100);  
}  

//********************** Play/pause + Mute ************************************   

if(millis()-eventTime<time_tinkling && millis()-eventTime<time_holding-1 && data >= play_pause - button_range && data <= play_pause + button_range)  
{   
flag = 7;  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 7)  
{  
Remote.play_pause();   
flag = 0;  
delay(10);  
Remote.clear();  
}  

if(millis()-eventTime>time_holding && data >= play_pause - button_range && data <= play_pause + button_range && flag == 7)  
{   
Remote.mute(); 
flag = 0; 
delay(10); 
Remote.clear();  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 3 || data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 5 || data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 6)  
{  
flag = 0;  
}   
} 
