int ACC = 7;// котакт на Ардуино входа  АСС
int XP0 = 3;// контакт на Ардуино для управления каналом ХР0
int XP1 = 4;// контакт на Ардуино для управления каналом ХР1
int XP2 = 5;// контакт на Ардуино для управления каналом ХР2
int XP3 = 6;// контакт на Ардуино для управления каналом ХР3
int Bloc = 9;//контакт на Ардуино для управления блокировкой включения системы питания
int XP11 = 8;//контакт на Ардуино для управления датчиком Холла
int XP10 = 12;//контакт на Ардуино для управления режимом OTG
int Min = 15;/котакт на Ардуино для управления отслеживанием напряжения на АКБ
int ACCState = 0;
int MinState = 0;
uint32_t accoffmillis = 0; 

void setup() 
{
pinMode(ACC, INPUT); 
pinMode(Min, INPUT);
pinMode(XP0, OUTPUT); 
pinMode(XP1, OUTPUT); 
pinMode(XP2, OUTPUT); 
pinMode(XP3, OUTPUT); 
pinMode(XP11, OUTPUT); 
pinMode(XP10, OUTPUT);
pinMode(Bloc, OUTPUT);
}

void loop() 
{
 ACCState = digitalRead(ACC);
 MinState = digitalRead(Min);
 
 
 //========== ВКЛЮЧЕНИЕ АСС ============
  //Если зажигание включено и напряжение на АКБ не менее 11.5В 
  //(напряжение выставляется выбором положения на DIP - переключателе)
  if ((ACCState == HIGH)&& (MinState == HIGH))
  {
    {
    accon(); //выполняем команду void accon
    }
    
    {
    accoffmillis=millis();//запоминаем время перед выключением АСС
    }
  }

  
  //========== ВЫКЛЮЧЕНИЕ АСС ============
  if ((ACCState == LOW )&& accoffmillis && millis()-accoffmillis > 6000)
  //проверяем, что зажигание отключено ACCState == LOW
  //считаем сколько времени прошло accoffmillis && millis()-accoffmillis > 6000 
  //это время задержки влияет на "просадку" во время кручения стартером
    {
    accoff(); //выполняем команду void accoff
    }


    
   //========= РЕЖИМ СНА ПЛАНШЕТА ======== 
  //Если зажигание не включалось 3 6 часов, отключаем питание планшета.
  if ((ACCState == LOW)&&(MinState == HIGH )&& (accoffmillis && millis()-accoffmillis > 129600000))
   /* (60000 - 1 мин),(3600000 - 60мин)*/
    {
    tabletoff(); //выполняем команду void tabletoff
    }
  
  //Если АКБ разрядился во время сна планшета выполнится  = РЕЖИМ РАЗРЯДКИ АКБ =
  
  //========== РЕЖИМ РАЗРЯДКИ АКБ =========== 
  //Если зажигание выключено и  АКБ разрядился до 11.5В 
  //или  
  //зажигание включено,но АКБ разрядился тогда  ждем 10 сек. и выключаем по алгоритму  akbmin()
  //время задержки должно быть больше, чем время в "ВЫКЛЮЧЕНИЕ АСС"
  if (((ACCState == LOW)&& (MinState == LOW)&& (accoffmillis && millis()-accoffmillis > 10000))
  || (ACCState == HIGH)&& (MinState == LOW)&& millis()-accoffmillis > 10000)
 {
   {
    akbmin(); //выполняем команду void akbmin()
    }
   }
  }

//================================================================================
void accon()
{
digitalWrite(Bloc, HIGH);//включаем блокировку питания системы
digitalWrite(XP1, HIGH); //включаем питание на канале ХР1
delay(500);              //пауза перед следующим действием
digitalWrite(XP11, HIGH);//отключаем "массу" на датчике Холла
delay(500);              //пауза перед следующим действием
digitalWrite(XP2, HIGH);//включаем питание на канале ХР2
delay(1000);            //пауза перед следующим действием
digitalWrite(XP10, HIGH);//включаем режим OTG
delay(500);              //пауза перед следующим действием
digitalWrite(XP3, HIGH);//включаем питание на канале ХР3
delay(1000);            //пауза перед следующим действием              
digitalWrite(XP0, HIGH);//включаем питание на канале ХР0
 }
  
void accoff()
{ 
digitalWrite(XP3, LOW); //отключаем питание на канале ХР3             
digitalWrite(XP11, LOW);//отключаем режим OTG
delay (1000);           //пауза перед следующим действием             
digitalWrite(XP0, LOW);//отключаем питание на канале ХР0
digitalWrite(XP10, LOW);//подаём "массу" на датчик Холла
delay (1000);           //пауза перед следующим действием
digitalWrite(XP2, LOW); //отключаем питание на канале ХР2
 }

void akbmin()
{
digitalWrite(XP11, LOW);//подаём "массу" на датчик Холла
digitalWrite(XP3, LOW);//отключаем питание на канале ХР3
digitalWrite(XP10, LOW);//отключаем режим OTG
delay (2000);           //пауза перед следующим действием              
digitalWrite(XP0, LOW);//отключаем питание на канале ХР0   
digitalWrite(XP1, LOW);//отключаем питание на канале ХР1
digitalWrite(XP2, LOW);//отключаем питание на канале ХР2
digitalWrite(Bloc, LOW);//отключаем блокировку питания системы
}

void tabletoff() 
{
digitalWrite(XP1, LOW);//отключаем питание на канале ХР1
digitalWrite(Bloc, LOW);//отключаем блокировку питания системы
} 
