#include <Wire.h>
#include <Goodix.h>
#include <HID-Project.h>
#include <HID-Settings.h>
// INT_PIN will be used with attachInterrupt(intPin, _goodix_irq_handler, RISING), so select it properly for Your board
#define INT_PIN 1
#define RST_PIN 0
#define sout Serial
#define debug 0
#define X_SIZE 1024 //4-button
//#define X_SIZE 1000 //5-button
Goodix touch = Goodix();
char pressedKey = 0;
boolean prevContact[MAX_CONTACTS_LOC]; 
boolean nextContact[MAX_CONTACTS_LOC];
void sendKey(int y) {
  /*  4-button  */
  
  if(y < 100) pressedKey = 97;              //a
  if(y >= 100 && y < 180) pressedKey = 99;  //c 
  if(y >= 180 && y < 270) pressedKey = 101; //e
  if(y >= 270) pressedKey = 100;            //d
  
  /* 5-button 
  if(y < 100) pressedKey = 97;              //a
  if(y >= 100 && y < 190) pressedKey = 98;  //b
  if(y >= 190 && y < 280) pressedKey = 99;  //c
  if(y >= 280 && y < 370) pressedKey = 100; //d
  if(y >= 370) pressedKey = 101;            //e
  */
  Keyboard.press(pressedKey);
}
void handleTouch(int8_t contacts, GTPoint *points) {
#if defined(debug)  
  sout.print("Contacts: ");
  sout.println(contacts);
#endif  
  for (uint8_t i = 0; i < MAX_CONTACTS_LOC; i++) {    
    nextContact[i] = false;
  } 
  if(contacts == 0 && pressedKey != 0) {
    Keyboard.release(pressedKey);
    pressedKey = 0;
  }
  for (uint8_t i = 0; i < contacts; i++) {
#if defined(debug)    
    sout.print("C");
    sout.print(i);
    sout.print(": #");
    sout.print(points[i].trackId);
    sout.print(" x:");
    sout.print(points[i].x);
    sout.print(" y:");
    sout.print(points[i].y);
    sout.print(" s:");
    sout.println(points[i].area);
#endif    
    nextContact[points[i].trackId] = true;    
    int x0 = X_SIZE - points[i].x;
    if(x0 > 0) {
      //Масштабируем координаты
      long x = (X_SIZE - points[i].x)*10000/X_SIZE;
      long y = points[i].y*10000/600;      
      Touchscreen.setFinger(points[i].trackId, (uint16_t) x, (uint16_t) y, points[i].area);
    } else {
      if(pressedKey == 0) sendKey(points[i].y);
    }
  }
  for (uint8_t i = 0; i < MAX_CONTACTS_LOC; i++) {    
    if(!nextContact[i] && prevContact[i]) Touchscreen.releaseFinger(i);
    prevContact[i] = nextContact[i];
  } 
  Touchscreen.send();
  yield();
}

void touchStart() {
 
 if (touch.begin(INT_PIN, RST_PIN)!=true) {
    sout.println("Module reset failed");
  } else {
    sout.println("Module reset OK");
  }  
  sout.print("Check ACK on addr request on 0x");
  sout.print(touch.i2cAddr, HEX);  

  Wire.beginTransmission(touch.i2cAddr);  
  int error = Wire.endTransmission();
  if (error == 0) {    
    sout.println(": SUCCESS");   
  } else {
    sout.print(": ERROR #");
    sout.println(error);
  }
}

void setup() {  
  delay(2000);
#if defined(debug)
  sout.println("\nGoodix GT911x touch driver");
#endif  
  for (int i = 0; i < MAX_CONTACTS_LOC; i++) {
    prevContact[i] = false;
    nextContact[i] = false;
  }
  Touchscreen.begin();
  Keyboard.begin();
  Wire.setClock(400000);
  Wire.begin();
  delay(300);
  touch.setHandler(handleTouch);
  touchStart();  
}

void loop() {  
  touch.loop();
  delay(1);
}
