struct RDSData;
/*
Here is definition of RDSData structure
typedef struct RDSData
{
	double currentStation;
	BYTE recievedSignalStrength;
	BYTE monoStereo;
	char* rdsText;
} RDSData;
*/

// Call this function first, it will return 0 in case of NO ERRORS or non-zero in case of any errors.
int fm_OpenFMRadio();
// Call this function last when you don't work with radio anymore.
void fm_CloseFMRadio();
// Call this function anytime after OpenFMRadio to get RDSData.
int fm_GetRDSData(RDSData *rdsData);
// Call this function to start playing radio, for example when user press on Radio button in frontend. 
// Radio will be played using default audio output device.
void fm_Play();
// Call this function to stop playing radio, for example when user switching to mp3/video mode.
void fm_Stop();
// Call this function to tune radio one step up or down.
int fm_TuneOneStep(BOOL up);
// Call this function to tune radio to specified frequency.
int fm_Tune(double frequency);
// Call this function to seek radio up or down. Find next radio station ????
int fm_Seek(BOOL up);
