﻿XIncludeFile "Form.pbf"

CompilerIf Defined(PB_Editor_CreateExecutable, #PB_Constant)=0
  #PB_Editor_CreateExecutable = #False
CompilerEndIf

CompilerIf #PB_Editor_CreateExecutable
  SetCurrentDirectory(GetPathPart(ProgramFilename()))
CompilerElse
  SetCurrentDirectory(GetCurrentDirectory()+"..\")
CompilerEndIf

Procedure Events()
  Protected Event
  
  Repeat
    Event = WindowEvent()
  Until Event=0 Or Event=#PB_Event_CloseWindow
  
  ProcedureReturn Event
EndProcedure

Procedure BootSend()
  Protected File.s, ID, Port.s
  Protected Event, i
  
  ClearGadgetItems(#Editor_0)
  Events()
  
  File = GetGadgetText(#String_0)
  If File And FileSize(File)>0
    
    File = Chr(34)+File+Chr(34)
    
    Port = GetGadgetText(#Combo_0)
    If Port<>""
      
      AddGadgetItem(#Editor_0, -1, "Ожидание открытия порта")
      Events()
      
      
      For i=1 To 100
        
        If OpenSerialPort(0, Port, 57600, #PB_SerialPort_NoParity, 8, 1, #PB_SerialPort_NoHandshake, 1024, 1024)
          CloseSerialPort(0)
          i=0
          Break
        EndIf
        
        Delay(200)
        
        Event = Events()
        If Event = #PB_Event_CloseWindow
          ProcedureReturn #PB_Event_CloseWindow
        EndIf
      Next
      
      If i>0
        AddGadgetItem(#Editor_0, -1, "Завершен таймаут ожидания окрытия порта")
        ProcedureReturn 0
      EndIf
      
      ID = RunProgram("avrdude", "-v -p atmega32u4 -c avr109 -P "+
                                     Port+" -b 57600 -D -U flash:w:"+File+":i",
                      "", #PB_Program_Hide|#PB_Program_Open|#PB_Program_Read)
      
      If ID
        
        ;x=2
        While ProgramRunning(ID) Or x>0
;           Delay(400)
;           x=ReadConsoleData(@Buffer.s{1024}, 1024)
;           Debug Buffer
          ;           If AvailableProgramOutput(ID)
          ;             AddGadgetItem(#Editor_0, -1, ReadProgramString(ID))
          ;           EndIf
        Wend
        
        CloseProgram(ID)
        
        AddGadgetItem(#Editor_0, -1, "Прошивка завершена")
        
      Else
        AddGadgetItem(#Editor_0, -1, "Не удалось запустить 'avrdude.exe'")
      EndIf
      
    Else
      AddGadgetItem(#Editor_0, -1, "Не выбран порт")
    EndIf
    
  Else
    AddGadgetItem(#Editor_0, -1, "Не найден HEX файл")
  EndIf
  
  ProcedureReturn 0
EndProcedure

OpenConsole("pb_Boot32u4_console")
OpenWindow_0()

For i=1 To 20
  AddGadgetItem(#Combo_0, -1, "COM"+Str(i))
Next i

OpenPreferences("Setting.ini")
SetGadgetText(#String_0, ReadPreferenceString("Path", ""))
SetGadgetText(#Combo_0, ReadPreferenceString("Port", "COM1"))
ClosePreferences()

; hwndC=FindWindow_(#Null, "pb_Boot32u4_console")
; If hwndC
;   ShowWindow_(hwndC, #SW_HIDE)
; EndIf


Repeat
  Event = WaitWindowEvent()
  
  If Event = #PB_Event_Gadget
    Select EventGadget()
      Case #Button_0
        File.s = GetGadgetText(#String_0)
        If File And FileSize(File)<=0
          File=""
        EndIf
        File = OpenFileRequester("", File, "HEX-файлы|*.hex|Все файлы|*.*", 0)
        If File
          SetGadgetText(#String_0, File)
        EndIf
      Case #Button_1
        DisableGadget(#Button_1, 1)
        If BootSend() = #PB_Event_CloseWindow
          Break
        EndIf
        DisableGadget(#Button_1, 0)
    EndSelect
  EndIf
  
Until Event = #PB_Event_CloseWindow

If CreatePreferences("Setting.ini")
  WritePreferenceString("Path", GetGadgetText(#String_0))
  WritePreferenceString("Port", GetGadgetText(#Combo_0))
  ClosePreferences()
EndIf
; IDE Options = PureBasic 5.31 (Windows - x86)
; ExecutableFormat = Console
; CursorPosition = 76
; FirstLine = 28
; Folding = -
; EnableUnicode
; EnableXP
; Executable = ..\Boot32u4.exe
; EnableExeConstant