;   This file is a basic code template for assembly code generation   *
;   on the PICmicro PIC12F675. This file contains the basic code      *
;   building blocks to build upon.                                    *
;                                                                     *
;   If interrupts are not used all code presented between the ORG     *
;   0x004 directive and the label main can be removed. In addition    *
;   the variable assignments for 'w_temp' and 'status_temp' can       *
;   be removed. If the internal RC oscillator is not implemented      *
;   then the first four instructions following the label 'main' can   *
;   be removed.                                                       *
;                                                                     *
;   Refer to the MPASM User's Guide for additional information on     *
;   features of the assembler (Document DS33014).                     *
;                                                                     *
;   Refer to the respective PICmicro data sheet for additional        *
;   information on the instruction set.                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Filename:	    MazdaCD.asm                                       *
;    Date:                                                            *
;    File Version:                                                    *
;                                                                     *
;    Author:                                                          *
;    Company:                                                         *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files required:                                                  *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:                                                           *
;                                                                     *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************

	list      p=12f675           ; list directive to define processor
	#include <p12f675.inc>        ; processor specific variable definitions

	errorlevel  -302              ; suppress message 302 from list file

	__CONFIG   _CP_OFF & _CPD_OFF & _BODEN_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT 

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The lables following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.






;***** VARIABLE DEFINITIONS
w_temp        	EQU     0x20        ; variable used for context saving 
status_temp   	EQU     0x21        ; variable used for context saving
Start			EQU		0
Stop			EQU		1

Bait0		EQU     0x40
TABLE_ADDR	EQU		0x200

	CBLOCK	H'22'

	TEMP
	Temp
	TEMP_CRC
	Flag
	COUNT
	COUNT_B
	RXBUF
	TXBUF



	ENDC

#define RX_TX 	GPIO,0






;**********************************************************************
		ORG     0x000             ; processor reset vector
		goto    main              ; go to beginning of program
	

		ORG     0x004             ; interrupt vector location
		movwf   w_temp            ; save off current W register contents
		movf	STATUS,w          ; move status register into W register
		movwf	status_temp       ; save off contents of STATUS register


; isr code can go here or be located as a call subroutine elsewhere



end_int
		movf    status_temp,w     ; retrieve copy of STATUS register
		movwf	STATUS            ; restore pre-isr STATUS register contents
		swapf   w_temp,f
		swapf   w_temp,w          ; restore pre-isr W register contents
		retfie                    ; return from interrupt


; these first 4 instructions are not required if the internal oscillator is not used
main
		call    0x3FF             ; retrieve factory calibration value
		bsf     STATUS,RP0        ; set file register bank to 1 
		movwf   OSCCAL            ; update register with factory cal value 
		bcf     STATUS,RP0        ; set file register bank to 0


; remaining code goes here

		clrf	Flag

		movlw 	07h ;Set GP<2:0> to
		movwf 	CMCON ;digital IO

		movlw	ANSEL
		movwf	FSR
		clrf 	INDF ;Digital I/O


		movlw 	TRISIO 
		movwf	FSR
		movlw 	b'00000001' 
		movwf	INDF

		movlw	IOC
		movwf	FSR
		movlw	b'00000001'
		movwf	INDF
		
		movlw	WPU							;
		movwf	FSR
		clrf	INDF


		movlw	b'00000000'
		movwf	INTCON

		movlw	OPTION_REG
		movwf	FSR
		movlw	b'10000101'
		movwf	INDF


dd
		call	RX_com
		btfsc	Flag,1
		goto	disk_st
	
		movlw	0x00
		xorwf	COUNT_B,W
		btfsc	STATUS,Z
		goto	dd
		

		movlw	Bait0+1
		movwf	FSR
		movlw	0x08
		xorwf	INDF,W
		btfsc	STATUS,Z
		goto	D86


		movlw	Bait0+1
		movwf	FSR
		movlw	0x09
		xorwf	INDF,W
		btfsc	STATUS,Z
		goto	DF005668

		movlw	Bait0+1
		movwf	FSR
		movlw	0x01
		xorwf	INDF,W
		btfss	STATUS,Z
		goto	dd
	
		movlw	Bait0+2
		movwf	FSR
		movlw	0x01
		xorwf	INDF,W
		btfsc	STATUS,Z
		goto	a511	


		goto	dd		



;**********************************************
DF005668
				
		call	wait_stop		
		movlw	.8
		movwf	COUNT
		movlw	0x00
		call	TX_TAB		

		call	wait_stop		
		movlw	.13
		movwf	COUNT
		movlw	TABLE_ADDR+.11
		call	TX_TAB		

		call	wait_stop		
		movlw	.16
		movwf	COUNT
		movlw	TABLE_ADDR+.24
		call	TX_TAB	

		call	wait_stop		
		movlw	.12
		movwf	COUNT
		movlw	TABLE_ADDR+.40
		call	TX_TAB	

		call	wait_stop		
		movlw	.16
		movwf	COUNT
		movlw	TABLE_ADDR+.52
		call	TX_TAB	

		goto	dd

;***********************************************
D86
		call	wait_stop		
		movlw	.3
		movwf	COUNT
		movlw	TABLE_ADDR+.8
		call	TX_TAB		

		goto	dd


;*************************************************
a511
		
		movlw	Bait0+4
		movwf	FSR
		btfsc	INDF,0
		goto	st_art

		movlw	Bait0+3
		movwf	FSR
		btfss	INDF,2
		goto	dd

		bcf		Flag,0				
		call	wait_stop		
		movlw	.13
		movwf	COUNT
		movlw	TABLE_ADDR+.109
		call	TX_TAB	
		goto	dd

st_art
	
		call	wait_stop		
		movlw	.12
		movwf	COUNT
		movlw	TABLE_ADDR+.97
		call	TX_TAB	

		call	wait_stop		
		movlw	.13
		movwf	COUNT
		movlw	TABLE_ADDR+.84
		call	TX_TAB	

disk_st
		bsf		Flag,0
		call	wait_stop		
		movlw	.16
		movwf	COUNT
		movlw	TABLE_ADDR+.68
		call	TX_TAB		
		bcf		Flag,1
		goto	dd	





;**********************************************
;	 COUNT      W 
;********************************************
TX_TAB

		movwf	COUNT_B
		clrf	TEMP
q1
		movf	COUNT_B,W
		addwf	TEMP,W
		call	NUM_TABLE
		call	TX_com
				
		incf	TEMP,F
		movf	TEMP,W
		xorwf	COUNT,W
		btfss	STATUS,Z
		goto	q1
	
		return
	
;****************************************************

;******************************************************************
;	     W
;*******************************************************************
TX_com
;*********************************************

		movwf	TXBUF

		btfss	TXBUF,3
		goto	$+3
		call	tx_1
		goto	$+2
		call	tx_0



		btfss	TXBUF,2
		goto	$+3
		call	tx_1
		goto	$+2
		call	tx_0

		btfss	TXBUF,1
		goto	$+3
		call	tx_1
		goto	$+2
		call	tx_0

		btfss	TXBUF,0
		goto	$+3
		call	tx_1
		goto	$+2
		call	tx_0
	
		return

;****************************************************
tx_0

		bsf		GPIO,1		;   0
		clrf	TMR0
		movf	TMR0,W
		xorlw	0x09
		btfss	STATUS,Z
		goto	$-3					; 0


		bcf		GPIO,1		;   1		
		movf	TMR0,W
		xorlw	0x2F
		btfss	STATUS,Z
		goto	$-3

		return

;****************************************************
tx_1

		bsf		GPIO,1		;   0
		clrf	TMR0
		movf	TMR0,W
		xorlw	0x1C
		btfss	STATUS,Z
		goto	$-3					; 1


		bcf		GPIO,1		;   1		
		movf	TMR0,W
		xorlw	0x2F
		btfss	STATUS,Z
		goto	$-3

		return
;*****************************************************		
;	   
;*****************************************************
wait_stop
		btfss	RX_TX
		goto	$-1				;  
		clrf	TMR0
b2
		btfss	RX_TX
		goto	wait_st

		movf	TMR0,W
		sublw	0x33			;  
		btfsc	STATUS,C
		goto	b2
		
		return
;**************************************************************
;******************************************************
;    COUNT_B    - 1 ,  
; COUNT_B = 0 ,  ,  .
;********************************************************
RX_com
		btfss	Flag,0
		goto	cc

		movlw	OPTION_REG
		movwf	FSR
		movlw	b'10000111'
		movwf	INDF
		clrf	TMR0
ee
		btfss	RX_TX
		goto	ss
		movlw	0xFF
		xorwf	TMR0,W
		btfss	STATUS,Z
		goto	ee
		bsf		Flag,1
		movlw	OPTION_REG
		movwf	FSR
		movlw	b'10000101'
		movwf	INDF
		return
ss
		movlw	OPTION_REG
		movwf	FSR
		movlw	b'10000101'
		movwf	INDF
		goto	cd
cc
		call	wait_stop		
cd
		bcf		Flag,1
		movlw	.4
		movwf	COUNT
		clrf	COUNT_B
		clrf	RXBUF

bit_rx
;	bcf		GPIO,1
		btfsc	RX_TX
		goto	$-1				; 
		clrf	TMR0

		btfss	RX_TX
		goto	$-1

		movf	TMR0,W
		movwf	TEMP

		movf	TEMP,W			;  =0
		sublw	0x05
		btfss	STATUS,C		
		goto	bs0_1			;	 
		btfss	STATUS,Z		;	 
		goto	err_	
bs0_1
		movf	TEMP,W			;  =0
		sublw	0x0D
		btfsc	STATUS,C		
		goto	bs0				;	   
;************************************************************

		movf	TEMP,W			;  =1
		sublw	0x18
		btfss	STATUS,C		
		goto	bs1_1			;	 
		btfss	STATUS,Z		;	 
		goto	err_	
bs1_1
		movf	TEMP,W			;  =1
		sublw	0x20
		btfsc	STATUS,C		
		goto	bs1				;	   
		goto	err_	

bs1
		bsf		RXBUF,0

bs0

		decfsz	COUNT,F
		goto	r_bit
		goto	w_bait

r_bit
		bcf		STATUS,C
		rlf		RXBUF,F
		goto	wait_st

w_bait
		movf	COUNT_B,W
		addlw	Bait0			; RXBUF   (COUNT_B + Bait0)
		movwf	FSR
		movf	RXBUF,W
		movwf	INDF
		incf	COUNT_B,F
		clrf	RXBUF
		movlw	.4
		movwf	COUNT
wait_st
		btfss	RX_TX			;  
		goto	bit_rx			

		movf	TMR0,W
		xorlw	0x33			;  
		btfss	STATUS,Z
		goto	wait_st

;**************************************************
crc_check
		movlw	Bait0
		movwf	FSR
		movf	INDF,W			;  =5
		xorlw	0x05
		btfss	STATUS,Z
		goto	err_

sr_c
		decf	COUNT_B,F
		clrf	TEMP			;  
		clrf	TEMP_CRC	
sr_cr
		movf	COUNT_B,W
		xorwf	TEMP,W
		btfsc	STATUS,Z
		goto	sr_ecr
		
		movlw	Bait0
		addwf	TEMP,W
		movwf	FSR
		movf	INDF,W
		xorwf	TEMP_CRC,F
		incf	TEMP,F
		goto	sr_cr

sr_ecr
		incf	TEMP_CRC,F
		movf	COUNT_B,W
		addlw	Bait0
		movwf	FSR
		movf	INDF,W
		xorwf	TEMP_CRC,W
		btfss	STATUS,Z
		goto	err_

sr_end

;	bsf		GPIO,1
		return					; 5,   OK


err_
		clrf	COUNT_B			;  ,  
;	bcf		GPIO,1
		return

;*****************************************************************

    org     TABLE_ADDR
NUM_TABLE       
				MOVWF   Temp            ; Store value to TEMP register
                MOVLW   HIGH(TABLE_ADDR); Ensure that the PCLATH high has the 
                MOVWF   PCLATH          ;   correct value
                MOVF    Temp, W         ; Value into table
;                ANDLW   0x0F            ; Mask to 4-bits (00 - 0Fh) 

				ADDWF   PCL, F          ; 
                RETLW   0x0D            ; DF005668
                RETLW   0x0F            ; DF005668
                RETLW   0x00            ; DF005668
                RETLW   0x00            ; DF005668	TABLE_ADDR
                RETLW   0x05            ; DF005668	
                RETLW   0x06            ; DF005668
                RETLW   0x06            ; DF005668
                RETLW   0x08           	; DF005668
          
		      	RETLW   0x0D           	; D86
                RETLW   0x08			; D86	TABLE_ADDR+.8
				RETLW	0x06			; D86
                
                RETLW   0x0D            ; DC101995946F1
                RETLW   0x0C            ; DC101995946F1
                RETLW   0x01            ; DC101995946F1
                RETLW   0x00            ; DC101995946F1
                RETLW   0x01            ; DC101995946F1	TABLE_ADDR+.11
                RETLW   0x09            ; DC101995946F1
                RETLW   0x09	        ; DC101995946F1		
                RETLW   0x05           	; DC101995946F1
                RETLW   0x09            ; DC101995946F1
                RETLW   0x04            ; DC101995946F1
                RETLW   0x06            ; DC101995946F1
                RETLW   0x0F            ; DC101995946F1
                RETLW   0x01            ; DC101995946F1


                RETLW   0x0D            ; DD1234560000F20B
                RETLW   0x0D            ; DD1234560000F20B
                RETLW   0x01            ; DD1234560000F20B
                RETLW   0x02            ; DD1234560000F20B
                RETLW   0x03            ; DD1234560000F20B	TABLE_ADDR+.24
                RETLW   0x04            ; DD1234560000F20B
                RETLW   0x05	        ; DD1234560000F20B		
                RETLW   0x06           	; DD1234560000F20B
                RETLW   0x00            ; DD1234560000F20B
                RETLW   0x00            ; DD1234560000F20B
                RETLW   0x00            ; DD1234560000F20B
                RETLW   0x00            ; DD1234560000F20B
                RETLW   0x0F            ; DD1234560000F20B
                RETLW   0x02            ; DD1234560000F20B
                RETLW   0x00            ; DD1234560000F20B
                RETLW   0x0B            ; DD1234560000F20B


                RETLW   0x0D            ; DB9100000098
                RETLW   0x0B            ; DB9100000098
                RETLW   0x09            ; DB9100000098
                RETLW   0x01	        ; DB9100000098		
                RETLW   0x00           	; DB9100000098
                RETLW   0x00            ; DB9100000098		TABLE_ADDR+.40
                RETLW   0x00            ; DB9100000098
                RETLW   0x00            ; DB9100000098
                RETLW   0x00            ; DB9100000098
                RETLW   0x00            ; DB9100000098
                RETLW   0x09            ; DB9100000098
                RETLW   0x08            ; DB9100000098
    

                RETLW   0x0D            ; D910011000000015
                RETLW   0x09            ; D910011000000015
                RETLW   0x01            ; D910011000000015
                RETLW   0x00            ; D910011000000015
                RETLW   0x00	        ; D910011000000015		
                RETLW   0x01           	; D910011000000015
                RETLW   0x01            ; D910011000000015	TABLE_ADDR+.52
                RETLW   0x00            ; D910011000000015
                RETLW   0x00            ; D910011000000015
                RETLW   0x00            ; D910011000000015
                RETLW   0x00            ; D910011000000015
                RETLW   0x00            ; D910011000000015
                RETLW   0x00            ; D910011000000015
                RETLW   0x00            ; D910011000000015
                RETLW   0x01            ; D910011000000015
                RETLW   0x05            ; D910011000000015

                RETLW   0x0D	        ; D940011000000012	
                RETLW   0x09	        ; D940011000000012	
                RETLW   0x04           	; D940011000000012
                RETLW   0x00            ; D940011000000012	
                RETLW   0x00         	; D940011000000012
                RETLW   0x01            ; D940011000000012
                RETLW   0x01            ; D940011000000012
                RETLW   0x00            ; D940011000000012
                RETLW   0x00            ; D940011000000012
                RETLW   0x00            ; D940011000000012		TABLE_ADDR+.68
                RETLW   0x00	        ; D940011000000012
                RETLW   0x00           	; D940011000000012
                RETLW   0x00            ; D940011000000012	
                RETLW   0x00            ; D940011000000012
                RETLW   0x01            ; D940011000000012
                RETLW   0x02            ; D940011000000012


                RETLW   0x0D	        ; DC101195946F9
                RETLW   0x0C	        ; DC101195946F9
                RETLW   0x01           	; DC101195946F9
                RETLW   0x00            ; DC101195946F9	
                RETLW   0x01          	; DC101195946F9
                RETLW   0x01            ; DC101195946F9
                RETLW   0x09            ; DC101195946F9
                RETLW   0x05            ; DC101195946F9
                RETLW   0x09            ; DC101195946F9
                RETLW   0x04            ; DC101195946F9		TABLE_ADDR+.84
                RETLW   0x06	        ; DC101195946F9
                RETLW   0x0F           	; DC101195946F9
                RETLW   0x09            ; DC101195946F9	

                RETLW   0x0D	        ; DB9100000010
                RETLW   0x0B	        ; DB9100000010
                RETLW   0x09           	; DB9100000010
                RETLW   0x01            ; DB9100000010
                RETLW   0x00          	; DB9100000010
                RETLW   0x00            ; DB9100000010
                RETLW   0x00            ; DB9100000010
                RETLW   0x00            ; DB9100000010
                RETLW   0x00            ; DB9100000010
                RETLW   0x00            ; DB9100000010		TABLE_ADDR+.97
                RETLW   0x01	        ; DB9100000010
                RETLW   0x00           	; DB9100000010


                RETLW   0x0D	        ; DC201145946F7
                RETLW   0x0C	        ; DC201145946F7
                RETLW   0x02           	; DC201145946F7
                RETLW   0x00            ; DC201145946F7
                RETLW   0x01          	; DC201145946F7
                RETLW   0x01            ; DC201145946F7
                RETLW   0x04            ; DC201145946F7
                RETLW   0x05            ; DC201145946F7
                RETLW   0x09            ; DC201145946F7
                RETLW   0x04            ; DC201145946F7		TABLE_ADDR+.109
                RETLW   0x06	        ; DC201145946F7
                RETLW   0x0F           	; DC201145946F7
                RETLW   0x07           	; DC201145946F7

NUM_TBL_END   



; initialize eeprom locations

;		ORG	0x2100
;		DE	0x00, 0x01, 0x02, 0x03


		END                       ; directive 'end of program'

