;**********************************************************************
;   This file is a basic code template for assembly code generation   *
;   on the PICmicro PIC16F876. This file contains the basic code      *
;   building blocks to build upon.                                    *  
;                                                                     *
;   If interrupts are not used all code presented between the ORG     *
;   0x004 directive and the label main can be removed. In addition    *
;   the variable assignments for 'w_temp' and 'status_temp' can       *
;   be removed.                                                       *                         
;                                                                     *
;   Refer to the MPASM User's Guide for additional information on     *
;   features of the assembler (Document DS33014).                     *
;                                                                     *
;   Refer to the respective PICmicro data sheet for additional        *
;   information on the instruction set.                               *
;                                                                     *
;   Template file assembled with MPLAB V4.00 and MPASM V2.20.00.      *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Filename:	  Mazda3.asm                                        *
;    Date:                                                            *
;    File Version:                                                    *
;                                                                     *
;    Author:                                                          *
;    Company:                                                         *
;                                                                     * 
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files required:                                                  *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:                                                           *
;                                                                     *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************


	list      p=16f876a            ; list directive to define processor
	#include <p16f876A.inc>        ; processor specific variable definitions
	
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _WRT_OFF & _LVP_OFF & _DEBUG_OFF & _CPD_OFF 

; '__CONFIG' directive is used to embed configuration data within .asm file.
; The lables following the directive are located in the respective .inc file.
; See respective data sheet for additional information on configuration word.



;Constants

SPBRG_VAL	EQU	.64		;set baud rate 9600 for 10Mhz clock

TABLE_ADDR	EQU	0x600


;***** VARIABLE DEFINITIONS


	

Bait0		EQU     0x50

;----------------------------------------------------------------------------
;Bit Definitions

GotNewData	EQU	0		;bit indicates new data received

Clock_		EQU	0
Strobe_		EQU	1
Data_		EQU	2
Blanking_	EQU	3
Beep_		EQU	2
On_Off		EQU	1
Taste_		EQU	0
RC_			EQU 2
AC_			EQU 3
SCL_		EQU 0
DAT_		EQU 1
CS_			EQU	4
EN_			EQU	5
CG_			EQU	0		
DD_			EQU	1
MK_			EQU	2


		CBLOCK	0x20

		W_TEMP        	
		STATUS_TEMP   	
		Glob_Cont
		Beep_Cont
		Beep_Time
		Disp0
		Disp1
		Disp2
		Disp3
		Disp4
		Disp5
		Disp6
		Disp7
		Disp8
		Disp9
		Disp10
		Disp11
		PCLATH_TEMP
		Flags
		Flags_LCD
		Flags_DS_IN
		Data_DC
		Data_DC_PB
		Count_DC
		DelCnt		;  
		Temp
		Temp1
		TempLCD
		Cont
		Old_Dist
		DD_RAM
		MK_RAM
		CG_RAM
		Led
		Lcd0
		Lcd1
		Lcd2
		HMSD
		MSD
		LSD
		FSR_TEMP

             ENDC
;----------------------------------------------------------------------------

;**********************************************************************
		ORG     0x000             ; processor reset vector
		clrf    PCLATH            ; ensure page bits are cleared
  		goto    main              ; go to beginning of program


		ORG     0x004             ; interrupt vector location
		MOVWF 	W_TEMP ;Copy W to TEMP register
		SWAPF 	STATUS,W ;Swap status to be saved into W
		CLRF 	STATUS ;bank 0, regardless of current bank, Clears IRP,RP1,RP0
		MOVWF 	STATUS_TEMP ;Save status to bank zero STATUS_TEMP register
		movf	FSR,W
		movwf	FSR_TEMP
		MOVF 	PCLATH, W ;Only required if using pages 1, 2 and/or 3
		MOVWF 	PCLATH_TEMP ;Save PCLATH into W
		CLRF 	PCLATH ;Page zero, regardless of current page
		


;**************************************************************************
; isr code can go here or be located as a call subroutine elsewhere
;**************************************************************************
;		   RB4
;**************************************************************************

		movlw	OPTION_REG
		movwf	FSR
		movlw	0xFF
		movwf	INDF
int_RB
		btfss	INTCON,RBIF
		goto	int_INT
		movf	PORTB,W
		bcf		INTCON,RBIF
		
		btfss	PORTB,CS_		;   CS
		goto	rb1				;
		bcf		INTCON,INTE		; 


;***************************************************************************
;	    
;*************************************************************************** 

		movlw	.8
		movwf	Count_DC
		btfsc	Flags,On_Off
		goto	Disp_LCD_CONV
Disp_LCD_HEAD
		bcf		Flags_LCD,DD_
		clrf	DD_RAM
		goto	Disp_LCD_OUT
;***********************************************************
;    ParkBoy    LCD
;***********************************************************
Disp_LCD_CONV
		btfsc	Flags_DS_IN,AC_
		goto	Disp_LCD_HEAD
		btfsc	Flags_DS_IN,RC_
		goto	Disp_LCD_0		


		btfss	Data_DC,7
		goto	Disp_LCD_HEAD
		movf	Data_DC,W
		andlw	B'00011111'
		movwf	DD_RAM
		bsf		Flags_LCD,DD_
		goto	Disp_LCD_OUT
Disp_LCD_0

		btfss	Flags_LCD,DD_
		goto	Disp_LCD_HEAD	
		movf	DD_RAM,W
		sublw	0x0C
		btfss	STATUS,C
		goto	Disp_LCD_1	
		movf	DD_RAM,W
		addlw	0x24
		movwf	FSR
		movf	INDF,W
		movwf	Data_DC	
		goto	Disp_LCD_OUT
Disp_LCD_1
		
		movf	DD_RAM,W
		xorlw	0x1E
		btfss	STATUS,Z
		goto	Disp_LCD_2		
		bcf		Data_DC,4	
		goto	Disp_LCD_OUT
Disp_LCD_2
		movf	DD_RAM,W
		xorlw	0x1B
		btfss	STATUS,Z
		goto	Disp_LCD_3		
		bcf		Data_DC,4	
		goto	Disp_LCD_OUT
Disp_LCD_3
		movf	DD_RAM,W
		xorlw	0x1C
		btfss	STATUS,Z
		goto	Disp_LCD_OUT		
		bcf		Data_DC,4	
		bcf		Data_DC,2	

;***********************************************************
;      Data_DC_OUT , Flags_DS_IN
;***********************************************************
Disp_LCD_OUT
		btfss	Flags_DS_IN,AC_
		goto	ac_0
		bsf		PORTA,AC_
		goto	rc_
ac_0
		bcf		PORTA,AC_		
rc_
		btfss	Flags_DS_IN,RC_
		goto	rc_0
		bsf		PORTA,RC_
		goto	rc_e
rc_0
		bcf		PORTA,RC_		
rc_e
		bcf		PORTA,5
bit_in_cikl
		bcf		PORTA,SCL_
		btfsc	Data_DC,7
		goto	bit_set
		bcf		PORTA,DAT_		
		goto	rot_

bit_set
		bsf		PORTA,DAT_		

rot_
		bsf		PORTA,SCL_
		decfsz	Count_DC,F
		goto	dd0
		goto	dd1
dd0
		rlf		Data_DC,F
		goto	bit_in_cikl

dd1
		bsf		PORTA,5
		incf	DD_RAM,F		
		clrf	Data_DC	
		goto	end_int
;***************************************************************************
rb1								
		movf	PORTB,W
		andlw	B'00001100'
		movwf	Flags_DS_IN


		movlw	.8
		movwf	Count_DC
		bsf		INTCON,INTE
		goto	end_int
;**************************************************************************
;		   INT
;**************************************************************************
int_INT
		btfss	INTCON,INTF
		goto	int_TMR1
		bcf		INTCON,INTF


		btfsc	PORTB,DAT_
		goto	bit_s_i
		bcf		Data_DC,0		
		goto	dec_i
bit_s_i
		bsf		Data_DC,0
dec_i
		decfsz	Count_DC,F
		goto	rl_
		goto	end_int

rl_
		rlf		Data_DC,F

		goto	end_int

	

;*****************************************************************
;		   TMR1
;*****************************************************************
int_TMR1


		btfss	PIR1,TMR1IF
		goto	end_int
		bcf		PIR1,TMR1IF
		btfss	Flags,Beep_
		goto	i2

		movlw	0x00
		xorwf	Beep_Time,w
		btfsc	STATUS,Z
		goto	i1_

		btfsc	Flags,7
		goto	i_
		movlw	0x02
		xorwf	Beep_Cont,w
		btfsc	STATUS,Z		
		goto	i2
i_
		movf	Beep_Cont,w
		subwf	Beep_Time,w
		btfss	STATUS,C
		clrf	Beep_Cont

		movf	Beep_Time,w
		xorwf	Beep_Cont,w
		btfsc	STATUS,Z
		goto	i1
		incf	Beep_Cont,f
		goto	i3
i1	
		btfss	Flags,7
		goto	i2
i1_
		bcf		Flags,7
		movlw	0x0C
		movwf	CCP1CON

		clrf	Beep_Cont
		goto	i3
i2
		bsf		Flags,7
		clrf	CCP1CON
		clrf	Beep_Cont
i3
		movlw	0x9F	;7f
		movwf	TMR1H
		movlw	B'00100001'
		movwf	T1CON
;*****************************************************************

end_int


		MOVF 	PCLATH_TEMP, W 	;Restore PCLATH
		MOVWF 	PCLATH 			;Move W into PCLATH
		movf	FSR_TEMP,W
		movwf	FSR
		SWAPF 	STATUS_TEMP,W 	;Swap STATUS_TEMP register into W
								;(sets bank to original state)
		MOVWF 	STATUS 			;Move W into STATUS register
		SWAPF 	W_TEMP,F 		;Swap W_TEMP
		SWAPF 	W_TEMP,W 		;Swap W_TEMP into W
		retfie                  ; return from interrupt
;*************************************************************************************


main

; remaining code goes here


		clrf	Flags
		clrf	Lcd0
		clrf	Lcd1
		clrf	Lcd2
		clrf	Led
		clrf	Data_DC_PB
		movlw	0xFF
		movwf	Glob_Cont		
		
		movlw	0xFF
		movwf	PORTA
		movlw	TRISA
		movwf	FSR
		movlw	B'00000000'	; RA0 - RA5 -  
		movwf	INDF


		clrf	PORTB
		movlw	TRISB
		movwf	FSR
		movlw	B'00011111'	
		movwf	INDF

		movlw	TRISC
		movwf	FSR
		movlw	B'11111011'	; RC0 - 
		movwf	INDF
		clrf	PORTC

		movlw	ADCON1
		movwf	FSR
		movlw	B'00000111'	
		movwf	INDF
;----------------------------------------------------------------
	

		movlw	OPTION_REG
		movwf	FSR
		movlw	0xFF
		movwf	INDF

		movlw	PIE1	;
		movwf	FSR		;    TMR1
		movlw	0x01	;
		movwf	INDF	;

		movlw	B'00100001' ; TMR1  1:2
		movwf	T1CON


		movlw	B'10001000'	;   
		movwf	INTCON		;
		clrf	Beep_Cont

		call 	SetupSerial
;-------------------------------------------------------------
;     
;-------------------------------------------------------------


MainLoop:	
		bsf		INTCON,PEIE				;bs
		call	RX_Slovo
		call	CRS_Check
		movf	Temp,w
		addlw	Bait0
		movwf	FSR		
		movf	INDF,w
		xorwf	Temp1,w
		btfss	STATUS,Z
		goto	MainLoop

		movlw	Bait0
		movwf	FSR		
		movf	INDF,w
		movwf	Temp
		movlw	0x01
		xorwf	Temp,w
		btfsc	STATUS,Z
		goto	Set01_

		movlw	0x02
		xorwf	Temp,w
		btfsc	STATUS,Z
		goto	Set02_		


		movlw	0x03
		xorwf	Temp,w
		btfsc	STATUS,Z
		goto	Set03_

		movlw	0x04
		xorwf	Temp,w
		btfsc	STATUS,Z
		goto	Set04_

		movlw	0x05
		xorwf	Temp,w
		btfsc	STATUS,Z
		goto	Set05_

		movlw	0x07
		xorwf	Temp,w
		btfsc	STATUS,Z
		goto	Set07_

		movlw	0x08
		xorwf	Temp,w
		btfsc	STATUS,Z
		goto	Set08_

		goto	MainLoop

;--------------------------------------------------------------
Set01_
;-----------------------------------------------------
		bcf		Flags,Beep_
		movlw	Bait0+2
		movwf	FSR
		btfss	INDF,0
		goto	Disp_Off
		movlw	Bait0+3
		movwf	FSR
		movf	INDF,w
		xorlw	0xFF
		btfsc	STATUS,Z		
		goto	Disp_On
		movlw	Bait0+3
		movwf	FSR
		movf	INDF,w		
		call	BIN_3_BCD
		movlw	0x31
		movwf	Disp7
		movf	LSD, W		; Load the MSD value into the Wreg
		call	NUM_TABLE	; Get the ASCII code
		movwf	Disp9	
		movf	HMSD, W		; Load the MSD value into the Wreg
		xorlw	0x00
		btfsc	STATUS,Z
		goto	a
		movf	MSD, W
		call	NUM_TABLE	; Get the ASCII code
		movwf	Disp8	
		goto	a2
a
		movlw	0x20
		movwf	Disp7
		movf	MSD, W		; Load the MSD value into the Wreg
		xorlw	0x00
		btfsc	STATUS,Z
		goto	a1
		movf	MSD, W
		call	NUM_TABLE	; Get the ASCII code
		movwf	Disp8	
		goto	a2
a1
		movlw	0x20
		movwf	Disp8	
a2
		movlw	Bait0+4
		movwf	FSR
		movf	INDF,w		
		movwf	Led
		andlw	0x0F
		xorlw	0x00
		btfss	STATUS,Z
		goto	a2_1

		movlw	PR2
		movwf	FSR
		movlw	0x2F	;3F
		movwf	INDF
		movlw	0x10	;20
		movwf	CCPR1L	
		goto	a2_2
a2_1
		movlw	PR2
		movwf	FSR
		movlw	0x6F	;7F
		movwf	INDF
		movlw	0x30	;40
		movwf	CCPR1L	
a2_2
		movlw	0x06
		movwf	T2CON


;  
		movlw	Bait0+3
		movwf	FSR
		movf	INDF,w	
		subwf	Old_Dist,w
		btfss	STATUS,C
		goto	a3_1

		movlw	Bait0+3
		movwf	FSR
		movf	INDF,w	
		xorwf	Old_Dist,w
		btfss	STATUS,Z
		goto	a3_2
		btfss	Flags,4
		goto	a3_2
		bcf		Flags,Beep_
		goto	a3_4	

a3_1

		bcf		Flags,Beep_
		bsf		Flags,4
		goto	a3_4

a3_2
		bcf		Flags,4
		bsf		Flags,Beep_

a3_3
		movlw	Bait0+3
		movwf	FSR
		movf	INDF,w		
		call	Dist_Beep



a3_4
		movlw	Bait0+3
		movwf	FSR
		movf	INDF,w	
		movwf	Old_Dist

		bsf		Flags,On_Off
		movlw	0x20
		movwf	Disp0
		movlw	0x20
		movwf	Disp1
		movlw	0x23
		movwf	Disp2
		movlw	0x20
		movwf	Disp3
		movlw	0x20
		movwf	Disp4
		movlw	0x20
		movwf	Disp5
		movlw	0x20
		movwf	Disp6
		movlw	0x63
		movwf	Disp10
		movlw	0x6D
		movwf	Disp11

		call	Lcd_Disp_Conv
		call	Ret_TX_Stat
		goto	MainLoop

Disp_Off

		clrf	T2CON
		clrf	CCP1CON	
		movlw	0xFF
		movwf	Old_Dist
		bcf		Flags,Beep_
		bcf		Flags,On_Off

		call	Ret_TX_Stat
		goto	MainLoop

Disp_On
		clrf	T2CON
		clrf	CCP1CON	
		bcf		Flags,Beep_
		movlw	0xFF
		movwf	Old_Dist
		movlw	0x50
		movwf	Disp0
		movlw	0x61
		movwf	Disp1
		movlw	0x72
		movwf	Disp2
		movlw	0x6B
		movwf	Disp3
		movlw	0x20
		movwf	Disp4
		movlw	0x42
		movwf	Disp5
		movlw	0x6F
		movwf	Disp6
		movlw	0x79
		movwf	Disp7
		movlw	0x20
		movwf	Disp8
		movlw	0x20
		movwf	Disp9
		movlw	0x4F
		movwf	Disp10
		movlw	0x4E
		movwf	Disp11
		bsf		Flags,On_Off

		call	Ret_TX_Stat
		goto	MainLoop		
;----------------------------------------------------------
Set02_
		bcf		Flags,On_Off		

		call	Ret_TX_Stat
		goto	MainLoop




;-----------------------------------------------------------
Set03_
		clrf	T2CON
		clrf	CCP1CON	

		call	Ret_TX_Stat
		goto	MainLoop

;-------------------------------------------------------
Set04_
		clrf	T2CON
		clrf	CCP1CON	
		bcf		Flags,On_Off
		bcf		Flags,Beep_
		call	Ret_TX_Stat
		goto	MainLoop

;----------------------------------------------------------------------
Set05_

		clrf	T2CON
		clrf	CCP1CON	
		movlw	0x55
		call	TransmitSerial
		call	ReceiveSerial

		movlw	Bait0
		movwf	FSR
		movlw	0x86
		movwf	INDF

		call	TransmitSerial
		call	ReceiveSerial
	

		movlw	Bait0+1
		movwf	FSR
		movf	INDF,w

		call	TransmitSerial
		call	ReceiveSerial


		movlw	Bait0+2
		movwf	FSR
		movf	INDF,w

		call	TransmitSerial
		call	ReceiveSerial


		movlw	Bait0+3
		movwf	FSR
		movf	INDF,w

		call	TransmitSerial
		call	ReceiveSerial


		movlw	Bait0+4
		movwf	FSR
		movf	INDF,w

		call	TransmitSerial
		call	ReceiveSerial


		movlw	Bait0+5
		movwf	FSR
		movf	INDF,w

		call	TransmitSerial
		call	ReceiveSerial


		movlw	Bait0+6
		movwf	FSR
		movf	INDF,w

		call	TransmitSerial
		call	ReceiveSerial


		call	CRS_Check
		movf	Temp,w
		addlw	Bait0
		movwf	FSR		
		movf	Temp1,w
		movwf	INDF

		call	TransmitSerial
		call	ReceiveSerial
		goto	MainLoop


;-----------------------------------------------------------


Set07_

		clrf	T2CON
		clrf	CCP1CON	

		bcf		Flags,Beep_

		bcf		Flags,On_Off
		call	Ret_TX_Stat
		goto	MainLoop
;--------------------------------------------------
Set08_
		clrf	T2CON
		clrf	CCP1CON	
		movlw	0x55
		call	TransmitSerial
		call	ReceiveSerial


		movlw	Bait0
		movwf	FSR
		movlw	0x88
		movwf	INDF

		call	TransmitSerial
		call	ReceiveSerial
	

		movlw	Bait0+1
		movwf	FSR
		movf	INDF,w

		call	TransmitSerial
		call	ReceiveSerial


		movlw	Bait0+2
		movwf	FSR
		movf	INDF,w

		call	TransmitSerial
		call	ReceiveSerial



		call	CRS_Check
		movf	Temp,w
		addlw	Bait0
		movwf	FSR		
		movf	Temp1,w
		movwf	INDF

		call	TransmitSerial
		call	ReceiveSerial

		goto	MainLoop


;------------------------------------------------------------------
;
;-----------------------------------------------------------------
RX_Slovo	
		bcf		Flags,GotNewData		
		call	ReceiveSerial	;go get received data if available
		btfss	Flags,GotNewData ;check if data received
		goto	RX_Slovo	;go do main loop again
		xorlw	0x55
		btfss	STATUS,Z
		goto	RX_Slovo	;go do main loop again


M0
		clrf	Cont
		movlw	0x02
		movwf	Temp
M1
		bcf		Flags,GotNewData
		call	ReceiveSerial	;go get received data if available
		btfss	Flags,GotNewData ;check if data received
		goto	M1		;go do main loop again

		movlw	0x01
		xorwf	Cont,w
		btfss	STATUS,Z
		goto	M2
		movf	Temp1,w
		movwf	Temp
M2
		

		movlw	Bait0
		addwf	Cont,w
		movwf	FSR
		movf	Temp1,w
		movwf	INDF
		incf	Cont,f
		movf	Temp,w

		xorwf	Cont,w
		btfss	STATUS,Z
		goto	M1

		return
		
;----------------------------------------------------------------
;
;----------------------------------------------------------------
Ret_TX_Stat
		movlw	0x55
		call	TransmitSerial
		call	ReceiveSerial


		movlw	Bait0
		movwf	FSR
		movlw	0x81
		movwf	INDF


		call	TransmitSerial
		call	ReceiveSerial
	

		movlw	Bait0+1
		movwf	FSR
		movlw	0x06
		movwf	INDF


		call	TransmitSerial
		call	ReceiveSerial


		clrf	Temp
		btfss	PORTC,0
		bsf		Temp,Taste_
		btfsc	Flags,On_Off
		bsf		Temp,On_Off				
		btfsc	Flags,Beep_
		bsf		Temp,Beep_
		movlw	Bait0+2
		movwf	FSR
		movf	Temp,w
		movwf	INDF


		call	TransmitSerial
		call	ReceiveSerial


		btfss	Temp,Taste_
		goto	x1
		btfsc	Flags,5
		goto	x2
		bsf		Flags,5
		movlw	0x0F
		movwf	Glob_Cont
		goto	x2
;------------------------------------------
x1
		btfss	Flags,5
		goto	x2
		bcf		Flags,5

		movlw	0x0F
		movwf	Glob_Cont
		goto	x2

;------------------------------------------

x2


		movlw	0xFF
		xorwf	Glob_Cont,w
		btfss	STATUS,Z
		incf	Glob_Cont,f
		movlw	Bait0+3
		movwf	FSR
		movf	Glob_Cont,w
		movwf	INDF

		call	TransmitSerial
		call	ReceiveSerial


		movlw	Bait0+4
		movwf	FSR
		movlw	0x00
		movwf	INDF

		call	TransmitSerial
		call	ReceiveSerial


		call	CRS_Check
		movf	Temp,w
		addlw	Bait0
		movwf	FSR		
		movf	Temp1,w
		movwf	INDF

		call	TransmitSerial
		call	ReceiveSerial
		
		return



;-----------------------------------------------------------------
;   Led    LCD
;----------------------------------------------------------------
Lcd_Disp_Conv
		btfss	Led,0
		goto	led1_1
		btfss	Led,4
		goto	led1_2
		movlw	0xC6
		movwf	Disp0
		goto	led2
led1_1
		btfss	Led,4
		goto	led1_3
		movlw	0x22
		movwf	Disp0
		goto	led2
led1_2
		btfss	Led,0
		goto	led1_3
		movlw	0x5F
		movwf	Disp0
		goto	led2
led1_3

		movlw	0x20
		movwf	Disp0		
;***********************************
led2
		btfss	Led,1
		goto	led2_1
		btfss	Led,5
		goto	led2_2
		movlw	0xC6
		movwf	Disp1
		goto	led3
led2_1
		btfss	Led,5
		goto	led2_3
		movlw	0x22
		movwf	Disp1
		goto	led3
led2_2
		btfss	Led,1
		goto	led2_3
		movlw	0x5F
		movwf	Disp1
		goto	led3
led2_3

		movlw	0x20
		movwf	Disp1
;****************************************************
led3
		btfss	Led,2
		goto	led3_1
		btfss	Led,6
		goto	led3_2
		movlw	0xC6
		movwf	Disp3
		goto	led4
led3_1
		btfss	Led,6
		goto	led3_3
		movlw	0x22
		movwf	Disp3
		goto	led4
led3_2
		btfss	Led,2
		goto	led3_3
		movlw	0x5F
		movwf	Disp3
		goto	led4
led3_3

		movlw	0x20
		movwf	Disp3
;****************************************
led4
		btfss	Led,3
		goto	led4_1
		btfss	Led,7
		goto	led4_2
		movlw	0xC6
		movwf	Disp4
		goto	lede
led4_1
		btfss	Led,7
		goto	led4_3
		movlw	0x22
		movwf	Disp4
		goto	lede
led4_2
		btfss	Led,3
		goto	led4_3
		movlw	0x5F
		movwf	Disp4
		goto	lede
led4_3

		movlw	0x20
		movwf	Disp4

lede
		return	
;---------------------------------------------------------------
;      Beep
;----------------------------------------------------------------
Dist_Beep
		clrf	Beep_Time
		movwf	Temp
		xorlw	0x00
		btfss	STATUS,Z
		goto	d1_
		movlw	0x00
		movwf	Beep_Time
		return
d1_
		movlw	.25
		subwf	Temp,f
d1
		movlw	.5
		subwf	Temp,f
		btfsc	STATUS,Z
		return
		incf	Beep_Time,f
		goto	d1





;-----------------------------------------------------------



;--------------------------------------------------------------------------
;  CRS   Temp1 - CRS, Temp -    CRS
;-------------------------------------------------------------------------
CRS_Check
		movlw	0x01
		movwf	Temp

		movlw	Bait0 + 1
		movwf	FSR
		movf	INDF,w
		movwf	Cont
		decf	Cont,f
		decf	Bait0,w
		movwf	Temp1
Crs1		

		movlw	Bait0
		addwf	Temp,w
		movwf	FSR
		movf	INDF,w
		addwf	Temp1,f

		incf	Temp,f
		movf	Temp,w
		xorwf	Cont,w
		btfss	STATUS,Z
		goto	Crs1
		comf	Temp1,f
		incf	Cont,f
		return


;----------------------------------------------------------------------------
;Check if data received and if so, return it in the working register.

ReceiveSerial:	
		btfss	PIR1,RCIF	;check if data
		return			;return if no data

		btfsc	RCSTA,OERR	;if overrun error occurred
		goto	ErrSerialOverr	; then go handle error
		btfsc	RCSTA,FERR	;if framing error occurred
		goto	ErrSerialFrame	; then go handle error

		movf	RCREG,W		;get received data
		movwf	Temp1
		bcf		PIR1,RCIF
		bsf		Flags,GotNewData ;indicate new data received
		return

;error because OERR overrun error bit is set
;can do special error handling here - this code simply clears and continues

ErrSerialOverr:	
		bcf		RCSTA,CREN	;reset the receiver logic
		bsf		RCSTA,CREN	;enable reception again
		return

;error because FERR framing error bit is set
;can do special error handling here - this code simply clears and continues

ErrSerialFrame:	
		movf	RCREG,W		;discard received data that has error
		return

;----------------------------------------------------------------------------
;Transmit data in WREG when the transmit register is empty.

TransmitSerial:	
		btfss	PIR1,TXIF	;check if transmitter busy
		goto	$-1		;wait until transmitter is not busy
		movwf	TXREG		;and transmit the data
		return

;----------------------------------------------------------------------------
;Set up serial port.

SetupSerial:
		movlw	SPBRG	
		movwf	FSR
		movlw	SPBRG_VAL	;set baud rate
		movwf	INDF
		movlw	TXSTA
		movwf	FSR
		movlw	0x24		;enable transmission and high baud rate		
		movwf	INDF		
		movlw	0x90		;enable serial port and reception
		movwf	RCSTA
		clrf	Flags		;clear all flags
		return

;----------------------------------------------------------------------------
;******************************************************************************
; The BIN_3_BCD routine converts the binary number, in the W register, to a 
; binary coded decimal (BCD) munber. This BCD number is stored HMSD:MSD:LSD. This
; routine is used by the DISPLAY subroutine, to convert the time values.
;******************************************************************************
;
BIN_3_BCD   
		clrf	HMSD		; This value contain the 100's digit value
		CLRF    MSD           	; This value contain the 10's digit value
        MOVWF   LSD            	; This value contain the 1's digit value
TENS_SUB    
		MOVLW   .10            	; A decimal 10
        SUBWF   LSD, W         	;
        BTFSS   STATUS, C     	; Did this subtract cause a Negative Result?
		goto	Hundred_SUB
        MOVWF   LSD            	; No, move the result into LSD
        INCF    MSD, F         	; Increment the most significat digit
        GOTO    TENS_SUB       	;
Hundred_SUB
		MOVLW   .10            	; A decimal 10
        subwf   MSD, W         	;
        BTFSS   STATUS, C     	; Did this subtract cause a Negative Result?
        return           	; YES, Return from this Routine
        MOVWF   MSD            	; No, move the result into LSD
        INCF    HMSD, F         ; Increment the most significat digit
        GOTO    Hundred_SUB     
;----------------------------------------------------------------------------------

;---------------------------------------------------------
    org     TABLE_ADDR
;
NUM_TABLE       MOVWF   Temp            ; Store value to TEMP register
                MOVLW   HIGH(TABLE_ADDR); Ensure that the PCLATH high has the 
                MOVWF   PCLATH          ;   correct value
                MOVF    Temp, W         ; Value into table
                ANDLW   0x0F            ; Mask to 4-bits (00 - 0Fh) 
NUM_TBL         ADDWF   PCL, F          ; Determine Offset into table
                RETLW   0x30            ; ASCII value of "0" in W register
                RETLW   0x31            ; ASCII value of "1" in W register
                RETLW   0x32            ; ASCII value of "2" in W register
                RETLW   0x33            ; ASCII value of "3" in W register
                RETLW   0x34            ; ASCII value of "4" in W register
                RETLW   0x35            ; ASCII value of "5" in W register
                RETLW   0x36            ; ASCII value of "6" in W register
                RETLW   0x37           	; ASCII value of "7" in W register
                RETLW   0x38           	; ASCII value of "8" in W register
                RETLW   0x39			; ASCII value of "9" in W register
				RETLW	0xFF
                
NUM_TBL_END   



		END                       ; directive 'end of program'

