//
//первая версия соединения скетчей iCarDuino и rull_pioner_KK_cherez_SPI
// добавленные функции закоментированы //* (с звездочкой)
// замененные тоже только в начале - потом почистить
//** можно удалить - потом почистить
//
#include <IRremote.h> 
#include <OneWire.h>
#include <SPI.h>
#include <EEPROM.h>
  
#define RES_KEY_FLAG_ 0x76  // Флаг первого запуска скетча

byte bytes[4];

//-----------------------------------------
//- входы(пины) ардуино                   -
//-----------------------------------------
int WIRE_PIN = 4;       // цифровой вход(пин) 1WIRE-шины ( температурные датчики )
int RECV_PIN = 3;       // цифровой вход(пин) ИК приемника 
int CS0 = 6 ;           // цифровой выход(пин), управляющий защёлкой (СS в терминах SPI)реле
int CS1 = 8;            //* цифровой выход(пин), управляющий магнитолой (2й контакт)
int CS2 = 9 ;           //* цифровой выход(пин), управляющий защёлкой (СS в терминах SPI)круиз      *
int CS3 = 10 ;          //* цифровой выход(пин), управляющий защёлкой (СS в терминах SPI)магнитола  *


int xpin=0;             // аналоговый вход(пин) для оси X акселерометра
int ypin=1;             // аналоговый вход(пин) для оси Y акселерометра
int zpin=2;             // аналоговый вход(пин) для оси Z акселерометра
int ENCODER1_PIN = 6 ;  // аналоговый вход(пин) для первого энкодера
int ENCODER2_PIN = 7 ;  // аналоговый вход(пин) для второго энкодера 
int RES_PIN = 5 ;       // аналоговый вход(пин) для резестивных(рулевых) кнопок (используется в обоих скетчах)

//-----------------------------------------
//- переменные включения функций скетча   -
//-----------------------------------------
boolean is_ir_key = true; // при первом запуске включаем прием с ИК приемника(уже КК и Магнитола) остальное все выключаем
boolean is_temperature_sensors = false;
boolean is_accelerometer = false;
boolean is_encoder_1 = false;
boolean is_encoder_2 = false;
boolean is_res_keys = false;
boolean is_relay_state = false;

//-----------------------------------------
//- Переменные для температурных датчиков -
//-----------------------------------------
OneWire  ds(WIRE_PIN);
byte addr[8];            
byte data[12];
unsigned long temperature_sensors_milles;
unsigned long temperature_sensors_wait_milles = 500; // Интервал передачи данных от температурных датчиков

//-----------------------------------------
//- Переменные для ИК датчика             -
//-----------------------------------------
IRrecv irrecv(RECV_PIN); 
decode_results results; 
unsigned long ir_dt;
unsigned long ir_dt_old = 0;
unsigned long ir_dt_millis;
unsigned long ir_wait_millis;
unsigned long ir_wait_first = 250;  // время ожидания после первого нажатия кнопки
unsigned long ir_wait_next = 200;    // время ожидания при удержании

//-----------------------------------------
//- Переменные для акселерометра          -
//-----------------------------------------
int x, y, z;
int xyz[4];
int n=0; 
int x_cal=0;
int y_cal=0; //калибровка датчика
int z_cal=0;
unsigned long accelerometer_milles;
unsigned long accelerometer_wait_milles = 80; // Интервал передачи данных от акселерометра

//-----------------------------------------
//- Переменные для первого энкодера       -
//-----------------------------------------
unsigned long encoder1_dt;
unsigned long encoder1_key=0;
unsigned long encoder1_key_old=0;
int encoder1_key1 = 0;
int encoder1_key2 = 0;
int encoder1_key3 = 0;
unsigned long encoder1_millis;
unsigned long encoder1_wait_millis=1;
unsigned long encoder1_key_wait = 500;  // время ожидания до следующего нажатия кнопки энкодера
unsigned long encoder1_key_wait_millis;
unsigned long encoder1_key_millis;
unsigned long encoder1_dt_sum = 0;  
int encoder1_dt_n = 0;

//-----------------------------------------
//- Переменные для второго энкодера       -
//-----------------------------------------
unsigned long encoder2_dt;
unsigned long encoder2_key=0;
unsigned long encoder2_key_old=0;
int encoder2_key1 = 0;
int encoder2_key2 = 0;
int encoder2_key3 = 0;
unsigned long encoder2_millis;
unsigned long encoder2_wait_millis=1;
unsigned long encoder2_key_wait = 500;  // время ожидания до следующего нажатия кнопки энкодера
unsigned long encoder2_key_wait_millis;
unsigned long encoder2_key_millis;

//-------------------------------------------
//- команды управления круизом и магнитолой /*
//-------------------------------------------
const int VOL_UP = 1;
const int VOL_DN = 2;
const int PREV_TR = 3;
const int NEXT_TR = 4;
const int MODE = 5;
const int MUTE = 6;
const int DOP_1 = 7; //*
const int DOP_2 = 8; //*
const int DOP_3 = 9; //*
const int DOP_4 = 10; //*
const int DOP_5 = 11; //*
const int DOP_6 = 12; //*

//int i = 0;
int prevButton = 0;
unsigned long res_k_k= 10;     //задержки в программе круиза
//-----------------------------------------
//- Переменные для резестивных кнопок     -
//-----------------------------------------
unsigned long  res_dt = 0; 
unsigned long  res_dt_sum=0; 
#define RES_DT_COUNT 500                 // Количество считываемых данных
#define RES_DT_SKIP_COUNT 100            // Количество данных, которые надо пропустить при нажатии
#define RES_DT_POINT 6                   // Точность
int res_dt_n = 0;
unsigned long res_key=0;
unsigned long res_key_old=0;
unsigned long res_key_wait_first = 500;  // время ожидания после первого нажатия кнопки
unsigned long res_key_wait_next = 250;   // время ожидания до следующего нажатия кнопки
unsigned long res_key_wait_millis = 0;
unsigned long res_key_millis;
unsigned long res_key_array[51][2];
unsigned int res_key_count = 0;
unsigned int res_key_delta = 3;

//-----------------------------------------
//- Переменные для управления блоком реле -
//-----------------------------------------
unsigned long relays_milles ;
unsigned long  relays_wait_milles = 1000;
static uint8_t relays_state1 = 0x0000;
static uint8_t relays_state2 = 0x0000;
static uint8_t relays_state3 = 0x0000;
static uint8_t relays_state4 = 0x0000;

  
void setup() 
{ 
  Serial.begin(115200); 
  irrecv.enableIRIn(); // включить приемник 
    xyz[0]=0;
    xyz[1]=0; // прочитать значение осей
    xyz[2]=0;
    ir_wait_millis = ir_wait_first;
    accelerometer_milles = millis();
    temperature_sensors_milles = millis();
    encoder1_key_millis = millis();
    encoder2_key_millis = millis();
    encoder1_millis = millis();
    encoder2_millis = millis();
    res_key_millis = millis();
    relays_milles = millis();
    
    encoder1_key_wait_millis=encoder1_key_wait;
    encoder2_key_wait_millis=encoder2_key_wait;
    
    unsigned int first_run_key = EEPROM.read(0);
    if ( first_run_key == RES_KEY_FLAG_ )
    {
      res_key_count = EEPROM.read(1);
      //EEPROM.write(addr, val);
      for(int i=0; i<res_key_count;i++) 
      { 
        res_key_array[i][0] = (EEPROM.read(i+2) * 256) + EEPROM.read(i+2+50) - res_key_delta; res_key_array[i][1] = res_key_array[i][0] + res_key_delta + res_key_delta; 
      }
    }
    for(int i=res_key_count; i<51;i++) 
    { 
      res_key_array[i][0] = 0xFFFFFFFF; res_key_array[i][1] = 0xFFFFFFFF; 
    }
    
    // Инициализируем шину SPI. Если используется программная реализация,
    // то вы должны сами настроить пины, по которым будет работать SPI.
    SPI.begin();
    pinMode(CS0, OUTPUT);
    pinMode (CS2, OUTPUT); //*
    pinMode (CS3, OUTPUT); //*
    pinMode (CS1, INPUT); //*
    digitalWrite(CS0, LOW); // выбор ведомого - нашего регистра
    SPI.transfer(relays_state4); // очищаем содержимое регистра
    SPI.transfer(relays_state3);
    SPI.transfer(relays_state2);
    SPI.transfer(relays_state1);
    SPI.transfer(0); //* команда
    SPI.transfer(0); //* значение
    // Завершаем передачу данных. После этого регистр установит
    // на выводах Q0-Q7 уровни, соответствующие записанным битам.
    digitalWrite(CS0, HIGH);
    
}

//-----------------------------------------------------------
//Фильтр нажатия кнопок (сопротивление = код кнопки ) /*
//-----------------------------------------------------------
int getR() { // Эта функция читает сопротивление с кнопок на руле и возвращает код нажатой кнопки, либо 0

  // читаем сопротивление (на самом деле напряжение, конечно) на аналоговом пине
  int r=analogRead(RES_PIN);
  
   //Serial.println(RES_PIN);проверка нажатия кнопок , для настройки фильтра
  
  // Ищем, какая кнопка соответствует этому сопротивлению.
  // Данные значения сопротивлений подходят для Suzuki Swift, для других автомобилей числа будут другие.
  if (r >= 320 && r <= 340) return (VOL_UP);
  if (r >= 410 && r <= 440) return (VOL_DN);
  if (r >= 90 && r <= 120) return (PREV_TR);
  if (r >= 30 && r <= 50) return (NEXT_TR);
  if (r >= 170 && r <= 190) return (MODE);
  if (r >= 240 && r <= 260) return (MUTE);
  if (r >= 380 && r <= 400) return (DOP_1); //*
  if (r >= 350 && r <= 370) return (DOP_2); //*
  if (r >= 280 && r <= 300) return (DOP_3); //*
  if (r >= 220 && r <= 240) return (DOP_4); //*
  if (r >= 200 && r <= 220) return (DOP_5); //*
  if (r >= 120 && r <= 150) return (DOP_6); //*

  // если ни одна из кнопок не нажата, возвращаем 0
  return (0);
 
}
 
void loop() 



{
  if (Serial.available() >= 1) // Проверяем наличие команд от компьютера
  {
     switch (Serial.read())
    {
     case 0x01: // включить передачу данных от ик-пульта
       is_ir_key = true;
     break;

     case 0x02: // включить передачу данных от датчиков температуры
       is_temperature_sensors = true;
     break;

     case 0x03: // включить передачу данных от акселерометра
       is_accelerometer = true;
     break;

     case 0x04: // включить передачу данных от первого энкодера
       is_encoder_1 = true;
     break;

     case 0x05: // включить передачу данных от второго экнодера
       is_encoder_2 = true;
     break;

     case 0x06: // включить передачу данных от резестивных кнопок
       is_res_keys = true;
     break;

     case 0x07: // включить передачу данных о состоянии реле
       is_relay_state = true;
     break;

     case 0x17: // восстановить состояние реле
     {
       relays_state1 = EEPROM.read(211);
       relays_state2 = EEPROM.read(212);
       relays_state3 = EEPROM.read(213);
       relays_state4 = EEPROM.read(214);

       digitalWrite(CS0, LOW);
       SPI.transfer(relays_state4);
       SPI.transfer(relays_state3);
       SPI.transfer(relays_state2);
       SPI.transfer(relays_state1);
       digitalWrite(CS0, HIGH);

       bytes[0] = 0xBF;          // преобразовать в 4-байта  
       bytes[1] = 0xFF;  
       bytes[2] = 0xFF; 
       bytes[3] = 0xFF; 
       Serial.write( bytes,4); // отправить прочитаное значение компьютеру
       bytes[0] = relays_state4;          // преобразовать в 4-байта  
       bytes[1] = relays_state3;  
       bytes[2] = relays_state2; 
       bytes[3] = relays_state1; 
       Serial.write( bytes,4); // отправить прочитаное значение компьютеру
     }
     break;

     case 0x81: // выключить передачу данных от ик-пульта
       is_ir_key = true;//false;
     break;

     case 0x82: // выключить передачу данных от датчиков температуры
       is_temperature_sensors = false;
     break;

     case 0x83: // выключить передачу данных от акселерометра
       is_accelerometer = false;
     break;

     case 0x84: // выключить передачу данных от первого энкодера
       is_encoder_1 = false;
     break;

     case 0x85: // выключить передачу данных от второго энкодера
       is_encoder_2 = false;
     break;

     case 0x86: // выключить передачу данных от резестивных кнопок
       is_res_keys = false;
     break;

     case 0x87: // выключить передачу данных от резестивных кнопок
       is_relay_state = false;
     break;

     case 0x27: // сохранить текущее состояние реле и отключить их
     {
       EEPROM.write(211,relays_state1);
       EEPROM.write(212,relays_state2);
       EEPROM.write(213,relays_state3);
       EEPROM.write(214,relays_state4);

       relays_state1 = 0;
       relays_state2 = 0;
       relays_state3 = 0;
       relays_state4 = 0;

       digitalWrite(CS0, LOW);
       SPI.transfer(relays_state4);
       SPI.transfer(relays_state3);
       SPI.transfer(relays_state2);
       SPI.transfer(relays_state1);
       digitalWrite(CS0, HIGH);

       bytes[0] = 0xBF;          // преобразовать в 4-байта  
       bytes[1] = 0xFF;  
       bytes[2] = 0xFF; 
       bytes[3] = 0xFF; 
       Serial.write( bytes,4); // отправить прочитаное значение компьютеру
       bytes[0] = relays_state4;          // преобразовать в 4-байта  
       bytes[1] = relays_state3;  
       bytes[2] = relays_state2; 
       bytes[3] = relays_state1; 
       Serial.write( bytes,4); // отправить прочитаное значение компьютеру
     }
     break;

     case 0xAA: // выключить передачу данных от резестивных кнопок
     {
       while (Serial.available() < 5) {}
       int i = Serial.read();
       bytes[0] = Serial.read();          // преобразовать в 4-байта  
       bytes[1] = Serial.read();  
       bytes[2] = Serial.read(); 
       bytes[3] = Serial.read(); 
       unsigned long key_res_min = 0; key_res_min = bytes[0]; key_res_min = key_res_min * 256 + bytes[1];  
       unsigned long key_res_max = 0; key_res_max = bytes[2]; key_res_max = key_res_max * 256 + bytes[3];  
       res_key_array[i-1][0] = key_res_min; 
       res_key_array[i-1][1] = key_res_max;
     }
     break;

     case 0xAB: // сбросить настройки резестивных кнопок в EEPROM
     {
       EEPROM.write(0,0); // сбросить флаг первого запуска
       res_key_count = 0; // сбросить количество резистивных кнопок 
       EEPROM.write(1,0); //
       for(int i=0; i<51;i++) 
       { 
        res_key_array[i][0] = 0xFFFFFFFF; res_key_array[i][1] = 0xFFFFFFFF; 
       }
     } 
     break;

     case 0xBB: // Команда управление реле
     {
       while (Serial.available() < 2) {}
       byte relay_number = Serial.read();
       byte relay_command = Serial.read();
       if( relay_number == 0 && relay_command == 0xFF )
       {
          bytes[0] = 0xBF;          // преобразовать в 4-байта  
          bytes[1] = 0xFF;  
          bytes[2] = 0xFF; 
          bytes[3] = 0xFF; 
          Serial.write( bytes,4); // отправить прочитаное значение компьютеру
          bytes[0] = relays_state4;          // преобразовать в 4-байта  
          bytes[1] = relays_state3;  
          bytes[2] = relays_state2; 
          bytes[3] = relays_state1; 
          Serial.write( bytes,4); // отправить прочитаное значение компьютеру
       }
       else
       {
         uint8_t one = 1 ;
         switch (relay_command)
         {
           case 0x00: // выключить реле № relay_number
           if(relay_number <=8)
           {
             relays_state1 = relays_state1 & ~( one << (relay_number - 1) );
           }
           else
           {
             if(relay_number <=16)
             {
               relays_state2 = relays_state2 & ~( one << (relay_number - 9) );
             }
             else
             {
               if(relay_number <=24)
               {
                 relays_state3 = relays_state3 & ~( one << (relay_number - 17) );
               }
               else
               {
                 if(relay_number <=32)
                 {
                   relays_state4 = relays_state4 & ~( one << (relay_number - 25) );
                 }
               }
             }
           }
           digitalWrite(CS0, LOW);
           SPI.transfer(relays_state4);
           SPI.transfer(relays_state3);
           SPI.transfer(relays_state2);
           SPI.transfer(relays_state1);
           digitalWrite(CS0, HIGH);

            bytes[0] = 0xBF;          // преобразовать в 4-байта  
            bytes[1] = 0xFF;  
            bytes[2] = 0xFF; 
            bytes[3] = 0xFF; 
            Serial.write( bytes,4); // отправить прочитаное значение компьютеру
            bytes[0] = relays_state4;          // преобразовать в 4-байта  
            bytes[1] = relays_state3;  
            bytes[2] = relays_state2; 
            bytes[3] = relays_state1; 
            Serial.write( bytes,4); // отправить прочитаное значение компьютеру
           break;

           case 0x01: // включить реле № relay_number
           if(relay_number <=8)
           {
             relays_state1 = relays_state1 | ( one << (relay_number - 1) );
           }
           else
           {
             if(relay_number <=16)
             {
               relays_state2 = relays_state2 | ( one << (relay_number - 9) );
             }
             else
             {
               if(relay_number <=24)
               {
                 relays_state3 = relays_state3 | ( one << (relay_number - 17) );
               }
               else
               {
                 if(relay_number <=32)
                 {
                   relays_state4 = relays_state4 | ( one << (relay_number - 25) );
                 }
               }
             }
           }
           digitalWrite(CS0, LOW);
           SPI.transfer(relays_state4);
           SPI.transfer(relays_state3);
           SPI.transfer(relays_state2);
           SPI.transfer(relays_state1);
           digitalWrite(CS0, HIGH);

            bytes[0] = 0xBF;          // преобразовать в 4-байта  
            bytes[1] = 0xFF;  
            bytes[2] = 0xFF; 
            bytes[3] = 0xFF; 
            Serial.write( bytes,4); // отправить прочитаное значение компьютеру
            bytes[0] = relays_state4;          // преобразовать в 4-байта  
            bytes[1] = relays_state3;  
            bytes[2] = relays_state2; 
            bytes[3] = relays_state1; 
            Serial.write( bytes,4); // отправить прочитаное значение компьютеру
           break;
         }

       }
     }
     break;
    }
  } 
  /*if( is_ir_key )*/ir_key();                         //*  ИК приёмник ( уже магнитола и круиз )(включена принудительно так как используется и без икара)
  if( is_temperature_sensors ) temperature_sensors();  //  температурные датчики
  if( is_accelerometer ) accelerometer();              //  акселерометр
  if( is_encoder_1 ) encoder_1();                      //  первый энкодер
  if( is_encoder_2 ) encoder_2();                      //  второй энкодер
  /*if( is_res_keys )*/ res_keys();                    //*  резестивные кнопки  ( включена принудительно так как иногда не включалась) 
  if( is_relay_state ) relay_state();                  //  реле
  
}
//----------------------------------------------------------------------------------
// Функция работы с реле
//----------------------------------------------------------------------------------
void relay_state()
{
  if( relays_milles + relays_wait_milles < millis() )
  {
    bytes[0] = 0xBF;          // преобразовать в 4-байта  
    bytes[1] = 0xFF;  
    bytes[2] = 0xFF; 
    bytes[3] = 0xFF; 
    Serial.write( bytes,4); // отправить прочитаное значение компьютеру
    bytes[0] = relays_state4;       // преобразовать в 4-байта  
    bytes[1] = relays_state3;  
    bytes[2] = relays_state2; 
    bytes[3] = relays_state1; 
    Serial.write( bytes,4); // отправить прочитаное значение компьютеру

    relays_milles = millis();
  }
}

//----------------------------------------------------------------------------------
// Функция работы с резестивными кнопками
//----------------------------------------------------------------------------------
void res_keys()
{ 
  {
    res_dt = analogRead(RES_PIN); // прочитать данные АЦП 
    
    if( res_dt >= 0x05 && res_dt <= 0x3F0 )
    {
      res_dt_n++;                        //отсчитываем количество данных с кнопок
      if( res_dt_n > RES_DT_SKIP_COUNT ) //когда их больше RES_DT_SKIP_COUNT (100 по условию ) переходим дальше
      {
        res_dt_sum += (res_dt << RES_DT_POINT);//считаем дальше
        if( res_dt_n == RES_DT_COUNT)          // доходим до RES_DT_COUNT (500 по условию) переходим дальше 
        { 

          res_key = (res_dt_sum / (RES_DT_COUNT - RES_DT_SKIP_COUNT));
          res_key = (((((( res_dt_sum / (( RES_DT_COUNT - RES_DT_SKIP_COUNT ) + (2^(RES_DT_POINT-1)-1) ) >> (RES_DT_POINT-1)) + 1) >> 1) + 1)>> 1)); // + 1) >> 1;
          res_dt_sum = 0; res_dt_n = 0;
        }
       }
    }
    else
    { 
      res_dt_sum = 0; res_dt_n = 0; res_key = 0;
      res_key_wait_millis = 0;
    }
  }
  if( res_key_millis + res_key_wait_millis*2 <= millis() ) 
    { res_key_old = 0; }
  if( res_key_millis + res_key_wait_millis <= millis() )
  {
    if( res_key != 0 )
    {
      if( ((res_key_old - res_key_delta) <=  res_key) && (res_key <= (res_key_old + res_key_delta)) )
      {
        res_key_millis = millis(); res_key_wait_millis = res_key_wait_next;
      }
      else
      {
        res_key_millis = millis(); res_key_wait_millis = res_key_wait_first;
      }

        int i = 0; int exit = 0;
        while( res_key_array[i][0] != 0xFFFFFFFF && exit == 0 )
        {
          if( (res_key_array[i][0] <= res_key) && (res_key <= res_key_array[i][1]) ) exit = 1; else i++;
        }
        if( exit == 1 ) 
        { 
          bytes[0] = 0xAA;          // преобразовать в 4-байта  
          bytes[1] = 0;  
          bytes[2] = RES_PIN; 
          bytes[3] = i+1; 
          Serial.write( bytes,4); // отправить прочитаное значение компьютеру
        }
        else
        {
          if( res_key_count < 50 )
          {
            res_key_array[res_key_count][0] = res_key - res_key_delta; res_key_array[res_key_count][1] = res_key + res_key_delta;
            res_key_count++;
            
            EEPROM.write(1, res_key_count); // Запоминаем количество кнопок
            byte one_byte = res_key / 256;
            EEPROM.write(res_key_count+1, one_byte ); // Запоминаем старший байт значения кнопки
            one_byte = res_key - one_byte * 256;
            EEPROM.write(res_key_count+1+50, one_byte ); // Запоминаем младший байт значения кнопки
            EEPROM.write(0, RES_KEY_FLAG_);
          
            bytes[0] = 0xAA;          // преобразовать в 4-байта  
            bytes[1] = 0;  
            bytes[2] = RES_PIN; 
            bytes[3] = res_key_count; 
            Serial.write( bytes,4); // отправить прочитаное значение компьютеру
          }
          else
          {
            bytes[0] = 0xAA;          // преобразовать в 4-байта  
            bytes[1] = 0xAA;  
            bytes[2] = (res_key & 0xFF00) >> 8; 
            bytes[3] = res_key & 0xFF; 
            Serial.write( bytes,4); // отправить прочитаное значение компьютеру
          }
        }
    }
    res_key_old = res_key;
  }
}

//----------------------------------------------------------------------------------
// Функция работы с первым энкодером
//----------------------------------------------------------------------------------
void encoder_1()
{
  if( encoder1_key_millis + encoder1_key_wait_millis*2 < millis() ) { encoder1_key_old = 0; }
  if( encoder1_millis + encoder1_wait_millis < millis() )
  {
    encoder1_millis = millis();
    encoder1_dt = analogRead(ENCODER1_PIN); // прочитать данные АЦП
    
    if( encoder1_dt >= 0x246 && encoder1_dt <= 0x286 )
    { // Здесь обрабатываем удержание кнопки
      encoder1_key = ENCODER1_PIN;
      encoder1_key = (encoder1_key << 16) | 0x030000EE;
      if ( encoder1_key == encoder1_key_old )
      { // Здесь обрабатываем удержание кнопки
        if( encoder1_key_millis + encoder1_key_wait_millis < millis() )
        { 
          bytes[0] = encoder1_key & 0xFF;          // преобразовать в 4-байта  
          bytes[1] = (encoder1_key & 0xFF00) >> 8;  
          bytes[2] = (encoder1_key & 0xFF0000) >> 16; 
          bytes[3] = (encoder1_key & 0xFF000000) >> 24;
          Serial.write( bytes,4); // отправить прочитаное значение компьютеру
          encoder1_key_millis = millis(); encoder1_key_wait_millis = encoder1_key_wait; //ir_wait_next;
        }
      }
      else 
      { // Здесь обрабатываем первое нажатие кнопки
        encoder1_key_millis = millis(); encoder1_key_wait_millis = 50; //ir_wait_first;
      } 
      encoder1_key_old = encoder1_key;
    } 
    else
    {
      if( encoder1_dt >= 0x3E0 && encoder1_dt <= 0x410 && encoder1_key3 != 1 )
      {
        if( (encoder1_key2 == 2) && (encoder1_key3 == 3))
        { 
          bytes[0] = 0xEE;          // преобразовать в 2-байта 
          bytes[1] = 0; 
          bytes[2] = ENCODER1_PIN;
          bytes[3] = 1;
          Serial.write( bytes,4); // отправить прочитаное значение компьютеру     
        }
        else
        {
          if( (encoder1_key2 == 3) && (encoder1_key3 == 2) )
          {
            bytes[0] = 0xEE;          // преобразовать в 2-байта 
            bytes[1] = 0; 
            bytes[2] = ENCODER1_PIN;
            bytes[3] = 2;
            Serial.write( bytes,4); // отправить прочитаное значение компьютеру     
          }
        }
        encoder1_key1=encoder1_key2; encoder1_key2=encoder1_key3; encoder1_key3=1;
      }
      else
      {
        if( encoder1_dt >= 0xA0 && encoder1_dt <= 0xF0 && encoder1_key3 != 2 )
        {
          encoder1_key1=encoder1_key2; encoder1_key2=encoder1_key3; encoder1_key3=2;
        }
        else
        {
          if( encoder1_dt >= 0x1A0 && encoder1_dt <= 0x200 && encoder1_key3 != 3 )
          {
            encoder1_key1=encoder1_key2; encoder1_key2=encoder1_key3; encoder1_key3=3;
          }
        }
      }
    }
  }
}

//----------------------------------------------------------------------------------
// Функция работы со вторым энкодером
//----------------------------------------------------------------------------------
void encoder_2()
{  
  if( encoder2_key_millis + encoder2_key_wait_millis*2 < millis() ) { encoder2_key_old = 0; }
  if( encoder2_millis + encoder2_wait_millis < millis() )
  {
    encoder2_millis = millis();
    encoder2_dt = analogRead(ENCODER2_PIN); // прочитать данные АЦП
    if( encoder2_dt >= 0x246 && encoder2_dt <= 0x286 )
    { // Здесь обрабатываем удержание кнопки
      encoder2_key = ENCODER2_PIN;
      encoder2_key = (encoder2_key << 16) | 0x030000EE;
      if ( encoder2_key == encoder2_key_old )
      { // Здесь обрабатываем удержание кнопки
        if( encoder2_key_millis + encoder2_key_wait_millis < millis() )
        { 
          bytes[0] = encoder2_key & 0xFF;          // преобразовать в 4-байта  
          bytes[1] = (encoder2_key & 0xFF00) >> 8;  
          bytes[2] = (encoder2_key & 0xFF0000) >> 16; 
          bytes[3] = (encoder2_key & 0xFF000000) >> 24; 
          Serial.write( bytes,4); // отправить прочитаное значение компьютеру
          encoder2_key_millis = millis(); encoder2_key_wait_millis = encoder2_key_wait; //ir_wait_next;
        }
      }
      else 
      { // Здесь обрабатываем первое нажатие кнопки
        encoder2_key_millis = millis(); encoder2_key_wait_millis = 50; //ir_wait_first;
      } 
      encoder2_key_old = encoder2_key;
    } 
    else
    {
      if( encoder2_dt >= 0x3E0 && encoder2_dt <= 0x410 && encoder2_key3 != 1 )
      {
        if( (encoder2_key2 == 2) && (encoder2_key3 == 3))
        { 
          bytes[0] = 0xEE;          // преобразовать в 2-байта 
          bytes[1] = 0; 
          bytes[2] = ENCODER2_PIN;
          bytes[3] = 1;
          Serial.write( bytes,4); // отправить прочитаное значение компьютеру     
        }
        else
        {
          if( (encoder2_key2 == 3) && (encoder2_key3 == 2) )
          {
            bytes[0] = 0xEE;          // преобразовать в 2-байта 
            bytes[1] = 0; 
            bytes[2] = ENCODER2_PIN;
            bytes[3] = 2;
            Serial.write( bytes,4); // отправить прочитаное значение компьютеру     
          }
        }
        encoder2_key1=encoder2_key2; encoder2_key2=encoder2_key3; encoder2_key3=1;
      }
      else
      {
        if( encoder2_dt >= 0xA0 && encoder2_dt <= 0xF0 && encoder2_key3 != 2 )
        {
          encoder2_key1=encoder2_key2; encoder2_key2=encoder2_key3; encoder2_key3=2;
        }
        else
        {
          if( encoder2_dt >= 0x1A0 && encoder2_dt <= 0x200 && encoder2_key3 != 3 )
          {
            encoder2_key1=encoder2_key2; encoder2_key2=encoder2_key3; encoder2_key3=3;
          }
        }
      }
    }
  }
}

//----------------------------------------------------------------------------------
// Функция работы с ИК приёмником (вместо нее используем другую ниже)
//----------------------------------------------------------------------------------
/* void ir_key()
{
  if( ir_dt_millis + ir_wait_millis*2 < millis() ) { ir_dt_old = 0; }
  if (irrecv.decode(&results))  
  {
   if (results.value > 0 && results.value < 0xFFFFFFFF) 
   {
    ir_dt = results.value;
    if ( ir_dt == ir_dt_old )
    { // Здесь обрабатываем удержание кнопки
      if( ir_dt_millis + ir_wait_millis < millis() )
      { 
        bytes[0] = ir_dt & 0xFF;          // преобразовать в 4-байта  
        bytes[1] = (ir_dt & 0xFF00) >> 8;  
        bytes[2] = (ir_dt & 0xFF0000) >> 16; 
        bytes[3] = (ir_dt & 0xFF000000) >> 24; 
        Serial.write( bytes,4); // отправить прочитаное значение компьютеру
        ir_dt_millis = millis(); ir_wait_millis = ir_wait_next;
      }
    }
    else 
    { // Здесь обрабатываем первое нажатие кнопки
      bytes[0] = ir_dt & 0xFF;          // преобразовать в 4-байта  
      bytes[1] = (ir_dt & 0xFF00) >> 8;  
      bytes[2] = (ir_dt & 0xFF0000) >> 16; 
      bytes[3] = (ir_dt & 0xFF000000) >> 24; 
      Serial.write( bytes,4); // отправить прочитаное значение компьютеру
      ir_dt_millis = millis(); ir_wait_millis = ir_wait_first;
    } 
    ir_dt_old = ir_dt;
   }
   else
   {
      ir_dt_millis = millis(); ir_wait_millis = ir_wait_first;
   }
   irrecv.resume();
  }
}

*/
//----------------------------------------------------------------------------------
// Функция работы с акселерометром
//----------------------------------------------------------------------------------
void accelerometer()
{
  if( accelerometer_milles + accelerometer_wait_milles < millis() )
  {
    xyz[0]=analogRead(xpin);
    xyz[1]=analogRead(ypin); // прочитать значение осей
    xyz[2]=analogRead(zpin);
    xyz[3]=0;

    bytes[0] = 0xEF; bytes[1] = 0xFF; bytes[2] = 0xFF; bytes[3] = 0xFF; 
    Serial.write( bytes,4); // отправить 0xEFFFFFFF - код данных от акселерометра
    Serial.write( (byte*)&xyz,8); // отправить значения осей 
    accelerometer_milles = millis();
  }
}

//----------------------------------------------------------------------------------
// Функция определение температуры датчиков DS18B20
//----------------------------------------------------------------------------------
void temperature_sensors()
{
  if( temperature_sensors_milles + temperature_sensors_wait_milles < millis() )
  {
    temperature_sensors_milles = millis();
  
    byte i;

    if (!ds.search(addr)) 
    {                       // поиск нового датчика
      ds.reset_search();    // если не нашли, сбрасываем поиск в начало
      return;               // и выходим 
    }
  
    // Часть кода, которая ниже, выполняется только если
    // найден новый датчик температуры , с которым ещё не работали в
    // главном цикле до сброса поиска

    if (OneWire::crc8( addr, 7) != addr[7]) // Проверка CRC 
    { 
      return; // Если не пройдена, то в начало главного цикла и продолжаем поиск других датчиков
    }
  
    if (addr[0] != 0x28) // Проверка того, что найденное устройство - температурный датчик DS18B20 
    {        
      return; // Если не он, то опять в начало главного цикла на продолжение поиска
    }
  
    ds.reset();
    ds.select(addr);
    ds.write(0x44,1);
    ds.reset();
    ds.select(addr);
    ds.write(0xBE);

    bytes[0] = 0xFF; bytes[1] = 0xFF; bytes[2] = 0xFF; bytes[3] = 0xFF; 
    Serial.write( bytes,4); // отправить 0xFFFFFFFF - код температурного датчика
    Serial.write( addr,8); // отправить 8 байтовый номер температурного датчика 
  
    for ( i = 0; i < 9; i++) // получаем данные с датчика
    {         
      data[i] = ds.read();
    }
    bytes[0] = 0;          // отправляем байты содержащие температуру  
    bytes[1] = 0;  
    bytes[2] = data[0]; 
    bytes[3] = data[1]; 
    Serial.write( bytes,4); // значение температурного датчика 
  }
}  
//----------------------------------------------------------------------
//      Функция управления цыфровыми потенциометрами /*
//-----------------------------------------------------------------------
void ir_key()
{ 
    int currButton = getR(); // заносим в переменную currButton код нажатой кнопки
  if (currButton != prevButton) 
  { // если значение поменялось с прошлого раза

    res_k_k = millis();//delay(10);
    currButton = getR(); // ждем 10ms и читаем еще раз, чтобы исключить "дребезг" кнопки

    if (currButton != prevButton) 
    { // если код кнопки точно поменялся с прошлого раза
     // Serial.println(currButton); проверка фильтра кнопок
      prevButton = currButton;   // сохраняем новое значение в переменную prevButton

      // Выставляем сопротивление на потенциометре, тем самым посылаем команду на магнитолу или ...
      // Значения сопротивлений даны для магнитолы Pioneer и Круиза Solarisa? для магнитол других марок числа будут другие.
      switch (currButton) 
      {
        case VOL_UP: /*Serial.println("VOL_UP-1");*/digitalWrite(CS3, LOW); SPI.transfer(B00010001); SPI.transfer(174); digitalWrite(CS3, HIGH);break;  // 16k //21
        case VOL_DN: /*Serial.println("VOL_DN-2");*/digitalWrite(CS3, LOW); SPI.transfer(B00010001); SPI.transfer(133); digitalWrite(CS3, HIGH);break;  // 24k //31
        case PREV_TR: pinMode(CS1, OUTPUT);/*Serial.println("PREV_TR-3");*/digitalWrite(CS3, LOW); SPI.transfer(B00010001); SPI.transfer(202); digitalWrite(CS3, HIGH);pinMode(CS1, INPUT);break; // 11k //202
        case NEXT_TR: pinMode(CS1, OUTPUT);/*Serial.println("NEXT_TR-4");*/digitalWrite(CS3, LOW); SPI.transfer(B00010001); SPI.transfer(217); digitalWrite(CS3, HIGH);pinMode(CS1, INPUT);break; // 8k  //217
        case MODE: /*Serial.println("MODE-5");*/digitalWrite(CS3, LOW); SPI.transfer(B00010001); SPI.transfer(249); digitalWrite(CS3, HIGH);break;     // 1.6k//249
        case MUTE: /*Serial.println("MUTE-6");*/digitalWrite(CS3, LOW); SPI.transfer(B00010001); SPI.transfer(242); digitalWrite(CS3, HIGH);break;     // 3k  //242
        case DOP_1: /*Serial.println("DOP_1-7");*/digitalWrite(CS2, LOW); SPI.transfer(B00010001); SPI.transfer(153); digitalWrite(CS2, HIGH);break;     // --  //153
        case DOP_2: /*Serial.println("DOP_2-8");*/digitalWrite(CS2, LOW); SPI.transfer(B00010001); SPI.transfer(153); digitalWrite(CS2, HIGH);break;     // --  //153
        case DOP_3: /*Serial.println("DOP_3-9");*/ digitalWrite(CS2, LOW); SPI.transfer(B00010001); SPI.transfer(153); digitalWrite(CS2, HIGH);break;  // --  //153
        case DOP_4: /*Serial.println("DOP_4-10");*/digitalWrite(CS2, LOW); SPI.transfer(B00010001); SPI.transfer(215); digitalWrite(CS2, HIGH);break;  //+3.9k//196
        case DOP_5: /*Serial.println("DOP_5-11");*/digitalWrite(CS2, LOW); SPI.transfer(B00010001); SPI.transfer(15); digitalWrite(CS2, HIGH);break;   //-910 //46
        case DOP_6: /*Serial.println("DOP_6-12");*/digitalWrite(CS2, LOW); SPI.transfer(B00010001); SPI.transfer(3); digitalWrite(CS2, HIGH);break;   //-220 //15
        default: digitalWrite(CS2, LOW); SPI.transfer(B00010001); SPI.transfer(153); digitalWrite(CS2, HIGH); digitalWrite(CS3, LOW); SPI.transfer(B00010001); SPI.transfer(255); digitalWrite(CS3, HIGH); 
        //Serial.println("STOP"); 
        break; // 0k
      }
    }
  }
  res_k_k = millis();//delay(5);
} 
