/**
 * VXIS VX1937 Controller
 * Copyright (C) 2017 AngelOfGrief
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <EEPROM.h>

#define MENU 2
#define LEFT 3
#define RIGHT 4
#define UP 9
#define DOWN 10
#define ZOOM 11
#define PAL_NTSC 12

void setup() {
pinMode(LED_BUILTIN, OUTPUT);
pinMode(MENU, OUTPUT);
pinMode(LEFT, OUTPUT);
pinMode(RIGHT, OUTPUT);
pinMode(UP, OUTPUT);
pinMode(DOWN, OUTPUT);
pinMode(ZOOM, OUTPUT);
pinMode(PAL_NTSC, OUTPUT);
digitalWrite(LED_BUILTIN, HIGH);
digitalWrite(MENU, HIGH);
digitalWrite(LEFT, HIGH);
digitalWrite(RIGHT, HIGH);
digitalWrite(UP, HIGH);
digitalWrite(DOWN, HIGH);
digitalWrite(ZOOM, HIGH);
digitalWrite(PAL_NTSC, HIGH);

int x;
int y;
int w;
int h;
int c;
int b;
int d;

x=toneg(EEPROM.read(0)); // x offset
y=toneg(EEPROM.read(1)); // y offset
w=toneg(EEPROM.read(2)); // width
h=toneg(EEPROM.read(3)); // height
c=toneg(EEPROM.read(4)); // contrast
b=toneg(EEPROM.read(5)); // brighness
d=EEPROM.read(6); // start delay

wait(d);

adjust(x); // x position
if (y<0) press(DOWN,y); // y position
if (y>0) press(UP,y);

press(MENU,1); // enter menu
press(DOWN,2);
adjust(h); // V-size
press(ZOOM,1);

press(UP,1);
adjust(w); // width
press(DOWN,3);
adjust(c); // contrast
press(UP,1);
adjust(b); // brighness

press(MENU,1); // end

digitalWrite(LED_BUILTIN,HIGH);  

Serial.begin(9600);
  while (!Serial)   {
    ; // wait for serial connection
  }

}

void wait(int n) {
for(int cnt=0;cnt<n*2;cnt++) {
digitalWrite(LED_BUILTIN,HIGH);  
delay(250);
digitalWrite(LED_BUILTIN,LOW);
delay(250);
}
}

int toneg(int a) {
if (a>127) return a-256; else return a;
}


void press(int button,int n) {

for(int cnt=0;cnt<abs(n);cnt++) {
  digitalWrite(button, LOW);
  digitalWrite(LED_BUILTIN,LOW);  
  delay(50);
  digitalWrite(button, HIGH);
  digitalWrite(LED_BUILTIN,HIGH);  
  delay(50);
  }
}

void adjust(int p) {
if (p>0) press(RIGHT,p); // brightness 
if (p<0) press(LEFT,p); // brightness 
}

// X Y W H C B  

String cmd_line;
String num_value;
String cmd;

void loop() {
static int ptr=0;
int a=0;
int number;

if(Serial.available())  {

a = Serial.read();
Serial.write(a); // echo

if (a=='?') {
Serial.println("\r\nVX1937 Controller by AngelOfGrief (c) 2017 Moscow.");
Serial.println("X,Y - screen offset\r\nW - width\r\nH - height\r\nC - contrast\r\nB - brighness\r\nD - start up delay.");
Serial.println("Command example: B22, C10, X33, etc");
Serial.println("Stored values are:");
Serial.print("x=");
Serial.println(toneg(EEPROM.read(0)));
Serial.print("y=");
Serial.println(toneg(EEPROM.read(1)));
Serial.print("w=");
Serial.println(toneg(EEPROM.read(2)));
Serial.print("h=");
Serial.println(toneg(EEPROM.read(3)));
Serial.print("c=");
Serial.println(toneg(EEPROM.read(4)));
Serial.print("b=");
Serial.println(toneg(EEPROM.read(5)));
Serial.print("d=");
Serial.println(toneg(EEPROM.read(6)));
Serial.println("");
return;

}

if (a==0xD) {
//Serial.println(cmd_line);
cmd = cmd_line.substring(0,1);
cmd.toLowerCase();
num_value=cmd_line.substring(1);
cmd_line = "";

if (cmd=="x" || cmd=="y" || cmd=="w" || cmd=="h" || cmd=="c" || cmd=="b" || cmd=="d") {
Serial.println("");
Serial.print(cmd);
Serial.print(':');
Serial.print(num_value);
} else {
Serial.println("Unknown command. Command syntax: Xnnn, X - command, nnn - value. Allowed commands are X,Y,W,H,C,B.");
}  

number = num_value.toInt();

if (cmd=="x") {EEPROM.write(0,number);Serial.println(" Ok");}
if (cmd=="y") {EEPROM.write(1,number);Serial.println(" Ok");}
if (cmd=="w") {EEPROM.write(2,number);Serial.println(" Ok");}
if (cmd=="h") {EEPROM.write(3,number);Serial.println(" Ok");}
if (cmd=="c") {EEPROM.write(4,number);Serial.println(" Ok");}
if (cmd=="b") {EEPROM.write(5,number);Serial.println(" Ok");}
if (cmd=="d") {EEPROM.write(6,number);Serial.println(" Ok");}

} else {
cmd_line +=char(a);
}

}
 

}
