// USBRadioDlg.h : header file
//

#if !defined(AFX_USBRADIODLG_H__9D7506DB_8939_4A97_A60A_6451826C7D93__INCLUDED_)
#define AFX_USBRADIODLG_H__9D7506DB_8939_4A97_A60A_6451826C7D93__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"
#include "FMRadioDevice.h"
#include "SettingsDlg.h"
#include "RadioFirstRunDlg.h"

//Application Title to be displayed in the title bar
#define TITLE "Silicon Labs USB FM Radio"

//The Dialog height and width
#define DLGHEIGHT	255	//195
#define DLGWIDTH	560

//Volume Coordinates
#define VOLUME_MIN_X	357
#define VOLUME_MAX_X	446
#define VOLUME_MIN_Y	157
#define VOLUME_MAX_Y	175

//Coordinates for station text
#define STATION_X	355
#define	STATION_Y	73

//Coordinates/Limits for RDS Text
#define RDS_X		31
#define RDS_Y		120
#define RDS_MAX_X	530
#define RDS_WIDTH	RDS_MAX_X - RDS_X

//Transparent Color definition
#define TRANSPARENT_COLOR	0x00FF00

//Define for the Tray notify message
#define WM_TRAY_ICON_NOTIFY_MESSAGE	WM_USER + 1

//Timer ID/Time definitions
#define TIMER_FIND_DEVICE		0
#define TIMER_FIND_DEVICE_TIME	500

#define TIMER_POLL_DEVICE		1
#define TIMER_POLL_DEVICE_TIME	40

#define TIMER_AUDIO_STREAM		2
#define TIMER_AUDIO_STREAM_TIME	25

#define TIMER_BUTTON_DOWN		3
#define TIMER_BUTTON_DOWN_TIME	1750

#define TIMER_SCAN_UP			4
#define TIMER_SCAN_DOWN			5
#define TIMER_SCANPRESET_UP		6
#define TIMER_SCANPRESET_DOWN	7

#define TIMER_VOLUME_MOVING		8

#define TIMER_TUNE_DELAY		9
#define TIMER_TUNE_DELAY_TIME	750

#define TIMER_SCROLL_RDS		10
#define TIMER_SCROLL_RDS_0_TIME	2500
#define TIMER_SCROLL_RDS_TIME	250

//Keycode definitions
#define KEY_RIGHT	0x27
#define KEY_LEFT	0x25
#define KEY_UP		0x26
#define KEY_DOWN	0x28
#define KEY_F1	0x70
#define KEY_F2	0x71
#define KEY_F3	0x72
#define KEY_F4	0x73
#define KEY_F5	0x74
#define KEY_F6	0x75
#define KEY_F7	0x76
#define KEY_F8	0x77
#define KEY_F9	0x78
#define KEY_F10 0x79
#define KEY_F11 0x7A
#define KEY_F12	0x7B

//Current preset struct
typedef struct CurrentPreset
{
	int presetNum;
	bool onPreset;
} CurrentPreset;

/////////////////////////////////////////////////////////////////////////////
// CUSBRadioDlg dialog

class CUSBRadioDlg : public CDialog
{
// Construction
public:
	CUSBRadioDlg(CWnd* pParent = NULL);	// standard constructor

	void KeyUp(BYTE key);
	CPoint m_DownPoint;
	BYTE m_KeyDown;

// Dialog Data
	//{{AFX_DATA(CUSBRadioDlg)
	enum { IDD = IDD_USBRADIO_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CUSBRadioDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//Tooltip control
	CToolTipCtrl* m_pToolTip;

	HICON m_hIcon;
	HICON m_hSmallIcon;

	//Variables for the Radio Device Class, Radio Data Struct, and RDS Data struct
	CFMRadioDevice m_FMRadioDevice;
	RadioData m_RadioData;
	RDSData m_RDSData;

	//Tray variables
	NOTIFYICONDATA m_TrayData;
	CMenu m_TrayMenu;

	//Always on top boolean
	bool m_AlwaysOnTop;

	//Point variables for mouse click/movement
	CPoint m_Point;
	CPoint m_MovePoint;

	//Volume/Display/Radio control variables
	BYTE m_Volume;
	bool m_VolumeToggle;
	bool m_Muting;
	bool m_Scanning;
	bool m_ScanJustPressed;
	CurrentPreset m_CurrentPreset;
	int m_CurrentRDSDisplayIndex;

	//Running number of missed RDS calls variable
	BYTE m_MissedRDSCalls;

	//Temp Variables predefined for timer functions
	BYTE m_Status;
	BYTE m_tmpRSSI;
	BYTE m_tmpMonoStereo;
	CString m_tmpRDSText;

	//Bitmaps for the Buttons
	CBitmapButton m_Close;
	CBitmapButton m_Restore;
	CBitmapButton m_Minimize;
	CBitmapButton m_PresetScanDown;
	CBitmapButton m_PresetScanUp;
	CBitmapButton m_PresetScanUpDown;
	CBitmapButton m_PresetScanDownDown;
	CBitmapButton m_Preset1;
	CBitmapButton m_Preset2;
	CBitmapButton m_Preset3;
	CBitmapButton m_Preset4;
	CBitmapButton m_Preset5;
	CBitmapButton m_Preset6;
	CBitmapButton m_Preset7;
	CBitmapButton m_Preset8;
	CBitmapButton m_Preset9;
	CBitmapButton m_Preset10;
	CBitmapButton m_Preset11;
	CBitmapButton m_Preset12;
	CBitmapButton m_Mute;
	CBitmapButton m_MuteDown;
	CBitmapButton m_TuneDown;
	CBitmapButton m_TuneUp;
	CBitmapButton m_ScanDown;
	CBitmapButton m_ScanUp;
	CBitmapButton m_ScanDownDown;
	CBitmapButton m_ScanUpDown;
	CBitmapButton m_Settings;
	CBitmapButton m_StereoMono;
	CBitmapButton m_StereoMonoDown;
	CBitmapButton m_FMTunerLink;
	CBitmapButton m_USBMCULink;
	CBitmapButton m_SilabsLink;

	//Bitmaps for the Window and Letters
	CBitmap	m_bmpBackgroundImage;
	CBitmap m_bmpMHz;
	CBitmap m_bmpDotLarge;
	CBitmap m_bmpSpaceLarge;
	CBitmap	m_bmp0Large;
	CBitmap m_bmp1Large;
	CBitmap	m_bmp2Large;
	CBitmap m_bmp3Large;
	CBitmap	m_bmp4Large;
	CBitmap m_bmp5Large;
	CBitmap	m_bmp6Large;
	CBitmap m_bmp7Large;
	CBitmap	m_bmp8Large;
	CBitmap m_bmp9Large;
	CBitmap m_bmpALarge;
	CBitmap m_bmpBLarge;
	CBitmap m_bmpCLarge;
	CBitmap m_bmpDLarge;
	CBitmap m_bmpELarge;
	CBitmap m_bmpFLarge;
	CBitmap m_bmpGLarge;
	CBitmap m_bmpHLarge;
	CBitmap m_bmpILarge;
	CBitmap m_bmpJLarge;
	CBitmap m_bmpKLarge;
	CBitmap m_bmpLLarge;
	CBitmap m_bmpMLarge;
	CBitmap m_bmpNLarge;
	CBitmap m_bmpOLarge;
	CBitmap m_bmpPLarge;
	CBitmap m_bmpQLarge;
	CBitmap m_bmpRLarge;
	CBitmap m_bmpSLarge;
	CBitmap m_bmpTLarge;
	CBitmap m_bmpULarge;
	CBitmap m_bmpVLarge;
	CBitmap m_bmpWLarge;
	CBitmap m_bmpXLarge;
	CBitmap m_bmpYLarge;
	CBitmap m_bmpZLarge;
	CBitmap m_bmpDotSmall;
	CBitmap m_bmpDashSmall;
	CBitmap m_bmpApostropheSmall;
	CBitmap m_bmpExclamationSmall;
	CBitmap m_bmpAmpersandSmall;
	CBitmap m_bmpCommaSmall;
	CBitmap m_bmpSpaceSmall;
	CBitmap	m_bmp0Small;
	CBitmap m_bmp1Small;
	CBitmap	m_bmp2Small;
	CBitmap m_bmp3Small;
	CBitmap	m_bmp4Small;
	CBitmap m_bmp5Small;
	CBitmap	m_bmp6Small;
	CBitmap m_bmp7Small;
	CBitmap	m_bmp8Small;
	CBitmap m_bmp9Small;
	CBitmap m_bmpASmall;
	CBitmap m_bmpBSmall;
	CBitmap m_bmpCSmall;
	CBitmap m_bmpDSmall;
	CBitmap m_bmpESmall;
	CBitmap m_bmpFSmall;
	CBitmap m_bmpGSmall;
	CBitmap m_bmpHSmall;
	CBitmap m_bmpISmall;
	CBitmap m_bmpJSmall;
	CBitmap m_bmpKSmall;
	CBitmap m_bmpLSmall;
	CBitmap m_bmpMSmall;
	CBitmap m_bmpNSmall;
	CBitmap m_bmpOSmall;
	CBitmap m_bmpPSmall;
	CBitmap m_bmpQSmall;
	CBitmap m_bmpRSmall;
	CBitmap m_bmpSSmall;
	CBitmap m_bmpTSmall;
	CBitmap m_bmpUSmall;
	CBitmap m_bmpVSmall;
	CBitmap m_bmpWSmall;
	CBitmap m_bmpXSmall;
	CBitmap m_bmpYSmall;
	CBitmap m_bmpZSmall;
	CBitmap m_bmpRSSI0;
	CBitmap m_bmpRSSI1;
	CBitmap m_bmpRSSI2;
	CBitmap m_bmpRSSI3;
	CBitmap m_bmpRSSI4;
	CBitmap m_bmpRSSI5;
	CBitmap m_bmpMono;
	CBitmap m_bmpStereo;
	CBitmap m_bmpVolumeSlide;

	//Drawing functions
	void DrawBackground();
	void DrawLED(CDC* memDC, CClientDC* dc);
	void DrawStation(CDC* memDC, CClientDC* dc, double station);
	void DrawRSSI(CDC* memDC, CClientDC* dc, BYTE rssi);
	void DrawMonoStereo(CDC* memDC, CClientDC* dc, BYTE stereoMono);
	void DrawRDS(CDC* memDC, CClientDC* dc, CString rdsText);
	void DrawVolumeSlide(CDC* memDC, CClientDC* dc);
	void DrawBitmapOnDC(CDC* memDC, CClientDC* cDC, CBitmap* bmp, int x, int y);
	void DrawBitmapOnDC(CDC* memDC, CClientDC* cDC, CBitmap* bmp, int x, int y, UINT transparentColor);

	//Update functions
	void UpdateRadioLED();
	void UpdateStationLED();
	void UpdateRSSILED();
	void UpdateMonoStereoLED();
	void UpdateRDSDisplay();
	void UpdateStationToolTips(bool enableTips);
	void UpdateSettings();
	void ResetRDSText();

	//Bitmap Button functions
	void DisplayButtons();
	void LoadBitmaps();
	void LoadBitmapAndCoordinates(CBitmap* bmp, UINT resourceID);
	void CreateBitmapButton(CBitmapButton* bitmapButton, int left, int top, UINT upResource, UINT downresource, UINT buttonResource, CString toolTipText);
	CBitmap* GetAlphanumericLargeBitmap(char c);
	CBitmap* GetAlphanumericSmallBitmap(char c);
	void RemoveButtons();

	//Tray function
	void ShowTrayMenu(CPoint pt);

	//Radio Control functions
	void TunePreset(int preset);
	bool TuneStation(bool tuneUp);
	bool TuneDevice(bool tuneUp);
	bool TuneDevice(double frequency);
	bool SeekDevice(bool seekUp);
	void SetPreset(int preset, UINT id);
	void StartScan(UINT id, int timerID);
	void EndScan();
	
	// Generated message map functions
	//{{AFX_MSG(CUSBRadioDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnTrayNotify(WPARAM wParam, LPARAM lParam);
	afx_msg void OnCancel();
	afx_msg void OnMinimize();
	afx_msg LRESULT OnCommandHelp(WPARAM wParam, LPARAM lParam);
	afx_msg void OnPreset1();
	afx_msg void OnPreset2();
	afx_msg void OnPreset3();
	afx_msg void OnPreset4();
	afx_msg void OnPreset5();
	afx_msg void OnPreset6();
	afx_msg void OnPreset7();
	afx_msg void OnPreset8();
	afx_msg void OnPreset9();
	afx_msg void OnPreset10();
	afx_msg void OnPreset11();
	afx_msg void OnPreset12();
	afx_msg void OnStereoMono();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnSeekup();
	afx_msg void OnSeekdown();
	afx_msg void OnPresetScanUp();
	afx_msg void OnPresetScanDown();
	afx_msg void OnTuneup();
	afx_msg void OnTunedown();
	afx_msg void OnMute();
	afx_msg void OnShowradio();
	afx_msg void OnSettings();
	afx_msg void OnFMTunerLink();
	afx_msg void OnUSBMCULink();
	afx_msg void OnSilabsLink();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_USBRADIODLG_H__9D7506DB_8939_4A97_A60A_6451826C7D93__INCLUDED_)
