// SettingsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "USBRadio.h"
#include "SettingsDlg.h"
#include "AboutDlg.h"
#include <vector>
#include "DeviceSelectDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg dialog


CSettingsDlg::CSettingsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSettingsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSettingsDlg)
	m_MonoStereo = FALSE;
	m_AlwaysOnTop = FALSE;
	m_ShowInTitleBar = FALSE;
	m_ShowInTray = FALSE;
	m_MuteOnStartup = FALSE;
	m_Preset1 = 0.0;
	m_Preset2 = 0.0;
	m_Preset3 = 0.0;
	m_Preset4 = 0.0;
	m_Preset5 = 0.0;
	m_Preset6 = 0.0;
	m_Preset7 = 0.0;
	m_Preset8 = 0.0;
	m_Preset9 = 0.0;
	m_Preset10 = 0.0;
	m_Preset11 = 0.0;
	m_Preset12 = 0.0;
	m_IgnoreABFlag = FALSE;
	//}}AFX_DATA_INIT
}


void CSettingsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSettingsDlg)
	DDX_Control(pDX, IDC_SLIDER_SCANTIME, m_ScanTime);
	DDX_Control(pDX, IDC_SLIDER_SEEKTHRESHOLD, m_SeekThreshold);
	DDX_Control(pDX, IDC_SLIDER_BUFFERSIZE, m_BufferSize);
	DDX_Check(pDX, IDC_CHECK_MONO, m_MonoStereo);
	DDX_Check(pDX, IDC_CHECK_ALWAYSONTOP, m_AlwaysOnTop);
	DDX_Check(pDX, IDC_CHECK_SHOWINTITLEBAR, m_ShowInTitleBar);
	DDX_Check(pDX, IDC_CHECK_SHOWINTRAY, m_ShowInTray);
	DDX_Check(pDX, IDC_CHECK_MUTEONSTARTUP, m_MuteOnStartup);
	DDX_Text(pDX, IDC_EDIT_PRESET1, m_Preset1);
	DDV_MinMaxDouble(pDX, m_Preset1, 76., 108.);
	DDX_Text(pDX, IDC_EDIT_PRESET2, m_Preset2);
	DDV_MinMaxDouble(pDX, m_Preset2, 76., 108.);
	DDX_Text(pDX, IDC_EDIT_PRESET3, m_Preset3);
	DDV_MinMaxDouble(pDX, m_Preset3, 76., 108.);
	DDX_Text(pDX, IDC_EDIT_PRESET4, m_Preset4);
	DDV_MinMaxDouble(pDX, m_Preset4, 76., 108.);
	DDX_Text(pDX, IDC_EDIT_PRESET5, m_Preset5);
	DDV_MinMaxDouble(pDX, m_Preset5, 76., 108.);
	DDX_Text(pDX, IDC_EDIT_PRESET6, m_Preset6);
	DDV_MinMaxDouble(pDX, m_Preset6, 76., 108.);
	DDX_Text(pDX, IDC_EDIT_PRESET7, m_Preset7);
	DDV_MinMaxDouble(pDX, m_Preset7, 76., 108.);
	DDX_Text(pDX, IDC_EDIT_PRESET8, m_Preset8);
	DDV_MinMaxDouble(pDX, m_Preset8, 76., 108.);
	DDX_Text(pDX, IDC_EDIT_PRESET9, m_Preset9);
	DDV_MinMaxDouble(pDX, m_Preset9, 76., 108.);
	DDX_Text(pDX, IDC_EDIT_PRESET10, m_Preset10);
	DDV_MinMaxDouble(pDX, m_Preset10, 76., 108.);
	DDX_Text(pDX, IDC_EDIT_PRESET11, m_Preset11);
	DDV_MinMaxDouble(pDX, m_Preset11, 76., 108.);
	DDX_Text(pDX, IDC_EDIT_PRESET12, m_Preset12);
	DDV_MinMaxDouble(pDX, m_Preset12, 76., 108.);
	DDX_Check(pDX, IDC_CHECK_IGNOREABFLAG, m_IgnoreABFlag);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSettingsDlg, CDialog)
	//{{AFX_MSG_MAP(CSettingsDlg)
	ON_BN_CLICKED(IDC_BUTTON_ABOUT, OnButtonAbout)
	ON_BN_CLICKED(IDC_BUTTON_AUDIOINPUT, OnButtonAudioinput)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg message handlers

BOOL CSettingsDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	//Initialize all the settings in the dialog based on the radio data

	m_SeekThreshold.SetRange(0, MAX_SEEK_THRESHOLD, TRUE);
	m_SeekThreshold.SetTicFreq(4);
	m_SeekThreshold.SetPos(m_RadioData.seekThreshold);
	m_ScanTime.SetRange(1,15, TRUE);
	m_ScanTime.SetPos(m_RadioData.scanTime);
	m_MonoStereo = (m_RadioData.monoStereo) ? true : false;
	m_MuteOnStartup = m_RadioData.muteOnStartup;
	m_AlwaysOnTop = m_RadioData.alwaysOnTop;
	m_ShowInTitleBar = m_RadioData.showInTitleBar;
	m_ShowInTray = m_RadioData.showInTray;
	m_IgnoreABFlag = m_RadioData.ignoreABFlag;
	
	switch (m_RadioData.band)
	{
	case DATA_BAND_875_108MHZ	:	CheckRadioButton(IDC_RADIO_BAND_875, IDC_RADIO_BAND_76, IDC_RADIO_BAND_875);	break;
	case DATA_BAND_76_90MHZ		:	CheckRadioButton(IDC_RADIO_BAND_875, IDC_RADIO_BAND_76, IDC_RADIO_BAND_76);		break;
	default						:	CheckRadioButton(IDC_RADIO_BAND_875, IDC_RADIO_BAND_76, IDC_RADIO_BAND_875);	break;
	}

	switch (m_RadioData.spacing)
	{
	case DATA_SPACING_200KHZ	:	CheckRadioButton(IDC_RADIO_SPACING_200, IDC_RADIO_SPACING_50, IDC_RADIO_SPACING_200);	break;
	case DATA_SPACING_100KHZ	:	CheckRadioButton(IDC_RADIO_SPACING_200, IDC_RADIO_SPACING_50, IDC_RADIO_SPACING_100);	break;
	case DATA_SPACING_50KHZ		:	CheckRadioButton(IDC_RADIO_SPACING_200, IDC_RADIO_SPACING_50, IDC_RADIO_SPACING_50);	break;
	default						:	CheckRadioButton(IDC_RADIO_SPACING_200, IDC_RADIO_SPACING_50, IDC_RADIO_SPACING_100);	break;
	}
	
	switch (m_RadioData.deemphasis)
	{
	case DATA_DEEMPHASIS_75	:	CheckRadioButton(IDC_RADIO_DEEMPHASIS_75, IDC_RADIO_DEEMPHASIS_50, IDC_RADIO_DEEMPHASIS_75);	break;
	case DATA_DEEMPHASIS_50	:	CheckRadioButton(IDC_RADIO_DEEMPHASIS_75, IDC_RADIO_DEEMPHASIS_50, IDC_RADIO_DEEMPHASIS_50);	break;
	default					:	CheckRadioButton(IDC_RADIO_DEEMPHASIS_75, IDC_RADIO_DEEMPHASIS_50, IDC_RADIO_DEEMPHASIS_75);	break;
	}

	m_Preset1 = m_RadioData.preset[0];
	m_Preset2 = m_RadioData.preset[1];
	m_Preset3 = m_RadioData.preset[2];
	m_Preset4 = m_RadioData.preset[3];
	m_Preset5 = m_RadioData.preset[4];
	m_Preset6 = m_RadioData.preset[5];
	m_Preset7 = m_RadioData.preset[6];
	m_Preset8 = m_RadioData.preset[7];
	m_Preset9 = m_RadioData.preset[8];
	m_Preset10 = m_RadioData.preset[9];
	m_Preset11 = m_RadioData.preset[10];
	m_Preset12 = m_RadioData.preset[11];

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSettingsDlg::OnOK() 
{
	BOOL status = true;

	//On OK, update the settings, and then store them in the radio data
	if (UpdateData(TRUE))
	{
		m_RadioData.seekThreshold = m_SeekThreshold.GetPos();
		m_RadioData.scanTime = m_ScanTime.GetPos();
		m_RadioData.muteOnStartup = (m_MuteOnStartup ? true : false);
		m_RadioData.alwaysOnTop = (m_AlwaysOnTop ? true : false);
		m_RadioData.showInTitleBar = (m_ShowInTitleBar ? true : false);
		m_RadioData.showInTray = (m_ShowInTray ? true : false);
		m_RadioData.ignoreABFlag = (m_IgnoreABFlag ? true : false);

		if (m_MonoStereo)
			m_RadioData.monoStereo = DATA_MONOSTEREO_MONO;
		else
			m_RadioData.monoStereo = DATA_MONOSTEREO_STEREO;

		switch (GetCheckedRadioButton(IDC_RADIO_BAND_875, IDC_RADIO_BAND_76))
		{
		case IDC_RADIO_BAND_875	:	m_RadioData.band = DATA_BAND_875_108MHZ;	break;
		case IDC_RADIO_BAND_76	:	m_RadioData.band = DATA_BAND_76_90MHZ;		break;
		default					:	m_RadioData.band = DATA_BAND_875_108MHZ;	break;
		}

		switch (GetCheckedRadioButton(IDC_RADIO_SPACING_200, IDC_RADIO_SPACING_50))
		{
		case IDC_RADIO_SPACING_200	:	m_RadioData.spacing = DATA_SPACING_200KHZ;	break;
		case IDC_RADIO_SPACING_100	:	m_RadioData.spacing = DATA_SPACING_100KHZ;	break;
		case IDC_RADIO_SPACING_50	:	m_RadioData.spacing = DATA_SPACING_50KHZ;	break;
		default						:	m_RadioData.spacing = DATA_SPACING_100KHZ;	break;
		}

		switch (GetCheckedRadioButton(IDC_RADIO_DEEMPHASIS_75, IDC_RADIO_DEEMPHASIS_50))
		{
		case IDC_RADIO_DEEMPHASIS_75	:	m_RadioData.deemphasis = DATA_DEEMPHASIS_75;	break;
		case IDC_RADIO_DEEMPHASIS_50	:	m_RadioData.deemphasis = DATA_DEEMPHASIS_50;	break;
		default							:	m_RadioData.deemphasis = DATA_DEEMPHASIS_75;	break;
		}
			
		m_RadioData.preset[0] = m_Preset1;
		m_RadioData.preset[1] = m_Preset2;
		m_RadioData.preset[2] = m_Preset3;
		m_RadioData.preset[3] = m_Preset4;
		m_RadioData.preset[4] = m_Preset5;
		m_RadioData.preset[5] = m_Preset6;
		m_RadioData.preset[6] = m_Preset7;
		m_RadioData.preset[7] = m_Preset8;
		m_RadioData.preset[8] = m_Preset9;
		m_RadioData.preset[9] = m_Preset10;
		m_RadioData.preset[10] = m_Preset11;
		m_RadioData.preset[11] = m_Preset12;

		double minBand = 87.5, maxBand = 108.0, spacing = 0.2;

		switch (GetCheckedRadioButton(IDC_RADIO_BAND_875, IDC_RADIO_BAND_76))
		{
		case IDC_RADIO_BAND_875	:	minBand = 87.5;	
									maxBand = 108.0;	break;
		case IDC_RADIO_BAND_76	:	minBand = 76.0;	
									maxBand = 90.0;		break;
		default					:	minBand = 87.5;
									maxBand = 108.0;	break;
		}

		switch (GetCheckedRadioButton(IDC_RADIO_SPACING_200, IDC_RADIO_SPACING_50))
		{
		case IDC_RADIO_SPACING_200	:	spacing = 0.2;	break;
		case IDC_RADIO_SPACING_100	:	spacing = 0.1;	break;
		case IDC_RADIO_SPACING_50	:	spacing = 0.05;	break;
		default						:	spacing = 0.1;	break;
		}

		// Go through the presets and ensure they are valid to the new settings
		for (int i = 0; i < PRESET_NUM; i++)
		{
			if ((m_RadioData.preset[i] >= minBand) && (m_RadioData.preset[i] <= maxBand))
			{
				if ((minBand == 87.5) && (spacing == 0.2) && (((UINT)(m_RadioData.preset[i] * 100.0) % 20) != 10))
				{
					status = false;
				}
				if ((minBand == 76) && (spacing == 0.2) && (((UINT)(m_RadioData.preset[i] * 100.0) % 20) != 0))
				{
					status = false;
				}
				else if ((spacing == 0.1) && (((UINT)(m_RadioData.preset[i] * 100.0) % 10) != 0))
				{
					status = false;
				}
				else if ((spacing == 0.05) && (((UINT)(m_RadioData.preset[i] * 100.0) % 5) != 0))
				{
					status = false;
				}
			}
			else
			{
				status = false;
			}
		}
	}

	if (status)
	{
		CDialog::OnOK();
	}
	else
	{
		MessageBox("Please set all presets to valid stations", "Notice", MB_OK | MB_ICONEXCLAMATION);

	}
}

void CSettingsDlg::OnButtonAbout() 
{
	CAboutDlg aboutDlg;

	//Display the about box with the current version of everything
	aboutDlg.m_USBRadioHWVersion.Format("%d.%d.%d", m_RadioData.hwVersion, m_RadioData.swVersion, m_RadioData.firmwareVersion);

	aboutDlg.DoModal();
}

void CSettingsDlg::OnButtonAudioinput() 
{
	std::vector<CString> deviceList;

	//Obtain the number of input devices on the system
	DWORD numWaveInputDevices = waveInGetNumDevs();

	//Scan through each input device to see if we can find the FM Radio
	for (DWORD i = 0; i < numWaveInputDevices; i++)
	{
		WAVEINCAPS waveInputCapabilities;

		//Get the device capabilities of the currently indexed device
		if (waveInGetDevCaps(i, &waveInputCapabilities, sizeof(waveInputCapabilities)) == MMSYSERR_NOERROR)
		{
			deviceList.push_back(waveInputCapabilities.szPname);
		}
	}

	CDeviceSelectDlg deviceSelectDlg(&deviceList, m_RadioIndex);

	if (deviceSelectDlg.DoModal() == IDOK)
	{
		m_RadioIndex = deviceSelectDlg.GetIndex();
	}
}
