// DeviceSelectDlg.cpp : implementation file
//

#include "stdafx.h"
#include "USBRadio.h"
#include "DeviceSelectDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDeviceSelectDlg dialog


CDeviceSelectDlg::CDeviceSelectDlg(std::vector<CString>* deviceList /*=NULL*/, int lastKnownIndex /*=-1*/, CWnd* pParent /*=NULL*/)
	: CDialog(CDeviceSelectDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDeviceSelectDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	//Initialize the device list vector, and the last known device used
	m_pDeviceList = deviceList;
	m_Index = lastKnownIndex;
}


void CDeviceSelectDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDeviceSelectDlg)
	DDX_Control(pDX, IDC_LIST_DEVICE, m_DeviceList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDeviceSelectDlg, CDialog)
	//{{AFX_MSG_MAP(CDeviceSelectDlg)
	ON_LBN_DBLCLK(IDC_LIST_DEVICE, OnDblclkListDevice)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDeviceSelectDlg message handlers

BOOL CDeviceSelectDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	//Check that the device list isnt NULL, if it is, then cancel the dialog
	if (m_pDeviceList)
	{
		//Loop through each string, and add it to the list control
		for (DWORD i = 0; i < m_pDeviceList->size(); i++)
		{
			m_DeviceList.AddString((*m_pDeviceList)[i]);
		}

		//Set the selection to that last know index
		m_DeviceList.SetCurSel(m_Index);
	}
	else
	{
		CDialog::OnCancel();
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

int CDeviceSelectDlg::GetIndex()
{
	//Return the index
	return m_Index;
}

void CDeviceSelectDlg::OnOK() 
{
	//Set the index to the current selection
	m_Index = m_DeviceList.GetCurSel();
	
	CDialog::OnOK();
}

void CDeviceSelectDlg::OnDblclkListDevice() 
{
	//Double clicking the list is the same as clicking OK
	OnOK();	
}
