#if !defined(AFX_BOOTLOADDLG_H__CE75EBFA_964B_431B_B730_F72086B7614F__INCLUDED_)
#define AFX_BOOTLOADDLG_H__CE75EBFA_964B_431B_B730_F72086B7614F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// BootloadDlg.h : header file
//

#include "resource.h"
#include "FMRadioDevice.h"

//Timer definitions
#define TIMER_BOOTLOAD_PROGRESS			55
#define TIMER_BOOTLOAD_PROGRESS_TIME	250

//Bootlaod structure, contains verstion, complete status,
//and pointer to a bootload class
typedef struct BootloadStruct
{
	CFMRadioBootloader* pFMRadioBootloader;
	BOOL bootloadComplete;
	BYTE swVersion;
	BYTE hwVersion;
	BOOL bootloadSuccess;
	BOOL bootloadCloseOnFail;
} BootloadStruct;

/////////////////////////////////////////////////////////////////////////////
// CBootloadDlg dialog

class CBootloadDlg : public CDialog
{
// Construction
public:

	//Constructor which takes the SW/HW versions, HID Handle to the radio, and buffers/sizes used for bootloading
	CBootloadDlg(BYTE swVersion, BYTE hwVersion, HANDLE fmRadioDataHandle = NULL, BYTE* pEndpoint0ReportBuffer = NULL, DWORD endpoint0ReportBufferSize = 0, BYTE* pEndpoint2ReportBuffer = NULL, DWORD endpoint2ReportBufferSize = 0, CWnd *pParent = NULL);
	~CBootloadDlg();

	//Bootload structure which contains the bootloader, complete flag and HW/SW versions
	BootloadStruct m_BootloadStruct;

// Dialog Data
	//{{AFX_DATA(CBootloadDlg)
	enum { IDD = IDD_DIALOG_BOOTLOAD };
	CProgressCtrl	m_ProgressBar;
	CString	m_Percentage;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBootloadDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CBootloadDlg)
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnTimer(UINT nIDEvent);
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_BOOTLOADDLG_H__CE75EBFA_964B_431B_B730_F72086B7614F__INCLUDED_)
