//-----------------------------------------------------------------------------
// F320_FM_RadioMain.h
//-----------------------------------------------------------------------------
// Copyright 2006 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This is the header file for FM Radio project.
//
// FID:            32X000041
// Target:         C8051F320
// Tool chain:     KEIL C51 7.0.0.1
//                 Silicon Laboratories IDE version 2.3
// Command Line:   See Readme.txt
// Project Name:   F320_FM_Radio
//
// Release 1.1
//    -No changes made to this module (DM)
//    -16 JAN 2006
//
// Release 1.0
//    -Initial Revision (DM)
//    -05 AUG 2005
//

#ifndef F320_FM_RADIOMAIN_H_
#define F320_FM_RADIOMAIN_H_
//-----------------------------------------------------------------------------
// Other SFR Definitions
//-----------------------------------------------------------------------------

sbit RADIO_RESET = P1^2;               // Si470x reset
sbit SEN_bar = P1^3;                   // SPI enable (active low)
sbit SCK = P1^4;                       // SPI clock
sbit MISO = P1^5;                      // SPI master in/slave out
sbit MOSI = P1^6;                      // SPI master out/slave in
sfr16 TMR2RL = 0xca;                   // Timer2 reload value
sfr16 TMR2 = 0xcc;                     // Timer2 counter

//-----------------------------------------------------------------------------
// Global Constants
//-----------------------------------------------------------------------------

enum { OFF, ON };                      // ON and OFF constants

#define SYSCLK 24000000                // SYSCLK frequency in Hz

#define USB_REGISTER_BANK 1

// USB clock selections (SFR CLKSEL)
#define USB_4X_CLOCK       0x00        // Select 4x clock multiplier, for USB
#define USB_INT_OSC_DIV_2  0x10        // Full Speed See Data Sheet section
#define USB_EXT_OSC        0x20        // 13. Oscillators
#define USB_EXT_OSC_DIV_2  0x30
#define USB_EXT_OSC_DIV_3  0x40
#define USB_EXT_OSC_DIV_4  0x50

// System clock selections (SFR CLKSEL)
#define SYS_INT_OSC  0x00              // Select to use internal oscillator
#define SYS_EXT_OSC  0x01              // Select to use an external oscillator
#define SYS_4X_DIV_2 0x02

//-----------------------------------------------------------------------------
// Type Definitions
//-----------------------------------------------------------------------------

// BYTE type definition
#ifndef BYTE_DEF_
#define BYTE_DEF_
typedef unsigned char BYTE;
#endif // BYTE_DEF_

// UINT type definition
#ifndef UINT_DEF_
#define UINT_DEF_
typedef unsigned int UINT;
#endif // UINT_DEF_

// WORD type definition, for KEIL Compiler
#ifndef WORD_DEF_
#define WORD_DEF_
typedef union {unsigned int i; unsigned char c[2];} WORD;
#define LSB 1
#define MSB 0
#endif // WORD_DEF_

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------

void Oscillator_Init (void);           // Initialize the system clock
void Port_Init (void);                 // Configure ports
void USB0_Init (void);                 // Configure USB core
void Timer0_2_Init (void);             // Start timers 0 and 2
void ADC0_Init (void);                 // Configure ADC for audio sampling
void Crystal_Init (void);              // Configure for Si470x clock
void SPI0_Init (void);                 // Initialize SPI for Si470x
void PCA0_Init (void);                 // Initialize PCA for LED control

void Delay_Main (void);                // Approximately 500 uS (24 Mhz sysclk)

#endif // F320_FM_RADIOMAIN_H_
//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------