//-----------------------------------------------------------------------------
// F320_LED_Control.h
//-----------------------------------------------------------------------------
// Copyright 2006 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This is the header file controlling the LED patterns.
//
// FID:            32X000039
// Target:         C8051F320
// Tool chain:     KEIL C51 7.0.0.1
//                 Silicon Laboratories IDE version 2.3
// Command Line:   See Readme.txt
// Project Name:   F320_FM_Radio
//
// Release 1.1
//    -No changes made to this module (DM)
//    -16 JAN 2006
//
// Release 1.0
//    -Initial Revision (DM)
//    -22 JUN 2005
//

#ifndef  F320_LED_CONTROL_H_
#define  F320_LED_CONTROL_H_
//-----------------------------------------------------------------------------
// Other SFR Definitions
//-----------------------------------------------------------------------------

#define GREEN_LED_DIMMER PCA0CPH1
#define RED_LED_DIMMER   PCA0CPH0

//-----------------------------------------------------------------------------
// Constants
//-----------------------------------------------------------------------------

// Define LED operation modes
#define NO_CHANGE_LED    0x00
#define ALL_COLOR_LED    0x01
#define BLINK_GREEN_LED  0x02
#define BLINK_RED_LED    0x04
#define BLINK_ORANGE_LED 0x10
#define SOLID_GREEN_LED  0x20
#define SOLID_RED_LED    0x40
#define SOLID_ORANGE_LED 0x80

// Define all color LED states
#define OFF1_AC            0x00
#define GREEN_RAMPUP1_AC   0x01
#define ORANGE_FULL1_AC    0x02
#define GREEN_RAMPDOWN1_AC 0x03
#define OFF2_AC            0x04
#define GREEN_RAMPUP2_AC   0x05
#define ORANGE_FULL2_AC    0x06
#define GREEN_RAMPDOWN2_AC 0x07

// Define blinking LED states, used for all three colors
#define LED_ON_FULL_BLINK  0x00
#define LED_RAMPDOWN_BLINK 0x01
#define LED_OFF_BLINK      0x02
#define LED_ON_MIN_BLINK   0x03
#define LED_RAMPUP_BLINK   0x04

// Define maximum and minimum LED brightness controls for PCA, absolute max brigtness = 0x40!
#define MAX_BRIGHT_LED    0xC8
#define MIN_BRIGHT_LED    0xE0
#define OFF_BRIGHT_LED    0xFF
#define ORANGE_OFFSET_LED 0x03

// Define default timing for blink rates
#define GREEN_ON_TIME_LED        0xFF
#define GREEN_RAMPDOWN_TIME_LED  0x12
#define GREEN_OFF_TIME_LED       0xFF
#define GREEN_RAMPUP_TIME_LED    0x30

#define RED_ON_TIME_LED          0x0A
#define RED_RAMPDOWN_TIME_LED    0x04
#define RED_OFF_TIME_LED         0xFF
#define RED_RAMPUP_TIME_LED      0x01

#define ORANGE_ON_TIME_LED       0x09
#define ORANGE_RAMPDOWN_TIME_LED 0x09
#define ORANGE_OFF_TIME_LED      0xFF
#define ORANGE_RAMPUP_TIME_LED   0x09

//-----------------------------------------------------------------------------
// Type Definitions
//-----------------------------------------------------------------------------

// BYTE type definition
#ifndef BYTE_DEF_
#define BYTE_DEF_
typedef unsigned char BYTE;
#endif // BYTE_DEF_

//-----------------------------------------------------------------------------
// External Variable Declaration
//-----------------------------------------------------------------------------

extern data BYTE Next_LED_Mode;

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------

void LED_StateMachine (void);          // LED control state machine

#endif // F320_LED_CONTROL_H_
//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------