//****************** Здесь необходимо указать свои значения *************** 

int analogPin=0; // пин для подключения кнопок A0 

int release_button = 1023; // значение при отпущенных кнопках 
int button_release_range = 20; // диапазон значения + - при отпущенных кнопках 
int button_range = 10; // диапазон значения нажатых кнопок + - 
int time_holding = 500; // время для удержания кнопок в миллисекундах 
int time_tinkling = 10; // время исключающее дребезг контактов в миллисекундах 
int vol_up = 353; // значение кнопки увеличить громкость 
int vol_down = 170; // значение кнопки уменьшить громкость data1
int alt_tab = 0; // значение кнопки которая будет работать как Alt + Tab 
int next = 110; // значение кнопки которая будет работать как Next при коротком нажатии и Fast Forward при удержании 
int previous = 40; // значение кнопки которая будет работать как Previous при коротком нажатии и Rewind при удержании data1
int play_pause = 0; // значение кнопки которая будет работать как Play/Pause при коротком нажатии и Mute при удержании data1

//************************************************************************** 

#define ACCPin 2 // через делитель к ACC 
#define relePin1 10 // реле разрыва OTG 5 контакт
#define relePin2 9 // реле датчика хола
#define relePin3 8 // реле активации усилителе
#define ONHUB 100 // время включения реле HUB
#define ONTablet 3000 // время включения планшета 
#define ONAudio 5000 // время включения аудио        
#define OFFHUB 10000 // время выключения реле HUB---
#define OFFTablet 5000 // время выключения планшета 
#define OFFAudio 8000 // время выключения аудио        

unsigned long LastTimeKeyPressed = millis();
unsigned long duration, millisold, off = 0;
boolean stateACC, relestate1, relestate2,relestate3 = 0;
//**************************************************************************
int data;  
unsigned long flag = 0;  
unsigned long eventTime = 0;  
unsigned long pauseMillis = 0; 

void setup()  
{ 
 Serial.begin(9600);
pinMode(relePin1, OUTPUT); 
//pinMode(relePin4, OUTPUT); 
pinMode(relePin2, OUTPUT);
pinMode(relePin3, OUTPUT);
Keyboard.begin();  


}  

void loop()  
{  
autorele();  
Knopki();
} 

void Knopki(){
data=analogRead(analogPin);  
if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 0)  
{  
eventTime=millis();  
}  

//********************** Громкость ************************************ 

if(millis()-time_tinkling && millis()-eventTime<time_holding-1 && data >= vol_up - button_range && data <= vol_up + button_range && flag == 0) 
{   
Remote.increase();  
flag = 5;  
delay(10);  
Remote.clear();  
}  

if(millis()-eventTime>time_holding && data >= vol_up - button_range && data <= vol_up + button_range && flag == 5 || data >= vol_up - button_range && data <= vol_up + button_range && flag && flag == 3)  
{   
Remote.increase(); 
flag = 3;  
Remote.clear();  
delay(100);  
}  

if(millis()-time_tinkling && millis()-eventTime<time_holding-1 && data >= vol_down - button_range && data <= vol_down + button_range && flag == 0)  
{   
Remote.decrease();  
flag = 6;  
delay(10);  
Remote.clear();  
}  

if(millis()-eventTime>time_holding && data >= vol_down - button_range && data <= vol_down + button_range && flag == 6 || data >= vol_down - button_range && data <= vol_down + button_range && flag == 3)  
{   
Remote.decrease();  
flag = 3;  
Remote.clear();  
delay(100);  
}  

//********************** AltTab + Ещё что то ************************************   

if(millis()-time_tinkling && millis()-eventTime<time_holding-1 && data >= alt_tab - button_range && data <= alt_tab + button_range)  
{   
flag = 1;  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 1 && pauseMillis == 0)  
{  
Keyboard.press(KEY_LEFT_ALT);  
Keyboard.press(KEY_TAB);  
Keyboard.release(KEY_TAB);  
Keyboard.press(KEY_TAB);  
Keyboard.release(KEY_TAB);  
flag = 0;  
pauseMillis = millis();  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 1 && pauseMillis != 0)  
{  
Keyboard.press(KEY_TAB);  
Keyboard.release(KEY_TAB);  
flag = 0;  
pauseMillis = millis();  
}  

if(pauseMillis && millis()-pauseMillis >= 800 && data>=release_button - button_release_range && data<=release_button + button_release_range)  
{  
flag = 0;  
pauseMillis = 0;  
Keyboard.releaseAll();  
}  

if(millis()-eventTime>time_holding && data >= alt_tab - button_range && data <= alt_tab + button_range && flag == 1)  
{   
flag = 0;  
}  
//********************** Next и Fast Forward ************************************   

if(millis()-time_tinkling && millis()-eventTime<time_holding-1 && data >= next - button_range && data <= next + button_range)  
{   
flag = 2;  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 2)  
{  
Remote.next();  
flag = 0;  
delay(10);  
Remote.clear();  
}  

if(millis()-eventTime>time_holding && data >= next - button_range && data <= next + button_range && flag == 2 || data >= next - button_range && data <= next + button_range && flag == 3)  
{   
Remote.forward();  
flag = 3;  
Remote.clear();  
delay(100);  
}  
//********************** Previous и Rewind ************************************   

if(millis()-time_tinkling && millis()-eventTime<time_holding-1 && data >= previous - button_range && data <= previous + button_range)  
{   
flag = 4;  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 4)  
{  
Remote.previous();  
flag = 0;  
delay(10);  
Remote.clear();  
}  

if(millis()-eventTime>time_holding && data >= previous - button_range && data <= previous + button_range && flag == 4 || data >= previous - button_range && data <= previous + button_range && flag == 3)  
{   
Remote.rewind(); 
flag = 3;  
Remote.clear();  
delay(100);  
}  

//********************** Play/pause + Mute ************************************   

if(millis()-time_tinkling && millis()-eventTime<time_holding-1 && data >= play_pause - button_range && data <= play_pause + button_range)  
{   
flag = 7;  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 7)  
{  
Remote.play_pause();   
flag = 0;  
delay(10);  
Remote.clear();  
}  

if(millis()-eventTime>time_holding && data >= play_pause - button_range && data <= play_pause + button_range && flag == 7)  
{   
Remote.mute(); 
flag = 0; 
delay(10); 
Remote.clear();  
}  

if(data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 3 || data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 5 || data>=release_button - button_release_range && data<=release_button + button_release_range && flag == 6)  
{  
flag = 0;  
}   
}

void  autorele()
{
  if (digitalRead(ACCPin)&&!stateACC) {
    stateACC=1;
    duration = millis();
    }
    if (!digitalRead(ACCPin)&&stateACC) {
    stateACC=0;
    off = millis();
        }
    if(digitalRead(ACCPin) && stateACC && millis ()-duration > ONHUB){
    digitalWrite(relePin1, HIGH);
    relestate1 = 1;
    millisold = millis();
    }
    if(digitalRead(ACCPin) && stateACC &&  millis ()-duration > ONTablet){
    digitalWrite(relePin2, HIGH);
    relestate2 = 1;
    millisold = millis();
    }
    if(digitalRead(ACCPin) && stateACC &&  millis ()-duration > ONAudio){
    digitalWrite(relePin3, HIGH);
    relestate3 = 1;
    millisold = millis();
    }
 if(!digitalRead(ACCPin) && !stateACC && millis () -off> OFFHUB){
    digitalWrite(relePin1, LOW);
    relestate1 = 0;
    millisold = millis();    
  } 
if(!digitalRead(ACCPin) && !stateACC &&  millis () -off > OFFTablet){
    Remote.pause();// нажимаем пузу!
    Remote.clear();
    digitalWrite(relePin2, LOW); 
    relestate2 = 0;
    millisold = millis();     
  } 
 if(!digitalRead(ACCPin) && !stateACC &&  millis () -off > OFFAudio){
    digitalWrite(relePin3, LOW);
    relestate3 = 0;
    millisold = millis();     
  } 
}
