﻿if (!("FormatDuration" in utils))
    fb.ShowPopupMessage("This script requires the component JScript Panel v1.0.0 or higher.\n\nhttps://github.com/19379/foo-jscript-panel/releases");

properties = {
    ParentName:  window.GetProperty("_PROPERTY: Parent Panel", ""),	
    tf_artist: fb.TitleFormat("%artist%"),
    lockOnNowPlaying: window.GetProperty("lock on now playing playlist", true),
    lockOnPlaylistNamed: window.GetProperty("lock on specific playlist name", ""),	
    tf_albumartist: fb.TitleFormat("%album artist%"),
    tf_groupkey: fb.TitleFormat("$if2(%album artist%,$if(%length%,'Unknown artist(s)',%title%)) ^^ $if2(%album%,$if(%length%,'?',%path%)) ^^ %discnumber% ## $if2(%artist%,$if(%length%,'Unknown artist',%path%)) ^^ %title% ^^ [%genre%] ^^ [%date%]"),
    tf_track: fb.TitleFormat("%tracknumber% ^^ $if(%length%,%length%,ON AIR) ^^ $if2(%rating%,0) ^^ %mood%"),
    tf_path: fb.TitleFormat("$directory_path(%path%)\\"),
    tf_time_remaining: fb.TitleFormat("$if(%length%,-%playback_time_remaining%,'ON AIR')"),
    tf_elapsed_seconds: fb.TitleFormat("$if(%length%,%playback_time_seconds%,0)"),	
    tf_total_seconds: fb.TitleFormat("$if2(%length_seconds%,10)"),		
    defaultRowHeight: window.GetProperty("_PROPERTY: Row Height", 25),
    doubleRowPixelAdds: 13,
    rowHeight: window.GetProperty("_PROPERTY: Row Height", 25),
    drawAlternateBG: window.GetProperty("PROPERTY: Alternate row background", false),	
    rowScrollStep: 3,
    scrollSmoothness: 2.5,
	track_gradient_margin: 13,	
	track_gradient_size: 13,
    refreshRate: 35,
    refreshRateCover: 5,
	drag_scroll_speed_ms: 100,
    extraRowsNumber: window.GetProperty("_PROPERTY: Number of Extra Rows per Group", 1),
    minimumRowsNumberPerGroup: window.GetProperty("_PROPERTY: Number minimum of Rows per Group", 0),
    groupHeaderRowsNumber: window.GetProperty("_PROPERTY: Number of Rows for Group Header", 2),
    groupHeaderRowsNumberDouble: window.GetProperty("_PROPERTY: Number of Rows for Group Header, when double line is enabled", 1),	
    albumArtId: 0,
    showHeaderBar: window.GetProperty("_DISPLAY: Show Top Bar", false),
    defaultHeaderBarHeight: 40,
    headerBarHeight: 40,
    headerBarPaddingTop: 1,	
    expandBySingleClick: window.GetProperty("_PROPERTY: Expand Group By Single Click", true),	
    enableFullScrollEffectOnFocusChange: false,
    enableCustomColors: window.GetProperty("_PROPERTY: Custom Colors", true),
	darklayout: window.GetProperty("_DISPLAY: Dark layout", false),		
    showwallpaper: window.GetProperty("_DISPLAY: Show Wallpaper", false),	
    wallpaperblurred: window.GetProperty("_DISPLAY: Wallpaper Blurred", true),
    wallpaperblurvalue: window.GetProperty("_DISPLAY: Wallpaper Blur Value", 1.05),
    wallpapermode: window.GetProperty("_SYSTEM: Wallpaper Mode", 0),
	wallpaperpath: theme_img_path+"\\nothing_played_full.png",
    wallpaperdisplay: window.GetProperty("_DISPLAY: Wallpaper 0=Filling 1=Adjust 2=Stretch", 0),		
    defaultPlaylistItemAction: window.GetProperty("_PROPERTY: Default Playlist Action", "Play"), //"Add to playback queue"
    extra_font_size: window.GetProperty("_SYSTEM: Extra font size value", -1),
    showFilterBox: window.GetProperty("_PROPERTY: Enable Playlist Filterbox in Top Bar", true),
    doubleRowText: window.GetProperty("_PROPERTY: Double Row Text Info", false),
    doubleRowShowCover: window.GetProperty("_PROPERTY: Double Row Show Cover", true),	
    showArtistAlways: window.GetProperty("_DISPLAY: Show Artist in Track Row", true),
    showRating: window.GetProperty("_DISPLAY: Show Rating in Track Row", false),
    drawUpAndDownScrollbar: window.GetProperty("PROPERTY: Draw Up and Down Scrollbar Buttons", false),	
    showMood: window.GetProperty("_DISPLAY: Show Mood in Track Row", false),
    drawProgressBar: window.GetProperty("_DISPLAY Draw a progress bar under song title", true),		
    AlbumArtProgressbar: window.GetProperty("_DISPLAY Album art progress bar", true),			
    enableTouchControl: window.GetProperty("_PROPERTY: Touch control", false),
    DropInplaylist: window.GetProperty("_SYSTEM: Allow to drag items into a playlist", false),
    thumbnailWidthMin: window.GetProperty("COVER Width Minimal", 50),
    thumbnailWidth: window.GetProperty("COVER Width", 75),
	showSettingsMenu: window.GetProperty("_DISPLAY Show Settings context menu", true),
	enableAutoSwitchPlaylistMode: window.GetProperty("Automatically change displayed playlist", true),
    showgroupheaders: window.GetProperty("_DISPLAY: Show Group Headers", true),
    autocollapse: window.GetProperty("_PROPERTY: Autocollapse groups", false),
    addedRows_end_default: window.GetProperty("_PROPERTY: empty rows at the end", 1),
    load_covers_at_startup: window.GetProperty("COVER Load all at startup", true),		
    enableDiskCache: window.GetProperty("COVER Disk Cache", true),	
	margin_bottom:0
};
properties.groupHeaderRowsNumberSimple = properties.groupHeaderRowsNumber;
properties.wallpapermode_temp = properties.wallpapermode;
function set_display_properties(properties_name,value) {
	if(layout_state==1){
        switch(properties_name) {
            case "showgroupheaders":
				MiniMode_properties.showgroupheaders = value;
				window.SetProperty("_DISPLAY_MiniMode: Show Group Headers", value)
                break;
            case "autocollapse":
				MiniMode_DisplayProperties.autocollapse = value;
				window.SetProperty("_PROPERTY_MiniMode: Autocollapse groups", value)
                break;
        };
	} else {
        switch(properties_name) {
            case "showgroupheaders":
				properties.showgroupheaders = value;
				window.SetProperty("_DISPLAY: Show Group Headers", value)
                break;
            case "autocollapse":
				DisplayProperties.autocollapse = value;
				window.SetProperty("_PROPERTY: Autocollapse groups", value)
                break;
        };		
	}
}

function get_display_properties(properties_name) {
	if(layout_state==1){
        switch(properties_name) {
            case "showgroupheaders":
				return MiniMode_properties.showgroupheaders
                break;
            case "autocollapse":
				return MiniMode_DisplayProperties.autocollapse
                break;
        };
	} else {
        switch(properties_name) {
            case "showgroupheaders":
				return properties.showgroupheaders
                break;
            case "autocollapse":
				return DisplayProperties.autocollapse
                break;
        };		
	}
}
var gradient_w = 31;
var gradient_m = 15;
var draw_right_line = false;
var g_active_playlist = null;
var Update_Required_function = "";
var playing_track_playcount = 0;
if(!properties.showgroupheaders) properties.extraRowsNumber=0;
cTouch = {
    down: false,
    y_start: 0,
    y_end: 0,
    y_current: 0,
    y_prev: 0,
    y_move: 0,
    scroll_delta: 0,
    t1: null, 
    timer: false,
    multiplier: 0,
    delta: 0
};

cSettings = {
    visible: false
};

cFilterBox = {
    enabled: window.GetProperty("_PROPERTY: Enable Filter Box", true),
    default_w: 120,
    default_h: 20,
    x: 5,
    y: 2,
    w: 120,
    h: 20
};

cColumns = {
    dateWidth: 0,
    albumArtistWidth: 0,
    titleWidth: 0,
    genreWidth: 0
};

cPlaylistManager = {
    default_width: 230,
    width: 0,
    default_topbarHeight: 44,
    topbarHeight: 44,
    default_botbarHeight: 11,
    botbarHeight: 11,
    default_scrollbarWidth: 10,
    scrollbarWidth: 10,
    default_rowHeight : 33,
    rowHeight: 33,
    blink_timer: false,
    blink_counter: -1,
    blink_id: null,
    blink_row: null,
    blink_totaltracks: 0,
    showTotalItems: window.GetProperty("_PROPERTY.PlaylistManager.ShowTotalItems", true)
};
cNowPlaying = {
    flashEnable: false,
    flashescounter: 0,
    flash: false,
	flashescountermax:40
}
cScrollBar = {
    enabled: window.GetProperty("DISPLAY: Show Scrollbar", true),
    visible: true,
    themed: false,
    defaultWidth: 10,
	width: 10,
	normalWidth: 4,		
	hoverWidth: 10,	
	downWidth: 10,	
	ButtonType: {cursor: 0, up: 1, down: 2},
    defaultMinCursorHeight: 40,
    minCursorHeight: 40,
    maxCursorHeight: 100,	
    timerID: false,
	timerCounter: -1
};

cover = {
    masks: window.GetProperty("_PROPERTY: Cover art masks (used for the cache)","*front*.*;*cover*.*;*folder*.*;*.*"),
    show: window.GetProperty("_DISPLAY: Show Cover Art", true),
	column: false,
    draw_glass_reflect: false,
    glass_reflect: null,
    keepaspectratio: false,
    default_margin: 4,
    margin: 4,
    padding: 12,
	trackMargin:7,
	trackMarginRight:9,
    w: properties.groupHeaderRowsNumber * properties.rowHeight,
	max_w: properties.groupHeaderRowsNumber * properties.rowHeight,
    h: properties.groupHeaderRowsNumber * properties.rowHeight,
	max_h: properties.groupHeaderRowsNumber * properties.rowHeight,
    nocover_img: gdi.Image(theme_img_path+"\\no_cover.png"),	
    stream_img: gdi.Image(theme_img_path+"\\stream_icon.png"),	
	previous_max_size: -1,
	resized: false
};

images = {
    path: theme_img_path + "\\",
    glass_reflect: null,
    loading_angle: 0,
    loading_draw: null,
    noart: null,
    stream: null,
	now_playing_1: gdi.Image(theme_img_path + "\\graphic_browser\\now_playing_track1.png"),
	now_playing_0: gdi.Image(theme_img_path + "\\graphic_browser\\now_playing_track0.png")	
};

cList = {
	search_string: "",
	incsearch_font: gdi.Font("lucida console", 9, 0),
	incsearch_font_big: gdi.Font("lucida console", 20, 1),
    inc_search_noresult: false,
	clear_incsearch_timer: false,
	incsearch_timer: false
};

timers = {
    coverLoad: false,
    coverDone: false,
    mouseWheel: false,
    saveCover: false,
    mouseDown: false,
    showPlaylistManager: false,
    resize: false,	
    hidePlaylistManager: false,
	showToolTip: false,
	reactive_playlist: false,
	callback_avoid_populate: false
};

dragndrop = {
    enabled: true,
    contigus_sel: null,
    x: 0,
    y: 0,
    drag_id: -1,
    drop_id: -1,
    timerID: false,
    drag_in: false,
    drag_out: false,
    clicked: false,
    moved: false
};

/* 
===================================================================================================
    Images cache
===================================================================================================
*/
function reset_cover_timers() {
    if(timers.coverDone) {
        timers.coverDone && window.ClearTimeout(timers.coverDone);
        timers.coverDone = false;
    };
};

function on_load_image_done(tid, image){
    var tot = brw.groups.length;
								fb.trace("on_load_image_done")
    for(var k = 0; k < tot; k++) {
        if(brw.groups[k].metadb) {
            if(brw.groups[k].tid == tid && brw.groups[k].load_requested == 1) {
                brw.groups[k].load_requested = 2;
                brw.groups[k].cover_img = g_image_cache.getit(brw.groups[k].metadb, k, image);
                //if(!isScrolling && !cScrollBar.timerID) {
                    if(k < brw.groups.length && brw.groups[k].rowId >= g_start_ && brw.groups[k].rowId <= g_end_) {
                        //if(!timers.coverDone) {
                          //  timers.coverDone = window.SetTimeout(function() {
                                g_1x1 = false;
                                brw.cover_repaint();
								fb.trace("cover_repaint")
                              //  timers.coverDone && window.ClearTimeout(timers.coverDone);
                                //timers.coverDone = false;
                           // }, 5);
                        //};
                    }; else {
                        g_1x1 = true;
                        window.RepaintRect(0, 0, 1, 1);
                        g_1x1 = false;
                    };
                //};
                break;
            };
        };
    };
};

function on_get_album_art_done(metadb, art_id, image, image_path) {
    var tot = brw.groups.length;	
    if(properties.albumArtId != 0) {
        for(var i = 0; i < tot; i++) {
            if(brw.groups[i].metadb) {
                if(brw.groups[i].metadb.Compare(metadb)) {
					brw.groups[i].load_requested = 2;
                    brw.groups[i].cover_img = g_image_cache.getit(metadb, i, image);
                    //if(!isScrolling && !cScrollBar.timerID) {
                        if(i < brw.groups.length && brw.groups[i].rowId >= g_start_ && brw.groups[i].rowId <= g_end_) {
                            if(!timers.coverDone) {
                                timers.coverDone = window.SetTimeout(function() {
                                    g_1x1 = false;
                                    brw.cover_repaint();
                                    timers.coverDone && window.ClearTimeout(timers.coverDone);
                                    timers.coverDone = false;
                                }, 5);
                            };
                        }; else {
                            g_1x1 = true;
                            window.RepaintRect(0, 0, 1, 1);
                            g_1x1 = false;
                        };
                    //};
                    break;
                };
            };
        };
    }; else {
        var i = art_id - 5;
        g_last = i;
        if(i < tot) {
            if(brw.groups[i].metadb) {
                brw.groups[i].cover_img = g_image_cache.getit(metadb, i, image);
                //if(!isScrolling && !cScrollBar.timerID) {
                    if(i < brw.groups.length && brw.groups[i].rowId >= g_start_ && brw.groups[i].rowId <= g_end_) {
						brw.groups[i].load_requested = 2;
                        if(!timers.coverDone) {
                            timers.coverDone = window.SetTimeout(function() {
                                g_1x1 = false;
                                brw.cover_repaint();
                                timers.coverDone && window.ClearTimeout(timers.coverDone);
                                timers.coverDone = false;
                            }, 5);
                        };
                    }; else {
						fb.trace("albumArtId=1"+i+"brw.groups.length"+brw.groups.length+" g_start_"+g_start_+"brw.groups[i].rowId"+brw.groups[i].rowId+" g_end_"+g_end_)
                        g_1x1 = true;
                        window.RepaintRect(0, 0, 1, 1);
                        g_1x1 = false;
                    };
                //};
            };
        };
    };
};

//=================================================// Cover Tools
image_cache = function () {
    this._cachelist = {};
    this.hit = function (metadb, albumIndex) {
        try{var img = this._cachelist[brw.groups[albumIndex].cachekey];}catch(e){}
        if (typeof(img) == "undefined" || img == null) { // if image not in cache, we load it asynchronously	
            //if(!isScrolling  && !cScrollBar.timerID) { // and when no scrolling
                brw.groups[albumIndex].crc = check_cache(metadb, albumIndex);
                if(properties.enableDiskCache && brw.groups[albumIndex].crc && brw.groups[albumIndex].load_requested == 0) {
					//Dont save as its already in the cache
					brw.groups[albumIndex].save_requested=true;					
                    // load img from cache
                    if(!timers.coverLoad) {
                        timers.coverLoad = window.SetTimeout(function() {
                            try {
								fb.trace("load_image_from_cache")								
                                brw.groups[albumIndex].tid = load_image_from_cache(metadb, brw.groups[albumIndex].crc);
                                brw.groups[albumIndex].load_requested = 1;
                            }; catch(e) {};
                            timers.coverLoad && window.ClearTimeout(timers.coverLoad);
                            timers.coverLoad = false;
                        }, (!isScrolling  && !cScrollBar.timerID ? 5 : 25));
                    };
                }; else if(brw.groups[albumIndex].load_requested == 0) {               
                    // load img default method
                    if(!timers.coverLoad) {
                        timers.coverLoad = window.SetTimeout(function() {
                            this.albumArtId = properties.albumArtId == 0 ? albumIndex + 5 : properties.albumArtId;
                            brw.groups[albumIndex].load_requested = 1;
								fb.trace("GetAlbumArtAsync")							
                            utils.GetAlbumArtAsync(window.ID, metadb, this.albumArtId, true, false, false);
                            timers.coverLoad && window.ClearTimeout(timers.coverLoad);
                            timers.coverLoad = false;
                        }, (!isScrolling  && !cScrollBar.timerID ? 5 : 25));
                    };
                };
            //};
        }
        return img;
    };
    this.reset = function(key) {
        this._cachelist[key] = null;
    };
    this.getit = function (metadb, albumId, image) {
        var cw = globalProperties.thumbnailWidthMax;
        var ch = cw;
        var img = null;
        var cover_type = null;
        
        if(cover.keepaspectratio) {
            if(!image) {
                var pw = cw - cover.margin * 2;
                var ph = ch - cover.margin * 2;
            }; else {
                if(image.Height>=image.Width) {
                    var ratio = image.Width / image.Height;
                    var pw = (cw - cover.margin * 2) * ratio;
                    var ph = ch - cover.margin * 2;
                }; else {
                    var ratio = image.Height / image.Width;
                    var pw = cw - cover.margin * 2;
                    var ph = (ch - cover.margin * 2) * ratio;
                };
            };
        }; else {
            var pw = cw - cover.margin * 2;
            var ph = ch - cover.margin * 2;
        };
        // cover.type : 0 = nocover, 1 = external cover, 2 = embedded cover, 3 = stream
        if(brw.groups[albumId].tracktype != 3) {
            if(metadb) {
                if(image) {
                    img = FormatCover(image, pw, ph, false);
                    cover_type = 1;
                }; else {
                    //img = FormatCover(images.noart, pw, ph, false);
                    cover_type = 0;
                };
            };
        }; else {
            //img = FormatNoCover(albumId, pw, ph, false, mode = 2);
            cover_type = 3;
            
        };
        if(cover_type == 1) {
            this._cachelist[brw.groups[albumId].cachekey] = img;
        };
        // save img to cache
        if(properties.enableDiskCache && cover_type == 1 && !brw.groups[albumId].save_requested && image) {
            if(!timers.saveCover) {
                brw.groups[albumId].save_requested = true;
                save_image_to_cache(image, albumId); 
                timers.saveCover = window.SetTimeout(function() {
                    window.ClearTimeout(timers.saveCover);
                    timers.saveCover = false;
                }, 100);
            };
        };
        
        brw.groups[albumId].cover_type = cover_type;
        
        return img;
    };
};
//var g_image_cache = new image_cache;

function FormatCover(image, w, h, rawBitmap) {
	if(!image || w<=0 || h<=0) return image;
	if(rawBitmap) {
		return image.Resize(w, h, 1).CreateRawBitmap();
	} else {
		return image.Resize(w, h, 1);
	}
};

/* 
===================================================================================================
    Objects
===================================================================================================
*/
oPlaylist = function(idx, rowId) {
    this.idx = idx;
    this.rowId = rowId;
    this.name = plman.GetPlaylistName(idx);
    this.y = -1;
};

oPlaylistManager = function(name) {
    this.name = name;
    this.playlists = [];
    this.state = 0;  // 0 = hidden, 1 = visible
    // metrics
    this.scroll = 0;
    this.offset = 0;
    this.w = 250;
    this.h = brw.h - 100;
    this.x = ww;
    this.y = brw.y + 50;
    this.total_playlists = null;
    this.rowTotal = -1;
    this.drop_done = false;
    this.firstPopulateDone = false;
    this.adjustPanelHeight = function() {
        // adjust panel height to avoid blank area under last visible item in the displayed list
        var target_total_rows = Math.floor((this.default_h - cPlaylistManager.topbarHeight) / cPlaylistManager.rowHeight);
        if(this.rowTotal != -1 && this.rowTotal < target_total_rows) target_total_rows = this.rowTotal;
        this.h = cPlaylistManager.topbarHeight + (target_total_rows * cPlaylistManager.rowHeight);
        this.y = this.default_y + Math.floor((this.default_h - this.h) / 2);       
       
        this.totalRows = Math.floor((this.h - cPlaylistManager.topbarHeight) / cPlaylistManager.rowHeight);
        this.max = (this.rowTotal > this.totalRows ? this.totalRows : this.rowTotal);
    };

    this.setSize = function(x, y, w, h) {
        this.default_x = x;
        this.default_y = y;
        this.default_w = w;
        this.default_h = h;  
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.totalRows = Math.floor((this.h - cPlaylistManager.topbarHeight) / cPlaylistManager.rowHeight);
        
        // adjust panel height / rowHeight + rowTotal (! refresh must have been executed once to have a valide rowTotal)
        this.adjustPanelHeight();
    };
    
    this.showPanel = function() {
		if(brw.drag_clicked){
			if(pman.offset < pman.w) {
				var delta = Math.ceil((pman.w - pman.offset) / 2);
				pman.offset += delta;
				brw.repaint();
			};
			if(pman.offset >= pman.w) {
				pman.offset = pman.w;
				window.ClearInterval(timers.showPlaylistManager);
				timers.showPlaylistManager = false;
				brw.repaint();
			};
		}
    };
  
    this.hidePanel = function() {
        if(pman.offset > 0) {
            var delta = Math.ceil((pman.w - (pman.w - pman.offset)) / 2);
            pman.offset -= delta;
            brw.repaint();
        };
        if(pman.offset < 1) {
            pman.offset = 0;
            pman.state = 0;
			pman.scroll	= 0;			
            window.ClearInterval(timers.hidePlaylistManager);
            timers.hidePlaylistManager = false;
            brw.repaint();
        };
    };
    
    this.populate = function(exclude_active, reset_scroll) {
        this.playlists.splice(0, this.playlists.length);
        this.total_playlists = plman.PlaylistCount;
        var rowId = 0;
        var isAutoPl = false;
        var isReserved = false;
        var plname = null;
		this.firstPopulateDone = true;
        for(var idx = 0; idx < this.total_playlists; idx++) {
            plname = plman.GetPlaylistName(idx);
            isAutoPl = plman.IsAutoPlaylist(idx);
            isReserved = (plname == "Queue Content" || plname == "Historic");

            if(!isAutoPl && !isReserved) {
                if(idx == plman.ActivePlaylist && properties.selectionPlaylist!=plname) {
                    if(!exclude_active) {
                        this.playlists.push(new oPlaylist(idx, rowId));
                        rowId++;
                    };
                }; else if(properties.selectionPlaylist!=plname){
                    this.playlists.push(new oPlaylist(idx, rowId));
                    rowId++;
                };
            };
        };
        this.rowTotal = rowId;
        
        // adjust panel height / rowHeight + rowTotal
        this.adjustPanelHeight();
        
        if(reset_scroll || this.rowTotal <= this.totalRows) {
            this.scroll = 0;
        }; else {
            //check it total playlist is coherent with scroll value
            if(this.scroll > this.rowTotal - this.totalRows) {
                  this.scroll = this.rowTotal - this.totalRows;
            };
        };
    };
    
        
    this.draw = function(gr) {
		if(!this.firstPopulateDone){
			this.populate(exclude_active = false, reset_scroll = true);
		}		
        if(this.offset > 0) {
            // metrics
            var cx = this.x - this.offset;
            var ch = cPlaylistManager.rowHeight;
            var cw = this.w;
            var bg_margin_top = 2;
            var bg_margin_left = 10;
            var txt_margin = 10;
            var bg_color = pm_color_bg;
            var txt_color = pm_color_txt;
			var gradient_size = 30;
            // scrollbar metrics
            if(this.rowTotal > this.totalRows) {
                this.scr_y = this.y + cPlaylistManager.topbarHeight;
                this.scr_w = cPlaylistManager.scrollbarWidth;
                this.scr_h = this.h - cPlaylistManager.topbarHeight;
            }; else {
                this.scr_y = 0;
                this.scr_w = 0;
                this.scr_h = 0;
            };

			//Overlay
			height_top_fix = (properties.showHeaderBar ? properties.headerBarHeight : 0)		
            gr.FillSolidRect(0, height_top_fix+1, ww, wh-height_top_fix-1, pm_color_overlay);
			
			//Shadows
			gr.FillGradRect(cx,this.y-gradient_size,ww-(draw_right_line?1:0),gradient_size,90,pm_color_shadow_on,pm_color_shadow_off,0)
			gr.FillGradRect(cx,this.y + this.h + cPlaylistManager.botbarHeight,ww-(draw_right_line?1:0),gradient_size,90,pm_color_shadow_on,pm_color_shadow_off,1.0)
			//Main BG
			gr.FillSolidRect(cx, this.y, this.w, this.h + cPlaylistManager.botbarHeight + 1, pm_color_bg);
			gr.FillSolidRect(cx, this.y, ww-(draw_right_line?1:0), 1, pm_color_border);
			gr.FillSolidRect(cx, this.y + this.h + cPlaylistManager.botbarHeight, ww-(draw_right_line?1:0), 1, pm_color_border);			
           // gr.FillSolidRect(cx + bg_margin_left, this.y + cPlaylistManager.topbarHeight - 2, this.w - bg_margin_left*2, 1, pm_color_bg4);
            
            // ** items **
            var rowIdx = 0;
            var totalp = this.playlists.length;
            var start_ = this.scroll;
            var end_ = this.scroll + this.totalRows;
			var tw = 0;
            if(end_ > totalp) end_ = totalp;
            for(var i = start_; i < end_; i++) {
                cy = this.y + cPlaylistManager.topbarHeight + rowIdx*ch;
                this.playlists[i].y = cy;
                
                // ** item bg **
                gr.FillSolidRect(cx + bg_margin_left+5, cy + bg_margin_top-3, cw - bg_margin_left*2-10 - this.scr_w, 1, pm_item_separator_line);
                
                // ** item text **
                // playlist total items
                if(cPlaylistManager.showTotalItems) {
                    t = plman.PlaylistItemCount(this.playlists[i].idx);
                    tw = gr.CalcTextWidth(t+"  ", gdi.Font(g_fname, g_fsize - 1, 0));
                    gr.GdiDrawText(t, gdi.Font(g_fname, g_fsize - 1, 0), blendColors(txt_color, bg_color, 0.2), cx + bg_margin_left + txt_margin, cy, cw - bg_margin_left*2 - txt_margin*2 - this.scr_w, ch, DT_RIGHT | DT_CALCRECT | DT_VCENTER | DT_END_ELLIPSIS | DT_NOPREFIX);
                }; else {
                    tw = 0;
                };
				
				//draw playing playlist icon
				if(fb.IsPlaying && this.playlists[i].idx == plman.PlayingPlaylist){
					gr.DrawImage(images.playing_playlist, cx + bg_margin_left + txt_margin - 9, cy+6, images.playing_playlist.Width, images.playing_playlist.Height, 0, 0, images.playing_playlist.Width, images.playing_playlist.Height,0,255);
					playlistname_padding_left = images.playing_playlist.Width - 6;
				} else playlistname_padding_left = 0;
				
                // draw playlist name
                if((this.activeIndex == i + 1 && cPlaylistManager.blink_counter < 0) || (cPlaylistManager.blink_id == i + 1 && cPlaylistManager.blink_row != 0)) {
                    gr.GdiDrawText("+ " + this.playlists[i].name , gdi.Font(g_fname, g_fsize+1, 1), txt_color, cx + playlistname_padding_left + bg_margin_left + txt_margin, cy, cw - bg_margin_left*2 - txt_margin*2 - tw - this.scr_w, ch, DT_LEFT | DT_CALCRECT | DT_VCENTER | DT_END_ELLIPSIS | DT_NOPREFIX);
                }; else {
                    gr.GdiDrawText(this.playlists[i].name , g_font, blendColors(txt_color, bg_color, 0.2), cx + playlistname_padding_left + bg_margin_left + txt_margin, cy, cw - bg_margin_left*2 - txt_margin*2 - tw - this.scr_w, ch, DT_LEFT | DT_CALCRECT | DT_VCENTER | DT_END_ELLIPSIS | DT_NOPREFIX);
                };
                
				
                // draw flashing item on lbtn_up after a drag'n drop
                if(cPlaylistManager.blink_counter > -1) {
                    if(cPlaylistManager.blink_row != 0) {
                        if(i == cPlaylistManager.blink_id - 1) {
                            if(cPlaylistManager.blink_counter <= 6 && Math.floor(cPlaylistManager.blink_counter / 2) == Math.ceil(cPlaylistManager.blink_counter / 2)) {
                                gr.FillSolidRect(cx + bg_margin_left, cy +(cPlaylistManager.topbarHeight-40), cw - bg_margin_left*2 - this.scr_w, ch, pm_color_blink);
                            };
                        };
                    };
                };
                
                rowIdx++;
            };
            			
            // top bar
            // draw flashing top bar item on lbtn_up after a drag'n drop
            if(cPlaylistManager.blink_counter > -1) {
                if(cPlaylistManager.blink_row == 0) {
					gr.GdiDrawText("+ Sent to a new Playlist" , gdi.Font(g_fname, g_fsize+1, 1), txt_color, cx + bg_margin_left + txt_margin, this.y + cPlaylistManager.topbarHeight - 30, cw - bg_margin_left*2 - txt_margin*2 - tw - this.scr_w, ch, DT_LEFT | DT_CALCRECT | DT_VCENTER | DT_END_ELLIPSIS | DT_NOPREFIX);
                    if(cPlaylistManager.blink_counter <= 6 && Math.floor(cPlaylistManager.blink_counter / 2) == Math.ceil(cPlaylistManager.blink_counter / 2)) {                        
						gr.FillSolidRect(cx + bg_margin_left, this.y +(cPlaylistManager.topbarHeight-31), cw - bg_margin_left*2 - this.scr_w, ch+1, pm_color_blink);
						gr.DrawRect(cx + bg_margin_left, this.y +(cPlaylistManager.topbarHeight-31), cw - bg_margin_left*2 - this.scr_w - 1, ch, 1.0, pm_color_blink_rectline);							
                    };
                }; else {
                    gr.GdiDrawText("Send to ..." , g_font, txt_color, cx + bg_margin_left + txt_margin, this.y + cPlaylistManager.topbarHeight - 30, cw - bg_margin_left*2 - txt_margin*2 - tw - this.scr_w, ch, DT_LEFT | DT_CALCRECT | DT_VCENTER | DT_END_ELLIPSIS | DT_NOPREFIX);
                };
            }; else {
                if(this.activeRow == 0) {
                    gr.GdiDrawText("+ Send to a new Playlist" , gdi.Font(g_fname, g_fsize+1, 1), txt_color, cx + bg_margin_left + txt_margin, this.y + cPlaylistManager.topbarHeight - 30, cw - bg_margin_left*2 - txt_margin*2 - tw - this.scr_w, ch, DT_LEFT | DT_CALCRECT | DT_VCENTER | DT_END_ELLIPSIS | DT_NOPREFIX);
					
					gr.FillSolidRect(cx + bg_margin_left, this.y +(cPlaylistManager.topbarHeight-31), cw - bg_margin_left*2 - this.scr_w, ch+1, pm_color_blink);
					gr.DrawRect(cx + bg_margin_left, this.y +(cPlaylistManager.topbarHeight-31), cw - bg_margin_left*2 - this.scr_w - 1, ch, 1.0, pm_color_blink_rectline);	
					
                }; else {
                    gr.GdiDrawText("Send to ..." , g_font, txt_color, cx + bg_margin_left + txt_margin, this.y + cPlaylistManager.topbarHeight - 30, cw - bg_margin_left*2 - txt_margin*2 - tw - this.scr_w, ch, DT_LEFT | DT_CALCRECT | DT_VCENTER | DT_END_ELLIPSIS | DT_NOPREFIX);
                };
            };
            
            // draw activeIndex hover frame
            if(cPlaylistManager.blink_counter > -1 && cPlaylistManager.blink_row > 0) {
                cy_ = this.y + cPlaylistManager.blink_row * ch;
                gr.DrawRect(cx + bg_margin_left, cy_ + bg_margin_top +(cPlaylistManager.topbarHeight-33), cw - bg_margin_left*2 - this.scr_w - 1, ch, 1.0, pm_color_blink_rectline);
            }; else {
                if(this.activeRow > 0 && this.activeIndex > 0) {
                    if(cPlaylistManager.blink_counter < 0){
                        cy_ = this.y + this.activeRow * ch;
						gr.FillSolidRect(cx + bg_margin_left, cy_ + bg_margin_top +(cPlaylistManager.topbarHeight-33), cw - bg_margin_left*2 - this.scr_w, ch+1, pm_color_blink);
                        gr.DrawRect(cx + bg_margin_left, cy_ + bg_margin_top +(cPlaylistManager.topbarHeight-33), cw - bg_margin_left*2 - this.scr_w - 1, ch, 1.0, pm_color_blink_rectline);
                    };
                };
            };
            
            // scrollbar
            if(this.scr_w > 0) {
                this.scr_cursor_h = (this.scr_h / (ch * this.rowTotal)) * this.scr_h;
                if(this.scr_cursor_h < 20) this.scr_cursor_h = 20;
                // set cursor y pos
                var ratio = (this.scroll * ch) / (this.rowTotal * ch - this.scr_h);
                this.scr_cursor_y = this.scr_y + Math.round((this.scr_h - this.scr_cursor_h) * ratio);
                
                gr.FillSolidRect(cx + cw - this.scr_w , this.scr_cursor_y, this.scr_w - 8, this.scr_cursor_h, pm_color_scrollbar);
            };
        };
    };
    
    this._isHover = function(x, y) {
        return (x >= this.x - this.offset && x <= this.x - this.offset + this.w && y >= this.y && y <= this.y + this.h - 1);
    };
    
    
    this.on_mouse = function(event, x, y, delta) {
        this.ishover = this._isHover(x, y);
        
        switch(event) {
            case "move":
                // get active item index at x,y coords...
                this.activeIndex = -1;
                if(this.ishover) {
                    this.activeRow = Math.ceil((y - this.y - 10) / cPlaylistManager.rowHeight) - 1;
                    this.activeIndex = Math.ceil((y - this.y - 10) / cPlaylistManager.rowHeight) + this.scroll - 1;
					if(this.activeIndex>this.playlists.length) {
						this.activeIndex = this.activeRow = -1
					}//this.playlists[i].y
                }; else this.activeRow = -1
                if(this.activeIndex != this.activeIndexSaved) {
                    this.activeIndexSaved = this.activeIndex;
                    brw.repaint();
                };
                if(this.scr_w > 0 && x > this.x - this.offset && x <= this.x - this.offset + this.w) {
                    if(y < this.y && pman.scroll > 0) {
                        if(!timers.scrollPman && cPlaylistManager.blink_counter < 0) {
                            timers.scrollPman = window.SetInterval(function() {
                                pman.scroll--;
                                if(pman.scroll < 0) {
                                    pman.scroll = 0;
                                    window.ClearInterval(timers.scrollPman);
                                    timers.scrollPman = false;
                                }; else {
                                    brw.repaint();
                                };
                            }, 100);
                        };
                    }; else if(y > this.scr_y + this.scr_h && pman.scroll < this.rowTotal - this.totalRows) {
                        if(!timers.scrollPman && cPlaylistManager.blink_counter < 0) {
                            timers.scrollPman = window.SetInterval(function() {
                                pman.scroll++;
                                if(pman.scroll > pman.rowTotal - pman.totalRows) {
                                    pman.scroll = pman.rowTotal - pman.totalRows;
                                    window.ClearInterval(timers.scrollPman);
                                    timers.scrollPman = false;
                                }; else {
                                    brw.repaint();
                                };
                            }, 100);
                        };
                    }; else {
                        if(timers.scrollPman) {
                            window.ClearInterval(timers.scrollPman);
                            timers.scrollPman = false;
                        };
                    };
                };
                break;
            case "up":
                brw.drag_clicked = false;
                if(brw.drag_moving) {
                    window.SetCursor(IDC_ARROW);
                    this.drop_done = false;
                    if(this.activeIndex > -1) {
                        brw.metadblist_selection = plman.GetPlaylistSelectedItems(g_active_playlist);
                        if(this.activeRow == 0) {
                            // send to a new playlist
                            this.drop_done = true;
                            window.NotifyOthers("JSSmoothPlaylist->JSSmoothBrowser:avoid_on_playlist_switch_callbacks_on_sendItemToPlaylist", true);
                            fb.RunMainMenuCommand("File/New playlist");
                            plman.InsertPlaylistItems(plman.PlaylistCount-1, 0, brw.metadblist_selection, false);  
                        }; else {
                            // send to selected (hover) playlist
                            this.drop_done = true;
                            var row_idx = this.activeIndex - 1;
                            var playlist_idx = this.playlists[row_idx].idx;
                            var insert_index = plman.PlaylistItemCount(playlist_idx);
                            plman.InsertPlaylistItems(playlist_idx, insert_index, brw.metadblist_selection, false);
                        };
                        // timer to blink the playlist item where tracks have been droped!
                        if(this.drop_done) {
                            if(!cPlaylistManager.blink_timer) {
                                cPlaylistManager.blink_x = x;
                                cPlaylistManager.blink_y = y;
                                cPlaylistManager.blink_totaltracks = brw.metadblist_selection.Count;
                                cPlaylistManager.blink_id = this.activeIndex;
                                cPlaylistManager.blink_row = this.activeRow;
                                cPlaylistManager.blink_counter = 0;
                                cPlaylistManager.blink_timer = window.SetInterval(function() {
                                    cPlaylistManager.blink_counter++;
                                    if(cPlaylistManager.blink_counter > 6) {
                                        window.ClearInterval(cPlaylistManager.blink_timer);
                                        cPlaylistManager.blink_timer = false;
                                        cPlaylistManager.blink_counter = -1;
                                        cPlaylistManager.blink_id = null;
                                        pman.drop_done = false;
                                        // close pman
                                        if(!timers.hidePlaylistManager) {
                                            timers.hidePlaylistManager = window.SetInterval(pman.hidePanel, 25);
                                        };
                                        brw.drag_moving = false;
                                    };
                                    brw.repaint();
                                }, 150);
                            };
                        };
                    }; else {
                        if(timers.showPlaylistManager) {
                            window.ClearInterval(timers.showPlaylistManager);
                            timers.showPlaylistManager = false;
                        };
                        if(!timers.hidePlaylistManager) {
                            timers.hidePlaylistManager = window.SetInterval(this.hidePanel, 25);
                        };
                        brw.drag_moving = false;
                    };
                    brw.drag_moving = false;
                }; 
                break;
            case "right":
                brw.drag_clicked = false;
                if(brw.drag_moving) {
                    if(timers.showPlaylistManager) {
                        window.ClearInterval(timers.showPlaylistManager);
                        timers.showPlaylistManager = false;
                    };
                    if(!timers.hidePlaylistManager) {
                        timers.hidePlaylistManager = window.SetInterval(this.hidePanel, 25);
                    };
                    brw.drag_moving = false;
                };
                break;
            case "wheel":
                var scroll_prev = this.scroll;
                this.scroll -= delta;
                if(this.scroll < 0) this.scroll = 0;
                if(this.scroll > (this.rowTotal - this.totalRows)) this.scroll = (this.rowTotal - this.totalRows);
                if(this.scroll != scroll_prev) {
                    this.on_mouse("move", m_x, m_y);
                };
                break;
            case "leave":
                brw.drag_clicked = false;
                if(brw.drag_moving) {
                    if(timers.showPlaylistManager) {
                        window.ClearInterval(timers.showPlaylistManager);
                        timers.showPlaylistManager = false;
                    };
                    if(!timers.hidePlaylistManager) {
                        timers.hidePlaylistManager = window.SetInterval(this.hidePanel, 25);
                    };
                    brw.drag_moving = false;
                };
                break;
        };
    };
};

oFilterBox = function() {
	this.images = {
        resetIcon_off: null,
        resetIcon_ov: null
	};

    this.getImages = function() {
		var gb;
        var w = Math.round(18 * g_zoom_percent / 100);
        
		if(properties.darklayout){
			this.images.search_icon = gdi.Image(theme_img_path + "\\icons\\white\\search_icon.png");	
		} else {
			this.images.search_icon = gdi.Image(theme_img_path + "\\icons\\search_icon.png");			
		}

        this.images.resetIcon_off = gdi.CreateImage(w, w);
        gb = this.images.resetIcon_off.GetGraphics();
            gb.setSmoothingMode(2);
            gb.DrawLine(5, 5, w-5, w-5, 1.0, g_color_normal_txt);
            gb.DrawLine(5, w-5, w-5, 5, 1.0, g_color_normal_txt);
            gb.setSmoothingMode(0);
        this.images.resetIcon_off.ReleaseGraphics(gb);

        this.images.resetIcon_ov = gdi.CreateImage(w, w);
        gb = this.images.resetIcon_ov.GetGraphics();
            gb.setSmoothingMode(2);
            gb.DrawLine(4, 4, w-4, w-4, 1.0, g_color_normal_txt);
            gb.DrawLine(4, w-4, w-4, 4, 1.0, g_color_normal_txt);
            gb.setSmoothingMode(0);
        this.images.resetIcon_ov.ReleaseGraphics(gb);

        this.images.resetIcon_dn = gdi.CreateImage(w, w);
        gb = this.images.resetIcon_dn.GetGraphics();
            gb.setSmoothingMode(2);
            gb.DrawLine(4, 4, w-4, w-4, 1.0, reseticon_down);
            gb.DrawLine(4, w-4, w-4, 4, 1.0, reseticon_down);
            gb.setSmoothingMode(0);
        this.images.resetIcon_dn.ReleaseGraphics(gb);

        this.reset_bt = new button(this.images.resetIcon_off, this.images.resetIcon_ov, this.images.resetIcon_dn);
	};
	this.getImages();
    
	this.on_init = function() {
		this.inputbox = new oInputbox(cFilterBox.w, cFilterBox.h, "", "Filter", g_color_normal_txt, 0, 0, g_color_selected_bg, g_sendResponse, "brw");
        this.inputbox.autovalidation = true;
    };
	this.on_init();
    
	this.set_default_text = function() {
		if(properties.lockOnNowPlaying) this.inputbox.empty_text = "Search playing tracks";
		else this.inputbox.empty_text = "Search current playlist";		
	}
	
    this.reset_colors = function() {
        this.inputbox.textcolor = g_color_normal_txt;
        this.inputbox.backselectioncolor = g_color_selected_bg;
    };

    this.setSize = function(w, h, font_size) {
        this.inputbox.setSize(w, h, font_size);
        this.getImages();
    };

    this.clearInputbox = function() {
        if(this.inputbox.text.length > 0) {
            this.inputbox.text = "";
            this.inputbox.offset = 0;
            filter_text = "";
			brw.populate(true,29);
        };
    };
    
	this.draw = function(gr, x, y) {
        var bx = x;
		var by = y + properties.headerBarPaddingTop;
        var bw = this.inputbox.w + Math.round(44 * g_zoom_percent / 100);
        
        if(this.inputbox.text.length > 0) {
            this.reset_bt.draw(gr, bx+6, by+2, 255);
        }; else {
			gr.DrawImage(this.images.search_icon, bx, by+Math.round(this.inputbox.h/2-this.images.search_icon.Height/2), this.images.search_icon.Width, this.images.search_icon.Height, 0, 0, this.images.search_icon.Width, this.images.search_icon.Height, 0, 255);
        };
		this.inputbox.draw(gr, bx+Math.round(22 * g_zoom_percent / 100)+12, by, 0, 0);
    };
        
    this.on_mouse = function(event, x, y, delta) {
        switch(event) {
            case "lbtn_down":
				this.inputbox.check("down", x, y);
                if(this.inputbox.text.length > 0) this.reset_bt.checkstate("down", x, y);
                break;
            case "lbtn_up":
                if(this.inputbox.text.length > 0) {
                    if(this.reset_bt.checkstate("up", x, y) == ButtonStates.hover && !this.inputbox.drag) {
                        this.clearInputbox();
                    };
                };
				this.inputbox.check("up", x, y);				
                break;
            case "lbtn_dblclk":
				this.inputbox.check("dblclk", x, y);
                break;
            case "rbtn_down":
				this.inputbox.check("right", x, y);
                break;
            case "move":
				this.inputbox.check("move", x, y);
                if(this.inputbox.text.length > 0) this.reset_bt.checkstate("move", x, y);
                break;
        };
    };
    
    this.on_key = function(event, vkey) {
        switch(event) {
            case "down":
				this.inputbox.on_key_down(vkey);
                break;
        };
    };
    
    this.on_char = function(code) {
        this.inputbox.on_char(code);
    };
    
	this.on_focus = function(is_focused) {
		this.inputbox.on_focus(is_focused);
	};
};

oScrollbar = function(themed) {
    this.themed = themed;
    this.showButtons = true;
    this.buttons = Array(null, null, null);
    this.buttonType = {cursor: 0, up: 1, down: 2};
    this.buttonClick = false;
    
    this.color_bg = g_color_normal_bg;
    this.color_txt = g_color_normal_txt;
    
    if(this.themed) {
        this.theme = window.CreateThemeManager("scrollbar");
    }; else {
        this.theme = false;
    };
    
    this.setNewColors = function() {
        this.color_bg = g_color_normal_bg;
        this.color_txt = g_color_normal_txt;  
        this.setButtons();
        this.setCursorButton();
    };

    this.setButtons = function() {
        // normal scroll_up Image
        // Draw Themed Scrollbar (lg/col)
        if(this.themed) {
            this.upImage_normal = gdi.CreateImage(this.w, this.w);
            var gb = this.upImage_normal.GetGraphics();
            try {
                this.theme.SetPartAndStateId(1, 1);
                this.theme.DrawThemeBackground(gb, 0, 0, this.w, this.w);
            }; catch(e) {
                DrawPolyStar(gb, 4, 4, this.w-8, 1, 3, 0, g_color_normal_txt, blendColors(this.color_txt, this.color_bg, 0.5), 0, 255);
            };
        }; else {
            this.upImage_normal = gdi.CreateImage(70, 70);
            var gb = this.upImage_normal.GetGraphics();
            DrawPolyStar(gb, 11, 16, 44, 1, 3, 0, g_color_normal_txt, blendColors(this.color_txt, this.color_bg, 0.5), 0, 255);
        };
        this.upImage_normal.ReleaseGraphics(gb);

        // hover scroll_up Image
        // Draw Themed Scrollbar (lg/col)
        if(this.themed) {
            this.upImage_hover = gdi.CreateImage(this.w, this.w);
            gb = this.upImage_hover.GetGraphics();
            try {
                this.theme.SetPartAndStateId(1, 2);
                this.theme.DrawThemeBackground(gb, 0, 0, this.w, this.w);
            }; catch(e) {
                DrawPolyStar(gb, 4, 4, this.w-8, 1, 3, 0, blendColors(this.color_txt, this.color_bg, 0.3), blendColors(this.color_txt, this.color_bg, 0.3), 0, 255);
            };
        }; else {
            this.upImage_hover = gdi.CreateImage(70, 70);
            var gb = this.upImage_hover.GetGraphics();
            DrawPolyStar(gb, 11, 16, 44, 1, 3, 0, blendColors(this.color_txt, this.color_bg, 0.3), blendColors(this.color_txt, this.color_bg, 0.3), 0, 255);
        };
        this.upImage_hover.ReleaseGraphics(gb);

        // down scroll_up Image
        // Draw Themed Scrollbar (lg/col)
        if(this.themed) {
            this.upImage_down = gdi.CreateImage(this.w, this.w);
            gb = this.upImage_down.GetGraphics();
            try {
                this.theme.SetPartAndStateId(1, 3);
                this.theme.DrawThemeBackground(gb, 0, 0, this.w, this.w);
            }; catch(e) {
                DrawPolyStar(gb, 4, 4, this.w-8, 1, 3, 0, g_color_normal_txt, blendColors(this.color_txt, this.color_bg, 0.05), 0, 255);
            };
        }; else {
            this.upImage_down = gdi.CreateImage(70, 70);
            gb = this.upImage_down.GetGraphics();
            DrawPolyStar(gb, 11, 13, 44, 1, 3, 0, g_color_normal_txt, blendColors(this.color_txt, this.color_bg, 0.05), 0, 255);
        };
        this.upImage_down.ReleaseGraphics(gb);

        // normal scroll_down Image
        // Draw Themed Scrollbar (lg/col)
        if(this.themed) {
            this.downImage_normal = gdi.CreateImage(this.w, this.w);
            gb = this.downImage_normal.GetGraphics();
            try {
                this.theme.SetPartAndStateId(1, 5);
                this.theme.DrawThemeBackground(gb, 0, 0, this.w, this.w);
            }; catch(e) {
                DrawPolyStar(gb, 4, 4, this.w-8, 1, 3, 0, g_color_normal_txt, blendColors(this.color_txt, this.color_bg, 0.5), 180, 255);
            };
        }; else {
            this.downImage_normal = gdi.CreateImage(70, 70);
            gb = this.downImage_normal.GetGraphics();
            DrawPolyStar(gb, 11, 10, 44, 1, 3, 0, g_color_normal_txt, blendColors(this.color_txt, this.color_bg, 0.5), 180, 255);
        };
        this.downImage_normal.ReleaseGraphics(gb);

        // hover scroll_down Image
        // Draw Themed Scrollbar (lg/col)
        if(this.themed) {
            this.downImage_hover = gdi.CreateImage(this.w, this.w);
            gb = this.downImage_hover.GetGraphics();
            try {
                this.theme.SetPartAndStateId(1, 6);
                this.theme.DrawThemeBackground(gb, 0, 0, this.w, this.w);
            }; catch(e) {
                DrawPolyStar(gb, 4, 4, this.w-8, 1, 3, 1, blendColors(this.color_txt, this.color_bg, 0.3), blendColors(this.color_txt, this.color_bg, 0.3), 180, 255);
            };
        }; else {
            this.downImage_hover = gdi.CreateImage(70, 70);
            gb = this.downImage_hover.GetGraphics();
            DrawPolyStar(gb, 11, 10, 44, 1, 3, 1, blendColors(this.color_txt, this.color_bg, 0.3), blendColors(this.color_txt, this.color_bg, 0.3), 180, 255);
        };
        this.downImage_hover.ReleaseGraphics(gb);

        // down scroll_down Image
        // Draw Themed Scrollbar (lg/col)
        if(this.themed) {
            this.downImage_down = gdi.CreateImage(this.w, this.w);
            gb = this.downImage_down.GetGraphics();
            try {
                this.theme.SetPartAndStateId(1, 7);
                this.theme.DrawThemeBackground(gb, 0, 0, this.w, this.w);
            }; catch(e) {
                DrawPolyStar(gb, 4, 4, this.w-8, 1, 3, 0, g_color_normal_txt, blendColors(this.color_txt, this.color_bg, 0.05), 180, 255);
            };
        }; else {
            this.downImage_down = gdi.CreateImage(70, 70);
            gb = this.downImage_down.GetGraphics();
            DrawPolyStar(gb, 11, 13, 44, 1, 3, 0, g_color_normal_txt, blendColors(this.color_txt, this.color_bg, 0.05), 180, 255);
        };
        this.downImage_down.ReleaseGraphics(gb);
        
        for(i = 1; i < this.buttons.length; i++) {
            switch(i) {
            case this.buttonType.cursor:
                this.buttons[this.buttonType.cursor] = new button(this.cursorImage_normal, this.cursorImage_hover, this.cursorImage_down);
                break;
            case this.buttonType.up:
                this.buttons[this.buttonType.up] = new button(this.upImage_normal.Resize(this.w,this.w,2), this.upImage_hover.Resize(this.w,this.w,2), this.upImage_down.Resize(this.w,this.w,2));
                break;
            case this.buttonType.down:
                this.buttons[this.buttonType.down] = new button(this.downImage_normal.Resize(this.w,this.w,2), this.downImage_hover.Resize(this.w,this.w,2), this.downImage_down.Resize(this.w,this.w,2));
                break;
            };
        };
    };

    this.setCursorButton = function() {
        // normal cursor Image
        this.cursorImage_normal = gdi.CreateImage(this.cursorw, this.cursorh);
        var gb = this.cursorImage_normal.GetGraphics();
        // Draw Themed Scrollbar (lg/col)
        if(this.themed) {
            try {
                this.theme.SetPartAndStateId(3, 1);
                this.theme.DrawThemeBackground(gb, 0, 0, this.cursorw, this.cursorh);
                if(this.cursorh >= 30) {
                    this.theme.SetPartAndStateId(9, 1);
                    this.theme.DrawThemeBackground(gb, 0, 0, this.cursorw, this.cursorh);
                };
            }; catch(e) {
                gb.FillSolidRect(1, 0, this.cursorw-2, this.cursorh, blendColors(this.color_txt, this.color_bg, 0.5));
            };
        }; else {
            //gb.FillSolidRect(1, 0, this.cursorw-2, this.cursorh, blendColors(this.color_txt, this.color_bg, 0.5) & 0x88ffffff);
            //gb.DrawRect(1, 0, this.cursorw-2 - 1, this.cursorh - 1, 1.0, this.color_txt & 0x44ffffff);
			gb.FillSolidRect(this.cursorw-cScrollBar.normalWidth, 0, cScrollBar.normalWidth, this.cursorh, scrollbar_cursor_color);			
        };
        this.cursorImage_normal.ReleaseGraphics(gb);
        
        // hover cursor Image
        this.cursorImage_hover = gdi.CreateImage(this.cursorw, this.cursorh);
        gb = this.cursorImage_hover.GetGraphics();
        // Draw Themed Scrollbar (lg/col)
        if(this.themed) {
            try {
                this.theme.SetPartAndStateId(3, 2);
                this.theme.DrawThemeBackground(gb, 0, 0, this.cursorw, this.cursorh);
                if(this.cursorh >= 30) {
                    this.theme.SetPartAndStateId(9, 2);
                    this.theme.DrawThemeBackground(gb, 0, 0, this.cursorw, this.cursorh);
                };
            }; catch(e) {
                gb.FillSolidRect(1, 0, this.cursorw-2, this.cursorh, blendColors(this.color_txt, this.color_bg, 0.3));
            };
        }; else {
            //gb.FillSolidRect(1, 0, this.cursorw-2, this.cursorh, blendColors(this.color_txt, this.color_bg, 0.3) & 0x88ffffff);
            //gb.DrawRect(1, 0, this.cursorw-2 - 1, this.cursorh - 1, 1.0, this.color_txt & 0x44ffffff);
			gb.FillSolidRect(this.cursorw-cScrollBar.hoverWidth, 0, cScrollBar.hoverWidth, this.cursorh,scrollbar_cursor_color);
        };
        this.cursorImage_hover.ReleaseGraphics(gb);
		
        // down cursor Image
        this.cursorImage_down = gdi.CreateImage(this.cursorw, this.cursorh);
        gb = this.cursorImage_down.GetGraphics();
        // Draw Themed Scrollbar (lg/col)
        if(this.themed) {
            try {
                this.theme.SetPartAndStateId(3, 3);
                this.theme.DrawThemeBackground(gb, 0, 0, this.cursorw, this.cursorh);
                if(this.cursorh >= 30) {
                    this.theme.SetPartAndStateId(9, 3);
                    this.theme.DrawThemeBackground(gb, 0, 0, this.cursorw, this.cursorh);
                };
            }; catch(e) {
                gb.FillSolidRect(1, 0, this.cursorw-2, this.cursorh, blendColors(this.color_txt, this.color_bg, 0.05));
            };
        }; else {
            //gb.FillSolidRect(1, 0, this.cursorw-2, this.cursorh, blendColors(this.color_txt, this.color_bg, 0.05) & 0x88ffffff);
            //gb.DrawRect(1, 0, this.cursorw-2 - 1, this.cursorh - 1, 1.0, this.color_txt & 0x44ffffff);
			gb.FillSolidRect(this.cursorw-cScrollBar.downWidth, 0, cScrollBar.downWidth, this.cursorh,scrollbar_cursor_color);
        };
        this.cursorImage_down.ReleaseGraphics(gb);
		
        // create/refresh cursor Button in buttons array
        this.buttons[this.buttonType.cursor] = new button(this.cursorImage_normal, this.cursorImage_hover, this.cursorImage_down);
        this.buttons[this.buttonType.cursor].x = this.x;
        this.buttons[this.buttonType.cursor].y = this.cursory;
    };
    
    this.draw = function(gr) {
        // scrollbar background
        if(this.themed) {
            try {
                this.theme.SetPartAndStateId(6, 1);
                this.theme.DrawThemeBackground(gr, this.x, this.y, this.w, this.h);
            }; catch(e) {
                //gr.FillSolidRect(this.x, this.y, this.w, this.h, this.color_bg & 0x25ffffff);
                //gr.FillSolidRect(this.x, this.y, 1, this.h, this.color_txt & 0x05ffffff);
            };
        }; else {
           // gr.FillSolidRect(this.x, this.y, this.w, this.h, this.color_bg & 0x25ffffff);
            //gr.FillSolidRect(this.x, this.y, 1, this.h, this.color_txt & 0x05ffffff);
        };
        // scrollbar buttons
        if(cScrollBar.visible) this.buttons[this.buttonType.cursor].draw(gr, this.x, this.cursory, 255);
        if(this.showButtons && properties.drawUpAndDownScrollbar) {
            this.buttons[this.buttonType.up].draw(gr, this.x, this.y, 255);
            this.buttons[this.buttonType.down].draw(gr, this.x, this.areay + this.areah, 255);
        };
    };
       
    this.updateScrollbar = function() {
        var prev_cursorh = this.cursorh;
        this.total = brw.rowsCount+properties.addedRows_end;
        this.rowh = properties.rowHeight;
        this.totalh = this.total * this.rowh+brw.PaddingTop*2+properties.margin_bottom;
        // set scrollbar visibility
        cScrollBar.visible = (this.totalh > brw.h +5 );

        // set cursor width/height
        this.cursorw = cScrollBar.width;
        if(this.total > 0) {
            this.cursorh = Math.round((brw.h / this.totalh) * this.areah);
            if(this.cursorh < cScrollBar.minCursorHeight) this.cursorh = cScrollBar.minCursorHeight;
        }; else {
            this.cursorh = cScrollBar.minCursorHeight;
        };
        // set cursor y pos
        this.setCursorY();
        if(this.cursorh != prev_cursorh) this.setCursorButton();
    };
    
    this.setCursorY = function() {
        // set cursor y pos
        var ratio = scroll / (this.totalh - brw.h);
        this.cursory = this.areay + Math.round((this.areah - this.cursorh) * ratio);
    };
    
    this.setSize = function() {
        if(properties.drawUpAndDownScrollbar) this.buttonh = cScrollBar.width;
		else this.buttonh = 0;		
        this.x = brw.x + brw.w-cScrollBar.width;
        this.y = brw.y - properties.headerBarHeight*0-brw.PaddingTop;
        this.w = cScrollBar.width;
        this.h = brw.h + properties.headerBarHeight*0;
        if(this.showButtons) {
            this.areay = this.y + this.buttonh;
            this.areah = this.h - (this.buttonh * 2);
        }; else {
            this.areay = this.y;
            this.areah = this.h;
        };
        this.setButtons();
    };
    
    this.setScrollFromCursorPos = function() {
        // calc ratio of the scroll cursor to calc the equivalent item for the full list (with gh)
        var ratio = (this.cursory - this.areay) / (this.areah - this.cursorh);
        // calc idx of the item (of the full list with gh) to display at top of the panel list (visible)
        scroll = Math.round((this.totalh - brw.h) * ratio);
    };

    this.cursorCheck = function(event, x, y) {
		if(!this.buttons[this.buttonType.cursor]) return;
        switch(event) {
        case "down":
            var tmp = this.buttons[this.buttonType.cursor].checkstate(event, x, y);
			if(tmp == ButtonStates.down) {
                this.cursorClickX = x;
                this.cursorClickY = y;
                this.cursorDrag = true;
                this.cursorDragDelta = y - this.cursory;
            };
            break;
        case "up":
			this.buttons[this.buttonType.cursor].checkstate(event, x, y);
            if(this.cursorDrag) {
                this.setScrollFromCursorPos();
                brw.repaint();
            };
            this.cursorClickX = 0;
            this.cursorClickY = 0;
            this.cursorDrag = false;
            break;
        case "move":
			this.buttons[this.buttonType.cursor].checkstate(event, x, y);
            if(this.cursorDrag) {
                this.cursory = y - this.cursorDragDelta;
                if(this.cursory + this.cursorh > this.areay + this.areah) {
                    this.cursory = (this.areay + this.areah) - this.cursorh;
                };
                if(this.cursory < this.areay) {
                    this.cursory = this.areay;
                };
                this.setScrollFromCursorPos();
                brw.repaint();
            };
            break;
		case "leave":
			this.buttons[this.buttonType.cursor].checkstate(event, 0, 0);
			break;
        };
    };
    
    this._isHover = function(x, y) {
        return (x >= this.x && x <= this.x + this.w && y >= this.y && y <= this.y + this.h);
    };

    this._isHoverArea = function(x, y) {
        return (x >= this.x && x <= this.x + this.w && y >= this.areay && y <= this.areay + this.areah);
    };

    this._isHoverCursor = function(x, y) {
        return (x >= this.x && x <= this.x + this.w && y >= this.cursory && y <= this.cursory + this.cursorh);
    };

    this.on_mouse = function(event, x, y, delta) {
        this.isHover = this._isHover(x, y);
        this.isHoverArea = this._isHoverArea(x, y);
        this.isHoverCursor = this._isHoverCursor(x, y);
        this.isHoverButtons = this.isHover && !this.isHoverCursor && !this.isHoverArea;
        this.isHoverEmptyArea = this.isHoverArea && !this.isHoverCursor;
        
        var scroll_step = properties.rowHeight;
        var scroll_step_page = brw.h;

        switch(event) {
            case "down":
            case "dblclk":
                if((this.isHoverCursor || this.cursorDrag) && !this.buttonClick && !this.isHoverEmptyArea) {
                    this.cursorCheck(event, x, y);
                }; else {
                    // buttons events
                    var bt_state = ButtonStates.normal;
                    for(var i = 1; i < 3; i++) {
                        switch(i) {
                            case 1: // up button
                                bt_state = this.buttons[i].checkstate(event, x, y);
                                if((event == "down" && bt_state == ButtonStates.down) || (event == "dblclk" && bt_state == ButtonStates.hover)) {
                                    this.buttonClick = true;
                                    scroll = scroll - scroll_step;
                                    scroll = check_scroll(scroll);
                                    if(!cScrollBar.timerID) {
                                        cScrollBar.timerID = window.SetInterval(function() {
                                            if(cScrollBar.timerCounter > 6) {
                                                scroll = scroll - scroll_step;
                                                scroll = check_scroll(scroll);
                                            }; else {
                                                cScrollBar.timerCounter++;
                                            };
                                        }, 80);
                                    };
                                };
                                break;
                            case 2: // down button
                                bt_state = this.buttons[i].checkstate(event, x, y);
                                if((event == "down" && bt_state == ButtonStates.down) || (event == "dblclk" && bt_state == ButtonStates.hover)) {
                                    this.buttonClick = true;
                                    scroll = scroll + scroll_step;
                                    scroll = check_scroll(scroll);
                                    if(!cScrollBar.timerID) {
                                        cScrollBar.timerID = window.SetInterval(function() {
                                            if(cScrollBar.timerCounter > 6) {
                                                scroll = scroll + scroll_step;
                                                scroll = check_scroll(scroll);
                                            }; else {
                                                cScrollBar.timerCounter++;
                                            };
                                        }, 80);
                                    };
                                };
                                break;
                        };
                    };
                    if(!this.buttonClick && this.isHoverEmptyArea) {
                        // check click on empty area scrollbar
                        if(y < this.cursory) {
                            // up
                            this.buttonClick = true;
                            scroll = scroll - scroll_step_page;
                            scroll = check_scroll(scroll);
                            if(!cScrollBar.timerID) {
                                cScrollBar.timerID = window.SetInterval(function() {
                                    if(cScrollBar.timerCounter > 6 && m_y < brw.scrollbar.cursory) {
                                        scroll = scroll - scroll_step_page;
                                        scroll = check_scroll(scroll);
                                    }; else {
                                        cScrollBar.timerCounter++;
                                    };
                                }, 80);
                            };
                        }; else {
                            // down
                            this.buttonClick = true;
                            scroll = scroll + scroll_step_page;
                            scroll = check_scroll(scroll);
                            if(!cScrollBar.timerID) {
                                cScrollBar.timerID = window.SetInterval(function() {
                                    if(cScrollBar.timerCounter > 6 && m_y > brw.scrollbar.cursory + brw.scrollbar.cursorh) {
                                        scroll = scroll + scroll_step_page;
                                        scroll = check_scroll(scroll);
                                    }; else {
                                        cScrollBar.timerCounter++;
                                    };
                                }, 80);
                            };
                        };
                    };
                };
                break;
            case "right":
            case "up":
                if(cScrollBar.timerID) {
                    window.ClearInterval(cScrollBar.timerID);
                    cScrollBar.timerID = false;
                };
                cScrollBar.timerCounter = -1;
                
                this.cursorCheck(event, x, y);
                for(var i = 1; i < 3; i++) {
                    this.buttons[i].checkstate(event, x, y);
                };
                this.buttonClick = false;
                break;
            case "move":
                this.cursorCheck(event, x, y);
                for(var i = 1; i < 3; i++) {
                    this.buttons[i].checkstate(event, x, y);
                };
                break;
            case "wheel":
                if(!this.buttonClick) {
                    this.updateScrollbar();
                };
                break;
            case "leave":
                this.cursorCheck(event, 0, 0);
                for(var i = 1; i < 3; i++) {
                    this.buttons[i].checkstate(event, 0, 0);
                };
                break;
        };
    };
};

oGroup = function(index, start, handle, groupkey) {
	this.index = index;
	this.start = start;
	this.count = 1;
    this.metadb = handle;
    this.marginTop = 10;	
    this.marginBottom = 10;		
    this.groupkey = groupkey;
    this.cachekey = process_cachekey(globalProperties.tf_crc.EvalWithMetadb(handle));
    //
    this.cover_img = null;
    this.cover_type = null;
    this.tracktype = TrackType(handle.rawpath.substring(0, 4));
    this.tra = [];
    this.load_requested = 0;
    this.save_requested = false;
    this.collapsed = properties.autocollapse;
    this.TimeString = "";
    this.TotalTime = 0;
	
	this.FormatTime = function(time){
		if(time>0){
		time_txt="";
		timetodraw=time;
		
		totalMth=Math.floor((timetodraw)/2592000); r_timetodraw=timetodraw-totalMth*2592000; 
		totalW=Math.floor(r_timetodraw/604800);      
		totalD=Math.floor((r_timetodraw%604800)/86400);    
		totalH=Math.floor((r_timetodraw%86400)/3600);
		totalM=Math.floor((r_timetodraw%3600)/60);
		totalS=Math.round((r_timetodraw%60));
		totalS=(totalS>9) ? totalS:'0'+totalS;
		
		txt_month=(totalMth>1)?totalMth+' months, ':totalMth+' month, ';
		txt_week=(totalW>1)?totalW+' weeks, ':totalW+' week, ';if(totalW==0) txt_week='';   
		txt_day=(totalD>1)?totalD+' days, ':totalD+' day, '; if(totalD==0) txt_day='';
		txt_hour=(totalH>1)?totalH+' h':totalH+' h'; if(totalH==0) txt_hour='';      
		if(totalMth>0) time_txt=txt_month+txt_week+txt_day+txt_hour+totalM+' min ';
		else if (totalW>0) time_txt=txt_week+txt_day+txt_hour+totalM+' min ';
		else if (totalD>0) time_txt=txt_day+txt_hour+", "+totalM+' min ';
		else if (totalH>0) time_txt=txt_hour+((totalM>0)?", "+totalM+' min':'');
		else time_txt=totalM+' min';
		} else time_txt="";	
		return time_txt;
	}

    this.finalize = function(count, tracks) {
        this.tra = tracks.slice(0);
        this.count = count;
        if(count < properties.minimumRowsNumberPerGroup) {
            this.rowsToAdd = properties.minimumRowsNumberPerGroup - count;
        }; else {
            this.rowsToAdd = 0;
        };
        this.rowsToAdd += properties.extraRowsNumber;
		
		this.TimeString = this.FormatTime(this.TotalTime);	
        if(this.collapsed) {
            if(brw.focusedTrackId >= this.start && brw.focusedTrackId < this.start + count) { // focused track is in this group!
                this.collapsed = false;
                g_group_id_focused = this.index;
            }
        };
    };
    
    //this.totalPreviousRows = 0
};

oBrowser = function(name) {
    this.name = name;
    this.groups = [];
    this.rows = [];
    this.SHIFT_start_id = null;
    this.SHIFT_count = 0;
    this.scrollbar = new oScrollbar(themed = cScrollBar.themed);
    this.keypressed = false;
    this.showNowPlaying_trigger = false;
    this.metadblist_selection = plman.GetPlaylistSelectedItems(g_active_playlist);
	this.trackInfo_tooltip = window.CreateTooltip();
	this.trackInfo_tooltip.Deactivate();
	this.FirstInitialisationDone = false;
	this.dontFlashNowPlaying = false;
	this.totaltracks = 0;
	this.drag_tracks = false;
	this.dragSource_track = -1
    this.launch_populate = function() {
        var launch_timer = window.SetTimeout(function(){
            // populate browser with items
            brw.populate(is_first_populate = true,0);
            // populate playlist popup panel list
            if(properties.DropInplaylist) pman.populate(exclude_active = false, reset_scroll = true);
            // kill Timeout
            launch_timer && window.ClearTimeout(launch_timer);
            launch_timer = false;
        }, 5);
    };

    this.repaint = function() {
        if(!window.IsVisible) return;
        repaint_main1 = repaint_main2;
    };
    
    this.cover_repaint = function() {
        if(!window.IsVisible) return;
        repaint_cover1 = repaint_cover2;
    };
    
    this.setSize = function(x, y, w, h) {
        this.x = x;
		
		if(properties.doubleRowText && properties.showgroupheaders)
			this.PaddingTop = 23;
		else if(properties.showgroupheaders)
			this.PaddingTop = 10;			
		else this.PaddingTop = 7;
		
        this.y = y+this.PaddingTop;
        this.w = w;
        this.h = h;
        this.marginLR = 0;
        this.paddingLeft = 1;		
        this.paddingRight = 11;		
	
        this.groupHeaderRowHeight = properties.groupHeaderRowsNumber;
        this.totalRows = Math.ceil(this.h / properties.rowHeight);
        this.totalRowsVis = Math.floor(this.h / properties.rowHeight);
        
        if(g_first_populate_done) 
			this.gettags();
        
        g_filterbox.setSize(this.w, cFilterBox.h+2, g_fsize+1);

        this.scrollbar.setSize();
       
        scroll = Math.round(scroll / properties.rowHeight) * properties.rowHeight;
        scroll = check_scroll(scroll);
        scroll_ = scroll;
        
        // scrollbar update       
        this.scrollbar.updateScrollbar();
        
        if(properties.DropInplaylist) pman.setSize(ww, y + 45, ww, h - 90);
    };

    this.collapseAll = function(bool) { // bool = true to collapse all groups otherwise expand them all
        var end = this.groups.length;
        for(i = 0; i < end; i++) {
            this.groups[i].collapsed = bool;
        };
        this.setList(true);
        g_focus_row = this.getOffsetFocusItem(g_focus_id);
        // if focused track not totally visible, we scroll to show it centered in the panel
        if(g_focus_row < scroll / properties.rowHeight || g_focus_row > scroll / properties.rowHeight + brw.totalRowsVis - 1) {
            scroll = (g_focus_row - Math.floor(brw.totalRowsVis / 2)) * properties.rowHeight;
            scroll = check_scroll(scroll);
            scroll_ = scroll;
        };
        if(this.rowsCount > 0) brw.gettags(true);
        this.scrollbar.updateScrollbar();
        this.repaint();
    };
           
    this.setList = function() {
        this.rows.splice(0, this.rows.length);
        var r = 0, i = 0, j = 0, m = 0, n = 0, s = 0, p = 0;
        var grptags = "";
        var headerTotalRows = properties.groupHeaderRowsNumber;	
        
        /*
		var d1 = new Date();
		var t1 = d1.getSeconds()*1000 + d1.getMilliseconds();
        */
        
        var end = this.groups.length;
        for(i = 0; i < end; i++) {
            
            this.groups[i].load_requested = 0;

            // update total rows present before this group
            //this.groups[i].totalPreviousRows = r;

            grptags = this.groups[i].groupkey;
            
            s = this.groups[i].start;

            if(this.groups[i].collapsed) {
                this.groups[i].rowId = r;				
                if(properties.showgroupheaders) {
                    for(k=0; k < headerTotalRows; k++) {
                        this.rows[r] = new Object();
                        this.rows[r].type = k + 1; // 1st line of group header
                        this.rows[r].metadb = this.groups[i].metadb;
                        this.rows[r].albumId = i;
                        this.rows[r].albumTrackId = 0;
                        this.rows[r].playlistTrackId = s;
                        this.rows[r].groupkey = grptags;
                        r++;
                    };
                };
                // empty extra rows when collapsed
                p = this.groups[i].rowsToAdd;
                for(n = 0; n < p; n++) {
                    this.rows[r] = new Object();
                    this.rows[r].type = 99; // extra row at bottom of the album/group
                    r++;
                };				
            }; else {
                this.groups[i].rowId = r;				
                if(properties.showgroupheaders) {
                    for(k=0; k < headerTotalRows; k++) {
                        this.rows[r] = new Object();
                        this.rows[r].type = k + 1; // 1st line of group header
                        this.rows[r].metadb = this.groups[i].metadb;
                        this.rows[r].albumId = i;
                        this.rows[r].albumTrackId = 0;
                        this.rows[r].playlistTrackId = s;
                        this.rows[r].groupkey = grptags;
                        r++;
                    };
                };
                // tracks
                m = this.groups[i].count;
                for(j = 0; j < m; j++) {
                    this.rows[r] = new Object();
                    this.rows[r].type = 0; // track
                    this.rows[r].metadb = this.list.Item(s + j);
                    this.rows[r].albumId = i;
                    this.rows[r].albumTrackId = j;
                    this.rows[r].playlistTrackId = s + j;
                    this.rows[r].groupkey = grptags;
                    this.rows[r].tracktype = TrackType(this.rows[r].metadb.rawpath.substring(0, 4));
                    this.rows[r].rating = -1;
                    r++;
                };
                // empty extra rows
                p = this.groups[i].rowsToAdd;
                for(n = 0; n < p; n++) {
                    this.rows[r] = new Object();
                    this.rows[r].type = 99; // extra row at bottom of the album/group
                    r++;
                };
            };
        };
        this.rowsCount = r;

    };
    
    this.showNowPlaying = function() {
        if(fb.IsPlaying && (properties.lockOnPlaylistNamed=="" || plman.PlayingPlaylist==g_active_playlist)) {
			g_filterbox.clearInputbox();			
            try {
                this.nowplaying = plman.GetPlayingItemLocation();
                if(this.nowplaying.IsValid) {
                    if(plman.PlayingPlaylist != g_active_playlist && !(properties.lockOnNowPlaying || properties.lockOnPlaylistNamed!="")) {
                        g_active_playlist = plman.ActivePlaylist = plman.PlayingPlaylist;						
						this.showNowPlaying_trigger = true;
						this.populate(is_first_populate = true,21);
                    } else {
						// set focus on the now playing item
						g_focus_id_prev = g_focus_id;
						g_focus_id = this.nowplaying.PlaylistItemIndex;
						g_focus_row = this.getOffsetFocusItem(g_focus_id);
						
						g = this.rows[g_focus_row].albumId;
						//plman.ClearPlaylistSelection(g_active_playlist);
						if(this.groups[g].collapsed && properties.showgroupheaders) {
							this.groups[g].collapsed = false;								
							this.setList();
							this.scrollbar.updateScrollbar();
							//if(this.rowsCount > 0) this.gettags(true);								 
							//this.selectGroupTracks(g);
						}; else {
							//plman.SetPlaylistSelectionSingle(g_active_playlist, g_focus_id, true);
						};
						
						plman.SetPlaylistFocusItem(g_active_playlist, g_focus_id);
						this.showFocusedItem();
						if(this.rowsCount > 0) this.gettags(true);
						if(!cNowPlaying.flashEnable && !this.dontFlashNowPlaying) {
							cNowPlaying.flashEnable = true;
							cNowPlaying.flashescounter = -2;
							cNowPlaying.flash = false;
						} else this.dontFlashNowPlaying=false;					
					}
                };
            }; catch(e) {};
        };
    };
    
    this.showFocusedItem = function() {
        g_focus_row = this.getOffsetFocusItem(g_focus_id);
       // if(g_focus_row < scroll / properties.rowHeight || g_focus_row > scroll / properties.rowHeight + this.totalRowsVis) {
		   if(properties.showgroupheaders) {
				scroll_to_track = (g_focus_row - Math.floor(this.totalRowsVis / 2)) * properties.rowHeight;
				scroll_to_header = this.groups[this.rows[g_focus_row].albumId].rowId * properties.rowHeight - properties.rowHeight*(properties.extraRowsNumber+1)
				if(g_focus_row*properties.rowHeight-scroll_to_header+properties.rowHeight>wh-properties.rowHeight) scroll=scroll_to_track
				else scroll=scroll_to_header				
		   } else 
				scroll = (g_focus_row - Math.floor(this.totalRowsVis / 4)) * properties.rowHeight;
				scroll = check_scroll(scroll);
            //if(!properties.enableFullScrollEffectOnFocusChange) {
             //   scroll_ = scroll + properties.rowHeight * 5 * (g_focus_id_prev <= g_focus_id ? -1 : 1);
           //     scroll_ = check_scroll(scroll_);
          //  };
           
            this.scrollbar.updateScrollbar();
       // };
    };
    
    this.selectAtoB = function(start_id, end_id) {
        var affectedItems = Array();
        
        if(this.SHIFT_start_id == null) {
            this.SHIFT_start_id = start_id;
        };
        
        //plman.ClearPlaylistSelection(g_active_playlist);
        
        var previous_focus_id = g_focus_id;
        
        if(start_id < end_id) {
            var deb = start_id;
            var fin = end_id;
        }; else {
            var deb = end_id;
            var fin = start_id;        
        };

        for(var i = deb; i <= fin ;i++) {
            affectedItems.push(i);
        };
        plman.SetPlaylistSelection(g_active_playlist, affectedItems, true);
        
        plman.SetPlaylistFocusItem(g_active_playlist, end_id);
        
        if(affectedItems.length > 1) {
            if(end_id > previous_focus_id) {
                var delta = end_id - previous_focus_id;
                this.SHIFT_count += delta;
            }; else {
                var delta = previous_focus_id - end_id;
                this.SHIFT_count -= delta;
            };
        };
    };
        
    this.getAlbumIdfromTrackId = function(valeur) { // fixed!
        if(valeur < 0) {
            return -1;
        }; else {
            var mediane = 0; var deb = 0; var fin = this.groups.length - 1;
            while(deb <= fin){
                mediane = Math.floor((fin + deb)/2);
                if(valeur >= this.groups[mediane].start && valeur < this.groups[mediane].start + this.groups[mediane].count) {
                    return mediane;
                }; else if(valeur < this.groups[mediane].start) {
                    fin = mediane - 1;
                }; else {
                    deb = mediane + 1;
                };
            };
            return -1;
        };
    };
    
    this.getOffsetFocusItem = function(fid) { // fixed!
        var row_idx = 0;
        if(fid > -1) {
            if(properties.showgroupheaders) {
                // fid = no item dans la playlist (focus id)
                // this.rows[] => albumId
                // 1 . rech album id contenant le focus_id
                g_focus_album_id = this.getAlbumIdfromTrackId(fid);
				//g_focus_album_id = this.rows[fid].albumId;
                // 2. rech row id
                for(i = 0; i < this.rows.length; i++) {
                    if(this.rows[i].type != 0 && this.rows[i].type != 99 && this.rows[i].albumId == g_focus_album_id) {
                        if(this.groups[g_focus_album_id].collapsed) {
                            row_idx = i;  
                        }; else {
                            var albumTrackId = g_focus_id - this.groups[g_focus_album_id].start;
                            row_idx = i + this.groupHeaderRowHeight + albumTrackId;
                        };
                        break;
                    };
                };
            }; else {
                // 1 . rech album id contenant le focus_id
                g_focus_album_id = this.getAlbumIdfromTrackId(fid);
                // 2. rech row id
                for(i = 0; i < this.rows.length; i++) {
                    if(this.rows[i].type == 0 && this.rows[i].albumId == g_focus_album_id) {
                        var albumTrackId = g_focus_id - this.groups[g_focus_album_id].start;
                        row_idx = i + albumTrackId;
                        break;
                    };
                };
            };
        };
        return row_idx;
    };
    
    this.init_groups = function() {
		var handle = null;
		var current = "";
		var previous = "";
        var g = 0, t = 0;
        var arr = [];
        var tr = [];
		
        var total = this.list.Count;
        this.totaltracks = 0;
		if(plman.PlaylistItemCount(g_active_playlist) > 0) {
			this.focusedTrackId = plman.GetPlaylistFocusItemIndex(g_active_playlist);
		}; else {
			this.focusedTrackId = -1;
		};

		var d1 = new Date();
		var t1 = d1.getSeconds()*1000 + d1.getMilliseconds();

		this.groups.splice(0, this.groups.length);
        CollectGarbage();
        var tf = properties.tf_groupkey;
        var str_filter = process_string(filter_text);
        
		for(var i = 0; i < total; i++) {
			handle = this.list.Item(i);
            arr = tf.EvalWithMetadb(handle).split(" ## ");
            current = arr[0].toLowerCase();
            if(str_filter.length > 0) {
                var toAdd = match(arr[0]+" "+arr[1], str_filter);
            }; else {
                var toAdd = true;  
            };
            if(toAdd) {
				this.totaltracks++;
                if(current != previous) {
                    if(g > 0) {
                        // finalize current group
                        this.groups[g-1].finalize(t, tr);
                        tr.splice(0, t);
                        t = 0;
                    }; 
                    if(i < total) {
                        // add new group
                        tr.push(arr[1]);
                        t++;
                        this.groups.push(new oGroup(g, i, handle, arr[0]));
						this.groups[g].TotalTime+=handle.Length;						
                        g++;
                        previous = current;
                    };
                }; else {
                    // add track to current group
                    tr.push(arr[1]);
					this.groups[g-1].TotalTime+=handle.Length;
                    t++;
                };
            };
		};
        
        // update last group properties
        if(g > 0) this.groups[g-1].finalize(t, tr); 
		
		//Open group if there is only one group
		if(brw.groups.length==1) this.groups[0].collapsed = false;
		
		//var d2 = new Date();
		//var t2 = d2.getSeconds()*1000 + d2.getMilliseconds();
		//fb.trace("JSSP POPULATE: init groups delay = "+Math.round(t2 - t1)+" /handleList count="+total);
    };
      
    this.populate = function(is_first_populate,call_id) {
        if(this.list) this.list.Dispose();
		setActivePlaylist();
		if(properties.lockOnNowPlaying) {
			this.FirstInitialisationDone = true;
			fb.trace("--> populate smoothplaylist with PlayingPlaylist call_id:"+call_id);
		} else {
			fb.trace("--> populate smoothplaylist with ActivePlaylist call_id:"+call_id);
		}
		if(properties.showHeaderBar) g_filterbox.set_default_text();
        this.list = plman.GetPlaylistItems(g_active_playlist);
        this.init_groups();
        this.setList();
        g_focus_row = brw.getOffsetFocusItem(g_focus_id);
        if(g_focus_id < 0) { // focused item not set
            if(is_first_populate) {
                scroll = scroll_ = 0;
            };
        }; else {
            if(is_first_populate) {
                // if focused track not totally visible, we scroll to show it centered in the panel
                if(g_focus_row < scroll/properties.rowHeight || g_focus_row > scroll/properties.rowHeight + brw.totalRowsVis - 1) {
                    scroll = (g_focus_row - Math.floor(brw.totalRowsVis / 2)) * properties.rowHeight;
                    scroll = check_scroll(scroll);
                    scroll_ = scroll;
                };
            };
        };
		if(this.showNowPlaying_trigger || (!g_first_populate_done && properties.lockOnNowPlaying)) {
			if(!g_first_populate_done) this.dontFlashNowPlaying = true;			
			brw.showNowPlaying();
			this.showNowPlaying_trigger = false;
		}
        if(brw.rowsCount > 0) brw.gettags(true);
        this.scrollbar.updateScrollbar();
        this.repaint();
        g_first_populate_done = true;
    };
    
    this.getlimits = function() {
        if(this.rows.length <= this.totalRowsVis) {
            var start_ = 0;
            var end_ = this.rows.length - 1;
        }; else {
            if(scroll_ < 0) scroll_ = scroll;
            var start_ = Math.round(scroll_ / properties.rowHeight + 0.4);
            var end_ = start_ + this.totalRows + (properties.groupHeaderRowsNumber - 1);
            // check boundaries
            start_ = start_ > 0 ? start_ - 1 : start_;
            if(start_ < 0) start_ = 0;
            if(end_ >= this.rows.length) end_ = this.rows.length - 1;
            //end_ = end_ < this.rows.length - 1  ? end_ + 1 : this.rows.length - 1;
        };
        g_start_ = start_;
        g_end_ = end_;
    };
       
    this.gettags = function(all) {
        var start_prev = g_start_;
        var end_prev = g_end_;
        
        this.getlimits();
        
        // force full list refresh especially when library is populating (call from 'on_item_focus_change')
        if( Math.abs(g_start_ - start_prev) > 1 || Math.abs(g_end_ - end_prev) > 1) all = true;
        
        var tf_grp = properties.tf_groupkey;
        var tf_trk = properties.tf_track;
        
        if(all) {
            for(var i = g_start_;i <= g_end_;i++){     
                switch(this.rows[i].type) {
                case this.groupHeaderRowHeight: // last group header row
                    // group tags
                    this.rows[i].groupkey = tf_grp.EvalWithMetadb(this.rows[i].metadb);
                    // track tags
                    this.rows[i].tracktags = tf_trk.EvalWithMetadb(this.rows[i].metadb);
                    break;
                case 0: // track row
                    // group tags
                    this.rows[i].groupkey = tf_grp.EvalWithMetadb(this.rows[i].metadb);
                    // track tags
                    this.rows[i].tracktags = tf_trk.EvalWithMetadb(this.rows[i].metadb);
                    break;
                };
            };
        }; else {           
            if(g_start_ < start_prev) {
                switch(this.rows[g_start_].type) {
                case this.groupHeaderRowHeight: // last group header row
                    // track tags
                    this.rows[g_start_].tracktags = parseInt(tf_trk.EvalWithMetadb(this.rows[g_start_].metadb));
                    break;
                case 0: // track row
                    // track tags
                    this.rows[g_start_].tracktags = tf_trk.EvalWithMetadb(this.rows[g_start_].metadb);
                    break;
                };
            }; else if(g_start_ > start_prev || g_end_ > end_prev) {
                switch(this.rows[g_end_].type) {
                case this.groupHeaderRowHeight: // last group header row
                    // track tags
                    this.rows[g_end_].tracktags = tf_trk.EvalWithMetadb(this.rows[g_end_].metadb);
                    break;
                case 0: // track row
                    // track tags
                    this.rows[g_end_].tracktags = tf_trk.EvalWithMetadb(this.rows[g_end_].metadb);
                    break;
                };
            };
        };
    };
	
    this.draw = function(gr) {
        var coverWidth, coverTop;
        var arr_g = [];
        var arr_t = [];
        var arr_e = [];
		this.group_unrequested_loading = false;
		
        if(repaint_main || !repaintforced){
            repaint_main = false;
            repaintforced = false;
            if(this.rows.length > 0) {
            
                var ax = this.marginLR + this.paddingLeft;				
                var aw = this.w-this.paddingRight - this.paddingLeft;
				
                var ah = properties.rowHeight;
                var ghrh = this.groupHeaderRowHeight;
                var g = 0;
                var coverWidth = cover.max_w;
				var TrackCover_w = ah-cover.trackMargin*2+2;
				var TrackCover_h = ah-cover.trackMargin*2;
				var TrackCover_x = ax+cover.trackMargin;		
                
                // get Now Playing track
                if(fb.IsPlaying && plman.PlayingPlaylist == g_active_playlist) {
                    this.nowplaying = plman.GetPlayingItemLocation();
                }; else {
                    this.nowplaying = null;
                };
				
				//this.getlimits();
				
                for(var i = g_start_;i <= g_end_;i++){
                    ay = Math.floor(this.y + (i * ah) - scroll_);
                    this.rows[i].x = ax;
                    this.rows[i].y = ay;
                    
                    switch(this.rows[i].type) {
                    case ghrh: // last group header row
                        if(ay > 0 - (ghrh * ah) && ay < this.h + (ghrh * ah)) {
                            try {
                                arr_g = this.rows[i].groupkey.split(" ^^ ");
                                arr_e = this.groups[this.rows[i].albumId].tra[0].split(" ^^ ");
                            }; catch(e) {};
                            
                            // Now Playing Group ?
                            if(this.nowplaying && this.nowplaying.PlaylistItemIndex >= this.groups[this.rows[i].albumId].start && this.nowplaying.PlaylistItemIndex < this.groups[this.rows[i].albumId].start + this.groups[this.rows[i].albumId].count) {
                                var nowplaying_group = true;
                            }; else {
                                var nowplaying_group = false;
                            };
                            
                            // group id
                            g = this.rows[i].albumId;
                        
                            // ================
                            // group header bg
                            // ================
                            // if group collapsed, check if 1st track of the group is selected to highlight the group as a selected track]
							var group_height_fix = -2;
                            var g_selected = false;
                            if(this.groups[g].collapsed) {
                                var deb = this.groups[g].start;
                                var fin = this.groups[g].start + this.groups[g].count;
                                for(var p = deb; p < fin; p++) {
                                    if(plman.IsPlaylistItemSelected(g_active_playlist, p)) {
                                        var g_selected = true;
                                        break;
                                    };
                                };
                            };
							
							if(properties.doubleRowText) {
								if(this.groups[g].collapsed){
									line_vertical_fix = 24;
									group_height_fix=-2;
								} else {
									line_vertical_fix = 24;
									group_height_fix=-10;									
								}
							}
							else {
								if(this.groups[g].collapsed){
									line_vertical_fix = 12;
									group_height_fix=2;

								} else {
									line_vertical_fix = 12;
									group_height_fix=-2;
								
								}								
							}
							var group_color_txt_normal = g_color_normal_txt;
							var group_color_txt_fader = g_color_faded_txt;							
                            if(g_selected) {								
								if(g>0) {
									gr.FillGradRect(ax+gradient_m, ay - ((ghrh - 1) * ah)-line_vertical_fix, gradient_w-gradient_m, 1, 0, grad_line_color_bg, grad_line_maincolor, 1.0);
									gr.FillGradRect(ax+gradient_w, ay - ((ghrh - 1) * ah)-line_vertical_fix, aw+this.paddingRight, 1, 0, grad_line_maincolor, grad_line_maincolor, 1.0);		
									gr.FillSolidRect(ax+gradient_m-1, ay - ((ghrh - 1) * ah)-line_vertical_fix, 2, 1, grad_line_color_bg);									
								}
                            }; else {

								if(g>0) {
									gr.FillGradRect(ax+gradient_m, ay - ((ghrh - 1) * ah)-line_vertical_fix, gradient_w-gradient_m, 1, 0, grad_line_color_bg, grad_line_maincolor, 1.0);
									gr.FillGradRect(ax+gradient_w, ay - ((ghrh - 1) * ah)-line_vertical_fix, aw+this.paddingRight, 1, 0, grad_line_maincolor, grad_line_maincolor, 1.0);			
									gr.FillSolidRect(ax+gradient_m-1, ay - ((ghrh - 1) * ah)-line_vertical_fix, 2, 1, grad_line_color_bg);												
								}
                                //gr.FillGradRect(ax, ay - ((ghrh - 1) * ah), aw+this.paddingRight, ah * ghrh - 1, 90, 0, g_color_normal_txt & 0x06ffffff, 1.0);
                                //gr.FillSolidRect(ax, ay - ((ghrh - 1) * ah), aw+this.paddingRight, ah * ghrh - 1, g_color_normal_txt & 0x05ffffff);
                                //gr.FillSolidRect(ax, ay - ((ghrh - 1) * ah), aw+this.paddingRight, 1, g_color_normal_txt & 0x08ffffff);
                            };
							
							if(g_dragndrop_rowId>-1 && this.rows[g_dragndrop_rowId].albumId==g && this.rows[g_dragndrop_rowId].type!=0){
								if(g==0) {
									gr.FillSolidRect(ax, ay - ((ghrh - 1) * ah)-line_vertical_fix+5, aw+this.paddingRight, 2, dragdrop_marker_line);
								}
								else if(!g_dragndrop_bottom) gr.FillSolidRect(ax, ay - ((ghrh - 1) * ah)-line_vertical_fix, aw+this.paddingRight, 2, dragdrop_marker_line);
								else gr.FillSolidRect(ax, ay - ((ghrh - 1) * ah)-line_vertical_fix, aw+this.paddingRight, 2, dragdrop_marker_line);
							}							
							if(g_dragndrop_bottom && i==this.rows.length-1-((properties.showgroupheaders) ? properties.extraRowsNumber: 0))  gr.FillSolidRect(ax, ay + ah + Math.round(ah/2), aw+this.paddingRight, 2, dragdrop_marker_line);
                            // ==========
                            // cover art
                            // ==========
                            if((ghrh > 1 || properties.doubleRowText) && cover.show) {
								cover.padding = (properties.doubleRowText)?16:10;
                                if(this.groups[g].cover_type == null) {
                                    if(this.groups[g].load_requested == 0) {
										//this.group_unrequested_loading=true;								
                                        this.groups[g].cover_img = g_image_cache.hit(this.rows[i].metadb, g);
										if (typeof this.groups[g].cover_img !== "undefined" && this.groups[g].cover_img!==null) {
											this.groups[g].cover_img = FormatCover(this.groups[g].cover_img, coverWidth, coverWidth, false);										
											this.groups[g].cover_type = 1;
										}
                                    }
                                }; else if(this.groups[g].cover_type == 0) {
                                    this.groups[g].cover_img = FormatCover(images.noart, coverWidth, coverWidth, false);
									g_image_cache._cachelist[this.groups[g].cachekey] = FormatCover(images.noart, globalProperties.thumbnailWidthMax, globalProperties.thumbnailWidthMax, false);
                                }; else if(this.groups[g].cover_type == 3) {
									this.groups[g].cover_img = FormatCover(images.stream, coverWidth, coverWidth, false);
									g_image_cache._cachelist[this.groups[g].cachekey] = FormatCover(images.stream, globalProperties.thumbnailWidthMax, globalProperties.thumbnailWidthMax, false);
                                };
						
                                if(this.groups[g].cover_img != null && typeof this.groups[g].cover_img != "string") {
									if(properties.doubleRowText){
										var cv_w = coverWidth-2;
										var cv_h = coverWidth-2;	
										var dx = (cover.max_w - cv_w) / 2;
										var dy = (cover.max_h - cv_h) / 2;
										var cv_x = Math.floor(ax + dx + 1)+6;
										var cv_y = Math.floor(ay + dy - ((ghrh - 1) * ah))+group_height_fix-1;										
									}else {
										var cv_w = coverWidth - cover.margin * 2-cover.padding;
										var cv_h = coverWidth - cover.margin * 2-cover.padding;		
										var dx = (cover.max_w - cv_w) / 2;
										var dy = (cover.max_h - cv_h) / 2;
										var cv_x = Math.floor(ax + dx + 1)-2;
										var cv_y = Math.floor(ay + dy - ((ghrh - 1) * ah))+group_height_fix-2;										
									}
                                    gr.DrawImage(this.groups[g].cover_img, cv_x+8, cv_y, cv_w, cv_h, 0, 0, this.groups[g].cover_img.Width, this.groups[g].cover_img.Height,0,255);
                                    gr.DrawRect(cv_x+8, cv_y, cv_w-1, cv_h-1, 1.0, cover_rectline_color);
								} else if (this.groups[g].cover_img=="no_cover") {
                                    var cv_w = coverWidth - cover.margin * 2-cover.padding;
                                    var cv_h = coverWidth - cover.margin * 2-cover.padding;
                                    var dx = (cover.max_w - cv_w) / 2;
                                    var dy = (cover.max_h - cv_h) / 2;
                                    var cv_x = Math.floor(ax + dx + 1)-2;
                                    var cv_y = Math.floor(ay + dy - ((ghrh - 1) * ah))+group_height_fix-2;									
									gr.DrawImage(cover.nocover_img, cv_x+8, cv_y, cv_w, cv_h, 0, 0, cover.nocover_img.Width, cover.nocover_img.Height, 0, 245);
									gr.DrawRect(cv_x+8, cv_y, cv_w-1, cv_h-1, 1.0, cover_rectline_color);									
                                }; else {
                                    var cv_x = Math.floor(ax + cover.margin + 1);
                                    var cv_y = Math.floor(ay - ((ghrh - 1) * ah) + cover.margin)+group_height_fix;
                                    gr.DrawImage(images.loading_draw, cv_x-cover.margin, cv_y-cover.margin, images.loading_draw.Width, images.loading_draw.Height, 0, 0, images.loading_draw.Width, images.loading_draw.Height, images.loading_angle, 230);
                                };
                                var text_left_margin = cover.max_w+cv_x+((properties.doubleRowText)?16:0);
                            }; else {
                                var text_left_margin = 0;
                            };
                            // =====
                            // text
                            // =====

                            if(arr_g[1] == "?") {
                                if(this.groups[g].count > 1) {
                                    var album_name = "(Singles)"
                                }; else {
                                    var arr_tmp = this.groups[g].tra[0].split(" ^^ ");
                                    var album_name = "(Single) " + arr_tmp[1];
                                };
                            }; else {
                                var album_name = arr_g[1];
                            };	
							arr_e[2]=arr_e[2].replace(/\s+/g, " ");
							//cColumns.albumWidth = gr.CalcTextWidth(album_name, gdi.Font("Segoe UI", g_fsize, 0))+ text_left_margin;	
							cColumns.albumWidth	= 0;
                            cColumns.timeWidth = gr.CalcTextWidth(this.groups[g].TimeString, g_font_group1) + 10;
							cColumns.dateWidth = gr.CalcTextWidth(arr_e[3], g_font_group2);		
							header_text_x = ax;
							header_text_w = aw;
                            // right area						
                            gr.gdiDrawText(this.groups[g].TimeString, gdi.Font(g_fname_light, g_fsize+((properties.doubleRowText)?1:0), g_fstyle_light),  g_color_faded_txt, header_text_x + header_text_w - cColumns.timeWidth - 5, ay - ((ghrh - 1) * ah) + Math.round(ah*1/3)*(ghrh - 1) - 2+group_height_fix, cColumns.timeWidth, Math.round(ah*2/3), DT_RIGHT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                            gr.gdiDrawText(arr_e[3], gdi.Font(g_fname_light, g_fsize-((properties.doubleRowText)?0:0), g_fstyle_light),  g_color_faded_txt, header_text_x + cColumns.albumWidth, ay - ((ghrh - 2) * ah)+group_height_fix-((properties.doubleRowText)?10:0), header_text_x + header_text_w -cColumns.albumWidth-6-this.paddingLeft, Math.round(ah*2/3)*(ghrh - 1), DT_RIGHT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                            // left area
                            gr.gdiDrawText(arr_g[0], gdi.Font("Segoe UI", g_fsize+((properties.doubleRowText)?3:3), 2), group_color_txt_normal, header_text_x + text_left_margin, ay - ((ghrh - 1) * ah) + Math.round(ah*1/3)*(ghrh - 1) - 2+group_height_fix, header_text_w - text_left_margin - cColumns.timeWidth - 10, Math.round(ah*2/3), DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                            gr.gdiDrawText(album_name, gdi.Font(g_fname_light, g_fsize+((properties.doubleRowText)?0:0), g_fstyle_light), g_color_faded_txt, header_text_x + text_left_margin, ay - ((ghrh - 2) * ah)+group_height_fix-((properties.doubleRowText)?10:0), header_text_w - text_left_margin - cColumns.dateWidth, Math.round(ah*2/3)*(ghrh - 1), DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                            if(nowplaying_group) {
                                //gr.gdiDrawText(">", g_font_group2, group_color_txt_normal, header_text_x + text_left_margin + 5, ay - ((ghrh - 2) * ah), 20, Math.round(ah*2/3), DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                            };
                        };
                        break;
                    case 0: // track row
                        //if(ay > this.y - properties.headerBarHeight - ah && ay < this.y + this.h) {
							if(ay > this.y - properties.headerBarHeight - ah && ay < this.y + this.h) {
                            try {
                                arr_t = this.rows[i].tracktags.split(" ^^ ");
                                arr_g = this.rows[i].groupkey.split(" ^^ ");
                                arr_e = this.groups[this.rows[i].albumId].tra[this.rows[i].albumTrackId].split(" ^^ ");
                                
                            }; catch(e) {};
                            
                            // =========
                            // track bg
                            // =========
                            var track_color_txt = g_color_normal_txt;
                            var track_artist_color_text = g_color_faded_txt;
                            var track_color_rating = blendColors(track_color_txt, g_color_normal_bg, 0.2);

                            // selected track bg
                            var t_selected = (plman.IsPlaylistItemSelected(g_active_playlist, this.rows[i].playlistTrackId));

							if(this.nowplaying && this.rows[i].playlistTrackId == this.nowplaying.PlaylistItemIndex) {
								var color_selected = grad_line_maincolor_selected;
								var color_selected_off = grad_line_color_bg_selected;								
							} else {
								var color_selected = grad_line_maincolor;
								var color_selected_off = grad_line_color_bg;									
							}
                            if(t_selected) {
                                //gr.FillSolidRect(ax, ay, aw+this.paddingRight, ah, g_color_selected_bg & 0xb0ffffff);
					

								//top
								gr.FillGradRect(ax+properties.track_gradient_margin, ay, properties.track_gradient_size, 1, 0, color_selected_off,  color_selected, 1.0);
								gr.FillGradRect(ax+aw-properties.track_gradient_size, ay, properties.track_gradient_size, 1, 0, color_selected, color_selected_off, 1.0);	
								gr.FillSolidRect(ax+properties.track_gradient_margin+properties.track_gradient_size, ay, aw-(properties.track_gradient_size*2)-properties.track_gradient_margin, 1, color_selected);					
								//bottom	
								gr.FillGradRect(ax+properties.track_gradient_margin, ay+ah-1, properties.track_gradient_size, 1, 0, color_selected_off,  color_selected, 1.0);
								gr.FillGradRect(ax+aw-properties.track_gradient_size, ay+ah-1, properties.track_gradient_size, 1, 0, color_selected, color_selected_off, 1.0);	
								gr.FillSolidRect(ax+properties.track_gradient_margin+properties.track_gradient_size, ay+ah-1, aw-(properties.track_gradient_size*2)-properties.track_gradient_margin, 1, color_selected);								
								
                                // default track bg (odd/even)
								if(properties.drawAlternateBG) {
									if(properties.showgroupheaders) {
										if(this.rows[i].albumTrackId % 2 == 1) {
											gr.FillSolidRect(ax, ay, aw+this.paddingRight, ah, g_color_alternate_row);
										};
									}; else {
										if(this.rows[i].playlistTrackId % 2 == 1) {
											gr.FillSolidRect(ax, ay, aw+this.paddingRight, ah,g_color_alternate_row);
										};
									};
								}
                            }; else {
								if(properties.drawAlternateBG) {
									// default track bg (odd/even)
									if(properties.showgroupheaders) {
										if(this.rows[i].albumTrackId % 2 != 0) {
											gr.FillSolidRect(ax, ay, aw+this.paddingRight, ah, g_color_alternate_row);
										};
									}; else {
										if(this.rows[i].playlistTrackId % 2 != 0) {
											gr.FillSolidRect(ax, ay, aw+this.paddingRight, ah, g_color_alternate_row);
										};
									};
								}
                            };
                            // focused track bg
                            if(this.rows[i].playlistTrackId == g_focus_id ) {
                                //gr.DrawRect(ax+1, ay+1, aw+this.paddingRight-2, ah-2, 2.0, g_color_selected_bg & 0xd0ffffff);
                            };
							
							//Drag_marker
							if(g_dragndrop_rowId==i){
								if(!g_dragndrop_bottom) gr.FillSolidRect(ax, ay-1, aw+this.paddingRight, 2, dragdrop_marker_line);
								else gr.FillSolidRect(ax, ay+ah-1, aw+this.paddingRight, 2, dragdrop_marker_line);
							}
							if(g_dragndrop_bottom && i==this.rows.length-1-((properties.showgroupheaders) ? properties.extraRowsNumber: 0))  gr.FillSolidRect(ax, ay+ah-1, aw+this.paddingRight, 2, dragdrop_marker_line);
                            

                            // =====
                            // text
                            // =====
                            if(ay >= (0 - ah) && ay < this.y + this.h) {
                                
                                var track_type =  this.groups[this.rows[i].albumId].tracktype;
                                
                                var nbc = this.groups[this.rows[i].albumId].count.toString().length;
                                if(nbc == 1) nbc++;
                                
                                // fields
                                var track_num = arr_t[0] == "?" ? this.rows[i].albumTrackId+1 : arr_t[0];
                                var track_num_part = parseInt(track_num,10)+"    ";
                                if(properties.showArtistAlways || !properties.showgroupheaders || arr_e[0].toLowerCase() != arr_g[0].toLowerCase() || properties.doubleRowText) {
                                    var track_artist_part = arr_e[0];
                                }; else {
                                    var track_artist_part = "";
                                };
                                var track_title_part = arr_e[1];
                                var track_time_part = arr_t[1];
                                // rating tag fixing & formatting
                                if(this.rows[i].rating == -1) {
                                    if(isNaN(arr_t[2])) {
                                        var track_rating_part = 0;
                                    }; else if(Math.abs(arr_t[2]) > 0 && Math.abs(arr_t[2]) < 6) {
                                        var track_rating_part = Math.abs(arr_t[2]);
                                    }; else {
                                        var track_rating_part = 0;
                                    };
                                    this.rows[i].rating = track_rating_part;
                                }; else {
                                    track_rating_part = this.rows[i].rating;
                                };
                                
                                if(properties.showRating && track_type != 3) {
                                    if(g_font_guifx_found) {
                                        cColumns.track_rating_part = gr.CalcTextWidth("bbbbb", g_font_rating);
                                    }; else if(g_font_wingdings2_found) {
                                        cColumns.track_rating_part = gr.CalcTextWidth(String.fromCharCode(234).repeat(5), g_font_rating)-5;
                                    }; else {
                                        cColumns.track_rating_part = gr.CalcTextWidth(String.fromCharCode(0x25CF).repeat(5), g_font_rating)+10;
                                    };
                                }; else {
                                    cColumns.track_rating_part = 0;
                                };
                                
                                gr.SetTextRenderingHint(4);
                                
                                //
                                if(properties.doubleRowText) {
                                    var ay_1 = ay + 2;
                                    var ah_1 = Math.floor(ah /2);
                                    var ay_2 = ay + ah_1 - 2;
                                    var ah_2 = ah - Math.floor(ah /2);

                                    if(this.nowplaying && this.rows[i].playlistTrackId == this.nowplaying.PlaylistItemIndex) { // now playing track
									
										if(cNowPlaying.flashEnable && cNowPlaying.flash && !(properties.drawProgressBar && properties.AlbumArtProgressbar)){
											gr.FillSolidRect(-1, ay+1, ww+2, ah-2, g_color_flash_bg);
										}		
										
                                        this.nowplaying_y = ay;
                                        if(!g_time_remaining) {
                                            g_time_remaining = properties.tf_time_remaining.Eval(true);
                                        };
                                        if(!g_elapsed_seconds) {
                                            g_elapsed_seconds = properties.tf_elapsed_seconds.Eval(true);
                                        };			
                                        if(!g_total_seconds) {
                                            g_total_seconds = properties.tf_total_seconds.Eval(true);
                                        };			
                                        track_time_part = g_time_remaining;
										
										if(cNowPlaying.flashEnable && cNowPlaying.flash && !(properties.drawProgressBar && properties.AlbumArtProgressbar)){
											gr.DrawRect(-1, ay, ww+2, ah-1, 1.0, g_color_flash_rectline);
										}				
																			
										if(properties.doubleRowShowCover && !properties.showgroupheaders) {
											if(arr_t[0]=="?") track_title_part = track_num+". "+track_title_part;										
											else track_title_part = track_title_part;		
										}
                                        cColumns.track_num_part = gr.CalcTextWidth("000", g_font) + 10;
                                        cColumns.track_artist_part = track_artist_part.length > 0 ? gr.CalcTextWidth(track_artist_part, g_font) + 0 : 0;
                                        cColumns.track_title_part = gr.CalcTextWidth(track_title_part, g_font) + 10;
                                        cColumns.track_time_part = gr.CalcTextWidth("00:00:00", g_font);
                                        var tx = ax + cColumns.track_num_part + ((properties.doubleRowShowCover && !properties.showgroupheaders)?cover.trackMarginRight+2:0);
                                        var tw = aw - cColumns.track_num_part - ((properties.doubleRowShowCover && !properties.showgroupheaders)?cover.trackMarginRight+2:0);
                                        if(track_time_part == "ON AIR") {
                                            gr.gdiDrawText(g_radio_title, g_font, track_color_txt, tx+10, ay_1, tw-cColumns.track_time_part-15-(cColumns.track_rating_part+10), ah_1, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                            gr.gdiDrawText(g_radio_artist, gdi.Font(g_fname_light, g_fsize-1, g_fstyle_light), track_artist_color_text, tx+10, ay_2, tw-cColumns.track_time_part-15, ah_2, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                        }; else {
                                            gr.gdiDrawText(track_title_part, g_font, track_color_txt, tx+13, ay_1, tw-cColumns.track_time_part-15-(cColumns.track_rating_part+10), ah_1, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                            gr.gdiDrawText(track_artist_part, gdi.Font(g_fname_light, g_fsize, 2), g_color_faded_txt, tx+13, ay_2, tw-cColumns.track_time_part-15, ah_2, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                        };
                                        gr.gdiDrawText(track_time_part, g_font, track_color_txt, tx+tw-cColumns.track_time_part-8, ay_1, cColumns.track_time_part, ah_1, DT_RIGHT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
																			
                                        // rating Stars
                                        if(properties.showRating && track_type != 3) {
                                            if(g_font_guifx_found) {
                                                gr.DrawString("b".repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part+5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                                gr.DrawString("b".repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part+5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                            }; else if(g_font_wingdings2_found) {
                                                gr.DrawString(String.fromCharCode(234).repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                                gr.DrawString(String.fromCharCode(234).repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                            }; else {
                                                gr.DrawString(String.fromCharCode(0x25CF).repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                                gr.DrawString(String.fromCharCode(0x25CF).repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                            };
                                        };
										
										if(properties.drawProgressBar && (cNowPlaying.flashescounter<5 || !cNowPlaying.flashEnable || properties.AlbumArtProgressbar)){
											if(track_num_part>9) var select_start=4;
											else var select_start=0;										
											var total_size=aw-3+select_start-12-properties.track_gradient_size;
											var elapsed_seconds = g_elapsed_seconds;
											var total_seconds =  g_total_seconds;
											if(total_seconds==0) total_seconds = 2
											var ratio = elapsed_seconds/total_seconds;
											if(track_time_part == "ON AIR") var current_size = properties.track_gradient_size+total_size-1;	
											else var current_size =  properties.track_gradient_size+Math.round(total_size*ratio);
											if(properties.doubleRowShowCover && !properties.showgroupheaders) var text_limit = current_size-34;
											else var text_limit = current_size-23;
											
											if(properties.AlbumArtProgressbar) {
												var playingText = gdi.CreateImage(total_size+15, ah);
												pt = playingText.GetGraphics();
													pt.SetTextRenderingHint(5);
													
													if(typeof(this.groups[this.rows[i].albumId].g_wallpaperImg) == "undefined" || !this.groups[this.rows[i].albumId].g_wallpaperImg) {		
														this.groups[this.rows[i].albumId].g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying(), true, ww, ah*16);
													};						
													pt.GdiDrawBitmap(this.groups[this.rows[i].albumId].g_wallpaperImg, 0, 0, total_size+15,  ah, 0, 0, this.groups[this.rows[i].albumId].g_wallpaperImg.Width, ah);
													pt.fillSolidRect(0, 0, total_size+15, ah,albumartprogressbar_color_overlay)	
													pt.DrawString(track_time_part, g_font, albumartprogressbar_color_txt, 0, 1, total_size+9, ah_1, 554696704);													
												playingText.ReleaseGraphics(pt);
												gr.DrawImage(playingText, ax+22-properties.track_gradient_size, ay, ax+current_size+7, ah, 0, 0, current_size+3, ah, 0, 255);
												gr.drawRect(ax+22-properties.track_gradient_size, ay, ax+current_size+6, ah-1,1,albumartprogressbar_color_rectline)
												gr.gdiDrawText(track_title_part, g_font, albumartprogressbar_color_txt, tx+13, ay_1, Math.min(text_limit,tw-cColumns.track_time_part-15), ah_1, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_NOPREFIX);			
												gr.gdiDrawText(track_artist_part, gdi.Font(g_fname_light, g_fsize, 2), albumartprogressbar_color_txt, tx+13, ay_2, Math.min(text_limit,tw-cColumns.track_time_part-15), ah_2, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_NOPREFIX);	

											} else {
												gr.FillGradRect(ax+25-properties.track_gradient_size, ay, (properties.track_gradient_size>current_size+6)?current_size+6:properties.track_gradient_size, 1, 0, progressbar_color_bg_off, progressbar_maincolor, 1.0); //grad top
												gr.FillSolidRect(ax+25-properties.track_gradient_size, ay,1,1,progressbar_color_bg_off)  // 1px bug fix
												gr.FillSolidRect(ax+25, ay, current_size+12-19, 1, progressbar_maincolor); //line top
												
												gr.FillGradRect(ax+25-properties.track_gradient_size, ay+1, (properties.track_gradient_size>current_size+6)?current_size+6:properties.track_gradient_size, ah-2, 0, progressbar_color_bg_off, progressbar_color_bg_on, 1.0); //grad main bg											
												gr.FillSolidRect(ax+25, ay+1, current_size+11-19, ah-2, progressbar_color_bg_on); //main bg												
												
												gr.FillGradRect(ax+25-properties.track_gradient_size, ay-1+ah, (properties.track_gradient_size>current_size+6)?current_size+6:properties.track_gradient_size, 1, 0, progressbar_color_bg_off, progressbar_maincolor, 1.0); //grad bottom
												gr.FillSolidRect(ax+25-properties.track_gradient_size, ay-1+ah,1,1,progressbar_color_bg_off)  // 1px bug fix
												gr.FillSolidRect(ax+25, ay-1+ah, current_size+12-19, 1, progressbar_maincolor); //line bottom	
												if(t_selected) gr.FillSolidRect(ax+current_size+17, ay+1, 1, ah-2, grad_line_maincolor); //vertical line when selected											
												gr.FillSolidRect(ax+current_size+17, ay+1, 1, ah-2, progressbar_maincolor);	//vertical line	
												gr.FillSolidRect(ax+current_size+18, ay+1, 2, ah+1, progressbar_color_shadow);	//vertical shadow			
												gr.FillSolidRect(ax+25-properties.track_gradient_size, ay+ah, current_size-5+properties.track_gradient_size, 2, progressbar_color_shadow);	//horizontal shadow	
											}
										}										
										if(properties.doubleRowShowCover && !properties.showgroupheaders){
											g = this.rows[i].albumId
											if(this.groups[g].cover_type == null) {
												if(this.groups[g].load_requested == 0 && this.groups[g].start==this.rows[i].playlistTrackId) {							
													this.groups[g].cover_img = g_image_cache.hit(this.rows[i].metadb, g);
													if (typeof this.groups[g].cover_img !== "undefined" && this.groups[g].cover_img!==null) {
														this.groups[g].cover_img = FormatCover(this.groups[g].cover_img, coverWidth, coverWidth, false);													
														this.groups[g].cover_type = 1;														
													}
												}
											}; else if(this.groups[g].cover_type == 0) {
												this.groups[g].cover_img = FormatCover(images.noart, coverWidth, coverWidth, false);
												g_image_cache._cachelist[this.groups[g].cachekey] = FormatCover(images.noart, globalProperties.thumbnailWidthMax, globalProperties.thumbnailWidthMax, false);
											}; else if(this.groups[g].cover_type == 3) {
												this.groups[g].cover_img = FormatCover(images.stream, coverWidth, coverWidth, false);
												g_image_cache._cachelist[this.groups[g].cachekey] = FormatCover(images.stream, globalProperties.thumbnailWidthMax, globalProperties.thumbnailWidthMax, false);
											};
											if(this.groups[g].cover_img != null && typeof this.groups[g].cover_img != "string") {
												gr.DrawImage(this.groups[g].cover_img, TrackCover_x+8, ay+cover.trackMargin, TrackCover_w, TrackCover_h, 0, 0, this.groups[g].cover_img.Width, this.groups[g].cover_img.Height,0,255);
												gr.FillSolidRect(TrackCover_x+8, ay+cover.trackMargin, TrackCover_w, TrackCover_h, playing_cover_overlay);
											} else if (this.groups[g].cover_img=="no_cover") {					
												gr.DrawImage(cover.nocover_img, TrackCover_x+8, ay+cover.trackMargin, TrackCover_w, TrackCover_h, 0, 0, cover.nocover_img.Width, cover.nocover_img.Height, 0, 245);
												gr.FillSolidRect(TrackCover_x+8, ay+cover.trackMargin, TrackCover_w, TrackCover_h, playing_cover_overlay);					
											}
											gr.DrawRect(TrackCover_x+8, ay+cover.trackMargin, TrackCover_w-1, TrackCover_h-1, 1.0, (properties.drawProgressBar && properties.AlbumArtProgressbar) ? cover_rectline_color_AlbumArtProgressbar : cover_rectline_color);
											
											var text_left_margin = cover.max_w+TrackCover_x;
											if(g_elapsed_seconds == 0 || g_elapsed_seconds / 2 == Math.floor(g_elapsed_seconds / 2)) {
												gr.DrawImage(images.now_playing_0, ax+11+((properties.doubleRowShowCover && !properties.showgroupheaders)?3:0), ay+Math.round(ah/2-images.now_playing_0.Height/2)-1, images.now_playing_0.Width, images.now_playing_0.Height, 0, 0, images.now_playing_0.Width, images.now_playing_0.Height, 0, 255);
											}; else {
												gr.DrawImage(images.now_playing_1, ax+11+((properties.doubleRowShowCover && !properties.showgroupheaders)?3:0),  ay+Math.round(ah/2-images.now_playing_0.Height/2)-1, images.now_playing_1.Width, images.now_playing_1.Height, 0, 0, images.now_playing_1.Width, images.now_playing_1.Height, 0, 255);
											};											
										} else {
											if(g_elapsed_seconds == 0 || g_elapsed_seconds / 2 == Math.floor(g_elapsed_seconds / 2)) {
												gr.DrawImage(images.now_playing_0, ax+11+((properties.doubleRowShowCover && !properties.showgroupheaders)?3:0), ay+Math.round(ah/2-images.now_playing_0.Height/2)-1, images.now_playing_0.Width, images.now_playing_0.Height, 0, 0, images.now_playing_0.Width, images.now_playing_0.Height, 0, 255);
											}; else {
												gr.DrawImage(images.now_playing_1, ax+11+((properties.doubleRowShowCover && !properties.showgroupheaders)?3:0),  ay+Math.round(ah/2-images.now_playing_0.Height/2)-1, images.now_playing_1.Width, images.now_playing_1.Height, 0, 0, images.now_playing_1.Width, images.now_playing_1.Height, 0, 255);
											};
										}											
                                    }; else {
										if(properties.doubleRowShowCover && !properties.showgroupheaders){
											g = this.rows[i].albumId
											if(this.groups[g].cover_type == null) {
												if(this.groups[g].load_requested == 0) {							
													this.groups[g].cover_img = g_image_cache.hit(this.rows[i].metadb, g);
													if (typeof this.groups[g].cover_img !== "undefined" && this.groups[g].cover_img!==null) {
														this.groups[g].cover_img = FormatCover(this.groups[g].cover_img, coverWidth, coverWidth, false);
														this.groups[g].cover_type = 1;
													}
												}
											}; else if(this.groups[g].cover_type == 0) {
												this.groups[g].cover_img = FormatCover(images.noart, coverWidth, coverWidth, false);
												g_image_cache._cachelist[this.groups[g].cachekey] = FormatCover(images.noart, globalProperties.thumbnailWidthMax, globalProperties.thumbnailWidthMax, false);
											}; else if(this.groups[g].cover_type == 3) {
												this.groups[g].cover_img = FormatCover(images.stream, coverWidth, coverWidth, false);
												g_image_cache._cachelist[this.groups[g].cachekey] = FormatCover(images.stream, globalProperties.thumbnailWidthMax, globalProperties.thumbnailWidthMax, false);
											};
											if(this.groups[g].cover_img != null && typeof this.groups[g].cover_img != "string") {
												gr.DrawImage(this.groups[g].cover_img, TrackCover_x+8, ay+cover.trackMargin, TrackCover_w, TrackCover_h, 0, 0, this.groups[g].cover_img.Width, this.groups[g].cover_img.Height,0,255);
												gr.DrawRect(TrackCover_x+8, ay+cover.trackMargin, TrackCover_w-1, TrackCover_h-1, 1.0, cover_rectline_color);
											} else if (this.groups[g].cover_img=="no_cover") {					
												gr.DrawImage(cover.nocover_img, TrackCover_x+8, ay+cover.trackMargin, TrackCover_w, TrackCover_h, 0, 0, cover.nocover_img.Width, cover.nocover_img.Height, 0, 245);
												gr.DrawRect(TrackCover_x+8, ay+cover.trackMargin, TrackCover_w-1, TrackCover_h-1, 1.0, cover_rectline_color);									
											}; else {
												gr.DrawRect(TrackCover_x+8, ay+cover.trackMargin, TrackCover_w-1, TrackCover_h-1, 1.0, cover_rectline_color);
											};
											var text_left_margin = cover.max_w+TrackCover_x;
										}									
										if(properties.doubleRowShowCover && !properties.showgroupheaders) {
											if(arr_t[0]!="?") track_title_part = track_num+". "+track_title_part;											
										}
                                        cColumns.track_num_part = gr.CalcTextWidth("000", g_font) + 14;
                                        cColumns.track_artist_part = track_artist_part.length > 0 ? gr.CalcTextWidth(track_artist_part, g_font) : 0;
                                        cColumns.track_title_part = gr.CalcTextWidth(track_title_part, g_font) + 10;
                                        cColumns.track_time_part = gr.CalcTextWidth("00:00:00", g_font);
                                        var tx = ax + cColumns.track_num_part + ((properties.doubleRowShowCover && !properties.showgroupheaders)?cover.trackMarginRight:0);
                                        var tw = aw - cColumns.track_num_part - ((properties.doubleRowShowCover && !properties.showgroupheaders)?cover.trackMarginRight:0);

                                        if(!properties.doubleRowShowCover || properties.showgroupheaders) gr.gdiDrawText(track_num_part, g_font_light, g_color_tracknumber_txt, ax+8, ay_1, cColumns.track_num_part, ah_1, DT_RIGHT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                        gr.gdiDrawText(track_artist_part, gdi.Font(g_fname_light, g_fsize, 2), g_color_faded_txt, tx+10, ay_2, tw-cColumns.track_time_part-15, ah_2, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                        gr.gdiDrawText(track_title_part, g_font, track_color_txt, tx+10, ay_1, tw-cColumns.track_time_part-15-(cColumns.track_rating_part+5), ah_1, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                        gr.gdiDrawText(track_time_part, g_font, track_color_txt, tx+tw-cColumns.track_time_part-8, ay_1, cColumns.track_time_part, ah_1, DT_RIGHT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                        // rating Stars
                                        if(properties.showRating && track_type != 3) {
                                            if(g_font_guifx_found) {
                                                gr.DrawString("b".repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part+5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                                gr.DrawString("b".repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part+5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                            }; else if(g_font_wingdings2_found) {
                                                gr.DrawString(String.fromCharCode(234).repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                                gr.DrawString(String.fromCharCode(234).repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                            }; else {
                                                gr.DrawString(String.fromCharCode(0x25CF).repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                                gr.DrawString(String.fromCharCode(0x25CF).repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay_1, cColumns.track_rating_part+10, ah_1, lc_stringformat);
                                            };
                                        };
                                    };
                                }; else {

                                    // calc text part width + dtaw text
                                    if(this.nowplaying && this.rows[i].playlistTrackId == this.nowplaying.PlaylistItemIndex) { // now playing track
										if(cNowPlaying.flashEnable && cNowPlaying.flash && !(properties.drawProgressBar && properties.AlbumArtProgressbar)){
											gr.FillSolidRect(-1, ay+1, ww+2, ah-2, g_color_flash_bg);
										}	
										if(cNowPlaying.flashEnable && !(properties.drawProgressBar && properties.AlbumArtProgressbar)){
											gr.DrawImage(images.now_playing_black, ax+11, ay+Math.round(ah/2-images.now_playing_black.Height/2)-1, images.now_playing_black.Width, images.now_playing_black.Height, 0, 0, images.now_playing_black.Width, images.now_playing_black.Height, 0, 255);
										}
                                        this.nowplaying_y = ay;
                                        if(!g_time_remaining) {
                                            g_time_remaining = properties.tf_time_remaining.Eval(true);
                                        };
                                        if(!g_elapsed_seconds) {
                                            g_elapsed_seconds = properties.tf_elapsed_seconds.Eval(true);
                                        };			
                                        if(!g_total_seconds) {
                                            g_total_seconds = properties.tf_total_seconds.Eval(true);
                                        };												
                                        track_time_part = g_time_remaining;
										

										if(cNowPlaying.flashEnable && cNowPlaying.flash && !(properties.drawProgressBar && properties.AlbumArtProgressbar)){
											gr.DrawRect(-1, ay, ww+2, ah-1, 1.0, g_color_flash_rectline);
										}												
                                        //
                                        if(track_time_part == "ON AIR") {
                                            if(g_radio_artist.length > 0) {
                                                g_radio_artist_final = " - " + g_radio_artist;
                                            } else g_radio_artist_final = ""
                                        };
                                        //
                                        cColumns.track_num_part = gr.CalcTextWidth("000", g_font) + 11;
                                        cColumns.track_title_part = gr.CalcTextWidth(track_title_part, g_font) + 10;
                                        cColumns.track_time_part = gr.CalcTextWidth("00:00:00", g_font) + 7;
										
									
                                        if(track_time_part == "ON AIR") {
                                            cColumns.track_artist_part = g_radio_title.length > 0 ? gr.CalcTextWidth(g_radio_title, g_font) +3: 0;
                                        }; else {
											if(properties.showgroupheaders){
												 track_part1 = track_title_part;
												 cColumns.track_part1 = track_part1.length > 0 ? gr.CalcTextWidth(track_part1 + " - ", g_font) + 5 : 5;
												 track_part1 = track_title_part
												 track_part2 = track_artist_part;
												 track_part1_color = track_color_txt
												 track_part2_color = track_artist_color_text												 
											} else{
												cColumns.track_part1 = track_artist_part.length > 0 ? gr.CalcTextWidth(track_artist_part + " - ", g_font) + 5 : 5;
												track_part1 = track_artist_part;
												track_part2 = track_title_part;
												track_part1_color = track_color_txt
												track_part2_color = track_artist_color_text												
											}												
                                            cColumns.track_artist_part = track_artist_part.length > 0 ? gr.CalcTextWidth(track_artist_part + " - ", g_font) +3: 0;
                                        };
                                        var tx = ax + cColumns.track_num_part;
                                        var tw = aw - cColumns.track_num_part;
										show_track_part2 = (tw-cColumns.track_part1-cColumns.track_time_part-5-(cColumns.track_rating_part+5)>13);
										if(show_track_part2 && track_part2!="" && track_part1!="") track_part1 = track_part1 + " - ";										
                                        if(cColumns.track_part1 > 0) {
                                            if(track_time_part == "ON AIR") {
                                                gr.gdiDrawText(g_radio_title, g_font, track_color_txt, tx+10, ay, tw-cColumns.track_time_part-15-(cColumns.track_rating_part+5), ah, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                            }; else {
                                                gr.gdiDrawText(track_part1, g_font, track_part1_color, tx+13, ay, tw-cColumns.track_time_part-15-(cColumns.track_rating_part+5), ah, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                            };
                                        };

										
                                        if(track_time_part == "ON AIR") {
                                            gr.gdiDrawText(g_radio_artist_final, g_font, track_artist_color_text, tx+cColumns.track_artist_part+10, ay, tw-cColumns.track_artist_part-cColumns.track_time_part-5-(cColumns.track_rating_part+5), ah, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                        }; else if(show_track_part2) {
                                            gr.gdiDrawText(track_part2, g_font_light, track_part2_color, tx+cColumns.track_part1+8, ay, tw-cColumns.track_part1-cColumns.track_time_part-5-(cColumns.track_rating_part+5), ah, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                        };
                                        gr.gdiDrawText(track_time_part, g_font, track_color_txt, tx+tw-cColumns.track_time_part-8, ay, cColumns.track_time_part, ah, DT_RIGHT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
																																											
                                        // rating Stars
                                        if(properties.showRating && track_type != 3) {
                                            if(g_font_guifx_found) {
                                                gr.DrawString("b".repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part+5), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                                gr.DrawString("b".repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part+5), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                            }; else if(g_font_wingdings2_found) {
                                                gr.DrawString(String.fromCharCode(234).repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                                gr.DrawString(String.fromCharCode(234).repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                            }; else {
                                                gr.DrawString(String.fromCharCode(0x25CF).repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                                gr.DrawString(String.fromCharCode(0x25CF).repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                            };
                                        };
										
										if(properties.drawProgressBar && (cNowPlaying.flashescounter<5 || !cNowPlaying.flashEnable || properties.AlbumArtProgressbar)){	
											if(track_num_part>9) var select_start=4;
											else var select_start=0;	
											var progress_start = 10;											
											var total_size=aw-3+select_start-12-progress_start;
											var elapsed_seconds = g_elapsed_seconds;
											var total_seconds =  g_total_seconds;
											var ratio = elapsed_seconds/total_seconds;
											if(track_time_part == "ON AIR") var current_size = progress_start + total_size;	
											else var current_size =  progress_start + Math.round(total_size*ratio);		
											
											if(properties.AlbumArtProgressbar) {
												
												var playingText = gdi.CreateImage(total_size+15, ah);
												pt = playingText.GetGraphics();
													pt.SetTextRenderingHint(5);
													
													if(typeof(this.groups[this.rows[i].albumId].g_wallpaperImg) == "undefined" || !this.groups[this.rows[i].albumId].g_wallpaperImg) {		
														this.groups[this.rows[i].albumId].g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying(), true);
													};						
													pt.GdiDrawBitmap(this.groups[this.rows[i].albumId].g_wallpaperImg, 0, 0, total_size+15,  ah, 0, 0, this.groups[this.rows[i].albumId].g_wallpaperImg.Width, ah);
													pt.fillSolidRect(0, 0, total_size+15, ah,albumartprogressbar_color_overlay)	
													pt.DrawString(track_time_part, g_font, albumartprogressbar_color_txt, 0, 0, total_size+3, ah, 554696704);													
												playingText.ReleaseGraphics(pt);
												gr.DrawImage(playingText, ax+22-properties.track_gradient_size, ay, ax+current_size+5, ah, 0, 0, current_size+3, ah, 0, 255);
												gr.drawRect(ax+22-properties.track_gradient_size, ay, ax+current_size+4, ah-1,1,albumartprogressbar_color_rectline)
												gr.gdiDrawText(track_part1, g_font, albumartprogressbar_color_txt, tx+13, ay, current_size-27, ah, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_NOPREFIX);					
												gr.gdiDrawText(track_part2, g_font_light, albumartprogressbar_color_txt, tx+cColumns.track_part1+8, ay, Math.min(current_size-cColumns.track_part1-22,tw-cColumns.track_part1-cColumns.track_time_part-5), ah, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_NOPREFIX);	
												
											} else {												
												gr.FillGradRect(ax+25-properties.track_gradient_size, ay, (properties.track_gradient_size>current_size+6)?current_size+6:properties.track_gradient_size, 1, 0, progressbar_color_bg_off, progressbar_maincolor, 1.0); //grad top
												gr.FillSolidRect(ax+25-properties.track_gradient_size, ay,1,1,progressbar_color_bg_off)  // 1px bug fix
												gr.FillSolidRect(ax+25, ay, current_size+12-19, 1, progressbar_maincolor); //line top
												
												gr.FillGradRect(ax+25-properties.track_gradient_size, ay+1, (properties.track_gradient_size>current_size+6)?current_size+6:properties.track_gradient_size, ah-2, 0, progressbar_color_bg_off, progressbar_color_bg_on, 1.0); //grad main bg											
												gr.FillSolidRect(ax+25, ay+1, current_size+11-19, ah-2, progressbar_color_bg_on); //main bg											
												
												gr.FillGradRect(ax+25-properties.track_gradient_size, ay-1+ah, (properties.track_gradient_size>current_size+6)?current_size+6:properties.track_gradient_size, 1, 0, progressbar_color_bg_off, progressbar_maincolor, 1.0); //grad bottom
												gr.FillSolidRect(ax+25-properties.track_gradient_size, ay-1+ah,1,1,progressbar_color_bg_off) // 1px bug fix
												gr.FillSolidRect(ax+25, ay-1+ah, current_size+12-19, 1, progressbar_maincolor); //line bottom		
												gr.FillSolidRect(ax+current_size+17, ay+1, 1, ah-2, progressbar_maincolor);	//vertical line	
												if(t_selected) gr.FillSolidRect(ax+current_size+17, ay+1, 1, ah-2, grad_line_maincolor); //vertical line when selected
												gr.FillSolidRect(ax+current_size+18, ay+1, 2, ah+1, progressbar_color_shadow);	//vertical shadow		
												gr.FillSolidRect(ax+25-properties.track_gradient_size, ay+ah, current_size-5+properties.track_gradient_size, 2, progressbar_color_shadow);	//horizontal shadow	
											}
										}		
										if(g_elapsed_seconds == 0 || g_elapsed_seconds / 2 == Math.floor(g_elapsed_seconds / 2)) {
											gr.DrawImage(images.now_playing_0, ax+11, ay+Math.round(ah/2-images.now_playing_0.Height/2)-1, images.now_playing_0.Width, images.now_playing_0.Height, 0, 0, images.now_playing_0.Width, images.now_playing_0.Height, 0, 255);
										}; else {
											gr.DrawImage(images.now_playing_1, ax+11,  ay+Math.round(ah/2-images.now_playing_0.Height/2)-1, images.now_playing_1.Width, images.now_playing_1.Height, 0, 0, images.now_playing_1.Width, images.now_playing_1.Height, 0, 255);
										};	
                                    }; else { // default track

                                        cColumns.track_num_part = gr.CalcTextWidth("000", g_font) + 11;
                                        cColumns.track_artist_part = track_artist_part.length > 0 ? gr.CalcTextWidth(track_artist_part + " - ", g_font) + 5 : 5;
                                        cColumns.track_title_part = gr.CalcTextWidth(track_title_part, g_font) + 10;
                                        cColumns.track_time_part = gr.CalcTextWidth("00:00:00", g_font) + 7;
                                        var tx = ax + cColumns.track_num_part;
                                        var tw = aw - cColumns.track_num_part;
                                        gr.gdiDrawText(track_num_part, g_font_light, g_color_tracknumber_txt, ax+10, ay, cColumns.track_num_part, ah, DT_RIGHT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
										
										if(track_time_part == "ON AIR"){
											 track_part1 = track_artist_part;
											 cColumns.track_part1 = track_part1.length > 0 ? gr.CalcTextWidth(track_part1 + " - ", g_font) + 5 : 5;
											 track_part1 = track_artist_part;
											 track_part2 = "";
											 track_part1_color = track_color_txt
											 track_part2_color = track_artist_color_text											
										} else if(properties.showgroupheaders){
											 track_part1 = track_title_part;
											 cColumns.track_part1 = track_part1.length > 0 ? gr.CalcTextWidth(track_part1 + " - ", g_font) + 5 : 5;
											 track_part1 = track_title_part;
											 track_part2 = track_artist_part;
											 track_part1_color = track_color_txt
											 track_part2_color = track_artist_color_text
										} else{
											cColumns.track_part1 = track_artist_part.length > 0 ? gr.CalcTextWidth(track_artist_part + " - ", g_font) + 5 : 5;
											track_part1 = track_artist_part;
											track_part2 = track_title_part;
											track_part1_color = track_color_txt
											if(track_part1.length>0) track_part2_color = track_artist_color_text
											else  track_part2_color = track_color_txt
										}
										show_track_part2 = (tw-cColumns.track_part1-cColumns.track_time_part-5-(cColumns.track_rating_part+5)>13);
										if(show_track_part2 && track_part2!="" && track_part1!="") track_part1 = track_part1 + " - ";
                                        if(cColumns.track_part1 > 0) {
                                            gr.gdiDrawText(track_part1, g_font, track_part1_color, tx+13, ay, tw-cColumns.track_time_part-5-(cColumns.track_rating_part+5), ah, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                        };
                                        if(show_track_part2)
										gr.gdiDrawText(track_part2, g_font_light, track_part2_color, tx+cColumns.track_part1+8, ay, tw-cColumns.track_part1-cColumns.track_time_part-5-(cColumns.track_rating_part+5), ah, DT_LEFT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                        gr.gdiDrawText(track_time_part, g_font, track_color_txt, tx+tw-cColumns.track_time_part-8, ay, cColumns.track_time_part, ah, DT_RIGHT | DT_VCENTER | DT_CALCRECT | DT_END_ELLIPSIS | DT_NOPREFIX);
                                        // rating Stars
                                        if(properties.showRating && track_type != 3) {
                                            if(g_font_guifx_found) {
                                                gr.DrawString("b".repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part+5), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                                gr.DrawString("b".repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part+5), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                            }; else if(g_font_wingdings2_found) {
                                                gr.DrawString(String.fromCharCode(234).repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                                gr.DrawString(String.fromCharCode(234).repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                            }; else {
                                                gr.DrawString(String.fromCharCode(0x25CF).repeat(5), g_font_rating, track_color_rating & 0x15ffffff, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                                gr.DrawString(String.fromCharCode(0x25CF).repeat(track_rating_part), g_font_rating, track_color_rating, tx+tw-cColumns.track_time_part-(cColumns.track_rating_part-5), ay, cColumns.track_rating_part+10, ah, lc_stringformat);
                                            };
                                        };
                                    };
                                };
                            };
                        };
                        break;
                    case 99: // extra bottom row
                        if(ay > -1 && ay < this.h && properties.drawAlternateBG) {
                            if(this.rows[i].albumTrackId % 2 == 1) {
                                gr.FillSolidRect(ax, ay, aw, ah, g_color_alternate_row);
                            };
                        };
                        break;
                    };

                };
				//if(properties.darklayout) Draw bottom gradient
					gr.FillGradRect(0, wh-fading_bottom_height, ww, fading_bottom_height, 90, grad_bottom_color2,  grad_bottom_color1,1);		

                // Incremental Search Display
                if(cList.search_string.length > 0) {
                    brw.tt_x = Math.floor(((brw.w) / 2) - (((cList.search_string.length*13)+(10*2)) / 2));
                    brw.tt_y = brw.y + Math.floor((brw.h / 2) - 30);
                    brw.tt_w = Math.round((cList.search_string.length*13)+(10*2));
                    brw.tt_h = 40;
                    gr.FillSolidRect(brw.tt_x, brw.tt_y, brw.tt_w, brw.tt_h,keyboard_search_bg);
                    try {
                        gr.GdiDrawText(cList.search_string, gdi.Font(g_fname, g_fsize+7,0), cList.inc_search_noresult?keyboard_search_txtred:keyboard_search_txt, brw.tt_x, brw.tt_y , brw.tt_w , brw.tt_h, DT_CENTER | DT_NOPREFIX | DT_CALCRECT | DT_VCENTER);
                    }; catch(e) {};
                };

            }; else { // no track, playlist is empty

            };

            // draw header
            if(properties.showHeaderBar) {
                //var boxText = "  "+this.groups.length+" album"+(this.groups.length>1?"s  ":"  ");
                var boxText = (this.totaltracks > 1 ? this.totaltracks+" items" : this.totaltracks+" item");
                // draw background part above playlist (headerbar)
				gr.FillSolidRect(0, 0, ww, properties.headerBarHeight, headerbar_bgcolor);

				gr.FillGradRect(headerBar_gradient_m, properties.headerBarHeight, gradient_w-headerBar_gradient_m, 1, 0, headerbar_line_bgcolor, headerbar_line_maincolor, 1.0);
				gr.FillGradRect(gradient_w, properties.headerBarHeight, ww, 1, 0, headerbar_line_maincolor, headerbar_line_maincolor, 1.0);	
				                
				if(g_filterbox.inputbox.text.length>0) {
					var text_width = gr.CalcTextWidth(boxText,gdi.Font(g_fname, g_fsize-1, 0))
					var inputbox_width = gr.CalcTextWidth(g_filterbox.inputbox.text,gdi.Font(g_fname, g_fsize-1, 0))
				} else{
					var text_width = 0;
					var inputbox_width = 0;
				}
				
				var tx = cFilterBox.x + cFilterBox.w + Math.round(22 * g_zoom_percent / 100) + 5 - text_width;
				var tw = this.w - tx - 18;
				if(inputbox_width<tw-10){
					//this.x + (cx * this.thumbnailWidth) + this.marginSide + this.marginLR;
					try {
						gr.gdiDrawText(boxText, gdi.Font(g_fname, g_fsize-1, 0),g_color_faded_txt, tx, 0, tw, properties.headerBarHeight-1, DT_RIGHT | DT_VCENTER | DT_CALCRECT | DT_NOPREFIX | DT_END_ELLIPSIS);
					}; catch(e) {
						fb.trace(">> debug: cScrollBar.width="+cScrollBar.width+" /boxText="+boxText+" /properties.headerBarHeight="+properties.headerBarHeight+" /g_fsize="+g_fsize);
					};
				}
            };
			//if(cScrollBar.enabled || (m_x > ww - cScrollBar.width && m_x < ww && m_y > properties.headerBarHeight && m_y < wh))  {
			if(cScrollBar.enabled)  {
				brw.scrollbar && brw.scrollbar.draw(gr);
			};	
        };
    };
    
    this.selectGroupTracks = function(aId) { // fixed!
        var affectedItems = [];
        var end = this.groups[aId].start + this.groups[aId].count;
        for(var i = this.groups[aId].start; i < end; i++) {
            affectedItems.push(i);
        };
        plman.SetPlaylistSelection(g_active_playlist, affectedItems, true);
    };
    
    this._isHover = function(x, y) {
        return (x > this.x && x < this.x + this.w && y > this.y && y < this.y + this.h);
    };
    
    this.dragndrop_check = function(x, y, rowId) {
        if(this.activeRow > -1 && rowId == this.activeRow) {
			while(typeof(this.rows[rowId]) !== "undefined" && this.rows[rowId].type == 99) {
				rowId=rowId+1;
				if(typeof(this.rows[rowId]) == "undefined") {rowId=this.rows.length-1;g_dragndrop_bottom=true;break}
			};			
            g_dragndrop_trackId = this.rows[rowId].playlistTrackId;
            g_dragndrop_rowId = rowId;
        };
    };
    
    this.on_mouse = function(event, x, y) {
        this.ishover = (x >= this.x && x <= this.x + this.w && y >= this.y && y <= this.y + this.h);
        
        // get hover row index (mouse cursor hover)
        if(y > this.y && y < this.y + this.h) {
            this.activeRow = Math.ceil((y + scroll_ - this.y) / properties.rowHeight - 1);
            if(this.activeRow >= this.rows.length) {
				this.activeRow = -1;
				
			}
        }; else {
            this.activeRow = -1;
			
        };
		
        // rating check
        this.ishover_rating_prev = this.ishover_rating;
        if(this.activeRow > -1) {
            var rating_x = this.x + this.w - cColumns.track_time_part - (cColumns.track_rating_part+13);
            var rating_y = Math.floor(this.y + (this.activeRow * properties.rowHeight) - scroll_);
            if(properties.showRating) {
                this.ishover_rating = (this.rows[this.activeRow].type == 0 && x >= rating_x  && x <= rating_x + cColumns.track_rating_part && y >= rating_y && y <= rating_y + properties.rowHeight);
            }; else {
                this.ishover_rating = false;
            };
        }; else {
            this.ishover_rating = false;
        };
        
        switch(event) {
            case "down":
			
				if( this.activeRow == -1) plman.ClearPlaylistSelection(g_active_playlist)
                this.metadblist_selection = plman.GetPlaylistSelectedItems(g_active_playlist);
                if(!cTouch.down && !timers.mouseDown && this.ishover && this.activeRow > -1 && Math.abs(scroll - scroll_) < 2) {
                    var rowType = this.rows[this.activeRow].type;

                    this.drag_clicked = true;
                    this.drag_clicked_x = x;
                    this.drag_clicked_y = y;
					this.dragSource_track = this.rows[this.activeRow];
					
                    switch(true) {
                        case (rowType > 0 && rowType < 99):     // ----------------> group header row
                            var playlistTrackId = this.rows[this.activeRow].playlistTrackId;
                            if(utils.IsKeyPressed(VK_SHIFT)) {
                                if (g_focus_id != playlistTrackId) {
                                    if (this.SHIFT_start_id != null) {
                                        this.selectAtoB(this.SHIFT_start_id, playlistTrackId);
                                    }; else {
                                        this.selectAtoB(g_focus_id, playlistTrackId);
                                    };
                                };
                            }; else if(utils.IsKeyPressed(VK_CONTROL)) {
                                this.selectGroupTracks(this.rows[this.activeRow].albumId);
                                this.SHIFT_start_id = null;
                            }; else {
								plman.ClearPlaylistSelection(g_active_playlist);
                                if(!((properties.autocollapse || properties.expandBySingleClick) && this.groups[this.rows[this.activeRow].albumId].collapsed)) {
                                    this.selectGroupTracks(this.rows[this.activeRow].albumId);
                                };
                                this.SHIFT_start_id = null;
                            };
                            plman.SetPlaylistFocusItem(g_active_playlist, playlistTrackId);														
							if(this.groups[this.rows[this.activeRow].albumId].collapsed && properties.expandBySingleClick) {
								this.groups[this.rows[this.activeRow].albumId].collapsed = false
								this.setList();
								this.scrollbar.updateScrollbar();
								if(this.rowsCount > 0) this.gettags(true);					
							}								
                            break;
                        case (rowType == 0):                    // ----------------> track row
                            var playlistTrackId = this.rows[this.activeRow].playlistTrackId;
                            if(utils.IsKeyPressed(VK_SHIFT)) {
                                if(g_focus_id != playlistTrackId) {
                                    if (this.SHIFT_start_id != null) {
                                        this.selectAtoB(this.SHIFT_start_id, playlistTrackId);
                                    }; else {
                                        this.selectAtoB(g_focus_id, playlistTrackId);
                                    };
                                };
                            }; else if(utils.IsKeyPressed(VK_CONTROL)) {
                                if(plman.IsPlaylistItemSelected(g_active_playlist, playlistTrackId)) {
                                    plman.SetPlaylistSelectionSingle(g_active_playlist, playlistTrackId, false);
                                }; else {
                                    plman.SetPlaylistSelectionSingle(g_active_playlist, playlistTrackId, true);
                                    plman.SetPlaylistFocusItem(g_active_playlist, playlistTrackId);
                                };
                                this.SHIFT_start_id = null;
                            }; else {
								
                                // check if rating to update ?
                                if(this.ishover_rating) {
                                    // calc new rating
                                    var l_rating = Math.ceil((x - rating_x) / (cColumns.track_rating_part / 5) + 0.1);
                                    if(l_rating > 5) l_rating = 5;
                                    // update if new rating <> current track rating
                                    if (this.rows[this.activeRow].tracktype < 2) {
                                        g_rating_updated = true;
                                        g_rating_rowId = this.activeRow;
                                        if(foo_playcount) {
                                            // Rate to database statistics brought by foo_playcount.dll
                                            if (l_rating != this.rows[this.activeRow].rating) {
                                                if (this.rows[this.activeRow].metadb) {
                                                    this.rows[this.activeRow].rating = l_rating;
                                                    window.Repaint();
                                                    var bool = fb.RunContextCommandWithMetadb("Rating/" + ((l_rating == 0) ? "<not set>" : l_rating), this.rows[this.activeRow].metadb);
                                                };
                                            }; else {
                                                this.rows[this.activeRow].rating = 0;
                                                window.Repaint();
                                                var bool = fb.RunContextCommandWithMetadb("Rating/<not set>", this.rows[this.activeRow].metadb);
                                            };
                                        }; else {
                                            // Rate to file
                                            if (l_rating != this.rows[this.activeRow].rating) {
                                                if (this.rows[this.activeRow].metadb) {
                                                    this.rows[this.activeRow].rating = l_rating;
                                                    window.Repaint();
                                                    var bool = this.rows[this.activeRow].metadb.UpdateFileInfoSimple("RATING", l_rating); 
                                                };
                                            }; else {
                                                this.rows[this.activeRow].rating = 0;
                                                window.Repaint();
                                                var bool = this.rows[this.activeRow].metadb.UpdateFileInfoSimple("RATING", "");
                                            };
                                        };
                                    };
                                }; else {
                                    if(plman.IsPlaylistItemSelected(g_active_playlist, playlistTrackId)) {
                                        if(this.metadblist_selection.Count > 1) {
                                            //plman.ClearPlaylistSelection(g_active_playlist);
                                            //plman.SetPlaylistSelectionSingle(g_active_playlist, playlistTrackId, true);
                                            //plman.SetPlaylistFocusItem(g_active_playlist, playlistTrackId);
                                        }; else {
                                            // nothing, single track already selected
                                        };
                                    }; else {
                                        plman.ClearPlaylistSelection(g_active_playlist);
                                        plman.SetPlaylistSelectionSingle(g_active_playlist, playlistTrackId, true);
                                        plman.SetPlaylistFocusItem(g_active_playlist, playlistTrackId);
                                    };
                                    this.SHIFT_start_id = null;
                                };
                            };
                            break;
                        case (rowType == 99):                   // ----------------> extra empty row

                            break;
                    };
                    this.repaint();
                }; else {
                    // scrollbar
                    if(cScrollBar.enabled && cScrollBar.visible) {
                        brw.scrollbar && brw.scrollbar.on_mouse(event, x, y);
                    };
                };
                break;
            case "up":
                this.metadblist_selection = plman.GetPlaylistSelectedItems(g_active_playlist);
                if(this.drag_clicked && this.activeRow > -1) {
                    var rowType = this.rows[this.activeRow].type;
                    //
                    switch(true) {
                        case (rowType > 0 && rowType < 99):     // ----------------> group header row
                            //var playlistTrackId = this.rows[this.activeRow].playlistTrackId;
                            break;
                        case (rowType == 0):                    // ----------------> track row
                            var playlistTrackId = this.rows[this.activeRow].playlistTrackId;
                            if(!utils.IsKeyPressed(VK_SHIFT) && !utils.IsKeyPressed(VK_CONTROL)) {
                                if(plman.IsPlaylistItemSelected(g_active_playlist, playlistTrackId)) {
                                    if(this.metadblist_selection.Count > 1) {
                                        plman.ClearPlaylistSelection(g_active_playlist);
                                        plman.SetPlaylistSelectionSingle(g_active_playlist, playlistTrackId, true);
                                        plman.SetPlaylistFocusItem(g_active_playlist, playlistTrackId);
                                    };
                                };
                            };
                            break;
                        case (rowType == 99):                   // ----------------> extra empty row

                            break;
                    };
                    this.repaint();
                };
				this.drag_tracks = false;
                this.drag_clicked = false;
                // scrollbar
                if(cScrollBar.enabled && cScrollBar.visible) {
                    brw.scrollbar && brw.scrollbar.on_mouse(event, x, y);
                };
                break;
            case "dblclk":
                if(this.ishover && this.activeRow > -1 && Math.abs(scroll - scroll_) < 2) {
                    var rowType = this.rows[this.activeRow].type;
                    switch(true) {
                        case (rowType > 0 && rowType < 99): // group header
                            if(!properties.expandBySingleClick || !this.groups[this.rows[this.activeRow].albumId].collapsed) {
								this.groups[this.rows[this.activeRow].albumId].collapsed = !this.groups[this.rows[this.activeRow].albumId].collapsed;
								this.setList(true);

								///*
								g_focus_row = this.getOffsetFocusItem(g_focus_id);
								// if focused track not totally visible, we scroll to show it centered in the panel
								if(g_focus_row < scroll / properties.rowHeight || g_focus_row > scroll / properties.rowHeight + brw.totalRowsVis - 1) {
									scroll = (g_focus_row - Math.floor(brw.totalRowsVis / 2)) * properties.rowHeight;
									scroll = check_scroll(scroll);
									scroll_ = scroll;
								};
								//*/
								if(this.rowsCount > 0) brw.gettags(true);
								this.scrollbar.updateScrollbar();
								brw.repaint();
							}
                            break;
                        case (rowType == 0): // track
							plman.ActivePlaylist = g_active_playlist
							plman.ExecutePlaylistDefaultAction(g_active_playlist, this.rows[this.activeRow].playlistTrackId);
                            break;
                        case (rowType == 99): // extra empty row

                            break;
                    };
                    this.repaint();
                }; else {
                    // scrollbar
                    if(cScrollBar.enabled && cScrollBar.visible) {
                        brw.scrollbar && brw.scrollbar.on_mouse(event, x, y);
                    };
                };
                break;
            case "move":
                if(g_lbtn_click && this.drag_clicked && !this.drag_moving) {
                    if(!properties.DropInplaylist || this.h > cPlaylistManager.rowHeight * 6) {
						if(properties.DropInplaylist && !this.drag_tracks && (Math.abs(y - this.drag_clicked_y) < 15 && Math.abs(x - this.drag_clicked_x) > 15) && plman.GetPlaylistSelectedItems(g_active_playlist).Count>0) {
							this.drag_moving = true;
							window.SetCursor(IDC_HELP);						
							pman.state = 1;
							if(timers.hidePlaylistManager) {
								window.ClearInterval(timers.hidePlaylistManager);
								timers.hidePlaylistManager = false;
							};
							if(!timers.showPlaylistManager) {
								timers.showPlaylistManager = window.SetInterval(pman.showPanel, 25);
							};
						} else if((!properties.DropInplaylist && (Math.abs(x - this.drag_clicked_x) > 5 || Math.abs(y - this.drag_clicked_y) > 5)) || (Math.abs(y - this.drag_clicked_y) > 15 && !this.drag_moving)){
							if(!this.drag_tracks && this.dragSource_track.type!=99 && plman.GetPlaylistSelectedItems(g_active_playlist).Count>0) {
								this.drag_tracks = true;
								on_drag_over(null, x, y, null);
								window.SetCursor(IDC_HELP);									
							}						
						}
                    };
                };
                if(this.drag_moving && !timers.hidePlaylistManager && !timers.showPlaylistManager && properties.DropInplaylist) {
                    pman.on_mouse("move", x, y);
                };
                // scrollbar
                if(this.ishover_rating && !brw.drag_tracks) {
                    if(!this.ishover_rating_prev) window.SetCursor(IDC_HAND);
                }; else if(!brw.drag_tracks){
                    if(this.ishover_rating_prev) window.SetCursor(IDC_ARROW);
                    if(cScrollBar.enabled && cScrollBar.visible) {
                        brw.scrollbar && brw.scrollbar.on_mouse(event, x, y);
                    };
                };
				/*if(this.ishover && this.activeRow > -1 && Math.abs(scroll - scroll_) < 2 && this.rows[this.activeRow].type==0 && this.TooltipRow!=this.activeRow && !timers.showToolTip) {
					if (!timers.showToolTip) {
						this.trackInfo_tooltip.SetMaxWidth(800);
						this.TooltipRow=this.activeRow;						

							track_info=brw.groups[brw.rows[brw.activeRow].albumId].tra[brw.rows[brw.activeRow].albumTrackId].split(" ^^ ");
							new_tooltip_text=track_info[1]+"\n"+track_info[0];				
							if(brw.TooltipRow==brw.activeRow && brw.trackInfo_tooltip.Text != new_tooltip_text){								
								brw.trackInfo_tooltip.Text = new_tooltip_text;							
								brw.trackInfo_tooltip.Activate();
								//brw.trackInfo_tooltip.SetDelayTime(0, 5000)
								brw.trackInfo_tooltip.TrackPosition(x, y);
								brw.trackInfo_tooltip.TrackActivate = true;					
							}
					} 
				}*/
                break;
            case "right":
                this.metadblist_selection = plman.GetPlaylistSelectedItems(g_active_playlist);
                if(this.ishover && this.activeRow > -1 && Math.abs(scroll - scroll_) < 2) {
                    var rowType = this.rows[this.activeRow].type;
                    switch(true) {
                        case (rowType > 0 && rowType < 99):     // ----------------> group header row
                            var playlistTrackId = this.rows[this.activeRow].playlistTrackId;
                            //if(!plman.IsPlaylistItemSelected(g_active_playlist, playlistTrackId)) {
                                plman.ClearPlaylistSelection(g_active_playlist);
                                this.selectGroupTracks(this.rows[this.activeRow].albumId);
                                plman.SetPlaylistFocusItem(g_active_playlist, playlistTrackId);
                                this.SHIFT_start_id = null;
                            //};
                            if(!utils.IsKeyPressed(VK_SHIFT)) {
                                this.context_menu(x, y, this.track_index, this.row_index);
                            };
                            break;
                        case (rowType == 0):                    // ----------------> track row
                            var playlistTrackId = this.rows[this.activeRow].playlistTrackId;
                            if(!plman.IsPlaylistItemSelected(g_active_playlist, playlistTrackId)) {
                                plman.ClearPlaylistSelection(g_active_playlist);
                                plman.SetPlaylistSelectionSingle(g_active_playlist, playlistTrackId, true);
                                plman.SetPlaylistFocusItem(g_active_playlist, playlistTrackId);
                            };
                            if(!utils.IsKeyPressed(VK_SHIFT)) {
                                this.context_menu(x, y, playlistTrackId, this.activeRow);
                            };
                            break;
                        case (rowType == 99):                   // ----------------> extra empty row
							this.context_menu(x, y,false,false);
                            break;
                    };
                    this.repaint();
                }; else {
                    // scrollbar
                    if(cScrollBar.enabled && cScrollBar.visible) {
                        brw.scrollbar && brw.scrollbar.on_mouse(event, x, y);
                    };
                    // settings menu
                    if(!g_filterbox.inputbox.hover) {
                        this.context_menu(x, y,false,false);
                    };
                };
                break;
            case "wheel":
                //this.scrollbar.updateScrollbar(); // update scrollbar done in g_time at each scroll update
                break;
            case "leave":
                // scrollbar
                if(cScrollBar.enabled && cScrollBar.visible) {
                    this.scrollbar && this.scrollbar.on_mouse(event, 0, 0);
                };
				this.trackInfo_tooltip.Deactivate();
                break;
            case "drag_over":
                g_dragndrop_bottom = false;
                if(this.groups.length > 0) {
                    var fin = this.rows.length;
                    for(var i = 0; i < fin; i++) {
                        this.dragndrop_check(x, y, i);
                    };
                    var rowId = fin - 1;
                    var item_height_row = (this.rows[rowId].type == 0 ? 1 : properties.groupHeaderRowsNumber);
                    var limit = this.rows[rowId].y + (item_height_row * properties.rowHeight);
					if(y<this.y+this.PaddingTop) {
						rowId=0
                        g_dragndrop_trackId = this.rows[rowId].playlistTrackId;
                        g_dragndrop_rowId = rowId;						
					}					
                    else if(y > limit || g_dragndrop_trackId==-1) {
                        g_dragndrop_bottom = true;
                        g_dragndrop_trackId = this.rows[rowId].playlistTrackId;
                        g_dragndrop_rowId = rowId;
                    }  
                }; else {
                    g_dragndrop_bottom = true;
                    g_dragndrop_trackId = 0;
                    g_dragndrop_rowId = 0;
                };
                break;
        };
    };
        
    if(this.g_time) {
        window.ClearInterval(this.g_time);
        this.g_time = false;
    };
    this.g_time = window.SetInterval(function() {
        if(!g_first_populate_done) {
            brw.populate(true,2);
			if(properties.DropInplaylist) pman.populate(exclude_active = false, reset_scroll = true);
        }		
        if(!window.IsVisible) {
            window_visible = false;
            return;
        };
        		
        var repaint_1 = false;

        if(!window_visible){
            window_visible = true;
        };
        
        if(cNowPlaying.flashEnable) {
            cNowPlaying.flashescounter++;
            if(cNowPlaying.flashescounter%5 == 0 && cNowPlaying.flashescounter <= cNowPlaying.flashescountermax && cNowPlaying.flashescounter>0) {
                cNowPlaying.flash = !cNowPlaying.flash;
            }
            if(cNowPlaying.flashescounter > cNowPlaying.flashescountermax) {
                cNowPlaying.flashEnable = false;
            }
            repaint_1 = true;
        }			
        
        // get hover row index (mouse cursor hover)
        if(m_y > brw.y && m_y < brw.y + brw.h) {
            brw.activeRow = Math.ceil((m_y + scroll_ - brw.y ) / properties.rowHeight - 1);
            if(brw.activeRow >= brw.rows.length) brw.activeRow = -1;
        }; else {
            brw.activeRow = -1;
        };

        if(repaint_main1 == repaint_main2){
            repaint_main2 = !repaint_main1;
            repaint_1 = true;
        };

		if(cScrollBar.visible) {
			scroll = check_scroll(scroll);
			if(Math.abs(scroll - scroll_) >= 2){
				scroll_ += (scroll - scroll_) / properties.scrollSmoothness;
				repaint_1 = true;
				isScrolling = true;
				//
				if(scroll_prev != scroll) brw.scrollbar.updateScrollbar();
			}; else {
				if(isScrolling) {
					if(scroll_< 1) scroll_ = 0;
					isScrolling = false;
					repaint_1 = true;
				};
			};
		} else scroll = scroll_ = 0;
		if(brw.group_unrequested_loading) {
			brw.group_unrequested_loading=false;
			repaint_1 = true;
		}	
		
		if(repaint_cover1 == repaint_cover2){
			repaint_cover2 = !repaint_cover1;
			repaint_1 = true;
		};
		
		if(repaint_1){
			if(isScrolling && brw.rows.length > 0) brw.gettags(false);
			repaintforced = true;
			repaint_main = true;
			images.loading_angle = (images.loading_angle+30) % 360;
			window.Repaint();
		};        	

		scroll_prev = scroll;

        // tweak to fix bug in timer/memory/repaint handle in WSH Panel Mod with timers
        g_counter_repaint++;
        if(g_counter_repaint > 100) {
            g_counter_repaint = 0;
            CollectGarbage();
        };
        
    }, properties.refreshRate);

	this.context_menu = function(x, y, id, row_id) {
		var _menu = window.CreatePopupMenu();
		var Context = fb.CreateContextMenuManager();
		var _child01 = window.CreatePopupMenu();
		var _child02 = window.CreatePopupMenu();
		if(id!==false){        
			if(brw.activeRow > -1) {
				var albumIndex = this.rows[this.activeRow].albumId;
				var crc = brw.groups[albumIndex].cachekey;
			};

			this.metadblist_selection = plman.GetPlaylistSelectedItems(g_active_playlist);
			Context.InitContext(this.metadblist_selection);

			// check if selection is single and is in the Media Library to provide if ok a link to Album View panel
			var showInAlbumView = false;
			/*if(this.metadblist_selection.Count == 1) {
				if(fb.IsMetadbInMediaLibrary(this.metadblist_selection.Item(0))) {
					showInAlbumView = true;
				};
			};*/

			Context.BuildMenu(_menu, 2, -1);
		   
			_menu.AppendMenuItem(plman.IsAutoPlaylist(g_active_playlist)?MF_DISABLED|MF_GRAYED:MF_STRING, 1020, "Remove selected");
			
			_menu.AppendMenuSeparator();			
		}
		
		var quickSearchMenu = window.CreatePopupMenu();	
		quickSearchMenu.AppendMenuItem(MF_STRING, 1029,"Same title");			
		quickSearchMenu.AppendMenuItem(MF_STRING, 1030,"Same artist");
		quickSearchMenu.AppendMenuItem(MF_STRING, 1031,"Same album");	
		quickSearchMenu.AppendMenuItem(MF_STRING, 1032,"Same genre");		
		quickSearchMenu.AppendMenuItem(MF_STRING, 1033,"Same date");		
		quickSearchMenu.AppendTo(_menu, MF_STRING, "Quick search for...");	
		
		if(utils.IsKeyPressed(VK_SHIFT)) {
			_child01.AppendTo(_menu, MF_STRING, "Send to...");
			//_child01.AppendMenuItem((showInAlbumView ? MF_STRING : MF_GRAYED | MF_DISABLED), 1011, "Highlight in JS Smooth Browser");
			_child01.AppendMenuItem(MF_STRING, 2000, "A new playlist...");
		}
		if(brw.activeRow > -1 && !properties.showgroupheaders && properties.doubleRowShowCover && properties.doubleRowText) {
			//if(this.metadblist_selection.Count == 1) {
				_menu.AppendMenuItem(MF_STRING, 1010, "Refresh this image");
			//};
		} else if(brw.activeRow > -1 && this.rows[this.activeRow].type > 0 && this.rows[this.activeRow].type < 99){
			//if(this.metadblist_selection.Count == 1) {
			_menu.AppendMenuItem(MF_STRING, 1010, "Refresh this image");
			//};			
		}	
		_menu.AppendMenuSeparator();
		_menu.AppendMenuItem(MF_STRING, 1034, "Select all");
		_menu.AppendMenuItem(MF_STRING, 1035, "Remove all");	
		
		
		
        var pl_count = plman.PlaylistCount;
		if(pl_count > 1) {
			_child02.AppendMenuItem(MF_SEPARATOR, 0, "");
		};
		for(var i=0; i < pl_count; i++) {
			if(i != this.playlist && !plman.IsAutoPlaylist(i)) {
				_child02.AppendMenuItem(MF_STRING, 2001 + i, plman.GetPlaylistName(i));
			};
		};
		if(properties.showSettingsMenu) {
			_menu.AppendMenuSeparator();
			_menu.AppendMenuItem(MF_STRING, 1, "Settings...");
		}
		var ret = _menu.TrackPopupMenu(x, y);
		if(ret > 1 && ret < 800) {
			Context.ExecuteByID(ret - 2);
		}; else if(ret<2) {
			switch (ret) {
			case 1:
				//window.ShowProperties();
                this.settings_context_menu(x, y);
				break;
			};
		}; else {
			switch (ret) {
			case 1010:
                if(fso.FileExists(cover_img_cache + "\\" + crc)) {
                    try {
                        fso.DeleteFile(cover_img_cache + "\\" + crc);
                    }; catch(e) {
                        fb.trace("WSH Panel Error: Image cache ["+crc+"] can't be deleted on disk, file in use, try later or reload panel.");
                    };
                };
                this.groups[albumIndex].tid = -1;
                this.groups[albumIndex].load_requested = 0;
                this.groups[albumIndex].save_requested = false;
                g_image_cache.reset(crc);
                this.groups[albumIndex].cover_img = null;
                this.groups[albumIndex].cover_type = null;
                this.repaint();
				window.NotifyOthers("RefreshImageCover",this.groups[albumIndex].metadb)
				break;
            case 1011:
                window.NotifyOthers("JSSmoothPlaylist->JSSmoothBrowser:show_item", this.metadblist_selection.Item(0));
                break;
			case 1020:
				//if(this.metadblist_selection.Count == 1)
					//removeItems(this.metadblist_selection,g_active_playlist,false);
				//else
					removeItems(this.metadblist_selection,g_active_playlist);
				//plman.RemovePlaylistSelection(g_active_playlist, false);
				break;
            case 1029:
				quickSearch(this.metadblist_selection.Item(0),"title");
                break;					
            case 1030:
				quickSearch(this.metadblist_selection.Item(0),"artist");
                break;	
            case 1031:
				quickSearch(this.metadblist_selection.Item(0),"album");		
                break;			
            case 1032:
				quickSearch(this.metadblist_selection.Item(0),"genre");		
                break;		
            case 1033:
				quickSearch(this.metadblist_selection.Item(0),"date");		
                break;	
			case 1034:
				selected_array=Array();
				for(var i = 0; i <= plman.PlaylistItemCount(g_active_playlist);i++) {
					selected_array.push(i);
				};		
				plman.SetPlaylistSelection(g_active_playlist,selected_array,true)
				break;				
			case 1035:
				removeItems(false,g_active_playlist);			
				break;					
			case 2000:
				fb.RunMainMenuCommand("File/New playlist");
				plman.InsertPlaylistItems(plman.PlaylistCount-1, 0, this.metadblist_selection, false);
				break;
			default:
				var insert_index = plman.PlaylistItemCount(ret-2001);
				plman.InsertPlaylistItems((ret-2001), insert_index, this.metadblist_selection, false);
			};
		};
		_child01.Dispose();
		_child02.Dispose();
		_menu.Dispose();
		if (typeof quickSearchMenu != "undefined") quickSearchMenu.Dispose();
        g_rbtn_click = false;
		return true;
	};
    
    this.settings_context_menu = function(x, y) {
            var _menu = window.CreatePopupMenu();
            var _menu1 = window.CreatePopupMenu();
            var _menu2 = window.CreatePopupMenu();
            var _menu3 = window.CreatePopupMenu();
			var _menu2A = window.CreatePopupMenu();
            var idx;

			var lockOnMenu = window.CreatePopupMenu();
			lockOnMenu.AppendTo(_menu, MF_STRING, "Displayed Playlist");
			lockOnMenu.AppendMenuItem(MF_STRING, 3300, "Playing Playlist");		
			lockOnMenu.AppendMenuItem(MF_STRING, 3299, "Active Playlist");		
				
			var pl_count = plman.PlaylistCount;
			if(pl_count > 1) {
				lockOnMenu.AppendMenuItem(MF_SEPARATOR, 0, "");
			};
			for(var i=0; i < pl_count; i++) {
				if(i != this.playlist) {
					playlist_name = plman.GetPlaylistName(i);
					lockOnMenu.AppendMenuItem(MF_STRING, 3301 + i, plman.GetPlaylistName(i));
				};
			};	
			if(properties.lockOnPlaylistNamed!="") playlist_idx = check_playlist(properties.lockOnPlaylistNamed);
			else playlist_idx = -1;
			if(playlist_idx>-1) {
				lockOnMenu.CheckMenuItem(3301 + playlist_idx, true);
			} else {
				lockOnMenu.CheckMenuItem(3299, !properties.lockOnNowPlaying);
				lockOnMenu.CheckMenuItem(3300, properties.lockOnNowPlaying);
			}
			lockOnMenu.AppendMenuSeparator();
			lockOnMenu.AppendMenuItem(MF_STRING, 3298, "Switch to Playing or Active depending on the filters state");	
			lockOnMenu.CheckMenuItem(3298, properties.enableAutoSwitchPlaylistMode);				
			
            _menu.AppendMenuItem((fb.IsPlaying ? MF_STRING : MF_GRAYED | MF_DISABLED), 900, "Show Now Playing");
            _menu.AppendMenuItem(MF_STRING, 901, "Enable Drag'n'Drop to a playlist");		
			_menu.CheckMenuItem(901, properties.DropInplaylist);

			_menu.AppendMenuSeparator();			
            _menu.AppendMenuItem(MF_STRING, 903, "Load all covers at startup");
            _menu.CheckMenuItem(903, properties.load_covers_at_startup);	
            _menu.AppendMenuItem(MF_STRING, 902, "Enable Disk Image Cache");
            _menu.CheckMenuItem(902, properties.enableDiskCache);				
			
            _menu.AppendMenuSeparator();
            _menu.AppendMenuItem(MF_STRING, 910, "Header Bar");
            _menu.CheckMenuItem(910, properties.showHeaderBar);
			
            _menu.AppendMenuItem(MF_STRING, 912, "Double Track Line");
            _menu.CheckMenuItem(912, properties.doubleRowText); 
			if(properties.doubleRowText && !properties.showgroupheaders){
				_menu.AppendMenuItem(MF_STRING, 913, "Double Track Line : Show covers");
				_menu.CheckMenuItem(913, properties.doubleRowShowCover);    
            }
            _menu.AppendMenuSeparator();
			
			_menu.AppendMenuItem(MF_GRAYED, 0, "Progress bar under playing title :");
			_menu.AppendMenuItem(MF_STRING, 914, "No progress bar");
			//_menu.CheckMenuItem(21, properties.drawProgressBar);	
			_menu.AppendMenuItem(MF_STRING, 916, "White Progress bar");			
			_menu.AppendMenuItem(MF_STRING, 915, "Progress bar according to the album art");
			//_menu.CheckMenuItem(23, properties.AlbumArtProgressbar);	
			_menu.CheckMenuRadioItem(914, 916, (!properties.drawProgressBar) ? 914 : (properties.AlbumArtProgressbar) ? 915 : 916, false);	
			_menu.AppendMenuSeparator();			
			
            _menu3.AppendMenuItem(MF_STRING, 300, "Enable");
            _menu3.CheckMenuItem(300, properties.showgroupheaders);
            _menu3.AppendMenuItem((properties.showgroupheaders ? MF_STRING : MF_GRAYED | MF_DISABLED), 310, "Autocollapse");
            _menu3.CheckMenuItem(310, properties.autocollapse);
            _menu3.AppendMenuSeparator();
            _menu3.AppendMenuItem((properties.showgroupheaders && !properties.autocollapse ? MF_STRING : MF_GRAYED | MF_DISABLED), 320, "Collapse All");
            _menu3.AppendMenuItem((properties.showgroupheaders && !properties.autocollapse ? MF_STRING : MF_GRAYED | MF_DISABLED), 330, "Expand All");

            _menu3.AppendTo(_menu,MF_STRING, "Group Headers");
			
            _menu1.AppendMenuItem((!properties.doubleRowText ? (!properties.showgroupheaders ? MF_GRAYED | MF_DISABLED : MF_STRING) : MF_GRAYED | MF_DISABLED), 111, "Artist");
            _menu1.CheckMenuItem(111, properties.showArtistAlways);
            //_menu1.AppendMenuItem(MF_STRING, 112, "Mood");
            //_menu1.CheckMenuItem(112, properties.showMood);
            _menu1.AppendMenuItem(MF_STRING, 113, "Rating");
            _menu1.CheckMenuItem(113, properties.showRating);
            _menu1.AppendTo(_menu,MF_STRING, "Extra Track Infos");

            _menu2.AppendMenuItem(MF_STRING, 200, "Enable");
            _menu2.CheckMenuItem(200, properties.showwallpaper);
            _menu2.AppendMenuItem(MF_STRING, 220, "Blur");
            _menu2.CheckMenuItem(220, properties.wallpaperblurred);
			
            _menu2A.AppendMenuItem(MF_STRING, 221, "Filling");
            _menu2A.CheckMenuItem(221, properties.wallpaperdisplay==0);	
            _menu2A.AppendMenuItem(MF_STRING, 222, "Adjust");
            _menu2A.CheckMenuItem(222, properties.wallpaperdisplay==1);
            _menu2A.AppendMenuItem(MF_STRING, 223, "Stretch");
            _menu2A.CheckMenuItem(223, properties.wallpaperdisplay==2);
			_menu2A.AppendTo(_menu2,MF_STRING, "Wallpaper size");
			
            //_menu2.AppendMenuSeparator();
            //_menu2.AppendMenuItem((!properties.showwallpaper ? MF_GRAYED | MF_DISABLED : MF_STRING), 210, "Default");
            //_menu2.AppendMenuItem((!properties.showwallpaper ? MF_GRAYED | MF_DISABLED : MF_STRING), 211, "Playing Album Cover");
            //_menu2.CheckMenuRadioItem(210, 211, properties.wallpapermode == 0 ? 211 : 210);

            _menu2.AppendTo(_menu,MF_STRING, "Background Wallpaper");

			if(layout_state==0 && main_panel_state==1){
				_menu.AppendMenuSeparator();
				_menu.AppendMenuItem(MF_STRING, 993, "Hide this playlist");
			}
            //_menu.AppendMenuSeparator();
            //_menu.AppendMenuItem(MF_STRING, 991, "Panel Properties");
            //_menu.AppendMenuItem(MF_STRING, 992, "Configure...");
            
            idx = _menu.TrackPopupMenu(x,y);
            
            switch(true) {
                case (idx == 111):
                    properties.showArtistAlways = !properties.showArtistAlways;
                    window.SetProperty("_DISPLAY: Show Artist in Track Row", properties.showArtistAlways);
                    get_metrics();
                    brw.repaint();
                    break;
                case (idx == 112):
                    properties.showMood = !properties.showMood;
                    window.SetProperty("_DISPLAY: Show Mood in Track Row", properties.showMood);
                    get_metrics();
                    brw.repaint();
                    break;
                case (idx == 113):
                    properties.showRating = !properties.showRating;
                    window.SetProperty("_DISPLAY: Show Rating in Track Row", properties.showRating);
                    get_metrics();
                    brw.repaint();
                    break;
                case (idx == 200):
                    toggleWallpaper();
                    break;
                case (idx == 210):
                    properties.wallpapermode = 99;on_colors_changed();		
                    window.SetProperty("_SYSTEM: Wallpaper Mode", properties.wallpapermode);
                    if(fb.IsPlaying) g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying());
                    brw.repaint();
                    break;
                case (idx == 211):
                    properties.wallpapermode = 0;on_colors_changed();		
                    window.SetProperty("_SYSTEM: Wallpaper Mode", properties.wallpapermode);
                    if(fb.IsPlaying) g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying());
                    brw.repaint();
                    break;
                case (idx == 220):
                    properties.wallpaperblurred = !properties.wallpaperblurred;on_colors_changed();		
                    window.SetProperty("_DISPLAY: Wallpaper Blurred", properties.wallpaperblurred);
                    g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying());
                    brw.repaint();
                    break;
                case (idx == 221):
                    properties.wallpaperdisplay = 0;
                    window.SetProperty("_DISPLAY: Wallpaper 0=Filling 1=Adjust 2=Stretch", properties.wallpaperdisplay);
                    g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying());
                    brw.repaint();
                    break;	
                case (idx == 222):
                    properties.wallpaperdisplay = 1;
                    window.SetProperty("_DISPLAY: Wallpaper 0=Filling 1=Adjust 2=Stretch", properties.wallpaperdisplay);
                    g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying());
                    brw.repaint();
                    break;		
                case (idx == 223):
                    properties.wallpaperdisplay = 2;
                    window.SetProperty("_DISPLAY: Wallpaper 0=Filling 1=Adjust 2=Stretch", properties.wallpaperdisplay);
                    g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying());
                    brw.repaint();
                    break;						
                case (idx == 300):
                    properties.showgroupheaders = !properties.showgroupheaders;
                    window.SetProperty("_DISPLAY: Show Group Headers", properties.showgroupheaders);
					get_metrics();
					on_colors_changed();
                    if(properties.autocollapse) {
						properties.autocollapse = false;
						window.SetProperty("_PROPERTY: Autocollapse groups", properties.autocollapse);
					}						
                    if(!properties.showgroupheaders) brw.collapseAll(false);
					brw.populate(is_first_populate = false,3);
                    brw.repaint();
                    break;
                case (idx == 310):
                    properties.autocollapse = !properties.autocollapse;
                    window.SetProperty("_PROPERTY: Autocollapse groups", properties.autocollapse);
                    brw.populate(false,4);
                    brw.showFocusedItem();
                    break;
                case (idx == 320):
                    brw.collapseAll(true);
                    brw.showFocusedItem();
                    break;
                case (idx == 330):
                    brw.collapseAll(false);
                    brw.showFocusedItem();
                    break;
                case (idx == 900):
                    brw.showNowPlaying();
                    break;
                case (idx == 901):
                    properties.DropInplaylist = !properties.DropInplaylist
                    window.SetProperty("_SYSTEM: Allow to drag items into a playlist", properties.DropInplaylist);
					pman.populate(exclude_active = false, reset_scroll = true);
                    get_metrics();
                    brw.repaint();					
                    break;		
                case (idx == 902):
					enableDiskCacheGlobaly()				
					brw.repaint();				
                    break;
                case (idx == 903):
					enableCoversAtStartupGlobaly()
					break;						
                case (idx == 910):
                    properties.showHeaderBar = !properties.showHeaderBar;
                    window.SetProperty("_DISPLAY: Show Top Bar", properties.showHeaderBar);
                    get_metrics();
                    brw.repaint();
                    break;
                case (idx == 912):
                    properties.doubleRowText = !properties.doubleRowText;
                    window.SetProperty("_PROPERTY: Double Row Text Info", properties.doubleRowText);
                    get_metrics();
					get_images();
                    brw.repaint();
                    break;
                case (idx == 913):
                    properties.doubleRowShowCover = !properties.doubleRowShowCover;
                    window.SetProperty("_PROPERTY: Double Row Show Cover", properties.doubleRowShowCover);
                    on_colors_changed();
                    brw.repaint();
                    break;	
				case (idx == 914):
					properties.drawProgressBar = false;
					window.SetProperty("TRACKLIST Draw a progress bar under song title", properties.drawProgressBar);
					brw.repaint();
					break;			
				case (idx == 915):
					properties.AlbumArtProgressbar = true;		
					properties.drawProgressBar = true;								
					window.SetProperty("_DISPLAY Draw a progress bar under song title", properties.drawProgressBar);						
					window.SetProperty("_DISPLAY Album art progress bar", properties.AlbumArtProgressbar);	
					get_images();					
					brw.repaint();
					break;				
				case (idx == 916):
					properties.AlbumArtProgressbar = false;		
					properties.drawProgressBar = true;				
					window.SetProperty("_DISPLAY Draw a progress bar under song title", properties.drawProgressBar);						
					window.SetProperty("_DISPLAY Album art progress bar", properties.AlbumArtProgressbar);	
					get_images();
					brw.repaint();
					break;						
                case (idx == 991):
                    window.ShowProperties();
                    break;
                case (idx == 992):
                    window.ShowConfigure();
                    break;
                case (idx == 993):
                    set_nowplaying_state(0);
                    break;					
				case (idx == 3298):	
					properties.enableAutoSwitchPlaylistMode=!properties.enableAutoSwitchPlaylistMode;
					window.SetProperty("Automatically change displayed playlist", properties.enableAutoSwitchPlaylistMode);	
					if(filters_panel_state==2) properties.lockOnNowPlaying=false;
					else properties.lockOnNowPlaying=true;
					window.SetProperty("lock on now playing playlist", properties.lockOnNowPlaying);	
					properties.lockOnPlaylistNamed="";
					window.SetProperty("lock on specific playlist name", "");				
					brw.populate(true,4);	
					break;		
				case (idx == 3299):	
					properties.lockOnNowPlaying=false;
					window.SetProperty("lock on now playing playlist", properties.lockOnNowPlaying);	
					properties.lockOnPlaylistNamed="";
					window.SetProperty("lock on specific playlist name", "");
					brw.populate(true,4);
					break;
				case (idx == 3300):	
					properties.lockOnNowPlaying=true;
					window.SetProperty("lock on now playing playlist", properties.lockOnNowPlaying);	
					properties.lockOnPlaylistNamed="";
					window.SetProperty("lock on specific playlist name", "");
					brw.populate(true,4);
					break;		
				case (idx > 3300):	
					properties.lockOnPlaylistNamed=plman.GetPlaylistName(idx-3301);
					properties.lockOnNowPlaying=false;
					window.SetProperty("lock on now playing playlist", properties.lockOnNowPlaying);			
					window.SetProperty("lock on specific playlist name", properties.lockOnPlaylistNamed);	
					brw.populate(true,4);
					break;						
            };
            _menu2.Dispose();
			_menu2A.Dispose();
            _menu1.Dispose();
            _menu.Dispose();
            g_rbtn_click = false;
            return true;
    };

    this.incrementalSearch = function() {
        var count = 0;
        var albumartist, artist, groupkey;
        var chr;
        var gstart;
        var pid = -1;
        
        // exit if no search string in cache
        if(cList.search_string.length <= 0) return true;
        
        // 1st char of the search string
        var first_chr = cList.search_string.substring(0,1);  
        var len = cList.search_string.length;
        
        // which start point for the search
        if(this.list.count > 1000) {
            albumartist = properties.tf_albumartist.EvalWithMetadb(this.list.Item(Math.floor(this.list.Count / 2)));
            chr = albumartist.substring(0,1);
            if(first_chr.charCodeAt(first_chr) > chr.charCodeAt(chr)) {
                gstart = Math.floor(this.list.Count / 2);
            }; else {
                gstart = 0;
            };
        }; else {
            gstart = 0;
        };

        if(!properties.showgroupheaders) {

            // 1st search on "album artist" TAG
            var format_str = "";
            for(var i = gstart; i < this.list.Count; i++) {
                albumartist = properties.tf_albumartist.EvalWithMetadb(this.list.Item(i));
                format_str = albumartist.substring(0,len).toUpperCase();
                if(format_str == cList.search_string) {
                    pid = i;
                    break;
                };
            };
            
            // if not found, search in the first part (from 0 to gstart)
            if(pid < 0) {
                var format_str = "";
                for(var i = 0; i < gstart; i++) {
                    albumartist = properties.tf_albumartist.EvalWithMetadb(this.list.Item(i));
                    format_str = albumartist.substring(0,len).toUpperCase();
                    if(format_str == cList.search_string) {
                        pid = i;
                        break;
                    };
                };
            };
            
            if(pid < 0) {
                // 2nd search on "artist" TAG
                var format_str = "";
                for(var i = 0; i < this.list.Count; i++) {
                    artist = properties.tf_artist.EvalWithMetadb(this.list.Item(i));
                    format_str = artist.substring(0,len).toUpperCase();
                    if(format_str == cList.search_string) {
                        pid = i;
                        break;
                    };
                };
            };

        }; else {

            // 1st search on tf_group_key of current group by pattern
            var format_str = "";
            for(var i = gstart; i < this.list.Count; i++) {
                groupkey = properties.tf_groupkey.EvalWithMetadb(this.list.Item(i));
                format_str = groupkey.substring(0,len).toUpperCase();
                if(format_str == cList.search_string) {
                    pid = i;
                    break;
                };
            };
            
            // if not found, search in the first part (from 0 to gstart)
            if(pid < 0) {
                var format_str = "";
                for(var i = 0; i < gstart; i++) {
                    groupkey = properties.tf_groupkey.EvalWithMetadb(this.list.Item(i));
                    format_str = groupkey.substring(0,len).toUpperCase();
                    if(format_str == cList.search_string) {
                        pid = i;
                        break;
                    };
                };
            };

        };
        
        if(pid >= 0) { // found
            g_focus_id = pid;
            plman.ClearPlaylistSelection(g_active_playlist);
            plman.SetPlaylistSelectionSingle(g_active_playlist, g_focus_id, true);
            plman.SetPlaylistFocusItem(g_active_playlist, g_focus_id);
            this.showFocusedItem();
        }; else { // not found on "album artist" TAG, new search on "artist" TAG
            cList.inc_search_noresult = true;
            brw.repaint();
        };
        
        cList.clear_incsearch_timer && window.ClearTimeout(cList.clear_incsearch_timer);
        cList.clear_incsearch_timer = window.SetTimeout(function () {
            // reset incremental search string after 1 seconds without any key pressed
            cList.search_string = "";
            cList.inc_search_noresult = false;
            brw.repaint();
            window.ClearInterval(cList.clear_incsearch_timer);
            cList.clear_incsearch_timer = false;
        }, 1000);
    };
};

/* 
===================================================================================================
    Main
===================================================================================================
*/
var g_elapsed_seconds = null;
var g_time_remaining = null;
var g_total_seconds = null;
var g_radio_title = "loading live tag ...";
var g_radio_artist = "";

var fso = new ActiveXObject("Scripting.FileSystemObject");
var Img = new ActiveXObject("WIA.ImageFile.1");
var IP = new ActiveXObject("WIA.ImageProcess.1");
IP.Filters.Add(IP.FilterInfos("Scale").FilterID);   //ID = 1
IP.Filters.Add(IP.FilterInfos("Crop").FilterID);    //ID = 2
IP.Filters.Add(IP.FilterInfos("Convert").FilterID); //ID = 3
var WshShell = new ActiveXObject("WScript.Shell");
var htmlfile = new ActiveXObject('htmlfile');
var list_img = [];
var g_valid_tid = 0;

var cover_path = new RegExp("(artwork)|(cover)|(scan)|(image)");
var cover_img = cover.masks.split(";");
var stub_image,cell_null;

var brw = null;
var g_1x1 = false;
var g_last = 0;
var isScrolling = false;
var g_zoom_percent = 100;

var g_filterbox = null;
var filter_text = "";

var g_instancetype = window.InstanceType;
var g_counter_repaint = 0;

// fonts
var g_font = null;
var g_font_headers = null;
var g_font_group1 = null;
var g_font_group2 = null;
var g_font_rating = null;
var g_font_mood = null;
var g_font_guifx_found = utils.CheckFont("guifx v2 transports");
var g_font_wingdings2_found = utils.CheckFont("wingdings 2");

// drag'n drop from windows system
var g_dragndrop_status = false;
var g_dragndrop_x = -1;
var g_dragndrop_y = -1;
var g_dragndrop_bottom = false;
var g_dragndrop_timer = false;
var g_dragndrop_trackId = -1;
var g_dragndrop_rowId = -1;
var g_dragndrop_targetPlaylistId = -1;
var g_dragndrop_total_before = 0;
var g_dragndrop_drop_forbidden = false;

//
var ww = 0, wh = 0;
var g_metadb = null;
var g_focus = false;
var foo_playcount = utils.CheckComponent("foo_playcount", true);
clipboard = {
    selection: null
};
// wallpaper infos
var wpp_img_info = {orient: 0, cut: 0, cut_offset: 0, ratio: 0, x: 0, y: 0, w: 0, h: 0};
var update_wallpaper = false;
var m_x = 0, m_y = 0;
var g_focus_id = -1;
var g_focus_id_prev = -1;
var g_focus_row = 0;
var g_focus_album_id = -1;
var g_populate_opt = 1;
// color vars
var g_color_normal_bg = 0;
var g_color_selected_bg = 0;
var g_color_normal_txt = 0;
var g_color_selected_txt = 0;
var g_color_highlight = 0;
var g_syscolor_window_bg = 0;
var g_syscolor_highlight = 0;
var g_syscolor_button_bg = 0;
var g_syscolor_button_txt = 0;
// boolean to avoid callbacks
var g_avoid_on_playlists_changed = false;
var g_avoid_on_playlist_switch = false;
var g_avoid_on_item_focus_change = false;
var g_avoid_on_playlist_items_added = false;
var g_avoid_on_playlist_items_removed = false;
var g_avoid_on_playlist_items_removed_callbacks_on_sendItemToPlaylist = false;
var g_avoid_on_playlist_items_reordered = false;
// mouse actions
var g_lbtn_click = false;
var g_rbtn_click = false;
//
var g_total_duration_text = "";
var g_first_populate_done = false;
var g_first_populate_launched = false;
//
var repaintforced = false;
var launch_time = fb.CreateProfiler("launch_time");
var form_text = "";
var repaint_cover = true, repaint_cover1 = true, repaint_cover2 = true;
var repaint_main = true, repaint_main1 = true, repaint_main2 = true;
var window_visible = false;
var scroll_ = 0, scroll = 0, scroll_prev = 0;
var time222;
var g_start_ = 0, g_end_ = 0;
var g_last = 0;
var g_wallpaperImg = null;

var g_rating_updated = false;
var g_rating_rowId = -1;
var g_image_cache = false;
function setActivePlaylist(){
	var g_active_playlist_new=-1
	if(properties.lockOnPlaylistNamed!="") {
		g_active_playlist_new = check_playlist(properties.lockOnPlaylistNamed);
		if(g_active_playlist_new==-1) {
			window.SetProperty("lock on specific playlist name", "");
			properties.lockOnPlaylistNamed="";
			g_active_playlist_new = plman.ActivePlaylist;
		}
	}
	else if(fb.IsPlaying && properties.lockOnNowPlaying) g_active_playlist_new = plman.PlayingPlaylist;
	else if(properties.lockOnNowPlaying) g_active_playlist_new = -1
    else g_active_playlist_new = plman.ActivePlaylist;
	
	if(g_active_playlist!=g_active_playlist_new) changed = true;
	else changed = false;
	g_active_playlist = g_active_playlist_new;
	return changed;
}
function on_init() {
    window.DlgCode = 0x0004;
    
    get_font();
    get_colors();
    get_metrics();
	
	g_image_cache = new image_cache;

	setActivePlaylist()
    g_focus_id = getFocusId(g_active_playlist);

    brw = new oBrowser("brw");
    pman = new oPlaylistManager("pman");
    
	//g_first_populate_launched = true;
	//brw.launch_populate();	
	
    g_filterbox = new oFilterBox();
    g_filterbox.inputbox.visible = true;
    if(fb.IsPlaying) playing_track_playcount = fb.TitleFormat("%play_count%").EvalWithMetadb(fb.GetNowPlaying());		
};
on_init();

// START
function on_size() {
    window.DlgCode = 0x0004;
    
    ww = window.Width;
    wh = window.Height;
    
    if(!ww || !wh) {
        ww = 1;
        wh = 1;
    };
    
    window.MinWidth = 1;
    window.MinHeight = 1;
    
    // set wallpaper
	if(properties.showwallpaper || properties.darklayout){
		if(fb.IsPlaying) {
			g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying());
		}; else {
			//g_wallpaperImg = null;
			g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying());
		};
	}
    get_images();

    // set Size of browser
    if(cScrollBar.enabled)  {
        //brw.setSize(0, (properties.showHeaderBar ? properties.headerBarHeight : 0), ww - cScrollBar.width, wh - (properties.showHeaderBar ? properties.headerBarHeight : 0));
		brw.setSize(0, (properties.showHeaderBar ? properties.headerBarHeight : 0), ww, wh - (properties.showHeaderBar ? properties.headerBarHeight : 0));
    }; else {
        brw.setSize(0, (properties.showHeaderBar ? properties.headerBarHeight : 0), ww, wh - (properties.showHeaderBar ? properties.headerBarHeight : 0));
    };	
	
	/*if(!timers.resize) {
		timers.resize = window.SetTimeout(function() {
			window.ClearTimeout(timers.resize);		
			timers.resize=false;
			window.Repaint()					
		}, 150);	
	}*/
};
function set_update_function(string){
	if( Update_Required_function.indexOf("brw.populate(true")!=-1) return;
	else if(Update_Required_function.indexOf("brw.populate(false")!=-1) {
		if(string.indexOf("brw.populate(true")==-1) Update_Required_function=string;
	}
	else Update_Required_function=string;
}

function on_paint(gr) {
	if(Update_Required_function!="" && window.isVisible) {
		eval(Update_Required_function);
		Update_Required_function = "";
	}        
	if(update_wallpaper && properties.showwallpaper && properties.wallpapermode == 0){
		g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying());
	}		
    if(!ww) return;
    
    if(!g_1x1) {
        // draw background under playlist
        if(fb.IsPlaying && g_wallpaperImg && (properties.showwallpaper || properties.darklayout)) {
            gr.GdiDrawBitmap(g_wallpaperImg, 0, 0, ww, wh, 0, 0, g_wallpaperImg.Width, g_wallpaperImg.Height);
            gr.FillSolidRect(0, 0, ww, wh, (properties.wallpaperblurred)?wallpaper_overlay_blurred:wallpaper_overlay);
        }; else {
            //gr.FillSolidRect(0, 0, ww, wh, g_color_normal_bg);
            if(g_wallpaperImg && (properties.showwallpaper || properties.darklayout)) {
                gr.GdiDrawBitmap(g_wallpaperImg, 0, 0, ww, wh, 0, 0, g_wallpaperImg.Width, g_wallpaperImg.Height);
                gr.FillSolidRect(0, 0, ww, wh, (properties.wallpaperblurred)?wallpaper_overlay_blurred:wallpaper_overlay);
            }; else {
                gr.FillSolidRect(0, 0, ww, wh, g_color_normal_bg);
            };
        };
        
        brw && brw.draw(gr);        
		
        if(properties.DropInplaylist && pman.offset > 0) {
            pman.draw(gr);
        };
        
        if(properties.showHeaderBar) {
            // inputBox
            if(properties.showFilterBox && g_filterbox) {
                if(g_filterbox.inputbox.visible) {
                    g_filterbox.draw(gr, 12, Math.round(properties.headerBarHeight/2-cFilterBox.h/2)-2);
                };
            };
        };
    };
};

function on_mouse_lbtn_down(x, y) {
    g_lbtn_click = true;
    g_rbtn_click = false;
    
    // stop inertia
    if(cTouch.timer) {
        window.ClearInterval(cTouch.timer);
        cTouch.timer = false;
        // stop scrolling but not abrupt, add a little offset for the stop
        if(Math.abs(scroll - scroll_) > properties.rowHeight) {
            scroll = (scroll > scroll_ ? scroll_ + properties.rowHeight : scroll_ - properties.rowHeight);
            scroll = check_scroll(scroll);
        };
    };
    //TAGTAG
	
    var is_scroll_enabled = brw.rowsCount > brw.totalRowsVis;
    if(properties.enableTouchControl && is_scroll_enabled) {
        if(brw._isHover(x, y) && !brw.scrollbar._isHover(x, y)) {
            if(!timers.mouseDown) {
                cTouch.y_prev = y;
                cTouch.y_start = y;
                if(cTouch.t1) {
                    cTouch.t1.Reset();
                }; else {
                    cTouch.t1 = fb.CreateProfiler("t1");
                };
                timers.mouseDown = window.SetTimeout(function() {
                    window.ClearTimeout(timers.mouseDown);
                    timers.mouseDown = false;
                    if(Math.abs(cTouch.y_start - m_y) > 015) {
                        cTouch.down = true;
                    }; else {
                        brw.on_mouse("down", x, y);
                    };
                },50);
            };
        }; else {		
			// scrollbar
			if(cScrollBar.enabled && cScrollBar.visible) {
				brw.scrollbar && brw.scrollbar.on_mouse("down", x, y);
			};			
            else brw.on_mouse("down", x, y);
        };
    }; else {
		// scrollbar
		if(brw.scrollbar._isHover(x, y) && cScrollBar.enabled && cScrollBar.visible) {
			brw.scrollbar && brw.scrollbar.on_mouse("down", x, y);
		};			
		else brw.on_mouse("down", x, y);
    };
    
    // inputBox
    if(properties.showHeaderBar && properties.showFilterBox && g_filterbox.inputbox.visible) {
        g_filterbox.on_mouse("lbtn_down", x, y);
    };
};

function on_mouse_lbtn_up(x, y) {

    // inputBox
    if(properties.showHeaderBar && properties.showFilterBox && g_filterbox.inputbox.visible) {
        g_filterbox.on_mouse("lbtn_up", x, y);
    };

	if(brw.drag_tracks){
        if(g_dragndrop_bottom) {	
            plman.MovePlaylistSelection(g_active_playlist, plman.PlaylistItemCount(g_active_playlist));
        } else if(g_dragndrop_rowId>-1 && brw.rows[g_dragndrop_rowId].type!=99){
			
			var selected_items = plman.GetPlaylistSelectedItems(g_active_playlist);
			var	nb_selected_items = selected_items.Count;
			if(nb_selected_items > 0)	{	
				var save_focus_handle = selected_items.Item(0);
				var drop_handle = brw.rows[g_dragndrop_rowId].metadb;
				g_avoid_on_item_focus_change = true;
				g_avoid_on_playlist_items_reordered = true;
				drop_on_selected_row = (plman.IsPlaylistItemSelected(g_active_playlist, brw.rows[g_dragndrop_rowId].playlistTrackId));
				//if(drop_on_selected_row){
					//plman.SetPlaylistSelectionSingle(g_active_playlist, brw.rows[g_dragndrop_rowId].playlistTrackId, false);
				//}
				if(nb_selected_items > 1 && !drop_on_selected_row)	{
					// 1st: move selected item at the full end of the playlist to make then contigus
					
					plman.MovePlaylistSelection(g_active_playlist, plman.PlaylistItemCount(g_active_playlist));
					// 2nd: move bottom selection to new drop_id place (to redefine first...)
					plman.SetPlaylistFocusItemByHandle(g_active_playlist, drop_handle);
					var drop_id_new = plman.GetPlaylistFocusItemIndex(g_active_playlist);
				
					var delta = (plman.PlaylistItemCount(g_active_playlist)-nb_selected_items-drop_id_new) * -1;
					if(delta>0) delta=delta-1;							
					plman.MovePlaylistSelection(g_active_playlist, delta);
					if(drop_on_selected_row){
						plman.SetPlaylistSelectionSingle(g_active_playlist, plman.GetPlaylistFocusItemIndex(g_active_playlist), true);
					}					
					plman.SetPlaylistFocusItemByHandle(g_active_playlist, save_focus_handle);	

				}
				else if(g_dragndrop_rowId>-1 && brw.rows[g_dragndrop_rowId].type!=99 && !drop_on_selected_row){
					g_dragndrop_list_total = brw.list.Count;
					var delta = (brw.dragSource_track.playlistTrackId - g_dragndrop_trackId) * -1;
					if(delta>0) delta=delta-1
					plman.MovePlaylistSelection(g_active_playlist, delta);
				}
				g_avoid_on_playlist_items_reordered = false;
				g_avoid_on_item_focus_change = false;				
			}
        }		
		on_drag_leave();
		brw.drag_tracks = false;
		window.SetCursor(IDC_ARROW);
		brw.repaint();
	}	
	else if(properties.DropInplaylist && pman.state == 1) {
		pman.on_mouse("up", x, y);
	}; else {
		brw.on_mouse("up", x, y);
	};

    if(timers.mouseDown) {
        window.ClearTimeout(timers.mouseDown);
        timers.mouseDown = false;
        if(Math.abs(cTouch.y_start - m_y) <= 030) {
            brw.on_mouse("down", x, y);
        };
    };
	
    // create scroll inertia on mouse lbtn up
    if(cTouch.down) {
        cTouch.down = false;
        cTouch.y_end = y;
        cTouch.scroll_delta = scroll - scroll_;
        //cTouch.y_delta = cTouch.y_start - cTouch.y_end;
        if(Math.abs(cTouch.scroll_delta) > 030 ) {
            cTouch.multiplier = ((1000 - cTouch.t1.Time) / 20);
            cTouch.delta = Math.round((cTouch.scroll_delta) / 030);
            if(cTouch.multiplier < 1) cTouch.multiplier = 1;
            if(cTouch.timer) window.ClearInterval(cTouch.timer);
            cTouch.timer = window.SetInterval(function() {
                scroll += cTouch.delta * cTouch.multiplier;
                scroll = check_scroll(scroll);
                cTouch.multiplier = cTouch.multiplier - 1;
                cTouch.delta = cTouch.delta - (cTouch.delta / 10);
                if(cTouch.multiplier < 1) {
                    window.ClearInterval(cTouch.timer);
                    cTouch.timer = false;
                };
            }, 75);
        };
    };
    	
    g_lbtn_click = false;
};

function on_mouse_lbtn_dblclk(x, y, mask) {
    if(y >= brw.y) {    
        brw.on_mouse("dblclk", x, y);
    }; else if(x > brw.x && x < brw.x + brw.w) {
        brw.showNowPlaying();
    }; else {
        brw.on_mouse("dblclk", x, y);
    };
	
};

function on_mouse_rbtn_down(x, y, mask) {
    g_rbtn_click = true;
	if(brw.drag_tracks){
		brw.drag_clicked = false;		
		on_drag_leave();
		brw.drag_tracks = false;
		window.SetCursor(IDC_ARROW);
		brw.repaint();
	}	    
    if(!utils.IsKeyPressed(VK_SHIFT)) {
        // inputBox
        if(properties.showHeaderBar && properties.showFilterBox && g_filterbox.inputbox.visible) {
            g_filterbox.on_mouse("rbtn_down", x, y);
        };
        
        if(pman.state == 1 && properties.DropInplaylist) {
            pman.on_mouse("right", x, y);
        };
        
        brw.on_mouse("right", x, y);
    };
};
function on_mouse_mbtn_down(x, y, mask) {
	if(brw.drag_tracks){
		brw.drag_clicked = false;
		on_drag_leave();
		brw.drag_tracks = false;
		window.SetCursor(IDC_ARROW);
		brw.repaint();
	}		
}
function on_mouse_rbtn_up(x, y){
    g_rbtn_click = false;
    
    if(!utils.IsKeyPressed(VK_SHIFT)) {
        return;
    };	
};

function on_mouse_move(x, y) {
    
    if(m_x == x && m_y == y) return;
    
    // inputBox
    if(properties.showHeaderBar && properties.showFilterBox && g_filterbox.inputbox.visible && !brw.drag_tracks) {
        g_filterbox.on_mouse("move", x, y);
    };
    
	
    if(properties.DropInplaylist && pman.state == 1) {
        pman.on_mouse("move", x, y);
	} else if(brw.drag_tracks){
		on_drag_over(null, x, y, null);
		//brw.on_mouse("drag_over", x, y);
    }; else {
        if(cTouch.down) {
            cTouch.y_current = y;
            cTouch.y_move = (cTouch.y_current - cTouch.y_prev);
            if(x < brw.w) {
                    scroll -= cTouch.y_move;
                    cTouch.scroll_delta = scroll - scroll_;
                    if(Math.abs(cTouch.scroll_delta) < 030) cTouch.y_start = cTouch.y_current;
                    cTouch.y_prev = cTouch.y_current;
            };
        }; else {
            brw.on_mouse("move", x, y);
        };
    };
	
    m_x = x;
    m_y = y;
};

function on_mouse_wheel(step){

    if(cTouch.timer) {
        window.ClearInterval(cTouch.timer);
        cTouch.timer = false;
    };
    
    if(utils.IsKeyPressed(VK_SHIFT) && properties.showgroupheaders) { // zoom cover size only
        var zoomStep = 1;
        var previous = properties.groupHeaderRowsNumber;
        if(!timers.mouseWheel) {
            if(step > 0) {
                properties.groupHeaderRowsNumber += zoomStep;
                if(properties.groupHeaderRowsNumber > 5) properties.groupHeaderRowsNumber = 5;
            }; else {
                properties.groupHeaderRowsNumber -= zoomStep;
                if(properties.groupHeaderRowsNumber < 2) properties.groupHeaderRowsNumber = 2;
            };
            if(previous != properties.groupHeaderRowsNumber) {
                timers.mouseWheel = window.SetTimeout(function() {
                    window.SetProperty("_PROPERTY: Number of Rows for Group Header", properties.groupHeaderRowsNumber);
                    get_font();
                    get_metrics();
                    get_images();
                    
                    // refresh covers
                    //g_image_cache = new image_cache;
                    CollectGarbage();
                    var total = brw.groups.length;
                    for(var i = 0; i < total; i++) {
                        brw.groups[i].tid = -1;
                        brw.groups[i].load_requested = 0;
                        brw.groups[i].save_requested = false;
                        brw.groups[i].cover_img = null;
                        brw.groups[i].cover_type = null;
                    };
                    
                    brw.repaint();
                    timers.mouseWheel && window.ClearTimeout(timers.mouseWheel);
                    timers.mouseWheel = false;
                }, 100);
            };
        };
    }; else if(utils.IsKeyPressed(VK_CONTROL)) {
        var zoomStep = 1;
        var previous = properties.extra_font_size;
        if(!timers.mouseWheel) {
            if(step > 0) {
                properties.extra_font_size += zoomStep;
                if(properties.extra_font_size > 10) properties.extra_font_size = 10;
            }; else {
                properties.extra_font_size -= zoomStep;
                if(properties.extra_font_size < 0) properties.extra_font_size = 0;
            };
            if(previous != properties.extra_font_size) {
                timers.mouseWheel = window.SetTimeout(function() {
                    window.SetProperty("_SYSTEM: Extra font size value", properties.extra_font_size);
                    get_font();
                    get_metrics();
                    get_images();
                    
                    // refresh covers
                    //g_image_cache = new image_cache;
                    CollectGarbage();
                    var total = brw.groups.length;
                    for(var i = 0; i < total; i++) {
                        brw.groups[i].tid = -1;
                        brw.groups[i].load_requested = 0;
                        brw.groups[i].save_requested = false;
                        brw.groups[i].cover_img = null;
                        brw.groups[i].cover_type = null;
                    };
                    
                    brw.repaint();
                    timers.mouseWheel && window.ClearTimeout(timers.mouseWheel);
                    timers.mouseWheel = false;
                }, 100);
            };
        };
    }; else {
        if(properties.DropInplaylist && pman.state == 1) {
            if(pman.scr_w > 0) pman.on_mouse("wheel", m_x, m_y, step);
        }; else if(cScrollBar.visible) {
            var rowStep = properties.rowScrollStep;
            scroll -= step * properties.rowHeight * rowStep;
            scroll = check_scroll(scroll);
            brw.on_mouse("wheel", m_x, m_y, step);
        };
    };
    
};

function on_mouse_leave() {
    // inputBox
    if(properties.showHeaderBar && properties.showFilterBox && g_filterbox.inputbox.visible) {
        g_filterbox.on_mouse("leave", 0, 0);
    };
    brw.on_mouse("leave", 0, 0);
    
    if(properties.DropInplaylist && pman.state == 1) {
        pman.on_mouse("leave", 0, 0);
    };
};

//=================================================// Metrics & Fonts & Colors & Images
function get_metrics() {
	if(properties.doubleRowText) properties.groupHeaderRowsNumber = properties.groupHeaderRowsNumberDouble;
	else properties.groupHeaderRowsNumber = properties.groupHeaderRowsNumberSimple;
    if(!properties.showgroupheaders) properties.extraRowsNumber=0;
	else properties.extraRowsNumber = window.GetProperty("_PROPERTY: Number of Extra Rows per Group", 0);
	
	
    cPlaylistManager.width = Math.floor(cPlaylistManager.default_width * g_zoom_percent / 100);
    cPlaylistManager.topbarHeight = Math.floor(cPlaylistManager.default_topbarHeight * g_zoom_percent / 100);
    cPlaylistManager.botbarHeight = Math.floor(cPlaylistManager.default_botbarHeight * g_zoom_percent / 100);
    cPlaylistManager.rowHeight = Math.floor(cPlaylistManager.default_rowHeight * g_zoom_percent / 100);
    cPlaylistManager.scrollbarWidth = Math.floor(cPlaylistManager.default_scrollbarWidth * g_zoom_percent / 100);
    
    if(properties.showHeaderBar) {
        properties.headerBarHeight = Math.round(properties.defaultHeaderBarHeight * g_zoom_percent / 100);
        properties.headerBarHeight = Math.floor(properties.headerBarHeight / 2) != properties.headerBarHeight / 2 ? properties.headerBarHeight : properties.headerBarHeight - 1;
    }; else {
        properties.headerBarHeight = 0;
    };
    if(properties.doubleRowText) {
        var _defaultRowHeight = properties.defaultRowHeight + properties.doubleRowPixelAdds;
    }; else {
        var _defaultRowHeight = properties.defaultRowHeight;
    };
    properties.rowHeight = Math.round(_defaultRowHeight * g_zoom_percent / 100);
    cScrollBar.width = Math.floor(cScrollBar.defaultWidth * g_zoom_percent / 100);
    cScrollBar.minCursorHeight = Math.round(cScrollBar.defaultMinCursorHeight * g_zoom_percent / 100);
    //
    cover.margin = Math.floor(cover.default_margin * g_zoom_percent / 100);
    cover.w = properties.groupHeaderRowsNumber * properties.rowHeight;
	cover.max_w = properties.groupHeaderRowsNumber * properties.rowHeight;
    cover.h = properties.groupHeaderRowsNumber * properties.rowHeight;
	cover.max_h = properties.groupHeaderRowsNumber * properties.rowHeight;
    //
    
    CollectGarbage();
    
    cFilterBox.w = Math.floor(cFilterBox.default_w * g_zoom_percent / 100);
    cFilterBox.h = Math.round(cFilterBox.default_h * g_zoom_percent / 100);
    
	if(properties.doubleRowText)
		properties.addedRows_end = Math.round(properties.addedRows_end_default/2)-((properties.showgroupheaders)?properties.extraRowsNumber:0);
	else 
		properties.addedRows_end = properties.addedRows_end_default-((properties.showgroupheaders)?properties.extraRowsNumber:0);
	if(properties.addedRows_end<0) properties.addedRows_end = 0;
	
    if(brw) {
        if(cScrollBar.enabled)  {
            //brw.setSize(0, (properties.showHeaderBar ? properties.headerBarHeight : 0), ww - cScrollBar.width, wh - (properties.showHeaderBar ? properties.headerBarHeight : 0));
			brw.setSize(0, (properties.showHeaderBar ? properties.headerBarHeight : 0), ww, wh - (properties.showHeaderBar ? properties.headerBarHeight : 0));
        }; else {
            brw.setSize(0, (properties.showHeaderBar ? properties.headerBarHeight : 0), ww, wh - (properties.showHeaderBar ? properties.headerBarHeight : 0));
        };
        brw.setList();
        //
        g_focus_row = brw.getOffsetFocusItem(g_focus_id);
        // if focused track not totally visible, we scroll to show it centered in the panel
        if(g_focus_row < scroll/properties.rowHeight || g_focus_row > scroll/properties.rowHeight + brw.totalRowsVis - 1) {
            scroll = (g_focus_row - Math.floor(brw.totalRowsVis / 2)) * properties.rowHeight;
            scroll = check_scroll(scroll);
            scroll_ = scroll;
        };
        if(brw.rowsCount > 0) brw.gettags(true);
    };
};

function get_images() {
    var gb;
    var txt = "";
    
    //cover.glass_reflect = draw_glass_reflect(200, 200);
    	
	if(properties.AlbumArtProgressbar || properties.darklayout || (properties.doubleRowText && properties.doubleRowShowCover && !properties.showgroupheaders)){
		images.now_playing_1 = gdi.Image(theme_img_path + "\\graphic_browser\\now_playing_progress1.png");
		images.now_playing_0 = gdi.Image(theme_img_path + "\\graphic_browser\\now_playing_progress0.png");			
	} else {
		images.now_playing_1 = gdi.Image(theme_img_path + "\\graphic_browser\\now_playing_track1.png");
		images.now_playing_0 = gdi.Image(theme_img_path + "\\graphic_browser\\now_playing_track0.png");		
	}
	images.now_playing_black = gdi.Image(theme_img_path + "\\graphic_browser\\now_playing_track0.png");
	if(properties.darklayout) {
		images.playing_playlist = gdi.Image(theme_img_path + "\\graphic_browser\\now_playing_progress1.png");
	} else {
		images.playing_playlist = gdi.Image(theme_img_path + "\\graphic_browser\\now_playing_track1.png");
	}
		
	g_filterbox.getImages();
    // PLAY icon  
    images.play_on = gdi.CreateImage(70, 70);
    gb = images.play_on.GetGraphics();
    DrawPolyStar(gb, 12-2, 12, 46, 1, 3, 2, g_color_normal_bg, g_color_normal_txt, 90, 255);
    images.play_on.ReleaseGraphics(gb);

    images.play_off = gdi.CreateImage(70, 70);
    gb = images.play_off.GetGraphics();
    DrawPolyStar(gb, 16-2, 16, 38, 1, 3, 2, g_color_normal_bg, g_color_normal_txt, 90, 255);
    images.play_off.ReleaseGraphics(gb);
    
    var img_loading = gdi.Image(images.path+"load.png");
    var iw = properties.groupHeaderRowsNumber * properties.rowHeight;
    images.loading_draw = img_loading.Resize(iw, iw, 7);

    /*var nw = 60, nh= 60;
    txt = "NO\nCOVER";
	images.noart = gdi.CreateImage(nw, nh);
    gb = images.noart.GetGraphics();
    // draw no cover art image
    gb.FillSolidRect(0, 0, nw, nh, g_color_normal_txt & 0x10ffffff);
    //gb.setTextRenderingHint(4);
    gb.DrawString("?", gdi.Font(g_fname, Math.round(nh/12*7), 0), blendColors(g_color_normal_txt, g_color_normal_bg, 0.30), 1, 1, nw, nh, cc_stringformat);
    images.noart.ReleaseGraphics(gb);*/
    images.noart = cover.nocover_img;
	
	
    var sw = 250, sh= 250;
    txt = "STREAM";
	images.stream = cover.stream_img;
	/*images.stream = gdi.CreateImage(sw, sh);
    gb = images.stream.GetGraphics();
    // draw stream art image
    gb.FillSolidRect(0, 0, sw, sh, g_color_normal_txt & 0x10ffffff);
    gb.setTextRenderingHint(4);
    gb.DrawString(txt, gdi.Font(g_fname, Math.round(sh/12*2), 1), blendColors(g_color_normal_txt, g_color_normal_bg, 0.30), 1, 1, sw, sh, cc_stringformat);
    images.stream.ReleaseGraphics(gb);*/
};

function get_font() {
    var font_error = false;
    var default_font = null;
    
	if (g_instancetype == 0) {
		default_font = window.GetFontCUI(FontTypeCUI.items);
		g_font_headers = window.GetFontCUI(FontTypeCUI.labels);
	}; else if (g_instancetype == 1) {
		default_font = window.GetFontDUI(FontTypeDUI.playlists);
		g_font_headers = window.GetFontDUI(FontTypeDUI.tabs);
	};
    
    // tweaks to fix a problem with WSH Panel Mod on Font object Name property
    try {
        g_fname = "Segoe UI";
        g_fname_light = "Segoe UI Semilight";		
        g_fsize = default_font.Size;
        g_fstyle = default_font.Style;
        g_fstyle_light = 2;		
    }; catch(e) {
        fb.trace("WSH Panel Error: Unable to use the default font. Using Arial font instead.");
        g_fname = "arial";
        g_fname_light = "arial";			
        g_fsize = 12;
        g_fstyle = 0;
        g_fstyle_light = 2;			
        font_error = true;
    };
    
    // adjust font size if extra zoom activated
    g_fsize += properties.extra_font_size;
    g_font = gdi.Font(g_fname, g_fsize, g_fstyle);
	if(properties.darklayout) 
		g_font_light = gdi.Font(g_fname_light, g_fsize, g_fstyle_light);
	else {
		g_font_light = g_font;
		g_fname_light = g_fname
        g_fstyle_light = 0;			
    }
    g_zoom_percent = Math.floor(g_fsize / 12 * 100);

    g_font_group1 = gdi.Font(g_fname, (g_fsize * 160 / 100), 1);
    g_font_group2 = gdi.Font(g_fname, (g_fsize * 140 / 100), 0);
    
    //g_font_guifx_found = false;
    //g_font_wingdings2_found = false;
    
    if(g_font_guifx_found) {
        g_font_rating = gdi.Font("guifx v2 transports", Math.round(g_fsize * 130 / 100), 0);
        g_font_mood = gdi.Font("guifx v2 transports", Math.round(g_fsize * 130 / 100), 0);
    }; else if(g_font_wingdings2_found) {
        g_font_rating = gdi.Font("wingdings 2", Math.round(g_fsize * 130 / 100), 0);
        g_font_mood = gdi.Font("wingdings 2", Math.round(g_fsize * 200 / 100), 0);
    }; else {
        g_font_rating = gdi.Font("arial", Math.round(g_fsize * 140 / 100), 0);
        g_font_mood = gdi.Font("arial", Math.round(g_fsize * 120 / 100), 0);
    };
};

function get_colors() {
	if(properties.darklayout){
		wallpaper_overlay = GetGrey(0,220);
		wallpaper_overlay_blurred = GetGrey(0,200);	
		if(!properties.showwallpaper) {
			if(properties.wallpaperblurred) wallpaper_overlay_blurred = GetGrey(0,120);
			properties.wallpapermode_temp = 99;
			scrollbar_cursor_color=GetGrey(255,230);		
		} else {
			properties.wallpapermode_temp = properties.wallpapermode;		
			scrollbar_cursor_color=GetGrey(255,230);	
		}
		
		g_color_normal_txt = GetGrey(255);
		g_color_faded_txt = GetGrey(245);
		g_color_tracknumber_txt = GetGrey(245);	
		g_color_selected_bg = RGBA(015,177,255,160);
		g_color_alternate_row = GetGrey(0,20);
		g_color_flash_bg = GetGrey(0,215);		
		g_color_flash_rectline = GetGrey(255,105);	
		
		cover_rectline_color = GetGrey(255,40);
		cover_rectline_color_AlbumArtProgressbar = GetGrey(255,90);
		
		playing_cover_overlay = GetGrey(0,180);			
		
		grad_line_maincolor = GetGrey(255,45);
		grad_line_color_bg = GetGrey(0,0);
		grad_line_maincolor_selected = GetGrey(255,35);
		grad_line_color_bg_selected = GetGrey(0,0);
		
		grad_bottom_color1 = GetGrey(0,150);
		grad_bottom_color2 = GetGrey(0,0);	
		fading_bottom_height = 39;
		
		dragdrop_marker_line = GetGrey(255);
		
		keyboard_search_bg = GetGrey(0,205);
		keyboard_search_txt = GetGrey(255,245);
		keyboard_search_txtred = RGB(255,80,80);		

		reseticon_down = RGB(255,50,50);		
		
		headerbar_bgcolor = GetGrey(0,200);
		headerbar_line_maincolor = GetGrey(255,50);
		headerbar_line_bgcolor = GetGrey(255,50);		
		headerBar_gradient_m=0;
		
		progressbar_maincolor = GetGrey(255,45);
		progressbar_color_bg_off = GetGrey(0,0);
		progressbar_color_bg_on = GetGrey(255,20);		
		progressbar_color_shadow = GetGrey(0,15)		
		albumartprogressbar_color_txt = GetGrey(255);	
		albumartprogressbar_color_overlay = GetGrey(0,80);	
		albumartprogressbar_color_rectline = GetGrey(255,40);	
		
		pm_color_overlay = GetGrey(0,200);		
		pm_color_bg = GetGrey(0);
		pm_color_shadow_on = GetGrey(0,35);	
		pm_color_shadow_off = GetGrey(0,0);			
		pm_color_border = GetGrey(255,55);		
		pm_color_txt = GetGrey(255);
		pm_color_bg2 = GetGrey(0,120);	
		pm_color_bg3 = GetGrey(0,150);
		pm_color_bg4 = GetGrey(255,40);
		pm_item_separator_line = GetGrey(255,45);		
		pm_color_item_bg1 = GetGrey(0,130);		
		pm_color_item_bg2 = GetGrey(255,20);
		pm_color_blink = GetGrey(255,15);	
		pm_color_blink_rectline = GetGrey(70);	
		pm_color_scrollbar = GetGrey(240);			
	} else {
		properties.wallpapermode_temp = properties.wallpapermode;			
		g_color_normal_txt = GetGrey(0,255);		
		g_color_tracknumber_txt = GetGrey(130);
		g_color_alternate_row = GetGrey(0,4);
		g_color_selected_bg = RGBA(015,177,255,100);
		
		cover_rectline_color = GetGrey(0,30);	
		cover_rectline_color_AlbumArtProgressbar = GetGrey(255,90);
		
		playing_cover_overlay = GetGrey(0,150);	
		
		wallpaper_overlay = GetGrey(255,235);
		wallpaper_overlay_blurred = GetGrey(255,235);			
		
		g_color_flash_bg = GetGrey(0,10);		
		g_color_flash_rectline = GetGrey(0,41);		

		scrollbar_cursor_color=GetGrey(0,225);

		keyboard_search_bg = GetGrey(0,205);
		keyboard_search_txt = GetGrey(255,205);
		keyboard_search_txtred = RGB(255,80,80);			
		
		reseticon_down = RGB(255,50,50);
		
		if(properties.showwallpaper) {
			headerbar_bgcolor = GetGrey(255,240);		
			headerbar_line_maincolor = GetGrey(215);			
			headerbar_line_bgcolor = GetGrey(215);	
			headerBar_gradient_m=0;
			g_color_faded_txt = GetGrey(90);
		} else {
			headerbar_bgcolor = GetGrey(255,240);		
			headerbar_line_maincolor = GetGrey(215);			
			headerbar_line_bgcolor = GetGrey(255);	
			headerBar_gradient_m=gradient_m;
			g_color_faded_txt = GetGrey(125);
		}
		
		grad_line_maincolor = GetGrey(0,36);
		grad_line_color_bg = GetGrey(255,0);	
		grad_line_maincolor_selected = GetGrey(0,16);
		grad_line_color_bg_selected = GetGrey(255,0);
		
		grad_bottom_color1 = GetGrey(0,10);
		grad_bottom_color2 = GetGrey(0,0);
		fading_bottom_height = 39;		
		
		dragdrop_marker_line = GetGrey(0);
		
		progressbar_maincolor = GetGrey(0,70);	
		progressbar_color_bg_off = GetGrey(255,0);
		progressbar_color_bg_on = GetGrey(255,60);		
		progressbar_color_shadow = GetGrey(0,5);
		albumartprogressbar_color_txt = GetGrey(255);	
		albumartprogressbar_color_overlay = GetGrey(0,80);	
		albumartprogressbar_color_rectline = GetGrey(0,40);	
		
		pm_color_overlay = GetGrey(255,200);			
		pm_color_bg = GetGrey(255);
		pm_color_shadow_on = GetGrey(0,5);	
		pm_color_shadow_off = GetGrey(0,0);		
		pm_color_border = GetGrey(0,40);
		pm_color_txt = GetGrey(0);
		pm_color_bg2 = GetGrey(0,120);	
		pm_color_bg3 = GetGrey(0,150);
		pm_color_bg4 = GetGrey(255,40);		
		pm_item_separator_line = GetGrey(0,20);
		pm_color_item_bg1 = GetGrey(0,130);		
		pm_color_item_bg2 = GetGrey(255,20);
		pm_color_blink = GetGrey(0,10);	
		pm_color_blink_rectline = GetGrey(211);	
		pm_color_scrollbar = GetGrey(30);			
	}
};

function on_font_changed() {
    get_font();
    get_metrics();
    brw.repaint();
};

function on_colors_changed() {
    get_colors();
    get_images();
	get_font();
    if(brw) brw.scrollbar.setNewColors();
    g_filterbox.getImages();
    g_filterbox.reset_colors();
    brw.repaint();
};

function on_script_unload() {
    brw.g_time && window.ClearInterval(brw.g_time);
    brw.g_time = false;
    brw.g_timeCover && window.ClearInterval(brw.g_timeCover);
    brw.g_timeCover = false;
};

//=================================================// Keyboard Callbacks
function on_key_up(vkey) {
    if(cSettings.visible) {

    }; else {
        // inputBox
        if(properties.showHeaderBar && properties.showFilterBox && g_filterbox.inputbox.visible) {
            g_filterbox.on_key("up", vkey);
        };
        
        // scroll keys up and down RESET (step and timers)
        brw.keypressed = false;
        cScrollBar.timerCounter = -1;
        cScrollBar.timerID && window.ClearTimeout(cScrollBar.timerID);
        cScrollBar.timerID = false;
        if(vkey == VK_SHIFT) {
            brw.SHIFT_start_id = null;
            brw.SHIFT_count = 0;
        };
    };
    brw.repaint();
};

function vk_up() {
    var scrollstep = 1;
    var new_focus_id = 0, new_row = 0;
    
    new_row = g_focus_row - scrollstep;
    if(new_row < 0) {
        if(brw.groups[0].collapsed) {
            new_row = 0;
        }; else {
            if(properties.showgroupheaders) {
                new_row = 0 + properties.groupHeaderRowsNumber;
            }; else {
                new_row = 0;
            };
        };
        // kill timer
        cScrollBar.timerCounter = -1;
        cScrollBar.timerID && window.ClearTimeout(cScrollBar.timerID);
        cScrollBar.timerID = false;
    }; else {
        switch(brw.rows[new_row].type) {
            case 0: // track row
                // RAS
                break;
            case 99: // blank line (extra line)
                while(brw.rows[new_row].type == 99) {
                    if(new_row > 0) new_row -= 1;
                };
                break;
            default: // group row
                if(brw.groups[brw.rows[new_row].albumId].collapsed) {
                    new_row -= (properties.groupHeaderRowsNumber - 1);
                }; else {
                    new_row -= properties.groupHeaderRowsNumber;
                };
        };
    };
    if(new_row >= 0) {
        while(brw.rows[new_row].type == 99) {
            if(new_row > 0) new_row -= 1;
        };
        new_focus_id = brw.rows[new_row].playlistTrackId;
        plman.ClearPlaylistSelection(g_active_playlist);
        plman.SetPlaylistSelectionSingle(g_active_playlist, new_focus_id, true);
        plman.SetPlaylistFocusItem(g_active_playlist, new_focus_id);
    }; else {
        // kill timer
        cScrollBar.timerCounter = -1;
        cScrollBar.timerID && window.ClearTimeout(cScrollBar.timerID);
        cScrollBar.timerID = false;
    };
};

function vk_down() {
    var scrollstep = 1;
    var new_focus_id = 0, new_row = 0;
    
    new_row = g_focus_row + scrollstep;
    if(new_row > brw.rowsCount - 1) {
        new_row = brw.rowsCount - 1;
        if(brw.groups[brw.rows[new_row].albumId].collapsed) {
            new_row -= (properties.groupHeaderRowsNumber - 1);
        };
        // kill timer
        cScrollBar.timerCounter = -1;
        cScrollBar.timerID && window.ClearTimeout(cScrollBar.timerID);
        cScrollBar.timerID = false;
    }; else {
        switch(brw.rows[new_row].type) {
            case 0: // track row
                // RAS
                break;
            case 99: // blank line (extra line)
                while(brw.rows[new_row].type == 99) {
                    if(new_row < brw.rowsCount - 1) new_row += 1;
                };
                break;
            default: // group row
                if(brw.groups[brw.rows[new_row].albumId].collapsed) {
                    if(brw.rows[new_row].type > 1) { // if not 1st row of the group header
                        new_row += (properties.groupHeaderRowsNumber - brw.rows[new_row].type + 1);
                        if(new_row > brw.rowsCount - 1) {
                            new_row = brw.rowsCount - 1;
                            if(brw.groups[brw.rows[new_row].albumId].collapsed) {
                                new_row -= (properties.groupHeaderRowsNumber - 1);
                            };
                        }; else {
                            if(!brw.groups[brw.rows[new_row].albumId].collapsed) {
                                new_row += properties.groupHeaderRowsNumber;
                            };
                        };
                    }; else {
                        // RAS
                    };
                }; else {
                    if(brw.rows[new_row].type > 1) { // if not 1st row of the group header
                        // RAS, can't happend
                    }; else {
                        new_row += properties.groupHeaderRowsNumber;
                    };
                };
        };
    };
    if(new_row < brw.rowsCount) {
        while(brw.rows[new_row].type == 99) {
            if(new_row < brw.rowsCount - 1) new_row += 1;
        };
        new_focus_id = brw.rows[new_row].playlistTrackId;
        plman.ClearPlaylistSelection(g_active_playlist);
        plman.SetPlaylistSelectionSingle(g_active_playlist, new_focus_id, true);
        plman.SetPlaylistFocusItem(g_active_playlist, new_focus_id);
    }; else {
        // kill timer
        cScrollBar.timerCounter = -1;
        cScrollBar.timerID && window.ClearTimeout(cScrollBar.timerID);
        cScrollBar.timerID = false;
    };
};

function vk_pgup() {
    var scrollstep = brw.totalRowsVis;
    var new_focus_id = 0, new_row = 0;
    
    new_row = g_focus_row - scrollstep;
    if(new_row < 0) {
        if(brw.groups[0].collapsed || !properties.showgroupheaders) {
            new_row = 0;
        }; else {
            new_row = 0 + properties.groupHeaderRowsNumber;
        };
        // kill timer
        cScrollBar.timerCounter = -1;
        cScrollBar.timerID && window.ClearTimeout(cScrollBar.timerID);
        cScrollBar.timerID = false;
    }; else {
        switch(brw.rows[new_row].type) {
            case 0: // track row
                // RAS
                break;
            case 99: // blank line (extra line)
                while(brw.rows[new_row].type == 99) {
                    if(new_row > 0) new_row -= 1;
                };
                break;
            default: // group row
                if(brw.groups[brw.rows[new_row].albumId].collapsed) {
                    if(brw.rows[new_row].type > 1) { // if not 1st row of the group header
                        new_row -= (brw.rows[new_row].type - 1);
                    }; else {
                        // RAS
                    };
                }; else {
                    new_row += (properties.groupHeaderRowsNumber - brw.rows[new_row].type + 1);
                };
        };
    };
    if(new_row >= 0) {
        while(brw.rows[new_row].type == 99) {
            if(new_row > 0) new_row -= 1;
        };
        new_focus_id = brw.rows[new_row].playlistTrackId;
        plman.ClearPlaylistSelection(g_active_playlist);
        plman.SetPlaylistSelectionSingle(g_active_playlist, new_focus_id, true);
        plman.SetPlaylistFocusItem(g_active_playlist, new_focus_id);
    }; else {
        // kill timer
        cScrollBar.timerCounter = -1;
        cScrollBar.timerID && window.ClearTimeout(cScrollBar.timerID);
        cScrollBar.timerID = false;
    };
};

function vk_pgdn() {
    var scrollstep = brw.totalRowsVis;
    var new_focus_id = 0, new_row = 0;
    
    new_row = g_focus_row + scrollstep;
    if(new_row > brw.rowsCount - 1) {
        new_row = brw.rowsCount - 1;
		while(brw.rows[new_row].type == 99 && new_row>0) {
			new_row -= 1;
		};		
        //if(brw.groups[brw.rows[new_row].albumId].collapsed) {
          //  new_row -= (properties.groupHeaderRowsNumber - 1);
        //};
    }; else {
        switch(brw.rows[new_row].type) {
            case 0: // track row
                // RAS
                break;
            case 99: // blank line (extra line)
                while(brw.rows[new_row].type == 99) {
                    if(new_row < brw.rowsCount - 1) new_row += 1;
                };
                break;
            default: // group row
                if(brw.groups[brw.rows[new_row].albumId].collapsed) {
                    if(brw.rows[new_row].type > 1) { // if not 1st row of the group header
                        new_row -= (brw.rows[new_row].type - 1);
                    }; else {
                        // RAS
                    };
                }; else {
                    new_row += (properties.groupHeaderRowsNumber - brw.rows[new_row].type + 1);
                };
        };
    };
    if(new_row < brw.rowsCount) {
        while(brw.rows[new_row].type == 99) {
            if(new_row < brw.rowsCount - 1) new_row += 1;
        };
        new_focus_id = brw.rows[new_row].playlistTrackId;
        plman.ClearPlaylistSelection(g_active_playlist);
        plman.SetPlaylistSelectionSingle(g_active_playlist, new_focus_id, true);
        plman.SetPlaylistFocusItem(g_active_playlist, new_focus_id);
    }; else {
        // kill timer
        cScrollBar.timerCounter = -1;
        cScrollBar.timerID && window.ClearTimeout(cScrollBar.timerID);
        cScrollBar.timerID = false;
    };
};

function on_key_down(vkey) {
    var mask = GetKeyboardMask();
    
    if(cSettings.visible) {

    }; else {
        //if(dragndrop.drag_in) return true;

        // inputBox
        if(properties.showHeaderBar && properties.showFilterBox && g_filterbox.inputbox.visible) {
            g_filterbox.on_key("down", vkey);
        };

        var act_pls = g_active_playlist;
        
        if (mask == KMask.none) {
            switch (vkey) {
            case VK_F2:

                break;
            case VK_F3:
                brw.showNowPlaying();
                break;
            case VK_F5:
                // refresh covers
                //g_image_cache = new image_cache;
                CollectGarbage();
                var total = brw.groups.length;
                for(var i = 0; i < total; i++) {
                    brw.groups[i].tid = -1;
                    brw.groups[i].load_requested = 0;
                    brw.groups[i].save_requested = false;
                    brw.groups[i].cover_img = null;
                    brw.groups[i].cover_type = null;
                };
                brw.repaint();
                break;
            case VK_F6:

                break;
            case VK_TAB:
                break;
            case VK_BACK:
                if(cList.search_string.length>0) {
                    cList.inc_search_noresult = false;
                    brw.tt_x = ((brw.w) / 2) - (((cList.search_string.length*13)+(10*2)) / 2);
                    brw.tt_y = brw.y + Math.floor((brw.h / 2) - 30);
                    brw.tt_w = ((cList.search_string.length*13)+(10*2));
                    brw.tt_h = 60;
                    cList.search_string = cList.search_string.substring(0, cList.search_string.length - 1);
                    brw.repaint();
                    cList.clear_incsearch_timer && window.ClearTimeout(cList.clear_incsearch_timer);
                    cList.clear_incsearch_timer = false;
                    cList.incsearch_timer && window.ClearTimeout(cList.incsearch_timer);
                    cList.incsearch_timer = window.SetTimeout(function () {
                        brw.incrementalSearch();
                        window.ClearTimeout(cList.incsearch_timer);
                        cList.incsearch_timer = false;
                        cList.inc_search_noresult = false;
                    }, 400);
                };
                break;
            case VK_ESCAPE:
            case 222:
                brw.tt_x = ((brw.w) / 2) - (((cList.search_string.length*13)+(10*2)) / 2);
                brw.tt_y = brw.y + Math.floor((brw.h / 2) - 30);
                brw.tt_w = ((cList.search_string.length*13)+(10*2));
                brw.tt_h = 60;
                cList.search_string = "";
                window.RepaintRect(0, brw.tt_y - 2, brw.w, brw.tt_h + 4);
                break;
            case VK_UP:               
                if(brw.rowsCount > 0 && !brw.keypressed && !cScrollBar.timerID) {
                    brw.keypressed = true;
                    reset_cover_timers();

                    vk_up();
                    if(!cScrollBar.timerID) {
                        cScrollBar.timerID = window.SetTimeout(function() {
                            window.ClearTimeout(cScrollBar.timerID);
                            cScrollBar.timerID = window.SetInterval(vk_up, 100);
                        }, 400);
                    };
                };
                break;
            case VK_DOWN:
                if(brw.rowsCount > 0 && !brw.keypressed && !cScrollBar.timerID) {
                    brw.keypressed = true;
                    reset_cover_timers();
                    
                    vk_down();
                    if(!cScrollBar.timerID) {
                        cScrollBar.timerID = window.SetTimeout(function() {
                            window.ClearTimeout(cScrollBar.timerID);
                            cScrollBar.timerID = window.SetInterval(vk_down, 100);
                        }, 400);
                    };
                };
                break;
            case VK_PGUP:
                if(brw.rowsCount > 0 && !brw.keypressed && !cScrollBar.timerID) {
                    brw.keypressed = true;
                    reset_cover_timers();
                    
                   vk_pgup();
                    if(!cScrollBar.timerID) {
                        cScrollBar.timerID = window.SetTimeout(function() {
                            window.ClearTimeout(cScrollBar.timerID);
                            cScrollBar.timerID = window.SetInterval(vk_pgup, 100);
                        }, 400);
                    };
                };
                break;
            case VK_PGDN:
                if(brw.rowsCount > 0 && !brw.keypressed && !cScrollBar.timerID) {
                    brw.keypressed = true;
                    reset_cover_timers();
                    
                    vk_pgdn();
                    if(!cScrollBar.timerID) {
                        cScrollBar.timerID = window.SetTimeout(function() {
                            window.ClearTimeout(cScrollBar.timerID);
                            cScrollBar.timerID = window.SetInterval(vk_pgdn, 100);
                        }, 400);
                    };
                };
                break;
            case VK_RETURN:
                // play/enqueue focused item
                //if(!isQueuePlaylistActive()) {
                    var cmd = properties.defaultPlaylistItemAction;
                    if(cmd == "Play") {
                        plman.ExecutePlaylistDefaultAction(act_pls, g_focus_id);
                    }; else {
                        fb.RunContextCommandWithMetadb(cmd, brw.list.Item(g_focus_id), 0);
                    };
                //};
                break;
            case VK_END:
                if(brw.rowsCount > 0) {
					i=brw.rows.length-1;
					while(i>0 && brw.rows[i].type==99) i--;
                    var new_focus_id = brw.rows[i].playlistTrackId;
                    plman.SetPlaylistFocusItem(act_pls, new_focus_id);
                    plman.ClearPlaylistSelection(act_pls);
                    plman.SetPlaylistSelectionSingle(act_pls, new_focus_id, true);
                };
                break;
            case VK_HOME:
                if(brw.rowsCount > 0) {
                    var new_focus_id = brw.rows[0].playlistTrackId;
                    plman.ClearPlaylistSelection(act_pls);
                    plman.SetPlaylistSelectionSingle(act_pls, new_focus_id, true);
                    plman.SetPlaylistFocusItem(act_pls, new_focus_id);
                };
                break;
            case VK_DELETE:
                if(!plman.IsAutoPlaylist(act_pls)) {
                    plman.RemovePlaylistSelection(act_pls, false);
                    plman.RemovePlaylistSelection(act_pls, false);
                    plman.SetPlaylistSelectionSingle(act_pls, plman.GetPlaylistFocusItemIndex(act_pls), true);
                };
                break;
            };
        }; else {
            switch(mask) {
                case KMask.shift:
                    switch(vkey) {
                        case VK_SHIFT: // SHIFT key alone
                            brw.SHIFT_count = 0;
                            break;
                        case VK_UP: // SHIFT + KEY UP
                            if(brw.SHIFT_count==0) {
                                if(brw.SHIFT_start_id==null) {
                                    brw.SHIFT_start_id = g_focus_id;
                                };
                                plman.ClearPlaylistSelection(act_pls);
                                plman.SetPlaylistSelectionSingle(act_pls, g_focus_id, true);
                                if(g_focus_id > 0) {
                                    brw.SHIFT_count--;
                                    g_focus_id--;
                                    plman.SetPlaylistSelectionSingle(act_pls, g_focus_id, true);
                                    plman.SetPlaylistFocusItem(act_pls, g_focus_id);
                                };
                            }; else if(brw.SHIFT_count < 0) {
                                if(g_focus_id > 0) {
                                    brw.SHIFT_count--;
                                    g_focus_id--;
                                    plman.SetPlaylistSelectionSingle(act_pls, g_focus_id, true);
                                    plman.SetPlaylistFocusItem(act_pls, g_focus_id);
                                };
                            }; else {
                                plman.SetPlaylistSelectionSingle(act_pls, g_focus_id, false);
                                brw.SHIFT_count--;
                                g_focus_id--;
                                plman.SetPlaylistFocusItem(act_pls, g_focus_id);
                            };
                            break;
                        case VK_DOWN: // SHIFT + KEY DOWN
                            if(brw.SHIFT_count==0) {
                                if(brw.SHIFT_start_id == null) {
                                    brw.SHIFT_start_id = g_focus_id;
                                };
                                plman.ClearPlaylistSelection(act_pls);
                                plman.SetPlaylistSelectionSingle(act_pls, g_focus_id, true);
                                if(g_focus_id < brw.list.Count - 1) {
                                    brw.SHIFT_count++;
                                    g_focus_id++;
                                    plman.SetPlaylistSelectionSingle(act_pls, g_focus_id, true);
                                    plman.SetPlaylistFocusItem(act_pls, g_focus_id);
                                };
                            }; else if(brw.SHIFT_count>0) {
                                if(g_focus_id < brw.list.Count - 1) {
                                    brw.SHIFT_count++;
                                    g_focus_id++;
                                    plman.SetPlaylistSelectionSingle(act_pls, g_focus_id, true);
                                    plman.SetPlaylistFocusItem(act_pls, g_focus_id);
                                };
                            }; else {
                                plman.SetPlaylistSelectionSingle(act_pls, g_focus_id, false);
                                brw.SHIFT_count++;
                                g_focus_id++;
                                plman.SetPlaylistFocusItem(act_pls, g_focus_id);
                            };
                            break;
                    };
                    break;
                case KMask.ctrl:
                    if(vkey==65) { // CTRL+A
						selected_array=Array();
						for(var i = 0; i <= plman.PlaylistItemCount(g_active_playlist);i++) {
							selected_array.push(i);
						};		
						plman.SetPlaylistSelection(g_active_playlist,selected_array,true)
                        brw.metadblist_selection = plman.GetPlaylistSelectedItems(g_active_playlist);
                        brw.repaint();
                    };
                    if(vkey==66) { // CTRL+B
                        cScrollBar.enabled = !cScrollBar.enabled;
                        window.SetProperty("_DISPLAY: Show Scrollbar", cScrollBar.enabled);
                        get_metrics();
                        brw.repaint();
                    };
                    if(vkey==88) { // CTRL+X
                        if(!plman.IsAutoPlaylist(act_pls)) {
                            clipboard.selection = plman.GetPlaylistSelectedItems(plman.ActivePlaylist);
                            plman.RemovePlaylistSelection(act_pls, false);
                            plman.RemovePlaylistSelection(act_pls, false);
                            plman.SetPlaylistSelectionSingle(act_pls, plman.GetPlaylistFocusItemIndex(act_pls), true);
                        };
                    };
                    if(vkey==67) { // CTRL+C
                        clipboard.selection = plman.GetPlaylistSelectedItems(g_active_playlist);
                    };
                    if(vkey==86) { // CTRL+V
                        // insert the clipboard selection (handles) after the current position in the active playlist
                        if(clipboard.selection) {
                            if(clipboard.selection.Count > 0) {
                                try {
                                    if(brw.list.Count > 0) {
                                        plman.InsertPlaylistItems(g_active_playlist, g_focus_id + 1, clipboard.selection);
                                    }; else {
                                        plman.InsertPlaylistItems(g_active_playlist, 0, clipboard.selection);
                                    };
                                }; catch(e) {
                                    fb.trace("WSH Panel Error: Clipboard can't be pasted, invalid clipboard content.");
                                };
                            };
                        };
                    };
                    if(vkey==70) { // CTRL+F
                        fb.RunMainMenuCommand("Edit/Search");
                    };
                    if(vkey==73) { // CTRL+I

                    };
                    if(vkey==78) { // CTRL+N
                        fb.RunMainMenuCommand("File/New playlist");
                    };
                    if(vkey==79) { // CTRL+O
                        fb.RunMainMenuCommand("File/Open...");
                    };
                    if(vkey==80) { // CTRL+P
                        fb.RunMainMenuCommand("File/Preferences");
                    };
                    if(vkey==83) { // CTRL+S
                        fb.RunMainMenuCommand("File/Save playlist...");
                    };
                    if(vkey==84) { // CTRL+T
                        properties.showHeaderBar = !properties.showHeaderBar;
                        window.SetProperty("_DISPLAY: Show Top Bar", properties.showHeaderBar);
                        get_metrics();
                        brw.scrollbar.updateScrollbar();
                        brw.repaint();
                    };
                    if(vkey == 48 || vkey == 96) { // CTRL+0
                        var previous = properties.extra_font_size;
                        if(!timers.mouseWheel) {
                            properties.extra_font_size = 0;
                            if(previous != properties.extra_font_size) {
                                timers.mouseWheel = window.SetTimeout(function() {
                                    window.SetProperty("_SYSTEM: Extra font size value", properties.extra_font_size);
                                    get_font();
                                    get_metrics();
                                    get_images();
                                    
                                    // refresh covers
                                    //g_image_cache = new image_cache;
                                    CollectGarbage();
                                    var total = brw.groups.length;
                                    for(var i = 0; i < total; i++) {
                                        brw.groups[i].tid = -1;
                                        brw.groups[i].load_requested = 0;
                                        brw.groups[i].save_requested = false;
                                        brw.groups[i].cover_img = null;
                                        brw.groups[i].cover_type = null;
                                    };
                                    
                                    brw.repaint();
                                    timers.mouseWheel && window.ClearTimeout(timers.mouseWheel);
                                    timers.mouseWheel = false;
                                }, 100);
                            };
                        };
                    };
                    break;
                case KMask.alt:
                    switch(vkey) {
                    case 65: // ALT+A
                        fb.RunMainMenuCommand("View/Always on Top");
                        break;
                    case VK_ALT: // ALT key alone
                        break;
                    };
                    break;
            };
         };

    };
};

function on_char(code) {
    // inputBox
    if(properties.showHeaderBar && properties.showFilterBox && g_filterbox.inputbox.visible) {
        g_filterbox.on_char(code);
    };
    
    if(cSettings.visible) {

    }; else {
        if(g_filterbox.inputbox.edit) {
            //g_filterbox.on_char(code);
        }; else { 
            if(brw.list.Count > 0) {
                brw.tt_x = ((brw.w) / 2) - (((cList.search_string.length*13)+(10*2)) / 2);
                brw.tt_y = brw.y + Math.floor((brw.h / 2) - 30);
                brw.tt_w = ((cList.search_string.length*13)+(10*2));
                brw.tt_h = 60;
                if(code==32 && cList.search_string.length==0) return true; // SPACE Char not allowed on 1st char
                if(cList.search_string.length <= 20 && brw.tt_w <= brw.w - 20) {
                    if (code > 31) {
                        cList.search_string = cList.search_string + String.fromCharCode(code).toUpperCase();
                        brw.repaint();
                        cList.clear_incsearch_timer && window.ClearTimeout(cList.clear_incsearch_timer);
                        cList.clear_incsearch_timer = false;
                        cList.incsearch_timer && window.ClearTimeout(cList.incsearch_timer);
                        cList.incsearch_timer = window.SetTimeout(function () {
                            brw.incrementalSearch();
                            window.ClearTimeout(cList.incsearch_timer);
                            cList.incsearch_timer = false;
                        }, 400);
                    };
                };
            };
        }; 
    };
};

//=================================================// Playback Callbacks
function on_playback_stop(reason) {
	if(window.IsVisible) {
		g_elapsed_seconds = null;
		g_time_remaining = null;
		g_total_seconds = null;
		g_metadb = null;
		
		switch(reason) {
		case 0: // user stop
		case 1: // eof (e.g. end of playlist)
			// update wallpaper
			if(properties.showwallpaper && properties.wallpapermode == 0) {
				g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, null);
			};
			brw.repaint();
			break;
		case 2: // starting_another (only called on user action, i.e. click on next button)
			break;
		};
		
		g_radio_title = "loading live tag ...";
		g_radio_artist = "";
	}	    
};

function on_playback_new_track(metadb) {
	playing_track_playcount = fb.TitleFormat("%play_count%").EvalWithMetadb(fb.GetNowPlaying());	
	if(window.IsVisible){	
		g_metadb = metadb;
		g_radio_title = "loading live tag ...";
		g_radio_artist = "";
		if(properties.lockOnNowPlaying && plman.PlayingPlaylist!=g_active_playlist) {
			brw.populate(is_first_populate = true,6);
		}
		if(properties.showwallpaper && properties.wallpapermode == 0) {
			g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, g_metadb);
		};
		if(fb.CursorFollowPlayback && !(g_filterbox.inputbox.edit || g_filterbox.inputbox.length > 0)) {	
			brw.dontFlashNowPlaying=true;
			brw.showNowPlaying();
		}		
		g_total_seconds =  properties.tf_total_seconds.Eval(true); 
		g_time_remaining = properties.tf_time_remaining.Eval(true);
		g_elapsed_seconds = 0;
		brw.repaint();
	} else {
		set_update_function("on_playback_new_track(fb.GetNowPlaying())");
		g_total_seconds = null; 
		g_time_remaining = null;
		g_elapsed_seconds = 0;	
		if(properties.wallpapermode == 0) update_wallpaper = true;
	}
};

function on_playback_time(time) {
	if(window.IsVisible){
		g_elapsed_seconds = time;
		g_time_remaining = properties.tf_time_remaining.Eval(true);
		// radio Tags (live)
		if(g_metadb && g_metadb.Length < 0) {
			g_radio_title = fb.TitleFormat("%title%").Eval(true);
			g_radio_artist = fb.TitleFormat("$if2(%artist%,%bitrate%'K')").Eval(true);
		}; else if(!g_metadb) g_metadb = fb.GetNowPlaying();

		if(!cSettings.visible) {
			if(brw.nowplaying_y + properties.rowHeight > brw.y && brw.nowplaying_y < brw.y + brw.h) {
				brw.repaint();
			};
		};
	}
};
function on_playback_seek(time) {
	if(window.IsVisible){
		g_elapsed_seconds = time;
		g_time_remaining = properties.tf_time_remaining.Eval(true);
		brw.repaint();	
	}
}
//=================================================// Playlist Callbacks
function on_playlists_changed() {		
	if(!g_avoid_on_playlists_changed){	
		if(!(properties.lockOnNowPlaying || properties.lockOnPlaylistNamed!="") && window.IsVisible) {    
			if(plman.ActivePlaylist < 0 || plman.ActivePlaylist > plman.PlaylistCount - 1) {
				plman.ActivePlaylist = 0;
			};
			if(properties.DropInplaylist && pman.drop_done) {
				plman.ActivePlaylist = g_active_playlist;
			}; else {
				if(g_active_playlist != plman.ActivePlaylist) {
					changed = setActivePlaylist();
					if(changed) brw.populate(is_first_populate = true,7);
				};
			};
		} else set_update_function("on_playlists_changed()");	
		// refresh playlists list
		if(properties.DropInplaylist) pman.populate(exclude_active = false, reset_scroll = false);		
	}
};

function on_playlist_switch() {  
    if(!(properties.lockOnNowPlaying || properties.lockOnPlaylistNamed!="") && window.IsVisible) {    
		if(pman.drop_done) return;
		changed = setActivePlaylist();
		g_focus_id = getFocusId(g_active_playlist);
		g_filterbox.clearInputbox();
		if(changed) brw.populate(is_first_populate = true,8);
		brw.metadblist_selection = plman.GetPlaylistSelectedItems(g_active_playlist);
		
		// refresh playlists list
		if(properties.DropInplaylist) pman.populate(exclude_active = false, reset_scroll = false);
		if(properties.DropInplaylist) pman.populate(exclude_active = false);
	} else set_update_function("on_playlist_switch()");	
};
var callback_items_added=false;
var callback_items_removed=false;
var callback_avoid_populate=false
function on_playlist_items_added(playlist_idx) {
	if(!callback_avoid_populate){	
		g_avoid_on_playlist_items_removed_callbacks_on_sendItemToPlaylist = false;
		if(playlist_idx == g_active_playlist && !pman.drop_done) {
			g_focus_id = getFocusId(g_active_playlist);
			callback_avoid_populate=true;
			if(window.IsVisible) brw.populate(is_first_populate = false,9);
			else set_update_function("brw.populate(false,9)");
			timers.callback_avoid_populate = window.SetTimeout(function() {
				callback_avoid_populate=false;	
				window.ClearTimeout(timers.callback_avoid_populate);		 
			}, 30);					
		};
	}
};

function on_playlist_items_removed(playlist_idx, new_count) {
	if(!callback_avoid_populate){			
		if(playlist_idx == g_active_playlist && new_count == 0) scroll = scroll_ = 0;
		if(g_avoid_on_playlist_items_removed_callbacks_on_sendItemToPlaylist) return;
		if(playlist_idx == g_active_playlist) {
			g_focus_id = getFocusId(g_active_playlist);
			callback_avoid_populate=true;
			if(window.IsVisible) brw.populate(true,10);
			else set_update_function("brw.populate(true,10)");				
			timers.callback_avoid_populate = window.SetTimeout(function() {
				callback_avoid_populate=false;	
				window.ClearTimeout(timers.callback_avoid_populate);		 
			}, 30);						
		};
	}	
};

function on_playlist_items_reordered(playlist_idx) {  
	if(!callback_avoid_populate){	
		if(playlist_idx == g_active_playlist) {
			g_focus_id = getFocusId(g_active_playlist);
			callback_avoid_populate=true;
			if(window.IsVisible) brw.populate(true,11);
			else set_update_function("brw.populate(true,11)");	
			timers.callback_avoid_populate = window.SetTimeout(function() {
				callback_avoid_populate=false;	
				window.ClearTimeout(timers.callback_avoid_populate);		 
			}, 30);					
		};
	}
};


function on_item_focus_change(playlist, from, to) {
	if(window.IsVisible){
    if(!brw.list || !brw || !brw.list) return;
    
    var save_focus_id = g_focus_id;
    g_focus_id = to;
    
    if(!g_avoid_on_item_focus_change) {
        
        plman.SetActivePlaylistContext();
    
        if(playlist == g_active_playlist) {
            //
            plman.SetActivePlaylistContext();
            
            // Autocollapse handle
            if(properties.autocollapse) { // && !center_focus_item
                if(from > -1 && from < brw.list.Count) {
                    var old_focused_group_id = brw.getAlbumIdfromTrackId(from);
                }; else {
                    var old_focused_group_id = -1;
                };
                if(to > -1 && to < brw.list.Count) {
                    var new_focused_group_id = brw.getAlbumIdfromTrackId(to);
                }; else {
                    var old_focused_group_id = -1;
                };
                if(new_focused_group_id != old_focused_group_id) {
                    if(old_focused_group_id > -1) {
                        brw.groups[old_focused_group_id].collapsed = true;
                    };
                    if(new_focused_group_id > -1 && (!properties.expandBySingleClick)) {
                        brw.groups[new_focused_group_id].collapsed = false;
                    };
                    brw.setList();
                    brw.scrollbar.updateScrollbar();
                    if(brw.rowsCount > 0) brw.gettags(true);
                };
            }; 
            
            if(!g_rbtn_click) { // if new focused track not totally visible, we scroll to show it centered in the panel
                g_focus_row = brw.getOffsetFocusItem(g_focus_id);
                if(g_focus_row < scroll/properties.rowHeight || g_focus_row > scroll/properties.rowHeight + brw.totalRowsVis - 0.1) {
                    var old = scroll;
                    scroll = (g_focus_row - Math.floor(brw.totalRowsVis / 2)) * properties.rowHeight;
                    scroll = check_scroll(scroll);
                    if(!properties.enableFullScrollEffectOnFocusChange) {
                        if(Math.abs(scroll - scroll_) > properties.rowHeight * 5) {
                            if(scroll_ > scroll) {
                                scroll_ = scroll + properties.rowHeight * 5;
                            }; else {
                                scroll_ = scroll - properties.rowHeight * 5;
                            };
                        };
                    };
                    /*
                    if(!properties.enableFullScrollEffectOnFocusChange && !properties.autocollapse) {
                        scroll_ = scroll + properties.rowHeight * 5 * (from <= to ? -1 : 1);
                        scroll_ = check_scroll(scroll_);
                    };
                    */
                    brw.scrollbar.updateScrollbar();
                };
            };

            brw.metadblist_selection = plman.GetPlaylistSelectedItems(g_active_playlist);
            if(!isScrolling) brw.repaint();
        };
    };
	}
};

function on_metadb_changed(metadbs, fromhook) {
    if(!brw.list) return;
	playing_track_new_count = parseInt(playing_track_playcount,10)+1
	try {
		if(fb.IsPlaying && metadbs.Count==1 && metadbs.Item(0).RawPath==fb.GetNowPlaying().RawPath && fb.TitleFormat("%play_count%").EvalWithMetadb(metadbs.Item(0))==(playing_track_new_count)) {	
			return;
		} 
	} catch(e){
		fb.trace("ERROR:on_metadb_changed, WSHsmoothplaylist try/catch");
	}
    if(window.IsVisible){	
		// rebuild list
		if(g_rating_updated) { // no repopulate if tag update is from rating click action in playlist
			g_rating_updated = false;
			// update track tags info to avoid a full populate
			if(g_rating_rowId > -1) {
				brw.rows[g_rating_rowId].tracktags = properties.tf_track.EvalWithMetadb(brw.rows[g_rating_rowId].metadb);
				g_rating_rowId = -1;
			};
			window.Repaint();
		}; else {
			if(!(metadbs.Count == 1 && metadbs.Item(0).Length < 0)) {
				if(filter_text.length > 0) {
					g_focus_id = 0;
					brw.populate(is_first_populate = true,13);
					if(brw.rowsCount > 0) {
						var new_focus_id = brw.rows[0].playlistTrackId;
						plman.ClearPlaylistSelection(g_active_playlist);
						plman.SetPlaylistSelectionSingle(g_active_playlist, new_focus_id, true);
						plman.SetPlaylistFocusItem(g_active_playlist, new_focus_id);
					};
				}; else {
					brw.populate(is_first_populate = false,14);
				};
			};
		};
	} else set_update_function("brw.populate(false,14);");
};

function on_item_selection_change() {
    if(window.IsVisible) brw.repaint();
};

function on_playlist_items_selection_change() {
    if(window.IsVisible) brw.repaint();
};

function on_focus(is_focused) {   
    g_focus = is_focused;
    if(!is_focused && g_filterbox.inputbox.edit) {
		g_filterbox.inputbox.on_focus(is_focused)
        brw.repaint();
    };
};

//=================================================// Custom functions
function match(input, str){
    var temp = "";
    input = input.toLowerCase();
    for(var j in str){
        if(input.indexOf(str[j]) < 0)
            return false;
    };
    return true;
};


function process_string(str){
    str_ = [];
    str = str.toLowerCase();
    while(str !=(temp = str.replace("  "," ")))
        str  = temp;
    var str = str.split(" ").sort();
    for(var i in str){
        if(str[i] != "")
            str_[str_.length] = str[i];
    };
    return str_;
};

function checkMediaLibrayPlaylist() {
    g_avoid_on_playlists_changed = true;
    
    // check if library playlist is present
    var isMediaLibraryFound = false;
    var total = plman.PlaylistCount;
    for (var i = 0; i < total; i++) {
        if(plman.GetPlaylistName(i) == "Media Library") {
            var mediaLibraryIndex = i;
            isMediaLibraryFound = true;
            break;
        };
    };
    if(!isMediaLibraryFound) {
        // create Media Library playlist (sort forced)
        // > sort: sort string expression.
        // > flags: 1 - always sort.
        // > boolean CreateAutoPlaylist(idx, name, query, sort = "", flags = 0);
        plman.CreateAutoPlaylist(total, "Media Library", "%path% PRESENT", "%album artist% | $if(%album%,%date%,'9999') | %album% | %discnumber% | %tracknumber% | %title%", 1);
        //plman.CreateAutoPlaylist(total, "Media Library", "%album% PRESENT", "%album artist% | %date% | %album% | %discnumber% | %tracknumber% | %title%", 1);
        // Move it to the top
        plman.MovePlaylist(total, 0);
    }; else if(mediaLibraryIndex > 0) {
        // Always move it to the top
        plman.MovePlaylist(mediaLibraryIndex, 0);
    };
    
    g_avoid_on_playlists_changed = false;
};

function check_scroll(scroll___){
    if(scroll___ < 0)
        scroll___ = 0;
    var g1 = brw.h - (brw.totalRowsVis * properties.rowHeight);
    //var scroll_step = Math.ceil(properties.rowHeight / properties.scroll_divider);
    //var g2 = Math.floor(g1 / scroll_step) * scroll_step;
	
    var end_limit = ((brw.rowsCount+properties.addedRows_end) * properties.rowHeight) - (brw.totalRowsVis * properties.rowHeight) - g1+brw.PaddingTop*2+properties.margin_bottom;
    if(scroll___ != 0 && scroll___ > end_limit) {
        scroll___ = end_limit;
    };
    return scroll___;
};

function getFocusId(playlistIndex) {
    return plman.GetPlaylistFocusItemIndex(playlistIndex);
};

// ===================================================== // Wallpaper
function setWallpaperImg(defaultpath, metadb, progressbar_art, width, height) {
	progressbar_art = typeof progressbar_art !== 'undefined' ? progressbar_art : false;	
	width = typeof width !== 'undefined' ? width : ww;	
	height = typeof height !== 'undefined' ? height : wh;	
	    
    if(metadb && (properties.wallpapermode_temp == 0 || progressbar_art)) {
		cachekey = process_cachekey(globalProperties.tf_crc.EvalWithMetadb(metadb))		
		var tmp_img = g_image_cache._cachelist[cachekey];
        if (typeof tmp_img == "undefined" || tmp_img==null) {
			tracktype = TrackType(metadb.rawpath.substring(0, 4));
			if(tracktype == 3) tmp_img = cover.stream_img			
			else tmp_img = utils.GetAlbumArtV2(metadb, properties.wallpapermode_temp);
		}
    }; else {
        if(defaultpath) {
            tmp_img = gdi.Image(defaultpath);
        }; else {
            tmp_img = null;
        };
    };
    if(!tmp_img) {
        if(defaultpath) {
            tmp_img = gdi.Image(defaultpath);
        }; else {
            tmp_img = null;
        };
    };

    if(!progressbar_art) {
		g_wallpaperImg = null;
		var display = properties.wallpaperdisplay;
	} else {
		var display = 2;
	}
    var img = FormatWallpaper(tmp_img, width, height, 2, display, 0, "", true, progressbar_art);
    return img;
};

function g_sendResponse() {

	if(g_filterbox.inputbox.text.length == 0) {
        filter_text = "";
    }; else {
	    filter_text = g_filterbox.inputbox.text;
    };
       
    // filter in current panel
    g_focus_id = 0;
    brw.populate(true,15);
    if(brw.rowsCount > 0) {
        var new_focus_id = brw.rows[0].playlistTrackId;
        plman.ClearPlaylistSelection(g_active_playlist);
        plman.SetPlaylistSelectionSingle(g_active_playlist, new_focus_id, true);
        plman.SetPlaylistFocusItem(g_active_playlist, new_focus_id);
    };
};
function stopFlashNowPlaying() {
	cNowPlaying.flashEnable = false;
	cNowPlaying.flashescounter = 0;
	cNowPlaying.flash = false;	
}
function on_notify_data(name, info) {
    switch(name) {
        case "JSSmoothBrowser->JSSmoothPlaylist:avoid_on_playlist_items_removed_callbacks_on_sendItemToPlaylist":
            g_avoid_on_playlist_items_removed_callbacks_on_sendItemToPlaylist = true;
            break;
        case "FocusOnNowPlaying":
			if(window.IsVisible) {
				brw.showNowPlaying();
			}
            break;
		case"stopFlashNowPlaying":
			stopFlashNowPlaying();
			brw.repaint();
		break;  
		case"DiskCacheState":
			properties.enableDiskCache = info;
			window.SetProperty("COVER Disk Cache", properties.enableDiskCache);
			brw.repaint();
		break;  	
		case"DiskCacheState":
			properties.enableDiskCache = info;
			window.SetProperty("COVER Disk Cache", properties.enableDiskCache);
			brw.repaint();
		break; 	
		case"RefreshImageCover":
			CollectGarbage();
			var total = brw.groups.length;
			for(var i = 0; i < total; i++) {
				brw.groups[i].tid = -1;
				brw.groups[i].load_requested = 0;
				brw.groups[i].save_requested = false;
				brw.groups[i].cover_img = null;
				brw.groups[i].cover_type = null;
			};
			brw.repaint();
		break; 			
		case"LoadAllCoversState":
			properties.load_covers_at_startup = info;
			window.SetProperty("COVER Load all at startup", properties.load_covers_at_startup);	
		break; 		
		case "avoid_on_playlists_changed":  
			g_avoid_on_playlists_changed=info;
			break;			
		case "rePopulate":  
			brw.populate(true,16);
			break;		
		case"playlists_dark_theme":
			if(main_panel_state==1 && layout_state==0 && properties.ParentName=="Playlists"){
				properties.darklayout = info;
				window.SetProperty("_DISPLAY: Dark layout", properties.darklayout);
				on_colors_changed();				
				if(properties.darklayout) g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.IsPlaying ? fb.GetNowPlaying() : null);
				brw.repaint();
			}		
		case"minimode_dark_theme":			
		case"library_dark_theme":			
			if(window.IsVisible){
				properties.darklayout = info;
				window.SetProperty("_DISPLAY: Dark layout", properties.darklayout);
				on_colors_changed();				
				if(properties.darklayout) g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.IsPlaying ? fb.GetNowPlaying() : null);
				brw.repaint();
			}
		break; 
		case "wallpaperVisibility":
			if(window.IsVisible) toggleWallpaper(info);
		break; 	
		case "wallpaperBlur":
			if(window.IsVisible) toggleBlurWallpaper(info);
		break; 		
		case "wallpaperVisibility2":
			if(window.IsVisible) {
				properties.showwallpaper = info;
				window.SetProperty("_DISPLAY: Show Wallpaper", properties.showwallpaper);
				on_colors_changed();					
				if(properties.showwallpaper || properties.darklayout) {
					g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.IsPlaying ? fb.GetNowPlaying() : null);
					if(properties.darklayout) window.NotifyOthers("minimode_dark_theme", true);
				} else window.NotifyOthers("minimode_dark_theme", false);
				brw.repaint();			
			}
		break; 		
		case "wallpaperBlur2":
			if(window.IsVisible) {	
				properties.wallpaperblurred = info;
				on_colors_changed();		
				window.SetProperty("_DISPLAY: Wallpaper Blurred", properties.wallpaperblurred);
				if(fb.IsPlaying) g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying());
				brw.repaint();			
			}
		break; 		
		case "layout_state":  
			layout_state=info;
			if(layout_state==0 && window.IsVisible) window.NotifyOthers("playlist_height",window.height);			
		break;
		case "main_panel_state":  
			main_panel_state=info;
		break;		
		case "nowplaying_state":  
			nowplaying_state=info;
		break;			
		case "filters_panel_state":   
			filters_panel_state=info;
			if(properties.enableAutoSwitchPlaylistMode){
				if(filters_panel_state==2) properties.lockOnNowPlaying=false;
				else properties.lockOnNowPlaying=true;	
				properties.lockOnPlaylistNamed="";				
				window.SetProperty("lock on specific playlist name", "");
				window.SetProperty("lock on now playing playlist", properties.lockOnNowPlaying);
				brw.populate(true,17);				
			}		
		break;			
		case "lockOnNowPlaying":  
			properties.lockOnNowPlaying=info;
			window.SetProperty("lock on now playing playlist", properties.lockOnNowPlaying);	
			properties.lockOnPlaylistNamed="";
			window.SetProperty("lock on specific playlist name", "");				
			brw.populate(true,17);
		break;	
		case "lockOnSpecificPlaylist":  
			properties.lockOnPlaylistNamed=info;
			window.SetProperty("lock on specific playlist name", properties.lockOnPlaylistNamed);	
			brw.populate(true,17);
		break;			
		case "showgroupheaders":
			properties.showgroupheaders = !properties.showgroupheaders;
			window.SetProperty("_DISPLAY: Show Group Headers", properties.showgroupheaders);
			get_metrics();
			if(properties.autocollapse) {
				properties.autocollapse = false;
				window.SetProperty("_PROPERTY: Autocollapse groups", properties.autocollapse);
			}				
			if(!properties.showgroupheaders) brw.collapseAll(false);
			brw.populate(is_first_populate = false,18);
			brw.repaint();
			break;
		case "doubletrackline":
			properties.doubleRowText = !properties.doubleRowText;
			window.SetProperty("_PROPERTY: Double Row Text Info", properties.doubleRowText);
			get_metrics();
			brw.repaint();
			break;					
		case "autocollapse":
			if(properties.showgroupheaders) {
				properties.autocollapse = !properties.autocollapse;
				window.SetProperty("_PROPERTY: Autocollapse groups", properties.autocollapse);
				brw.populate(false,19);
				brw.showFocusedItem();
			}
			break;									
		case "collapseAll":
			brw.collapseAll(info);
			brw.showFocusedItem();
			break;	
		case "cover_cache_finalized": 
			g_image_cache._cachelist = info;
			window.Repaint();
		break;	
		case "WSH_panels_reload":
			window.Reload();
		break; 			
    };
};

//=================================================// Drag'n'Drop Callbacks
function on_drag_enter() {
    g_dragndrop_status = true;
    g_dragndrop_drop_forbidden = false;
};

function on_drag_leave() {
    g_dragndrop_status = false;
    g_dragndrop_trackId = -1;
    g_dragndrop_rowId = -1;
	g_dragndrop_bottom = false;
    brw.buttonclicked = false;
    cScrollBar.timerID && window.ClearInterval(cScrollBar.timerID);
    cScrollBar.timerID = false;
    if(g_dragndrop_drop_forbidden) {
        g_dragndrop_drop_forbidden = false;
        brw.repaint();
    };
};

function on_drag_over(action, x, y, mask) {
    
    if(x == g_dragndrop_x && y == g_dragndrop_y) return true;

    if(plman.IsAutoPlaylist(g_active_playlist)) {
        g_dragndrop_drop_forbidden = true;
        brw.repaint();
        return true;
    };

    g_dragndrop_trackId = -1;
    g_dragndrop_rowId = -1;
    g_dragndrop_targetPlaylistId = -1;
    g_dragndrop_bottom = false;
    brw.on_mouse("drag_over", x, y);
	
	if(scroll > 0 && y < brw.y + ((properties.doubleRowText)?properties.rowHeight:properties.rowHeight*2)) {
		if(!brw.buttonclicked) {
			brw.buttonclicked = true;
			if(!cScrollBar.timerID1) {
				cScrollBar.timerID1 = window.SetInterval(function () {
					on_mouse_wheel(1);
					if(scroll <= 0) {
						window.ClearInterval(cScrollBar.timerID1);
						cScrollBar.timerID1 = false;
						brw.buttonclicked = false;
						if(!dragndrop.timerID) {
							dragndrop.timerID = window.SetTimeout(function() {
								brw.on_mouse("drag_over", g_dragndrop_x, g_dragndrop_y);
								brw.repaint();
								dragndrop.timerID && window.ClearTimeout(dragndrop.timerID);
								dragndrop.timerID = false;
							}, 75);
						};
					};
				}, properties.drag_scroll_speed_ms);
			};
		};  else {
			brw.repaint();
		}; 
	}; else if(y > brw.y + brw.h - ((properties.doubleRowText)?properties.rowHeight:properties.rowHeight*2)) {
		if(!brw.buttonclicked) {
			brw.buttonclicked = true;
			//
			//
			if(!cScrollBar.timerID) {
				cScrollBar.timerID = window.SetInterval(function () {
					on_mouse_wheel(-1);
					if(scroll >= ((brw.totalRows - brw.totalRowVisible) * properties.rowHeight)) {
						window.ClearInterval(cScrollBar.timerID);
						cScrollBar.timerID = false;
						brw.buttonclicked = false;
						if(!dragndrop.timerID) {
							dragndrop.timerID = window.SetTimeout(function() {
								brw.on_mouse("drag_over", g_dragndrop_x, g_dragndrop_y);
								brw.repaint();
								dragndrop.timerID && window.ClearTimeout(dragndrop.timerID);
								dragndrop.timerID = false;
							}, 75);
						};
					};
				}, properties.drag_scroll_speed_ms);
			};
		}; else {
			brw.repaint();
		};
	}; else {
		cScrollBar.timerID1 && window.ClearInterval(cScrollBar.timerID1);
		cScrollBar.timerID1 = false;			
		cScrollBar.timerID && window.ClearInterval(cScrollBar.timerID);
		cScrollBar.timerID = false;
		brw.buttonclicked = false;
		if(!dragndrop.timerID) {
			dragndrop.timerID = window.SetTimeout(function() {
				brw.repaint();
				dragndrop.timerID && window.ClearTimeout(dragndrop.timerID);
				dragndrop.timerID = false;
			}, 75);
		};
	};
    
    brw.repaint();
    
    g_dragndrop_x = x;
    g_dragndrop_y = y;
};

function on_drag_drop(action, x, y, mask) {
        
    if(plman.IsAutoPlaylist(g_active_playlist)) {
        g_dragndrop_drop_forbidden = false;
        g_dragndrop_hover_playlistManager = false;
        brw.repaint();
        return true;
    };
    
    g_dragndrop_total_before = brw.list.Count;
    brw.buttonclicked = false;
    cScrollBar.timerID && window.ClearInterval(cScrollBar.timerID);
    cScrollBar.timerID = false;
    g_dragndrop_status = false;
    
    // We are going to process the dropped items to a playlist
    var total_pl = plman.PlaylistCount;
    if(total_pl < 1) {
        plman.CreatePlaylist(0, "Dropped Items");
        plman.ActivePlaylist = 0;
        action.ToPlaylist();
        action.Playlist = plman.ActivePlaylist;
        action.ToSelect = true;
    }; else {
        if(g_dragndrop_bottom) {
            plman.ClearPlaylistSelection(g_active_playlist);
            action.ToPlaylist();
			action.Playlist = g_active_playlist;
            action.ToSelect = true;
            g_dragndrop_timer && window.ClearTimeout(g_dragndrop_timer);
            g_dragndrop_timer = window.SetTimeout(function(){
                plman.SetPlaylistFocusItem(g_active_playlist, g_dragndrop_total_before);
                //brw.showFocusedItem();
                //full_repaint();
                g_dragndrop_trackId = -1;
                g_dragndrop_rowId = -1;
                window.ClearTimeout(g_dragndrop_timer);
                g_dragndrop_timer = false;
            },75);
        }; else {
			if(brw.rows[g_dragndrop_rowId].type!=99){
				g_avoid_on_playlist_items_added = true;
				g_avoid_on_playlist_items_reordered = true;
			
				plman.ClearPlaylistSelection(g_active_playlist);
				action.ToPlaylist();
				action.Playlist = g_active_playlist;
				action.ToSelect = true;
		
				g_dragndrop_timer && window.ClearTimeout(g_dragndrop_timer);
				g_dragndrop_timer = window.SetTimeout(function(){
					var delta = (g_dragndrop_total_before - g_dragndrop_trackId) * -1;
					plman.MovePlaylistSelection(g_active_playlist, delta);
					//plman.SetPlaylistFocusItem(g_active_playlist, g_dragndrop_trackId);
					//brw.showFocusedItem();
					g_dragndrop_trackId = -1;
					g_dragndrop_rowId = -1;
					g_avoid_on_playlist_items_added = false;
					g_avoid_on_playlist_items_reordered = false;
					window.ClearTimeout(g_dragndrop_timer);
					g_dragndrop_timer = false;
				},75);
			}
        };
    };
    g_dragndrop_bottom = false;
    g_dragndrop_drop_forbidden = false;
    g_dragndrop_hover_playlistManager = false;
    brw.repaint();
};

function toggleWallpaper(wallpaper_state){
	wallpaper_state = typeof wallpaper_state !== 'undefined' ? wallpaper_state : !properties.showwallpaper;	
	properties.showwallpaper = wallpaper_state;
	window.SetProperty("_DISPLAY: Show Wallpaper", properties.showwallpaper);
	on_colors_changed();					
	if(properties.showwallpaper || properties.darklayout) {
		g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.IsPlaying ? fb.GetNowPlaying() : null);
		if(properties.darklayout) window.NotifyOthers("minimode_dark_theme", true);
	} else window.NotifyOthers("minimode_dark_theme", false);
	brw.repaint();
}
function toggleBlurWallpaper(wallpaper_blur_state){
	wallpaper_blur_state = typeof wallpaper_blur_state !== 'undefined' ? wallpaper_blur_state : !properties.wallpaperblurred;	
	properties.wallpaperblurred = wallpaper_blur_state; on_colors_changed();		
	window.SetProperty("_DISPLAY: Wallpaper Blurred", properties.wallpaperblurred);
	if(fb.IsPlaying) g_wallpaperImg = setWallpaperImg(properties.wallpaperpath, fb.GetNowPlaying());
	brw.repaint();
}