#include <OneWire.h>
#include <EEPROM.h>
#define RES_KEY_FLAG_ 0x15  // Флаг первого запуска скетча
byte bytes[4];
//- входы(пины) ардуино                   -
int WIRE_PIN = 4;       // цифровой вход(пин) 1WIRE-шины ( температурные датчики )
int ENCODER1_PIN = 6 ;  // аналоговый вход(пин) для первого энкодера
int ENCODER2_PIN = 5 ;  // аналоговый вход(пин) для второго энкодера 
int RES_PIN = 7 ;       // аналоговый вход(пин) для резестивных(рулевых) кнопок 
int av_mode = 8;     //Выход для включения камеры 
int back_on = 9;    //Вход сигнал включения задней скорости 
// Переменные для круиз-контроля 0xAA000408
// 1Vol+, 2Vol-, 3Mode, 4Up, 5Down, 6Mute, 7Voice, 8OnOff, 9Res, 10Set, 11Cansel 
int CruiseKeyOnOff = 8;  // Код кнопки ПДУ для включения-выключения круиз-контроля
int CruiseKeySet = 10;  // Код кнопки ПДУ для нажатия кнопки Set круиз-контроля
int CruiseKeyRes = 9;  // Код кнопки ПДУ для нажатия кнопки Res круиз-контроля
int CruiseDelay = 100; //Задержка нажатия кнопок круиза 
int CruisePinOnOff = 11;  // Выход для включения-выключения круиз-контроля
int CruisePinSet = 10;  // Выход для нажатия кнопки Set круиз-контроля
int CruisePinRes = 12;  // Выход для нажатия кнопки Res круиз-контроля
int flag=0; // Флаг включения круиза
int k=0; // переменная отдельного кода нажатий кнопок
//- переменные включения функций скетча   -
boolean is_temperature_sensors = false;
boolean is_encoder_1 = false;
boolean is_encoder_2 = false;
boolean is_res_keys = false;
//- Переменные для температурных датчиков -
OneWire  ds(WIRE_PIN);
byte addr[8];            
byte data[12];
unsigned long temperature_sensors_milles;
unsigned long temperature_sensors_wait_milles = 1000; // Интервал передачи данных от температурных датчиков
int t_status = 0;
//- Переменные для первого энкодера       -
unsigned long encoder1_dt;
unsigned long encoder1_key=0;
unsigned long encoder1_key_old=0;
int encoder1_key1 = 0;
int encoder1_key2 = 0;
int encoder1_key3 = 0;
unsigned long encoder1_millis;
unsigned long encoder1_wait_millis=1;
unsigned long encoder1_key_wait = 500;  // время ожидания до следующего нажатия кнопки энкодера
unsigned long encoder1_key_wait_millis;
unsigned long encoder1_key_millis;
unsigned long encoder1_dt_sum = 0;  
int encoder1_dt_n = 0;
//- Переменные для второго энкодера       -
unsigned long encoder2_dt;
unsigned long encoder2_key=0;
unsigned long encoder2_key_old=0;
int encoder2_key1 = 0;
int encoder2_key2 = 0;
int encoder2_key3 = 0;
unsigned long encoder2_millis;
unsigned long encoder2_wait_millis=1;
unsigned long encoder2_key_wait = 500;  // время ожидания до следующего нажатия кнопки энкодера
unsigned long encoder2_key_wait_millis;
unsigned long encoder2_key_millis;
//- Новые переменные для кнопок
#define RES_BT_CNT 50  // макс кол-во кнопок
#define VOL_BT_CNT 2  // кол-во кнопок с автоповтором
#define RES_DT_MIN 5  // мин значение АЦП
#define  RES_DT_MAX 1020  // макс значение АЦП
unsigned long res_key_wait_long = 600;  // задержка длинного нажатия кнопки (ms)
unsigned int key_to_send = 0;
boolean res_key_hold = false;
//- Переменные для резестивных кнопок     -
unsigned long  res_dt = 0; 
unsigned long  res_dt_sum=0; 
#define RES_DT_COUNT 400 // Количество считываемых данных
#define RES_DT_SKIP_COUNT 100 // Количество данных, которые надо пропустить при нажатии
#define RES_DT_POINT 5 // Точность
int res_dt_n = 0;
unsigned long res_key=0;
unsigned long res_key_old=0;
//unsigned long res_key_wait_first = 500;  // время ожидания после первого нажатия кнопки
unsigned long res_key_wait_next = 200;  // время ожидания до следующего нажатия кнопки
unsigned long res_key_wait_millis = 0;
unsigned long res_key_millis;
//unsigned long res_key_array[51][2];
unsigned long res_key_array[RES_BT_CNT + 1][2];
unsigned int res_key_count = 0;
unsigned int res_key_delta = 5; // дельта для определения кода кнопки
//переменные для камеры
int cam_status = 0; //Первоначально камера выключена
byte temp;
unsigned long time_low_cam = 0;
unsigned long time_high_cam = 0;
//конец
 
void setup() 
{ 
//камера
  pinMode(av_mode, OUTPUT);   
  pinMode(back_on, INPUT); 
  digitalWrite(back_on, HIGH); //Подключить внутренний подтягивающий резистор 
  digitalWrite(av_mode, LOW); 
//круиз
  pinMode(CruisePinOnOff, OUTPUT);
  pinMode(CruisePinSet, OUTPUT);
  pinMode(CruisePinRes, OUTPUT);
  digitalWrite(CruisePinOnOff, LOW);
  digitalWrite(CruisePinSet, HIGH);
  digitalWrite(CruisePinRes, HIGH);
//конец
  Serial.begin(115200); 
    temperature_sensors_milles = millis();
    t_status = 0;
    encoder1_key_millis = millis();
    encoder2_key_millis = millis();
    encoder1_millis = millis();
    encoder2_millis = millis();
    res_key_millis = millis();
    
    encoder1_key_wait_millis=encoder1_key_wait;
    encoder2_key_wait_millis=encoder2_key_wait;
   
    unsigned int first_run_key = EEPROM.read(0);
    if ( first_run_key == RES_KEY_FLAG_ )
    {
      res_key_count = EEPROM.read(1);
      //EEPROM.write(addr, val);
      for(int i=0; i<res_key_count;i++) 
      { 
        //res_key_array[i][0] = (EEPROM.read(i+2) * 256) + EEPROM.read(i+2+50) - res_key_delta; res_key_array[i][1] = res_key_array[i][0] + res_key_delta + res_key_delta; 
          res_key_array[i][0] = (EEPROM.read(i+2) * 256) + EEPROM.read(i+2+RES_BT_CNT) - res_key_delta; res_key_array[i][1] = res_key_array[i][0] + res_key_delta + res_key_delta;   
    }
    
    }
    for(int i=res_key_count; i<(RES_BT_CNT+1);i++) 
    { 
      res_key_array[i][0] = 0xFFFFFFFF; res_key_array[i][1] = 0xFFFFFFFF; 
    }
    
}
 
void loop() 
{  


  if (Serial.available() >= 1) // Проверяем наличие команд от компьютера
  {
     switch (Serial.read())
    {
      
     case 0x02: // включить передачу данных от датчиков температуры
       is_temperature_sensors = true;
     break;
     
case 0x04: // включить передачу данных от первого энкодера
       is_encoder_1 = true;
     break;

     case 0x05: // включить передачу данных от второго экнодера
       is_encoder_2 = true;
     break;

     case 0x06: // включить передачу данных от резестивных кнопок
       is_res_keys = true;
     break;
     

     case 0x82: // выключить передачу данных от датчиков температуры
       is_temperature_sensors = false;
     break;

 case 0x84: // выключить передачу данных от первого энкодера
       is_encoder_1 = false;
     break;

     case 0x85: // выключить передачу данных от второго энкодера
       is_encoder_2 = false;
     break;

     case 0x86: // выключить передачу данных от резестивных кнопок
       is_res_keys = false;
     break;

     case 0xAA: // выключить передачу данных от резестивных кнопок
     {
       while (Serial.available() < 5) {}
       int i = Serial.read();
       bytes[0] = Serial.read();          // преобразовать в 4-байта  
       bytes[1] = Serial.read();  
       bytes[2] = Serial.read(); 
       bytes[3] = Serial.read(); 
       unsigned long key_res_min = 0; key_res_min = bytes[0]; key_res_min = key_res_min * 256 + bytes[1];  
       unsigned long key_res_max = 0; key_res_max = bytes[2]; key_res_max = key_res_max * 256 + bytes[3];  
       res_key_array[i-1][0] = key_res_min; 
       res_key_array[i-1][1] = key_res_max;
     }
     break;

     case 0xAB: // сбросить настройки резестивных кнопок в EEPROM
     {
       EEPROM.write(0,0); // сбросить флаг первого запуска
       res_key_count = 0; // сбросить количество резистивных кнопок 
       EEPROM.write(1,0); //
       for(int i=0; i<51;i++) 
       { 
        res_key_array[i][0] = 0xFFFFFFFF; res_key_array[i][1] = 0xFFFFFFFF; 
       }
     } 
     break;
    }
  } 
  if( is_temperature_sensors ) temperature_sensors();  //  температурные датчики
  if( is_encoder_1 ) encoder_1();                      //  первый энкодер
  if( is_encoder_2 ) encoder_2();                      //  второй энкодер
  if( is_res_keys ) res_keys();  //  резестивные кнопки
//  res_keys();
  cam(); //камера
}

//----------------------------------------------------------------------------------
// Функция работы с резестивными кнопками
//----------------------------------------------------------------------------------
void res_keys()
{  
  {
    res_dt = analogRead(RES_PIN); // прочитать данные АЦП 
    if( res_dt >= RES_DT_MIN && res_dt <= RES_DT_MAX )
    { 
      res_dt_n++;
      if( res_dt_n > RES_DT_SKIP_COUNT )
      {
        res_dt_sum += (res_dt << RES_DT_POINT);
        if( res_dt_n == RES_DT_COUNT)
        { 
         res_key = (((((( res_dt_sum / (( RES_DT_COUNT - RES_DT_SKIP_COUNT ) + (2^(RES_DT_POINT-1)-1) ) >> (RES_DT_POINT-1)) + 1) >> 1) + 1)>> 1)); // + 1) >> 1;
         res_dt_sum = 0; res_dt_n = 0;
        }
       }
    }
    else
    {
      res_dt_sum = 0; res_dt_n = 0; res_key = 0;
      res_key_wait_millis = 0;
    }
  }
//  обработка нажатия
  int key_code = 0;

  if (res_key != 0)  // что-то нажато
  {
    key_code = keyCode(res_key);
    if (key_code <= VOL_BT_CNT)  // первые кнопки с автоповтором
    {
      if (res_key_old == res_key)  // удержание кнопки
      {
        if (millis() - res_key_wait_millis > res_key_wait_next)  // задержка автоповтора
        {
          sendKey(key_code);
          res_key_wait_millis = millis();
        }
      }
      else
      {
        sendKey(key_code);
        res_key_wait_millis = millis();
        res_key_old = res_key;
      }
    }
    else  // кнопки с долгим нажатием
    {
      if (res_key_old == res_key)  // удержание кнопки
      {
        if (millis() - res_key_wait_millis > res_key_wait_long)   // длинное нажатие
        {
          if (!res_key_hold)
          {
            sendKey(key_code+RES_BT_CNT);
            res_key_wait_millis = millis();
            res_key_hold = true;
          }
        }
      }
      else
      {
        key_to_send = key_code;
        res_key_wait_millis = millis();
        res_key_old = res_key;
      }
    }
  }
  else  // ничего не нажато
  {
    res_key_old = 0;
    if (key_to_send != 0 && !res_key_hold) sendKey(key_to_send);
    res_key_hold = false;
    key_to_send = 0;
  }

//delay (50);
}
  
  void sendKey(int key_code)
{
 // Serial.println(key_code);
// перехват кнопок круизом
  
  bytes[0] = 0xAA;          // преобразовать в 4-байта  
  bytes[1] = 0;  
  bytes[2] = RES_PIN; 
  bytes[3] = key_code;
  k=key_code; 
if (key_code==CruiseKeyOnOff || key_code==CruiseKeySet || key_code==CruiseKeyRes)
{
   if(k == CruiseKeyOnOff &&flag==0)//если кнопка нажата и перемення flag равна 0 , то ...
	    {
	     flag=1;
             k=0;
             digitalWrite(CruisePinOnOff, HIGH);
	     }
          if(k == CruiseKeyOnOff &&flag==1)//если кнопка нажата и перемення flag равна 1 , то ...
              {
	       flag=0;
               k=0;
               digitalWrite(CruisePinOnOff, LOW);
               }
	  if(k==CruiseKeySet&&flag==1)
          { 
          digitalWrite(CruisePinSet, LOW);
          delay(CruiseDelay);
          digitalWrite(CruisePinSet, HIGH);
          k=0;
          }
          if(k==CruiseKeySet&&flag==0)
          { 
          Serial.write( bytes,4);
          }
          if(k==CruiseKeyRes&&flag==1)
          { 
          digitalWrite(CruisePinRes, LOW);
          delay(CruiseDelay);
          digitalWrite(CruisePinRes, HIGH);
          k=0;
          }
          if(k==CruiseKeyRes&&flag==0)
          { 
          Serial.write( bytes,4);
          }
}
else {
         //Serial.print(k);
        Serial.write( bytes,4);
        }
}

  

unsigned int keyCode(unsigned long key_res)
{
  int i = 0; boolean exit = false;
  while( res_key_array[i][0] != 0xFFFFFFFF && (!exit) )
  {  // проверяем новая ли кнопка
    if( (res_key_array[i][0] <= key_res) && (key_res <= res_key_array[i][1]) ) exit = true; else i++;
  }
  if ( exit )  // кнопкка уже известная
  {
    return (i+1);
  }
  else {  // кнопка новая
    if ( res_key_count < RES_BT_CNT )
    {
      res_key_array[res_key_count][0] = key_res - res_key_delta;
      res_key_array[res_key_count][1] = key_res + res_key_delta;
      res_key_count++;
            
      EEPROM.write(1, res_key_count); // Запоминаем количество кнопок
      byte one_byte = key_res / 256;
      EEPROM.write(res_key_count+1, one_byte ); // Запоминаем старший байт значения кнопки
      one_byte = key_res - one_byte * 256;
      EEPROM.write(res_key_count+1+RES_BT_CNT, one_byte ); // Запоминаем младший байт значения кнопки
      EEPROM.write(0, RES_KEY_FLAG_);
            
      return res_key_count;
    }
    else
    {  // переполнение - больше кнопок не запоминаем
      bytes[0] = 0xAA;          // преобразовать в 4-байта  
      bytes[1] = 0xAA;  
      bytes[2] = (key_res & 0xFF00) >> 8; 
      bytes[3] = key_res & 0xFF; 
      Serial.write( bytes,4); // отправить прочитаное значение компьютеру
    }
  }
}
  
//----------------------------------------------------------------------------------
// Функция работы с первым энкодером
//----------------------------------------------------------------------------------
void encoder_1()
{
  if( encoder1_key_millis + encoder1_key_wait_millis*2 < millis() ) { encoder1_key_old = 0; }
  if( encoder1_millis + encoder1_wait_millis < millis() )
  {
    encoder1_millis = millis();
    encoder1_dt = analogRead(ENCODER1_PIN); // прочитать данные АЦП
    
    if( encoder1_dt >= 0x246 && encoder1_dt <= 0x286 )
    { // Здесь обрабатываем удержание кнопки
      encoder1_key = ENCODER1_PIN;
      encoder1_key = (encoder1_key << 16) | 0x030000EE;
      if ( encoder1_key == encoder1_key_old )
      { // Здесь обрабатываем удержание кнопки
        if( encoder1_key_millis + encoder1_key_wait_millis < millis() )
        { 
          bytes[0] = encoder1_key & 0xFF;          // преобразовать в 4-байта  
          bytes[1] = (encoder1_key & 0xFF00) >> 8;  
          bytes[2] = (encoder1_key & 0xFF0000) >> 16; 
          bytes[3] = (encoder1_key & 0xFF000000) >> 24;
          Serial.write( bytes,4); // отправить прочитаное значение компьютеру
          encoder1_key_millis = millis(); encoder1_key_wait_millis = encoder1_key_wait; //ir_wait_next;
        }
      }
      else 
      { // Здесь обрабатываем первое нажатие кнопки
        encoder1_key_millis = millis(); encoder1_key_wait_millis = 50; //ir_wait_first;
      } 
      encoder1_key_old = encoder1_key;
    } 
    else
    {
      if( encoder1_dt >= 0x3E0 && encoder1_dt <= 0x410 && encoder1_key3 != 1 )
      {
        if( (encoder1_key2 == 2) && (encoder1_key3 == 3))
        { 
          bytes[0] = 0xEE;          // преобразовать в 2-байта 
          bytes[1] = 0; 
          bytes[2] = ENCODER1_PIN;
          bytes[3] = 1;
          Serial.write( bytes,4); // отправить прочитаное значение компьютеру     
        }
        else
        {
          if( (encoder1_key2 == 3) && (encoder1_key3 == 2) )
          {
            bytes[0] = 0xEE;          // преобразовать в 2-байта 
            bytes[1] = 0; 
            bytes[2] = ENCODER1_PIN;
            bytes[3] = 2;
            Serial.write( bytes,4); // отправить прочитаное значение компьютеру     
          }
        }
        encoder1_key1=encoder1_key2; encoder1_key2=encoder1_key3; encoder1_key3=1;
      }
      else
      {
        if( encoder1_dt >= 0xA0 && encoder1_dt <= 0xF0 && encoder1_key3 != 2 )
        {
          encoder1_key1=encoder1_key2; encoder1_key2=encoder1_key3; encoder1_key3=2;
        }
        else
        {
          if( encoder1_dt >= 0x1A0 && encoder1_dt <= 0x200 && encoder1_key3 != 3 )
          {
            encoder1_key1=encoder1_key2; encoder1_key2=encoder1_key3; encoder1_key3=3;
          }
        }
      }
    }
  }
}

//----------------------------------------------------------------------------------
// Функция работы со вторым энкодером
//----------------------------------------------------------------------------------
void encoder_2()
{  
  if( encoder2_key_millis + encoder2_key_wait_millis*2 < millis() ) { encoder2_key_old = 0; }
  if( encoder2_millis + encoder2_wait_millis < millis() )
  {
    encoder2_millis = millis();
    encoder2_dt = analogRead(ENCODER2_PIN); // прочитать данные АЦП
    if( encoder2_dt >= 0x246 && encoder2_dt <= 0x286 )
    { // Здесь обрабатываем удержание кнопки
      encoder2_key = ENCODER2_PIN;
      encoder2_key = (encoder2_key << 16) | 0x030000EE;
      if ( encoder2_key == encoder2_key_old )
      { // Здесь обрабатываем удержание кнопки
        if( encoder2_key_millis + encoder2_key_wait_millis < millis() )
        { 
          bytes[0] = encoder2_key & 0xFF;          // преобразовать в 4-байта  
          bytes[1] = (encoder2_key & 0xFF00) >> 8;  
          bytes[2] = (encoder2_key & 0xFF0000) >> 16; 
          bytes[3] = (encoder2_key & 0xFF000000) >> 24; 
          Serial.write( bytes,4); // отправить прочитаное значение компьютеру
          encoder2_key_millis = millis(); encoder2_key_wait_millis = encoder2_key_wait; //ir_wait_next;
        }
      }
      else 
      { // Здесь обрабатываем первое нажатие кнопки
        encoder2_key_millis = millis(); encoder2_key_wait_millis = 50; //ir_wait_first;
      } 
      encoder2_key_old = encoder2_key;
    } 
    else
    {
      if( encoder2_dt >= 0x3E0 && encoder2_dt <= 0x410 && encoder2_key3 != 1 )
      {
        if( (encoder2_key2 == 2) && (encoder2_key3 == 3))
        { 
          bytes[0] = 0xEE;          // преобразовать в 2-байта 
          bytes[1] = 0; 
          bytes[2] = ENCODER2_PIN;
          bytes[3] = 1;
          Serial.write( bytes,4); // отправить прочитаное значение компьютеру     
        }
        else
        {
          if( (encoder2_key2 == 3) && (encoder2_key3 == 2) )
          {
            bytes[0] = 0xEE;          // преобразовать в 2-байта 
            bytes[1] = 0; 
            bytes[2] = ENCODER2_PIN;
            bytes[3] = 2;
            Serial.write( bytes,4); // отправить прочитаное значение компьютеру     
          }
        }
        encoder2_key1=encoder2_key2; encoder2_key2=encoder2_key3; encoder2_key3=1;
      }
      else
      {
        if( encoder2_dt >= 0xA0 && encoder2_dt <= 0xF0 && encoder2_key3 != 2 )
        {
          encoder2_key1=encoder2_key2; encoder2_key2=encoder2_key3; encoder2_key3=2;
        }
        else
        {
          if( encoder2_dt >= 0x1A0 && encoder2_dt <= 0x200 && encoder2_key3 != 3 )
          {
            encoder2_key1=encoder2_key2; encoder2_key2=encoder2_key3; encoder2_key3=3;
          }
        }
      }
    }
  }
}


//----------------------------------------------------------------------------------
// Функция определение температуры датчиков DS18B20
//----------------------------------------------------------------------------------
void temperature_sensors()
{
  if(t_status == 0)
  {

    if (!ds.search(addr)) 
    {                       // поиск нового датчика
      ds.reset_search();    // если не нашли, сбрасываем поиск в начало
      return;               // и выходим 
    }
  
    // Часть кода, которая ниже, выполняется только если
    // найден новый датчик, с которым ещё не работали в
    // главном цикле до сброса поиска

    if (OneWire::crc8( addr, 7) != addr[7]) // Проверка CRC 
    { 
      return; // Если не пройдена, то в начало главного цикла и продолжаем поиск других датчиков
    }
  
    if (addr[0] != 0x28) // Проверка того, что найденное устройство - температурный датчик DS18B20 
    {        
      return; // Если не он, то опять в начало главного цикла на продолжение поиска
    }
  
    ds.reset();
    ds.select(addr);
    ds.write(0x44,1);
      
    t_status = 1;
  }
  else
  {
    if( temperature_sensors_milles + temperature_sensors_wait_milles < millis() )
    {
      temperature_sensors_milles = millis();

      byte i;

      ds.reset();
      ds.select(addr);
      ds.write(0xBE);
  
      for ( i = 0; i < 9; i++) // получаем данные с датчика
      {         
        data[i] = ds.read();
      }
      bytes[0] = 0xFF; bytes[1] = 0xFF; bytes[2] = 0xFF; bytes[3] = 0xFF; 
      Serial.write( bytes,4); // отправить 0xFFFFFFFF - код температурного датчика
      Serial.write( addr,8); // отправить 8 байтовый номер температурного датчика 
      bytes[0] = 0;          // отправляем байты содержащие температуру  
      bytes[1] = 0;  
      bytes[2] = data[0]; 
      bytes[3] = data[1]; 
      Serial.write( bytes,4); // значение температурного датчика
      t_status = 0;
    } 
  }
} 
//функции камеры
void cam()
{
  temp=digitalRead(back_on);

  if ( temp==LOW && digitalRead(av_mode)==LOW)
  {
    if ( time_high_cam == 0 )
    {
      time_high_cam = millis();
    }
   else
      {
         if ((millis()-time_high_cam)>1000)
         {
          digitalWrite(av_mode, HIGH);
          time_low_cam = 0;
          time_high_cam = 0;
         }
      } 
      
    
  }  

  if ( temp==HIGH && digitalRead(av_mode)==HIGH)
  {
    
    if ( time_low_cam == 0 )
    {
      time_low_cam = millis();
    }
   else
      {
         if ((millis()-time_low_cam)>100)
         {
          //Serial.println("Low");
          digitalWrite(av_mode, LOW);
          time_low_cam = 0;
          time_high_cam = 0;
         }
      } 
  }  

  if ( temp==LOW && digitalRead(av_mode)==HIGH)
  {
    //Это режи когда камера была включена, переход на D а потом снова R
    //т.е. в этом режиме камера не должна выключатся
          time_low_cam = 0;
          time_high_cam = 0;
  }  

  if ( temp==HIGH && digitalRead(av_mode)==LOW)
  {
    //Это режи когда камера НЕ была включена, переход на D а потом снова R
    //т.е. в этом режиме камера не должна ВКЛЮЧАТСЯ

          time_low_cam = 0;
          time_high_cam = 0;
  }  


  
}  

