//
#include <IRremote.h> 

byte bytes[4];

//-----------------------------------------
//- входы(пины) ардуино                   -
//-----------------------------------------
int RECV_PIN = 13;       // цифровой вход(пин) ИК приемника 

int xpin = 0;             // аналоговый вход(пин) для оси X акселерометра
int ypin = 1;             // аналоговый вход(пин) для оси Y акселерометра
int zpin = 2;             // аналоговый вход(пин) для оси Z акселерометра

// Переменные для круиз-контроля
unsigned long CruiseKey = 0x00FF708F;  // Код кнопки ПДУ для активации круиз-контроля (в обратном порядке, чем показывает iCarDS)
int CruisePin = 4;  // Пин D4 для эмуляции нажатия кнопки активации круиз-контроля

//-----------------------------------------
//- переменные включения функций скетча   -
//-----------------------------------------
boolean is_ir_key = true;
boolean is_accelerometer = true;

//-----------------------------------------
//- Переменные для ИК датчика             -
//-----------------------------------------
IRrecv irrecv(RECV_PIN); 
decode_results results; 
unsigned long ir_dt;
unsigned long ir_dt_old = 0;
unsigned long ir_dt_millis;
unsigned long ir_wait_millis;
unsigned long ir_wait_first = 250;  // время ожидания после первого нажатия кнопки
unsigned long ir_wait_next  = 200;  // время ожидания при удержании

//-----------------------------------------
//- Переменные для акселерометра          -
//-----------------------------------------
int x, y, z;
int xyz[4];
int n = 0;
int x_cal = 373;
int y_cal = 387; //калибровка датчика
int z_cal = 517;
unsigned long accelerometer_milles;
unsigned long accelerometer_wait_milles = 80; // Интервал передачи данных от акселерометра

void setup() 
{ 
  pinMode(CruisePin, OUTPUT);
  digitalWrite(CruisePin, LOW);
  Serial.begin(115200); 
  irrecv.enableIRIn(); // включить приемник 
  xyz[0] = 0;
  xyz[1] = 0; // прочитать значение осей
  xyz[2] = 0;
  ir_wait_millis = ir_wait_first;
  accelerometer_milles = millis();
}

void loop() 
{
  if (Serial.available() >= 1) // Проверяем наличие команд от компьютера
  {
    switch (Serial.read())
    {
    case 0x01: // включить передачу данных от ик-пульта
      is_ir_key = true;
      break;

    case 0x03: // включить передачу данных от акселерометра
      is_accelerometer = true;
      break;

    case 0x81: // выключить передачу данных от ик-пульта
      is_ir_key = false;
      break;

    case 0x83: // выключить передачу данных от акселерометра
      is_accelerometer = false;
      break;
    }
  } 
  if (is_ir_key) ir_key();                            //  ИК приёмник
  if (is_accelerometer) accelerometer();              //  акселерометр
}

//----------------------------------------------------------------------------------
// Функция работы с ИК приёмником
//----------------------------------------------------------------------------------
void ir_key() {
  if (ir_dt_millis + ir_wait_millis*2 < millis()) ir_dt_old = 0;
  if (irrecv.decode(&results)) {
    if (results.value > 0 && results.value < 0xFFFFFFFF) {
      ir_dt = results.value;
      if (ir_dt == ir_dt_old) {
        // Здесь обрабатываем удержание кнопки
        if (ir_dt_millis + ir_wait_millis < millis()) { 
          bytes[0] = ir_dt & 0xFF;          // преобразовать в 4-байта  
          bytes[1] = (ir_dt & 0xFF00) >> 8;  
          bytes[2] = (ir_dt & 0xFF0000) >> 16; 
          bytes[3] = (ir_dt & 0xFF000000) >> 24;
          if (ir_dt != CruiseKey) {
            Serial.write(bytes, 4); // отправить прочитаное значение компьютеру
          }
          ir_dt_millis = millis();
          ir_wait_millis = ir_wait_next;
        }
      } 
      else {
        // Здесь обрабатываем первое нажатие кнопки
        bytes[0] = ir_dt & 0xFF;          // преобразовать в 4-байта  
        bytes[1] = (ir_dt & 0xFF00) >> 8;  
        bytes[2] = (ir_dt & 0xFF0000) >> 16; 
        bytes[3] = (ir_dt & 0xFF000000) >> 24;
        if (ir_dt != CruiseKey) {
          Serial.write(bytes, 4); // отправить прочитаное значение компьютеру
        } 
        else {
          // Подаем импульс 125 мс на круиз-контроль
          digitalWrite(CruisePin, HIGH);
          delay(125);
          digitalWrite(CruisePin, LOW);
        }
        ir_dt_millis = millis();
        ir_wait_millis = ir_wait_first;
      } 
      ir_dt_old = ir_dt;
    } 
    else {
      ir_dt_millis = millis();
      ir_wait_millis = ir_wait_first;
    }
    irrecv.resume();
  }
}
//----------------------------------------------------------------------------------
// Функция работы с акселерометром
//----------------------------------------------------------------------------------
void accelerometer() {
  if (accelerometer_milles + accelerometer_wait_milles < millis()) {
    xyz[0] = analogRead(xpin);
    xyz[1] = analogRead(ypin); // прочитать значение осей
    xyz[2] = analogRead(zpin);
    xyz[3] = 0;

    bytes[0] = 0xEF;
    bytes[1] = 0xFF;
    bytes[2] = 0xFF;
    bytes[3] = 0xFF; 
    Serial.write(bytes, 4); // отправить 0xEFFFFFFF - код данных от акселерометра
    Serial.write((byte*)&xyz, 8); // отправить значения осей 
    accelerometer_milles = millis();
  }
}
