#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fcntl.h>
#include <termios.h>

typedef enum { TYPE_GPGSV, TYPE_GLGSV, TYPE_GNGSA, TYPE_GNGLL, TYPE_GNRMC, TYPE_GPVTG, TYPE_GPGGA, TYPE_GPZDA, TYPE_OTHER } nmea_type;

int checkdata( char *str )
{
int len;
char crc;

	if ( str[0] != '$' )
		return -1;
	len = strlen(str);
	if ( str[len-1] != '\n' )
		return -2;
	str[len-1]='\0';
	len = strlen(str);
	if ( str[len-3] != '*' )
		return -3;
	if ( sscanf( str+len-2, "%02X", &crc ) !=1 )
		return -4;
	len = strlen(str);

	char crcc=0;	
	int i;
	for (i=1;i<(len-3);i++)
		crcc^=str[i];
	if (crcc!=crc)
		return -5;
	return 0;
}

typedef struct GSVdata {
	char msgs[2];
	char msgnmb[2];
	char sats[3];
	int satsinmsg;
	char satid[4][4];
	char elev[4][3];
	char azim[4][4];
	char snr[4][3];
} GSVdata;

typedef struct GSAdata {
	char md1[2];
	char md2[2];
	char satid[12][4];
	char pdop[5];
	char hdop[5];
	char vdop[5];
	int gsatype;
	int activesats;
} GSAdata;

GSAdata mergeGSA( GSAdata gsa1, GSAdata gsa2, GSAdata gsa_dop )
{
GSAdata ret;
int i;
int j;
int k;
int sats[12];

	for (i=0;i<12;i++)
		sats[i]=-1;

	for (i=0;i<12;i++)
		if (gsa1.satid[i][0]!='\0')
		{
			int sat=0;
			sscanf(gsa1.satid[i],"%d",&sat);
			sats[i]=sat;
			memcpy(ret.satid[i],gsa1.satid[i],4);
		}
		else
			break;
			
	for (j=0,k=i;j<12;j++)
		if ((gsa2.satid[j][0]!='\0')&&(k<12))
		{
			int sat=0;
			sscanf(gsa2.satid[j],"%d",&sat);
			if ( (sat!=sats[0])&&(sat!=sats[1])&&(sat!=sats[2])&&(sat!=sats[3])&&(sat!=sats[4])&&(sat!=sats[5])&&(sat!=sats[6])&&(sat!=sats[7])&&(sat!=sats[8])&&(sat!=sats[9])&&(sat!=sats[10])&&(sat!=sats[11]) )
				memcpy(ret.satid[k++],gsa2.satid[j],4);
		}
		else
			break;
		
	for (;k<12;k++)
		ret.satid[k][0]='\0';

	memcpy(ret.md1,gsa_dop.md1,2);
	memcpy(ret.md2,gsa_dop.md2,2);
	memcpy(ret.pdop,gsa_dop.pdop,5);
	memcpy(ret.hdop,gsa_dop.hdop,5);
	memcpy(ret.vdop,gsa_dop.vdop,5);		
	ret.activesats = gsa1.activesats + gsa2.activesats;
	return ret;
}

GSVdata parseGSV( char *str )
{
GSVdata ret;
int len = strlen(str);
int j;
int i;
int k;
int n;

	for (i=7,j=0;i<len;i++)
		if ((str[i] != ',') && (j<1))
			ret.msgs[j++]=str[i];
		else
			break;
	ret.msgs[j]='\0';
	for(i=i+1,j=0;i<len;i++)
		if ((str[i] != ',') && (j<1))
			ret.msgnmb[j++]=str[i];
		else
			break;
	ret.msgnmb[j]='\0';
	for(i=i+1,j=0;i<len;i++)
		if ((str[i] != ',') && (j<2))
			ret.sats[j++]=str[i];
		else
			break;
	ret.sats[j]='\0';
	for(k=i+1,n=0;k<len;k++)
		if (str[k]==',')
			n++;
	if ( n == 15 )
		ret.satsinmsg=4;
	else if ( n == 11 )
		ret.satsinmsg=3;
	else if ( n == 7 )
		ret.satsinmsg=2;
	else if ( n == 3 )
		ret.satsinmsg=1;
	else
		ret.satsinmsg=0;

	for(k=0;k<ret.satsinmsg;k++)
	{
		for(i=i+1,j=0;i<len;i++)
			if ((str[i] != ',') && (j<3))
				ret.satid[k][j++]=str[i];
			else
				break;
		ret.satid[k][j]='\0';
		for(i=i+1,j=0;i<len;i++)
			if ((str[i] != ',') && (j<2))
				ret.elev[k][j++]=str[i];
			else
				break;
		ret.elev[k][j]='\0';
		for(i=i+1,j=0;i<len;i++)
			if ((str[i] != ',') && (j<3))
				ret.azim[k][j++]=str[i];
			else
				break;
		ret.azim[k][j]='\0';
		if (i==len-1)
			ret.snr[k][0]='\0';
		for(i=i+1,j=0;i<len;i++)
			if ((str[i] != ',') && (j<2))
			{
				ret.snr[k][j++]=str[i];
				if ( i == len-1 )
					ret.snr[k][j]='\0';
			}
			else
				break;
		ret.snr[k][j]='\0';
	}
	return ret;
}

GSAdata parseGSA( char *str )
{
GSAdata ret;
int len = strlen(str);
int j;
int i;
int k;

	for (i=7,j=0;i<len;i++)
		if ((str[i] != ',') && (j<1))
			ret.md1[j++]=str[i];
		else
			break;
	ret.md1[j]='\0';
	for(i=i+1,j=0;i<len;i++)
		if ((str[i] != ',') && (j<1))
			ret.md2[j++]=str[i];
		else
			break;
	ret.md2[j]='\0';
	for(k=0;k<12;k++)	
	{
		for(i=i+1,j=0;i<len;i++)
			if ((str[i] != ',') && (j<3))
				ret.satid[k][j++]=str[i];
			else
				break;
		ret.satid[k][j]='\0';
	}
	for(i=i+1,j=0;i<len;i++)
		if ((str[i] != ',') && (j<4))
			ret.pdop[j++]=str[i];
		else
			break;
	ret.pdop[j]='\0';
	for(i=i+1,j=0;i<len;i++)
		if ((str[i] != ',') && (j<4))
			ret.hdop[j++]=str[i];
		else
			break;
	ret.hdop[j]='\0';
	if (i==len-1)
		ret.vdop[0]='\0';
	for(i=i+1,j=0;i<len;i++)
		if ((str[i] != ',') && (j<4))
		{
			ret.vdop[j++]=str[i];
			if (i==len-1)
				ret.vdop[j]='\0';
		}
		else
			break;
	ret.vdop[j]='\0';
	if (ret.satid[0][0]=='\0')
		ret.gsatype=0;
	else
	{
		int sat0id=0;
		sscanf(ret.satid[0],"%d",&sat0id);
		if ((sat0id>=65)&&(sat0id<=96))
			ret.gsatype=2;
		else
			ret.gsatype=1;
	}

	for ( i = 0; i < 12; i++ )
		if (ret.satid[i][0]!='\0')
		{
			int sat=0;
			sscanf(ret.satid[i],"%d",&sat);
			if ( sat > 32 )
				sprintf( ret.satid[i], "%d", (((sat-1)&31)+1) );
		}
		else
			break;
	ret.activesats = i;

	return ret;
}

nmea_type datatype( char *str )
{
	if ( memcmp(str+1,"GPGSV",5) == 0 )				
		return TYPE_GPGSV; //GPGSV
	else if ( memcmp(str+1,"GLGSV",5) == 0 )				
		return TYPE_GLGSV; //GLGSV
	else if ( (memcmp(str+1,"GNGSA",5) == 0)||(memcmp(str+1,"GPGSA",5) == 0) )				
		return TYPE_GNGSA; //GNGSA, GPGSA
	else if ( memcmp(str+1,"GPGGA",5) == 0 )				
		return TYPE_GPGGA; //GPGGA
	else if ( memcmp(str+1,"GPVTG",5) == 0 )				
		return TYPE_GPVTG; //GPVTG
	else if ( (memcmp(str+1,"GNGLL",5) == 0)||(memcmp(str+1,"GPGLL",5) == 0) )				
		return TYPE_GNGLL; //GNGLL, GPGLL
	else if ( (memcmp(str+1,"GNRMC",5) == 0)||(memcmp(str+1,"GPRMC",5) == 0) )				
		return TYPE_GNRMC; //GNRMC, GPRMC
	else if ( memcmp(str+1,"GPZDA",5) == 0 )				
		return TYPE_GPZDA; //GPZDA
	else
		return TYPE_OTHER;
}

void senddata(int fd, char *str)
{
char outbuff[1024];
char crc = 0;
int i;

	int len = strlen(str);		
	for (i =0;i<len;i++)
		crc ^= str[i];
	sprintf(outbuff,"$%s*%02X\n",str,crc);
	write(fd,outbuff,strlen(outbuff));	
}

void PrintUsage( char *name )
{
	printf( "Usage:\n%s <input path> <output path (to be created)> [--gps-only | --glonass-only] [--nonzero-snr-only] [--filter TXT1 [TXT2] [TXT3] ... [TXT10]]\n", name );
	printf( "Options:\n" );
	printf( "    --gps-only                          process only GSV and GSA messages with GPS sats (cannot be used together with --glonass-only)\n" );
	printf( "    --glonass-only                      process only GSV and GSA messages with GLONASS sats (cannot be used together with --gps-only)\n" );
	printf( "    --nonzero-snr-only                  remove sats with zero signal level (SNR) from GSV messages\n" );
	printf( "    --filter TXT1 [TXT2] ... [TXT10]    remove messages with text matching TXT1 ... TXT10 (--filter must be the last option specified)\n" );

	printf( "Examples:\n%s /dev/ttyUSB0 /dev/ttyNMEA\n", name );
	printf( "%s /dev/ttyUSB0 /dev/ttyNMEA --gps-only\n", name );
	printf( "%s /dev/ttyUSB0 /dev/ttyNMEA --glonass-only\n", name );
	printf( "%s /dev/ttyUSB0 /dev/ttyNMEA --nonzero-snr-only\n", name );
	printf( "%s /dev/ttyUSB0 /dev/ttyNMEA --gps-only --nonzero-snr-only\n", name );
	printf( "%s /dev/ttyUSB0 /dev/ttyNMEA --glonass-only --nonzero-snr-only\n", name );
	printf( "%s /dev/ttyUSB0 /dev/ttyNMEA --filter RMC GLL\n", name );
	printf( "%s /dev/ttyUSB0 /dev/ttyNMEA --gps-only --filter RMC GLL\n", name );
	printf( "%s /dev/ttyUSB0 /dev/ttyNMEA --glonass-only --filter RMC GLL\n", name );
	printf( "%s /dev/ttyUSB0 /dev/ttyNMEA --nonzero-snr-only --filter RMC GLL\n", name );
	printf( "%s /dev/ttyUSB0 /dev/ttyNMEA --gps-only --nonzero-snr-only --filter RMC\n", name );
	printf( "%s /dev/ttyUSB0 /dev/ttyNMEA --glonass-only --nonzero-snr-only --filter GLL\n", name );
}

int main(int argc,char **argv)
{
	char inbuff[1024];
	char outbuff[1024];
	int res;
	int fd1;
	struct termios settings1;
	char tty_name1[128];
	int i;
	GSVdata gsv1[8];
	GSVdata gsv2[8];
	int gsv1_sats[8];
	int gsv1_msgs[8];
	int gsv1_msgnmb[8];
	int gsv2_sats[8];
	int gsv2_msgs[8];
	int gsv2_msgnmb[8];
	nmea_type gsv_typ;
	int gsv1_n = 0;
	int gsv2_n = 0;
	int gsv1_done = 0;
	int gsv2_done = 0;
	int gsv1_started = 0;
	int gsv2_started = 0;
	nmea_type gsv_last1 = TYPE_OTHER;
	nmea_type gsv_last2 = TYPE_OTHER;
	nmea_type gsv_last3 = TYPE_OTHER;
	nmea_type gsv_last4 = TYPE_OTHER;
	char* satid[24];
	char* elev[24];
	char* azim[24];
	char* snr[24];
	char sat[24][14];
	GSAdata prevGSA;
	int prevGSAtype=0;
	GSAdata newgsa;
	int fltrnmb=-1;
	char* fltr[10];
	int Mode=0;
	int nonzero_snr_only = 0;
	int activesats=-1;

	printf("\n%s by SanchSanch\n", argv[0]);

if (argc < 3) {
	PrintUsage(argv[0]);
	return 0;
}
if ( (strlen(argv[1]) < 6) || (strlen(argv[2]) < 6) ) {
	printf("Error: <input path>, <output path> should begin with \"/dev/\"\n");
	PrintUsage(argv[0]);
	return 0;
}
if ( (memcmp(argv[1], "/dev/",5) != 0) || (memcmp(argv[2], "/dev/",5) != 0) ) {
	printf("Error: <input path>, <output path> should begin with \"/dev/\"\n");
	PrintUsage(argv[0]);
	return 0;
}
for (i=3; i<argc;i++)
{
	if ( strcmp(argv[i],"--nonzero-snr-only") == 0 )
		nonzero_snr_only=1;
	else if ( (strcmp(argv[i],"--gps-only") == 0) && (Mode==0) )
		Mode=1;
	else if ( (strcmp(argv[i],"--glonass-only") == 0) && (Mode==0) )
		Mode=2;
	else if ((strcmp(argv[i],"--gps-only") == 0)||(strcmp(argv[i],"--glonass-only") == 0))
	{
		printf("Error: options \"--gps-only\" and \"--glonass-only\" should not be used together\n");
		PrintUsage(argv[0]);
		return 0;
	}
	else if ( strcmp(argv[i],"--filter") == 0 )
	{
		if ( i!=(argc-1) )
		{
			fltrnmb=0;
			break;
		}
		else
		{
			printf("Error: there should be something after \"--filter\"...\n");
			PrintUsage(argv[0]);
			return 0;
		}
	}
	else
	{
		printf("Error: unrecognised option: %s\n",argv[i]);
		PrintUsage(argv[0]);
		return 0;
	}
}
if ( fltrnmb == 0 )
	for (i=i+1; i<argc;i++)
		if ( fltrnmb < 10 )		
			fltr[fltrnmb++]=argv[i];
		else
		{
			printf("Error: maximum number of words after \"--filter\" should be no more than 10\n");
			PrintUsage(argv[0]);
			return 0;
		}
else
	fltrnmb=0;

    strncpy(tty_name1,argv[2],128);
    fd1 = open("/dev/ptmx", O_RDWR|O_NONBLOCK|O_NOCTTY);
    grantpt(fd1);
    unlockpt(fd1);
    tcgetattr(fd1,&settings1);
    settings1.c_lflag |=ICANON;
    settings1.c_lflag &=~ECHO;
    settings1.c_lflag &=~ECHONL;    
    unlink(tty_name1);
    symlink((void*)ptsname(fd1),tty_name1);    
    chmod(ptsname(fd1),0666);
    chmod(tty_name1,0666);

	FILE *fr = NULL;
	char *rd = NULL;

	for ( int i = 0; i<8; i++ )
	{
		gsv1_sats[i]=0;
		gsv1_msgs[i]=0;
		gsv1_msgnmb[i]=0;
		gsv2_sats[i]=0;
		gsv2_msgs[i]=0;
		gsv2_msgnmb[i]=0;
	}

	while( 1 )
	{
		if ( fr != NULL )
			rd = fgets( inbuff, 1023, fr );
		if ( (fr == NULL)||(rd == NULL) )
		{
			if ( fr != NULL )
				fclose( fr );
			fr = fopen( argv[1], "r" );
		}
		else
		{
			if ( checkdata(inbuff) == 0 )
			{
				inbuff[strlen(inbuff)-3]='\0';
				nmea_type typ = datatype( inbuff );
				
				GSVdata gsvtmp;
				GSAdata gsatmp;
				res=0;
				for (int iii = 0; iii<fltrnmb;iii++)
					if ( strstr(inbuff,fltr[iii])!=NULL )
					{
						res=1;
						break;
					}
				if ( res==1 )
				{
				}
				else if ( (typ==TYPE_GPGSV) || (typ==TYPE_GLGSV) )
				{
					gsvtmp=parseGSV(inbuff);
					int msgnmb=0;
					sscanf(gsvtmp.msgnmb,"%d",&msgnmb);
					int msgs=0;
					sscanf(gsvtmp.msgs,"%d",&msgs);
					int sats=0;
					sscanf(gsvtmp.sats,"%d",&sats);

					if ((typ==TYPE_GPGSV)&&(Mode!=2))
					{
						if ( msgnmb==1 )
						{
							gsv1_n=0;
							gsv1_done=0;
							gsv1_started=1;
							for ( int i = 0; i<8; i++ )
							{
								gsv1_sats[i]=0;
								gsv1_msgs[i]=0;
								gsv1_msgnmb[i]=0;
							}
						}
						if ( (msgnmb <=8) && (gsv1_n < 8) && gsv1_started )
						{
							gsv1[msgnmb-1]=gsvtmp;
							gsv1_sats[msgnmb-1]=sats;
							gsv1_msgs[msgnmb-1]=msgs;
							gsv1_msgnmb[msgnmb-1]=msgnmb;
							gsv1_n++;
						}
						else
							gsv1_started=0;

						if ( (msgnmb==msgs) && (gsv1_n==msgs) && gsv1_started )
						{
							gsv1_started=0;
							int i = 0;
							for ( i = 0; i<msgs; i++ )
							{
								if ( gsv1_sats[i] != gsv1_sats[0] )
									break;
								if ( gsv1_msgs[i] != msgs )
									break;
								if ( gsv1_msgnmb[i] != (i+1) )
									break;
							}
							if ( i==msgs )
							{
								gsv1_done=1;
								gsv_last4=gsv_last3;
								gsv_last3=gsv_last2;
								gsv_last2=gsv_last1;
								gsv_last1=typ;
							}
						}
					}
					else if ( (typ==TYPE_GLGSV)&&(Mode!=1) )
					{
						if ( msgnmb==1 )
						{
							gsv2_n=0;
							gsv2_done=0;
							gsv2_started=1;
							for ( int i = 0; i<8; i++ )
							{
								gsv2_sats[i]=0;
								gsv2_msgs[i]=0;
								gsv2_msgnmb[i]=0;
							}
						}
						if ( (msgnmb <=8) && (gsv2_n < 8) && gsv2_started )						
						{
							gsv2[msgnmb-1]=gsvtmp;
							gsv2_sats[msgnmb-1]=sats;
							gsv2_msgs[msgnmb-1]=msgs;
							gsv2_msgnmb[msgnmb-1]=msgnmb;
							gsv2_n++;
						}
						else
							gsv2_started=0;
						if ( (msgnmb==msgs) && (gsv2_n==msgs) && gsv2_started )
						{
							gsv2_started=0;
							int i = 0;
							for ( i = 0; i<msgs; i++ )
							{
								if ( gsv2_sats[i] != gsv2_sats[0] )
									break;
								if ( gsv2_msgs[i] != msgs )
									break;
								if ( gsv2_msgnmb[i] != (i+1) )
									break;
							}
							if ( i==msgs )
							{
								gsv2_done=1;
								gsv_last4=gsv_last3;
								gsv_last3=gsv_last2;
								gsv_last2=gsv_last1;
								gsv_last1=typ;
							}
						}
					}
					if ( (gsv1_done && gsv2_done)||(gsv1_done&&(gsv_last1==TYPE_GPGSV)&&(gsv_last2==TYPE_GPGSV)&&(gsv_last3==TYPE_GPGSV)&&(gsv_last4==TYPE_GPGSV))||(gsv2_done&&(gsv_last1==TYPE_GLGSV)&&(gsv_last2==TYPE_GLGSV)&&(gsv_last3==TYPE_GLGSV)&&(gsv_last4==TYPE_GLGSV))||(gsv1_done&&(Mode==1))||(gsv2_done&&(Mode==2)))
					{
							int j=0;
							int ii;
							if ( gsv1_done && (Mode!=2))
							{
								for( i = 0; i < gsv1_n;i++)
								{
									for (ii=0;ii<gsv1[i].satsinmsg;ii++)
									{
										if ( ((*(gsv1[i].snr[ii])!='\0')||(nonzero_snr_only==0))&&(j<24) )
										{
											if ( (*(gsv1[i].satid[ii])!='\0') && (*(gsv1[i].elev[ii])!='\0') && (*(gsv1[i].azim[ii])!='\0') )
											{
												int tmp = 0;
												sscanf(gsv1[i].satid[ii],"%d",&tmp);
												if ( (tmp>=1)&&(tmp<=32) )
												{
													satid[j]=gsv1[i].satid[ii];
													elev[j]=gsv1[i].elev[ii];
													azim[j]=gsv1[i].azim[ii];
													snr[j]=gsv1[i].snr[ii];
													j++;
												}
											}
										}
									}
								}
							}
							if ( gsv2_done && (Mode!=1) )
							{
								for( i = 0; i < gsv2_n;i++)
								{
									for (ii=0;ii<gsv2[i].satsinmsg;ii++)
									{
										if ( ((*(gsv2[i].snr[ii])!='\0')||(nonzero_snr_only==0))&&(j<24) )
										{
											if ( (*(gsv2[i].satid[ii])!='\0') && (*(gsv2[i].elev[ii])!='\0') && (*(gsv2[i].azim[ii])!='\0') )
											{
												int tmp = 0;
												sscanf(gsv2[i].satid[ii],"%d",&tmp);
												if ( (tmp>=65)&&(tmp<=96) )
												{
													satid[j]=gsv2[i].satid[ii];
													elev[j]=gsv2[i].elev[ii];
													azim[j]=gsv2[i].azim[ii];
													snr[j]=gsv2[i].snr[ii];
													j++;
												}
											}
										}
									}
								}
							}
							for(i=0;i<j;i++)
							{
								sprintf(sat[i],",%s,%s,%s,%s", satid[i],elev[i],azim[i],snr[i]);
							}

							int nmsg_snd = j/3;
							if ((j%3)!=0)
							{
								nmsg_snd++;
								sprintf(sat[i],"");
							}
							if ( (j%3)==1 )
							{
								sprintf(sat[i+1],"");
							}
							int nsats_snd = j+nmsg_snd-1;
							for (i=0;i<nmsg_snd;i++)
							{
								sprintf(outbuff,"GPGSV,%d,%d,%d%s%s%s,,,,",nmsg_snd,i+1,nsats_snd,sat[i*3],sat[i*3+1],sat[i*3+2]);
								senddata(fd1,outbuff);
							}
							gsv1_done=0;
							gsv2_done=0;
							gsv1_started=0;
							gsv2_started=0;
					}
				}
				else if (typ==TYPE_GNGSA)
				{
					gsatmp=parseGSA(inbuff);
					int dntsnd=0;
					if ( (gsatmp.gsatype==1) && (Mode!=2) && ((prevGSAtype==1) || (Mode==1)) )
						newgsa=gsatmp;
					else if ( (gsatmp.gsatype==2) && (Mode!=1) && ((prevGSAtype==2) || (Mode==2)) )
						newgsa=gsatmp;
					else if ( (prevGSAtype==1) && (gsatmp.gsatype==2) && (Mode==0) )
						newgsa=mergeGSA(prevGSA,gsatmp,gsatmp);
					else if ( (prevGSAtype == 0) && (gsatmp.gsatype != 0) && (Mode==0) )
						newgsa=gsatmp;
					else
						dntsnd=1;

					prevGSA=gsatmp;
					prevGSAtype=gsatmp.gsatype;

					if(dntsnd!=1)
					{
						activesats = newgsa.activesats;
						sprintf(outbuff,"GPGSA,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s",newgsa.md1,newgsa.md2,newgsa.satid[0],newgsa.satid[1],newgsa.satid[2],newgsa.satid[3],newgsa.satid[4],newgsa.satid[5],newgsa.satid[6],newgsa.satid[7],newgsa.satid[8],newgsa.satid[9],newgsa.satid[10],newgsa.satid[11],newgsa.pdop,newgsa.hdop,newgsa.vdop);
						senddata(fd1,outbuff);
					}
				}
				else if (typ==TYPE_GPGGA)
				{
					int j = 0;
					int n = 0;
					for ( int i = 1; i < strlen( inbuff ); i++ )
					{
						if ( inbuff[i]==',' )
							n++;
						if ( (n!=7) || (inbuff[i]==',') )
							outbuff[j++]=inbuff[i];
						if ( (n==7) && (inbuff[i]==',') && (activesats != -1) )
						{
							sprintf(outbuff+j,"%d",activesats);
							j++;
							if ( activesats >= 10 )
								j++;
						}
					}
					outbuff[j]='\0';
					if ( activesats != -1 )
						senddata(fd1,outbuff);
					else
						senddata(fd1,inbuff+1);
				}
				else
					senddata(fd1,inbuff+1);
			}
			memset(outbuff,0,sizeof(outbuff));
			res=read(fd1,outbuff,sizeof(outbuff));
			if(res>0)
			{
				FILE *fw = fopen( argv[1], "ab" );
				fwrite(outbuff,1,res,fw);
				fclose(fw);
			}
		}
    }
}