/*
 * Prolific PL2303 USB to serial adaptor driver header file
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 */

#define BENQ_VENDOR_ID			0x04a5
#define BENQ_PRODUCT_ID_S81		0x4027

#define PL2303_VENDOR_ID	0x067b
#define PL2303_PRODUCT_ID	0x2303
#define PL2303_PRODUCT_ID_RSAQ2		0x04bb
#define PL2303_PRODUCT_ID_DCU11		0x1234
#define PL2303_PRODUCT_ID_PHAROS	0xaaa0
#define PL2303_PRODUCT_ID_RSAQ3		0xaaa2
#define PL2303_PRODUCT_ID_ALDIGA	0x0611
#define PL2303_PRODUCT_ID_MMX		0x0612
#define PL2303_PRODUCT_ID_GPRS		0x0609
#define PL2303_PRODUCT_ID_HCR331	0x331a

#define ATEN_VENDOR_ID		0x0557
#define ATEN_VENDOR_ID2		0x0547
#define ATEN_PRODUCT_ID		0x2008

#define IODATA_VENDOR_ID	0x04bb
#define IODATA_PRODUCT_ID	0x0a03
#define IODATA_PRODUCT_ID_RSAQ5	0x0a0e

#define ELCOM_VENDOR_ID		0x056e
#define ELCOM_PRODUCT_ID	0x5003
#define ELCOM_PRODUCT_ID_UCSGT	0x5004

#define ITEGNO_VENDOR_ID	0x0eba
#define ITEGNO_PRODUCT_ID	0x1080
#define ITEGNO_PRODUCT_ID_2080	0x2080

#define MA620_VENDOR_ID		0x0df7
#define MA620_PRODUCT_ID	0x0620

#define RATOC_VENDOR_ID		0x0584
#define RATOC_PRODUCT_ID	0xb000

#define TRIPP_VENDOR_ID		0x2478
#define TRIPP_PRODUCT_ID	0x2008

#define RADIOSHACK_VENDOR_ID	0x1453
#define RADIOSHACK_PRODUCT_ID	0x4026

#define DCU10_VENDOR_ID		0x0731
#define DCU10_PRODUCT_ID	0x0528

#define SITECOM_VENDOR_ID	0x6189
#define SITECOM_PRODUCT_ID	0x2068

/* Alcatel OT535/735 USB cable */
#define ALCATEL_VENDOR_ID	0x11f7
#define ALCATEL_PRODUCT_ID	0x02df

/* Samsung I330 phone cradle */
#define SAMSUNG_VENDOR_ID	0x04e8
#define SAMSUNG_PRODUCT_ID	0x8001

#define SIEMENS_VENDOR_ID	0x11f5
#define SIEMENS_PRODUCT_ID_SX1	0x0001
#define SIEMENS_PRODUCT_ID_X65	0x0003
#define SIEMENS_PRODUCT_ID_X75	0x0004
#define SIEMENS_PRODUCT_ID_EF81	0x0005

#define SYNTECH_VENDOR_ID	0x0745
#define SYNTECH_PRODUCT_ID	0x0001

/* Nokia CA-42 Cable */
#define NOKIA_CA42_VENDOR_ID	0x078b
#define NOKIA_CA42_PRODUCT_ID	0x1234

/* CA-42 CLONE Cable www.ca-42.com chipset: Prolific Technology Inc */
#define CA_42_CA42_VENDOR_ID	0x10b5
#define CA_42_CA42_PRODUCT_ID	0xac70

#define SAGEM_VENDOR_ID		0x079b
#define SAGEM_PRODUCT_ID	0x0027

/* Leadtek GPS 9531 (ID 0413:2101) */
#define LEADTEK_VENDOR_ID	0x0413
#define LEADTEK_9531_PRODUCT_ID	0x2101

/* USB GSM cable from Speed Dragon Multimedia, Ltd */
#define SPEEDDRAGON_VENDOR_ID	0x0e55
#define SPEEDDRAGON_PRODUCT_ID	0x110b

/* DATAPILOT Universal-2 Phone Cable */
#define DATAPILOT_U2_VENDOR_ID	0x0731
#define DATAPILOT_U2_PRODUCT_ID	0x2003

/* Belkin "F5U257" Serial Adapter */
#define BELKIN_VENDOR_ID	0x050d
#define BELKIN_PRODUCT_ID	0x0257

/* Alcor Micro Corp. USB 2.0 TO RS-232 */
#define ALCOR_VENDOR_ID		0x058F
#define ALCOR_PRODUCT_ID	0x9720

/* Willcom WS002IN Data Driver (by NetIndex Inc.) */
#define WS002IN_VENDOR_ID	0x11f6
#define WS002IN_PRODUCT_ID	0x2001

/* Corega CG-USBRS232R Serial Adapter */
#define COREGA_VENDOR_ID	0x07aa
#define COREGA_PRODUCT_ID	0x002a

/* Y.C. Cable U.S.A., Inc - USB to RS-232 */
#define YCCABLE_VENDOR_ID	0x05ad
#define YCCABLE_PRODUCT_ID	0x0fba

/* "Superial" USB - Serial */
#define SUPERIAL_VENDOR_ID	0x5372
#define SUPERIAL_PRODUCT_ID	0x2303

/* Hewlett-Packard LD220-HP POS Pole Display */
#define HP_VENDOR_ID		0x03f0
#define HP_LD220_PRODUCT_ID	0x3524

/* Cressi Edy (diving computer) PC interface */
#define CRESSI_VENDOR_ID	0x04b8
#define CRESSI_EDY_PRODUCT_ID	0x0521

/* Zeagle dive computer interface */
#define ZEAGLE_VENDOR_ID	0x04b8
#define ZEAGLE_N2ITION3_PRODUCT_ID	0x0522

/* Sony, USB data cable for CMD-Jxx mobile phones */
#define SONY_VENDOR_ID		0x054c
#define SONY_QN3USB_PRODUCT_ID	0x0437

/* Sanwa KB-USB2 multimeter cable (ID: 11ad:0001) */
#define SANWA_VENDOR_ID		0x11ad
#define SANWA_PRODUCT_ID	0x0001

/* ADLINK ND-6530 RS232,RS485 and RS422 adapter */
#define ADLINK_VENDOR_ID		0x0b63
#define ADLINK_ND6530_PRODUCT_ID	0x6530

struct usb_device_id
{
    unsigned short VID;
    unsigned short PID;
};

struct usb_device_id id_table[] = { 
	
	{    PL2303_VENDOR_ID, PL2303_PRODUCT_ID },
	{ PL2303_VENDOR_ID, PL2303_PRODUCT_ID_RSAQ2 },
	{ PL2303_VENDOR_ID, PL2303_PRODUCT_ID_DCU11 },
	{ PL2303_VENDOR_ID, PL2303_PRODUCT_ID_RSAQ3 },
	{ PL2303_VENDOR_ID, PL2303_PRODUCT_ID_PHAROS },
	{ PL2303_VENDOR_ID, PL2303_PRODUCT_ID_ALDIGA },
	{ PL2303_VENDOR_ID, PL2303_PRODUCT_ID_MMX },
	{ PL2303_VENDOR_ID, PL2303_PRODUCT_ID_GPRS },
	{ PL2303_VENDOR_ID, PL2303_PRODUCT_ID_HCR331 },
	{ IODATA_VENDOR_ID, IODATA_PRODUCT_ID },
	{ IODATA_VENDOR_ID, IODATA_PRODUCT_ID_RSAQ5 },
	{ ATEN_VENDOR_ID, ATEN_PRODUCT_ID },
	{ ATEN_VENDOR_ID2, ATEN_PRODUCT_ID },
	{ ELCOM_VENDOR_ID, ELCOM_PRODUCT_ID },
	{ ELCOM_VENDOR_ID, ELCOM_PRODUCT_ID_UCSGT },
	{ ITEGNO_VENDOR_ID, ITEGNO_PRODUCT_ID },
	{ ITEGNO_VENDOR_ID, ITEGNO_PRODUCT_ID_2080 },
	{ MA620_VENDOR_ID, MA620_PRODUCT_ID },
	{ RATOC_VENDOR_ID, RATOC_PRODUCT_ID },
	{ TRIPP_VENDOR_ID, TRIPP_PRODUCT_ID },
	{ RADIOSHACK_VENDOR_ID, RADIOSHACK_PRODUCT_ID },
	{ DCU10_VENDOR_ID, DCU10_PRODUCT_ID },
	{ SITECOM_VENDOR_ID, SITECOM_PRODUCT_ID },
	{ ALCATEL_VENDOR_ID, ALCATEL_PRODUCT_ID },
	{ SAMSUNG_VENDOR_ID, SAMSUNG_PRODUCT_ID },
	{ SIEMENS_VENDOR_ID, SIEMENS_PRODUCT_ID_SX1 },
	{ SIEMENS_VENDOR_ID, SIEMENS_PRODUCT_ID_X65 },
	{ SIEMENS_VENDOR_ID, SIEMENS_PRODUCT_ID_X75 },
	{ SIEMENS_VENDOR_ID, SIEMENS_PRODUCT_ID_EF81 },
	{ BENQ_VENDOR_ID, BENQ_PRODUCT_ID_S81 }, 
	{ SYNTECH_VENDOR_ID, SYNTECH_PRODUCT_ID },
	{ NOKIA_CA42_VENDOR_ID, NOKIA_CA42_PRODUCT_ID },
	{ CA_42_CA42_VENDOR_ID, CA_42_CA42_PRODUCT_ID },
	{ SAGEM_VENDOR_ID, SAGEM_PRODUCT_ID },
	{ LEADTEK_VENDOR_ID, LEADTEK_9531_PRODUCT_ID },
	{ SPEEDDRAGON_VENDOR_ID, SPEEDDRAGON_PRODUCT_ID },
	{ DATAPILOT_U2_VENDOR_ID, DATAPILOT_U2_PRODUCT_ID },
	{ BELKIN_VENDOR_ID, BELKIN_PRODUCT_ID },
	{ ALCOR_VENDOR_ID, ALCOR_PRODUCT_ID },
	{ WS002IN_VENDOR_ID, WS002IN_PRODUCT_ID },
	{ COREGA_VENDOR_ID, COREGA_PRODUCT_ID },
	{ YCCABLE_VENDOR_ID, YCCABLE_PRODUCT_ID },
	{ SUPERIAL_VENDOR_ID, SUPERIAL_PRODUCT_ID },
	{ HP_VENDOR_ID, HP_LD220_PRODUCT_ID },
	{ CRESSI_VENDOR_ID, CRESSI_EDY_PRODUCT_ID },
	{ ZEAGLE_VENDOR_ID, ZEAGLE_N2ITION3_PRODUCT_ID },
	{ SONY_VENDOR_ID, SONY_QN3USB_PRODUCT_ID },
	{ SANWA_VENDOR_ID, SANWA_PRODUCT_ID },
	{ ADLINK_VENDOR_ID, ADLINK_ND6530_PRODUCT_ID },
	{ }					
	};



#define SET_LINE_REQUEST_TYPE		0x21
#define SET_LINE_REQUEST		0x20

#define SET_CONTROL_REQUEST_TYPE	0x21
#define SET_CONTROL_REQUEST		0x22
#define CONTROL_DTR			0x01
#define CONTROL_RTS			0x02

#define BREAK_REQUEST_TYPE		0x21
#define BREAK_REQUEST			0x23
#define BREAK_ON			0xffff
#define BREAK_OFF			0x0000

#define GET_LINE_REQUEST_TYPE		0xa1
#define GET_LINE_REQUEST		0x21

#define VENDOR_WRITE_REQUEST_TYPE	0x40
#define VENDOR_WRITE_REQUEST		0x01

#define VENDOR_READ_REQUEST_TYPE	0xc0
#define VENDOR_READ_REQUEST		0x01

#define UART_STATE			0x08
#define UART_STATE_TRANSIENT_MASK	0x74
#define UART_DCD			0x01
#define UART_DSR			0x02
#define UART_BREAK_ERROR		0x04
#define UART_RING			0x08
#define UART_FRAME_ERROR		0x10
#define UART_PARITY_ERROR		0x20
#define UART_OVERRUN_ERROR		0x40
#define UART_CTS			0x80


enum pl2303_type {
	type_0,		/* don't know the difference between type 0 and */
	type_1,		/* type 1, until someone from prolific tells us... */
	HX,		/* HX version of the pl2303 chip */
};

