// demo: CAN-BUS Shield, receive data
#include "mcp_can.h"
#include <SPI.h>
#include <stdio.h>
//#include <LiquidCrystal_I2C.h>
//#include <Wire.h>

#define INT8U unsigned char

/*"Joystick" Init*/
#define UP     A1    /*Analog Pin 1*/
#define DOWN   A3    /*Analog Pin 3*/
#define LEFT   A5    /*Analog Pin 5*/
#define RIGHT  A2    /*Analog Pin 2*/
#define CLICK  A4    /*Analog Pin 4*/
#define JSP    0  /*Joystick Pressed*/
#define JSNP   1  /*Joystick Not Pressed*/

/*Status LED's*/
#ifndef LED_2
int LED_2 = 8;
#endif
#ifndef LED_3
int LED_3 = 7;
#endif

//LiquidCrystal_I2C lcd(0x27,20,4);  // set address of lcd to 0x27 and count of char to 20, of rows to 4 (20х4)

INT8U Flag_Recv = 0;
INT8U len = 0;
INT8U buf[16];
char str[20];
INT8U speedCAN;
int speedCANtext;
int countPckg = 0;
//char speedInput;

//Timer 2 - blinking LED
unsigned int toggle = 0;  //used to keep the state of the LED
unsigned int count = 0;   //used to keep count of how many interrupts were fired

//Timer2 Overflow Interrupt Vector, called every 1ms
ISR(TIMER2_OVF_vect) {
  count++;               //Increments the interrupt counter
  if(count > 999){
    toggle = !toggle;    //toggles the LED state
    count = 0;           //Resets the interrupt counter
  }
  digitalWrite(LED_3,toggle);
  TCNT2 = 130;           //Reset Timer to 130 out of 255
  TIFR2 = 0x00;          //Timer2 INT Flag Reg: Clear Timer Overflow Flag
};  

/*
void init_LCD (void) 
{
  lcd.init();                     // инициализация LCD 
  lcd.backlight();                // включаем подсветку
  lcd.clear();                    // очистка дисплея
  lcd.setCursor(0, 0);
}
*/
void init_JoyStick(void)
{
  pinMode(UP,INPUT);
  pinMode(DOWN,INPUT);
  pinMode(LEFT,INPUT);
  pinMode(RIGHT,INPUT);
  pinMode(CLICK,INPUT);
  digitalWrite(UP, HIGH);  //enabled input pull-up resistor
  digitalWrite(DOWN, HIGH);  //enabled input pull-up resistor
  digitalWrite(LEFT, HIGH);  //enabled input pull-up resistor
  digitalWrite(RIGHT, HIGH);  //enabled input pull-up resistor
  digitalWrite(CLICK, HIGH);  //enabled input pull-up resistor
}

void init_Status_LED(void)
{
  pinMode(LED_2, OUTPUT);//communication LED
  pinMode(LED_3, OUTPUT); //Status LED 
  digitalWrite(LED_2,LOW);
  digitalWrite(LED_3,LOW);
}

void init_CAN(void)
{
  if (CAN.begin(speedCAN) == 0)                 // init can bus at baudrate
  {
/*    lcd.clear();
    lcd.print ("CAN init on "); 
    lcd.print (speedCANtext); 
    lcd.print ("KBPS"); 
*/    Serial.print("CAN init on ");
    Serial.print(speedCANtext);
    Serial.println("KBPS");
  } else
  {
/*    lcd.clear();
    lcd.print ("CAN init FAIL"); 
*/    Serial.println("CAN init FAIL");
  }
}

void select_CAN_speed(void)
{
      int speedInput = Serial.read ();
      switch (speedInput)
      {
        case '1':    
          speedCAN = CAN_83_1KBPS;
          speedCANtext = 831;
          break;
        case '2':    
          speedCAN = CAN_83_2KBPS;
          speedCANtext = 832;
          break;
        case '3':    
          speedCAN = CAN_83_3KBPS;
          speedCANtext = 833;
          break;
        case '4':    
          speedCAN = CAN_83_4KBPS;
          speedCANtext = 834;
          break;
        case '5':    
          speedCAN = CAN_83_5KBPS;
          speedCANtext = 835;
          break;
        case '6':    
          speedCAN = CAN_500KBPS;
          speedCANtext = 500;
          break;
        case '7':    
          speedCAN = CAN_100KBPS;
          speedCANtext = 100;
          break;
        case '8':    
          speedCAN = CAN_125KBPS;
          speedCANtext = 125;
          break;
        default:
          Serial.println ("Speed error");
          speedCANtext = -1;
      }
}

void setup()
{
  Serial.begin(115200);
//  init_LCD();
//  init_JoyStick();
  init_Status_LED();

  //Setup Timer2 to fire every 1ms
  TCCR2B = 0x00;        //Disbale Timer2 while we set it up
  TCNT2  = 130;         //Reset Timer Count to 130 out of 255
  TIFR2  = 0x00;        //Timer2 INT Flag Reg: Clear Timer Overflow Flag
  TIMSK2 = 0x01;        //Timer2 INT Reg: Timer2 Overflow Interrupt Enable
  TCCR2A = 0x00;        //Timer2 Control Reg A: Normal port operation, Wave Gen Mode normal
  TCCR2B = 0x05;        //Timer2 Control Reg B: Timer Prescaler set to 128

//for use with mega2560
  pinMode(10, OUTPUT);    
  digitalWrite(10, HIGH);
  pinMode(11, INPUT);    
  digitalWrite(11, LOW);
  pinMode(12, INPUT);    
  digitalWrite(12, LOW);
  pinMode(13, INPUT);    
  digitalWrite(13, LOW);

//  lcd.print ("Press Joy to start"); 
//  Serial.println("Press Joy to start...");

  Serial.println("Enter CAN-BUS speed:");
  Serial.println("1 - 83.333 (1)");
  Serial.println("2 - 83.333 (2)");
  Serial.println("3 - 83.333 (3)");
  Serial.println("4 - 83.333 (4)");
  Serial.println("5 - 83.333 (5)");
  Serial.println("6 - 500");
  Serial.println("7 - 100");
  Serial.println("8 - 125");
  speedCANtext = -1;
  while (speedCANtext < 0)
  {
    if (Serial.available() > 0) 
    {
      select_CAN_speed();
    } 
   }

/*  
//  while (digitalRead(CLICK));
  while (1) 
  {
    if(!digitalRead(DOWN))
    {
      speedCAN = CAN_83_1KBPS;
      speedCANtext = 831;
      break;
    }  else if(!digitalRead(UP))
    {
      speedCAN = CAN_83_2KBPS;
      speedCANtext = 832;
      break;
    } else if(!digitalRead(LEFT))
    {
      speedCAN = CAN_500KBPS;
      speedCANtext = 500;
      break;
    } else if(!digitalRead(RIGHT))
    {
      speedCAN = CAN_100KBPS;
      speedCANtext = 100;
      break;
    }
    
  }
*/  
  init_CAN ();
  attachInterrupt(0, MCP2515_ISR, FALLING); // start interrupt
}

void MCP2515_ISR()
{
     Flag_Recv = 1;
      digitalWrite(LED_2,HIGH);
}

void loop()
{
//    digitalWrite(LED_3,HIGH);
    if(Flag_Recv)                   // check if get data
    {
      Flag_Recv = 0;                // clear flag
      ++countPckg;                  // count of packages
      CAN.readMsgBuf(&len, buf);    // read data,  len: data length, buf: data buf
      Serial.print(countPckg);
//      Serial.println(": CAN_BUS GET DATA!");
/*      lcd.setCursor(0, 1);
      lcd.print (countPckg); 
      lcd.print (": CANBUS GET DATA"); 
*/      Serial.print(": data len = ");
      Serial.print(len, HEX);
      Serial.print("\t");
      for(int i = 0; i<len; i++)    // print the data
      {
        Serial.print(buf[i], HEX);
        Serial.print("\t");
      }
      Serial.println();
      digitalWrite(LED_2,LOW);
    }

}
