// RWI2CParams.cpp:  
//

#include "stdafx.h"
#include "SVRmeterMFC.h"
#include "RWI2CParams.h"
#include "afxdialogex.h"
#include "SVRmeterMFCDlg.h"
#include "..\..\..\..\..\Avto\MPLABXProjects\i2c\i2cCmds.h"

//   CRWI2CParams

IMPLEMENT_DYNAMIC(CRWI2CParams, CDialog)

CRWI2CParams::CRWI2CParams(CWnd* pParent /*=NULL*/)
	: CDialog(CRWI2CParams::IDD, pParent)
{
	m_bStopRead = 0;
}

CRWI2CParams::~CRWI2CParams()
{
}

void CRWI2CParams::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CRWI2CParams, CDialog)
	ON_BN_CLICKED(IDC_STARTTEST, &CRWI2CParams::OnBnClickedStarttest)
	ON_BN_CLICKED(IDC_STOPTEST, &CRWI2CParams::OnBnClickedStoptest)
	ON_BN_CLICKED(IDC_b27, &CRWI2CParams::OnBnClickedb27)
	ON_BN_CLICKED(IDC_b26, &CRWI2CParams::OnBnClickedb26)
	ON_BN_CLICKED(IDC_b1819, &CRWI2CParams::OnBnClickedb1819)
END_MESSAGE_MAP()


//   CRWI2CParams
void CRWI2CParams::PrintLog(LPCTSTR logstr, BOOL bPrintTime, BOOL bPrintNewString)
{
	((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(logstr, bPrintTime, bPrintNewString);
}

void CRWI2CParams::OnBnClickedStarttest()
{
	// TODO:     
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == NULL || ((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == INVALID_HANDLE_VALUE)
	{
		PrintLog(L":   ");
		return;
	}

	WCHAR DBS[100];

	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 0x11;
	pwbuff[3] = 0x1;		// Set i2cHoldTmr
	CString str;
	((CEdit *)GetDlgItem(IDC_I2CHOLDTMR))->GetWindowTextW(str);
	INT ret;
	if (!swscanf_s(str, L"%d", &ret) || ret > 255 || ret < 0)
	{
		PrintLog(L"I2CHoldTmr   (   ,    0 - 255)!");
		return;
	}
	pwbuff[4] = ret;
	swprintf_s(DBS, L" %d, %d, \n", ret, pwbuff[3]);
	OutputDebugString(DBS);
	m_bStopRead = 0;
	//   
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}

}

void CRWI2CParams::GetI2CResults()
{
	WCHAR DBS[100];
	INT itemID[] = { IDC_21, IDC_23, IDC_24, IDC_25, IDC_26, IDC_27, IDC_28, IDC_29, IDC_210, IDC_1416, IDC_1819 };
	BOOL bError = 0;
	if (m_bRdBuff[2] == 0x1)
	{
		bError = m_bRdBuff[3];
		swprintf_s(DBS, L"i2cHoldTmr error: 0x%x\n", m_bRdBuff[3]);
		PrintLog(DBS);
	}
	else
	{
		for (INT i = 0, j = 0; i < sizeof(itemID) / sizeof(INT); i++, j += 3)
		{
			if (!m_bRdBuff[j + 3] && !m_bRdBuff[j + 4])
			{

				if (itemID[i] == IDC_28 || itemID[i] == IDC_29)
				{
					swprintf_s(DBS, L"%x", m_bRdBuff[j + 5]);
					GetDlgItem(itemID[i])->SetWindowTextW(DBS);
				}
				else
				{
					((CButton *)GetDlgItem(itemID[i]))->SetCheck(m_bRdBuff[j + 5]);
				}
			}
			else
			{
				bError = 1;
				swprintf_s(DBS, L"Error for %x, Send: %x, Rec: %x", itemID[i], m_bRdBuff[j + 3], m_bRdBuff[j + 4]);
				PrintLog(DBS);
			}
		}
	}
	if (bError == FALSE && m_bStopRead == FALSE)
	{
		BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
		pwbuff[0] = 0x0;
		pwbuff[1] = 0x21;
		pwbuff[2] = 0x11;
		pwbuff[3] = 0x0;		// Read Params
		//   
		if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
			((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}
}


void CRWI2CParams::OnBnClickedStoptest()
{
	// TODO:     
	m_bStopRead = 1;
}


void CRWI2CParams::OnBnClickedb27()
{
	// TODO:     
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == NULL || ((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == INVALID_HANDLE_VALUE)
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(L":   ");
		//	return;
	}

	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 0x11;
	pwbuff[3] = 0x2;
	pwbuff[4] = _I2C_DO27;
	pwbuff[5] = 1;// ((CButton *)GetDlgItem(IDC_b27))->GetCheck();
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
		DWORD ReadSignal = WaitForSingleObject(((CSVRmeterMFCDlg*)m_pMainDlg)->m_hReadEvent, INFINITE);
		if (ReadSignal == WAIT_OBJECT_0)
		{
			ResetEvent(((CSVRmeterMFCDlg*)m_pMainDlg)->m_hReadEvent);
			WCHAR DBS[100];
			swprintf_s(DBS, L"DO27 Error: %x\n", ((CSVRmeterMFCDlg*)m_pMainDlg)->m_brdbuff[3]);
			PrintLog(DBS);
		}
	}



}


void CRWI2CParams::OnBnClickedb26()
{
	// TODO:     
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == NULL || ((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == INVALID_HANDLE_VALUE)
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(L":   ");
		//	return;
	}

	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 0x11;
	pwbuff[3] = 0x2;
	pwbuff[4] = _I2C_DO26;
	pwbuff[5] = ((CButton *)GetDlgItem(IDC_b26))->GetCheck();
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
		DWORD ReadSignal = WaitForSingleObject(((CSVRmeterMFCDlg*)m_pMainDlg)->m_hReadEvent, INFINITE);
		if (ReadSignal == WAIT_OBJECT_0)
		{
			ResetEvent(((CSVRmeterMFCDlg*)m_pMainDlg)->m_hReadEvent);
			WCHAR DBS[100];
			swprintf_s(DBS, L"DO26 Error: %x\n", ((CSVRmeterMFCDlg*)m_pMainDlg)->m_brdbuff[3]);
			PrintLog(DBS);
		}
		if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_brdbuff[3])
			OnBnClickedStoptest();
	}
}


void CRWI2CParams::OnBnClickedb1819()
{
	// TODO:     
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == NULL || ((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == INVALID_HANDLE_VALUE)
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(L":   ");
		//	return;
	}

	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 0x11;
	pwbuff[3] = 0x2;
	pwbuff[4] = _I2C_DO1819;
	pwbuff[5] = ((CButton *)GetDlgItem(IDC_b1819))->GetCheck();
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		//	((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}

}
