// BEANDlg.cpp:  
//

#include "stdafx.h"
#include "SVRmeterMFC.h"
#include "BEANDlg.h"
#include "afxdialogex.h"

#include "SVRmeterMFCDlg.h"

//   CBEANDlg

IMPLEMENT_DYNAMIC(CBEANDlg, CDialog)

CBEANDlg::CBEANDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBEANDlg::IDD, pParent)
{
	ZeroMemory(bRdBuff, 65);
	sec = 0;
	m_bPrevBEANVal = -1;
}

CBEANDlg::~CBEANDlg()
{
}

void CBEANDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BEANLOG, m_BEANLog);
	DDX_Control(pDX, IDC_FILETOLOG, m_BEANLogFile);
	DDX_Control(pDX, IDC_TMR0L, m_TMR0L);
	DDX_Control(pDX, IDC_T0CON, m_T0CON);
}


BEGIN_MESSAGE_MAP(CBEANDlg, CDialog)
	ON_BN_CLICKED(IDC_SELECTFILE, &CBEANDlg::OnBnClickedSelectfile)
	ON_BN_CLICKED(IDC_STARTREAD, &CBEANDlg::OnBnClickedStartread)
	ON_BN_CLICKED(IDC_STOPREAD, &CBEANDlg::OnBnClickedStopread)
	ON_BN_CLICKED(IDC_READBEANDIG, &CBEANDlg::OnBnClickedReadbeandig)
	ON_BN_CLICKED(IDC_BEAN_CODE, &CBEANDlg::OnBnClickedBeanCode)
	ON_BN_CLICKED(IDC_CODE_SORT, &CBEANDlg::OnBnClickedCodeSort)
	ON_BN_CLICKED(IDC_BUTTON1, &CBEANDlg::OnBnClickedButton1)
END_MESSAGE_MAP()


//   CBEANDlg

void CBEANDlg::PrintBEANLog()
{
	BYTE i;
	CString s, s1;
	if (m_ReprintBEAN)
	{
		m_BEANLog.SetSel(0, -1);
		m_BEANLog.ReplaceSel(L"");
	}

	for (i = 0; i < 100 && m_CodeSort[i][0] != 0; i++)
	{
//		s.Format(_T("i = %d, Line = %d, %d\n"), i, m_CodeSort[i][0], m_BEANLog.GetLineCount());
//		OutputDebugString(s);

		if (m_ReprintBEAN)
		{
			BYTE j;
			s = "";
			for (j = 0; j <= ((m_CodeSort[i][2] & 0x0F) + 5); j++)
			{
				s1.Format(_T("%02x "), m_CodeSort[i][j]);
				s += s1;
			}
			s1.Format(_T("\n"));
			s += s1;
			m_BEANLog.SetSel(-1, -1);
			m_BEANLog.ReplaceSel(s);
		}
		else
		{
			INT Line = m_BEANLog.LineIndex(i);
			if (Line > -1)
			{
				m_BEANLog.SetSel(Line, Line + 2);
				s.Format(_T("%02x"), m_CodeSort[i][0]);
				m_BEANLog.ReplaceSel(s);
			}
		}
	}
	m_ReprintBEAN = 0;
}

void CBEANDlg::OpenBEANFile()
{
	if (((CButton *)GetDlgItem(IDC_LOGTOFILE))->GetCheck())
	{
		CString sBEANFileName;
		m_BEANLogFile.GetWindowText(sBEANFileName);
		m_hBEANLogFile = CreateFile(sBEANFileName,
			GENERIC_READ | GENERIC_WRITE,
			FILE_SHARE_READ | FILE_SHARE_WRITE,
			NULL,        // no SECURITY_ATTRIBUTES structure
			OPEN_ALWAYS, // No special create flags
			0,   // Open device as non-overlapped so we can get data
			NULL);       // No template file

		DWORD err = GetLastError();
		if (err != 0 && !(err == 183 && MessageBox(L"  . ?", NULL, MB_ICONEXCLAMATION | MB_YESNO) == IDYES))
		{
			WCHAR DBS[30];
			swprintf_s(DBS, L"Open Log File err: %d", err);
			((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(DBS);
			if (m_hBEANLogFile != INVALID_HANDLE_VALUE)
			{
				CloseHandle(m_hBEANLogFile);
				m_hBEANLogFile = NULL;
			}
		}
		else
		{
			SYSTEMTIME time;
			GetLocalTime(&time);
			CHAR DBS[50];

			sprintf_s(DBS, "Log Started: %d:%d:%d\r\n", time.wHour, time.wMinute, time.wSecond);
			WriteFile(m_hBEANLogFile, DBS, strlen(DBS)*sizeof(CHAR), NULL, NULL);
		}
	}
	else
	{
		m_hBEANLogFile = NULL;
	}


}

void CBEANDlg::OnBnClickedStartread()
{
	// TODO:     
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == NULL || ((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == INVALID_HANDLE_VALUE)
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(L":   ");
		//	return;
	}

	/*OpenBEANFile();

	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 1;
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}
	*/
}


void CBEANDlg::OnBnClickedStopread()
{
	// TODO:     
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == NULL || ((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == INVALID_HANDLE_VALUE)
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(L":   ");
		//	return;
	}

	if (m_hBEANLogFile != INVALID_HANDLE_VALUE && m_hBEANLogFile != NULL)
		CloseHandle(m_hBEANLogFile);

	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 0;
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
	//	((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}

}

void CBEANDlg::PrintLog(LPCTSTR logstr, BOOL bPrintTime = 1, BOOL bPrintNewString = 1)
{
	((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(logstr, bPrintTime, bPrintNewString);
}


void CBEANDlg::GetBEANResults()
{
	// TODO:     
//	if (sec >= (bRdBuff[3] & 0x7F))
//		return;
//	sec = (bRdBuff[3] & 0x7F) + 1;
	
	WCHAR DBS[200];
	CString s, s1, file;
	union {
		BYTE res[4];
		ULONG32 time;
	};

	double msec;

	switch (bRdBuff[1])		// CMD in progress
	{
	case 1:
	case 2:
		for (BYTE i = 0; i < bRdBuff[2]; i += 2)
		{
			res[0] = bRdBuff[i + 3 + 1];
			res[1] = (bRdBuff[i + 3] & 0x3F);
			res[2] = 0;
			res[3] = 0;
			msec = time * 0.02133333;

			BYTE curBEANVal = !(!(bRdBuff[i + 3] & 0x80));
			BYTE TmrOverflow = !(!(bRdBuff[i + 3] & 0x40));	//  ,      
			if (((CButton *)GetDlgItem(IDC_WRITETOSCREEN))->GetCheck())
			{
				swprintf_s(DBS, L" bRdBuff[2]: %d, msec: %f, pins: %d, TmrOverfl: %d", bRdBuff[2], msec, curBEANVal, TmrOverflow);
				PrintLog(DBS);
			}
			if (m_hBEANLogFile != INVALID_HANDLE_VALUE && m_hBEANLogFile != NULL)
			{

				CHAR log[100];
				if (m_bPrevBEANVal < 0)
					m_bPrevBEANVal = curBEANVal;
				else
				{
					sprintf_s(log, "%f	%d	%x	%x\r\n", msec, m_bPrevBEANVal, (bRdBuff[i + 3] & 0x3F), bRdBuff[i + 3 + 1]);
					WriteFile(m_hBEANLogFile, log, strlen(log)*sizeof(CHAR), NULL, NULL);
					m_bPrevBEANVal = curBEANVal;
				}

				sprintf_s(log, "%f	%d	%x	%x	%d	%d\r\n", msec, curBEANVal, (bRdBuff[i + 3] & 0x3F), bRdBuff[i + 3 + 1], bRdBuff[2], TmrOverflow);
				WriteFile(m_hBEANLogFile, log, strlen(log)*sizeof(CHAR), NULL, NULL);
			}
		}
		break;
	case 3:	// CMD_BEAN_DIG
		s1.Format(_T("%d"), bRdBuff[2]);
		s = s1;
		file = s1;

		for (BYTE i = 0; i < bRdBuff[2]; i++)
		{
			if (i != 0 && (((INT)(i / 20)) * 20) == i)
			{
				s1.Format(_T("\n"));
				s += s1;
				s1.Format(_T("\r\n"));
				file += s1;
			}
			s1.Format(_T("	0x%x"), bRdBuff[i + 3]);
			s += s1;
			file += s1;
		}

		if (((CButton *)GetDlgItem(IDC_WRITETOSCREEN))->GetCheck())
			PrintLog(LPCTSTR(s));

		if (m_hBEANLogFile != INVALID_HANDLE_VALUE && m_hBEANLogFile != NULL)
		{
			char str[400];
			sprintf_s(str, "%S\r\n", LPCTSTR(s));
			WriteFile(m_hBEANLogFile, str, strlen(str), NULL, NULL);
		}

		break;
	case 4:
		for (BYTE i = 0; i < bRdBuff[2]; i++)
		{
			if (i != 0 && (((INT)(i / 20)) * 20) == i)
			{
				m_RecBuffPos = 0;
				if (m_RecBuff[(m_RecBuff[2] & 0x0F) + 4] == 0x7e)
				{
					m_RecBuff[1] = m_RecBuff[(m_RecBuff[2] & 0x0F) + 3];
					AddToCodeSort();
					PrintBEANLog();
				}
				else
				{
					BYTE a = 0;
					CString s, s1;
					for (; a < 22; a++)
					{
						s1.Format(_T("%x "), m_RecBuff[a]);
						s += s1;
					}
					PrintLog(s);
				}
			}

			m_RecBuff[m_RecBuffPos + 2] = bRdBuff[i + 3];
			m_RecBuffPos++;

		}
		if (bRdBuff[2] < 62)
	    {
			m_RecBuffPos = 0;
			if (m_RecBuff[(m_RecBuff[2] & 0x0F) + 4] == 0x7e)
			{
				m_RecBuff[1] = m_RecBuff[(m_RecBuff[2] & 0x0F) + 3];
				AddToCodeSort();
				PrintBEANLog();
			}
			else
			{
				BYTE a = 0;
				CString s, s1;
				for (; a < 22; a++)
				{
					s1.Format(_T("%x "), m_RecBuff[a]);
					s += s1;
				}
				PrintLog(s);
			}
		}
		break;
	}
}


void CBEANDlg::OnBnClickedSelectfile()
{
	// TODO:     
	CFileDialog dlgFile(TRUE, NULL, NULL, 6UL, NULL, NULL, 0UL, 1);
	
	dlgFile.DoModal();
	CString strPathname = dlgFile.GetPathName();
	m_BEANLogFile.SetWindowText(strPathname);
}


void CBEANDlg::OnBnClickedReadbeandig()
{
	// TODO:     
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == NULL || ((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == INVALID_HANDLE_VALUE)
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(L":   ");
		return;
	}
	

	OpenBEANFile();

/*	char str[300];
	CString s;
	s.Format(_T("%d %d"), 12, 11);
	sprintf_s(str, "%S\r\n", LPCTSTR(s));
	WriteFile(m_hBEANLogFile, str, strlen(str), NULL, NULL);
	*/
/*	CString s;
	BYTE bTMR0L = 0, bT0CON = 0;
	m_TMR0L.GetWindowTextW(s);
	swscanf_s(L"12", L"%d", bTMR0L);
	m_T0CON.GetWindowTextW(s);
	swscanf_s(LPCTSTR(s), L"%x", &bT0CON);

	s.Format(_T("%d, %d"), bTMR0L, bT0CON);
	PrintBEANLog(LPCTSTR(s));
*/
	/*BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 2;
	pwbuff[3] = 0x43;	// 0x43 = 0b01000011, 8 bit timer, 1:16 prescaler.
	pwbuff[4] = 75;		// 1200/16 = 75
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}*/

}


void CBEANDlg::OnBnClickedBeanCode()
{
	// TODO:     
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == NULL || ((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == INVALID_HANDLE_VALUE)
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(L":   ");
//		return;
	}


	OpenBEANFile();

	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 3;
	INT32 ret = 0;
	CString str;

	pwbuff[3] = 0x43;	// 0x43 = 0b01000011, 8 bit timer, 1:16 prescaler.
//	GetDlgItem(IDC_TMR0L)->GetWindowTextW(str);
//	if (swscanf_s(LPCTSTR(str), L"%d", &ret) != 1)
		pwbuff[4] = 75;		// 1200/16 = 75

//	INT32 ret = 0;
//	str = "75";
	
//	WCHAR DBS[100];
//	swprintf_s(DBS, L"%s, %d ", str, ret);
//	OutputDebugString(DBS);

	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}

}

void CBEANDlg::InsertToCodeSort(BYTE i)
{
	BYTE CSBuff[22];
//	CString s;
	do
	{
		memcpy(CSBuff, &m_CodeSort[i][0], 22);
//		s.Format(_T("i = %d, m_CodeSort = %x "), i, m_CodeSort[i][1]);
//		OutputDebugString(s);
		memcpy(&m_CodeSort[i][0], m_RecBuff, 22);
//		s.Format(_T("m_RecBuff = %x\n"), m_RecBuff[1]);
//		OutputDebugString(s);
		memcpy(m_RecBuff, CSBuff, 22);
		i++;
	} while (i < 100 && (CSBuff[0] != 0 || CSBuff[1] != 0 || CSBuff[2] != 0));
}

void CBEANDlg::AddToCodeSort()
{

	BYTE i, j;
	CString s;
	for (i = 0, j = 3; i < 100 /*&& m_CodeSort[i][0] != 0*/; i++)
	{
		while (m_RecBuff[j] == m_CodeSort[i][j] && j < ((m_CodeSort[i][2] & 0x0F) + 5))
			j++;
		if (j == ((m_CodeSort[i][2] & 0x0F) + 5))
		{
			m_CodeSort[i][0]++;
			break;
		}
		else
		{
			if (m_RecBuff[j] < m_CodeSort[i][j] || (m_CodeSort[i][0] == 0 && m_CodeSort[i][1] == 0 && m_CodeSort[i][2] == 0))
			{
				InsertToCodeSort(i);
				m_ReprintBEAN = 1;
				m_CodeSort[i][0]++;
				break;
			}
			else
			{
				j = 3;
			}
		}
	}

/*	BYTE i;
	CString s;
	for (i = 0; i < 100 && m_CodeSort[i][0] != 0; i++)
	{
		if (m_CodeSort[i][1] == m_RecBuff[1])
		{
			BYTE j;
			for (j = 1; j < ((m_CodeSort[i][2] & 0x0F) + 5); j++)
			{
				if (m_CodeSort[i][j] != m_RecBuff[j])
					break;
			}
			if (j == ((m_CodeSort[i][2] & 0x0F) + 5))
			{
				m_CodeSort[i][0]++;
				break;
			}
		}
	}
//	s.Format(_T("i = %d, %d\n"), i, m_CodeSort[i][0]);
//	OutputDebugString(s);
	if (i == 100 || m_CodeSort[i][0] == 0)
	{
		memcpy(&m_CodeSort[i][0], m_RecBuff, 22);
		m_CodeSort[i][0]++;
	}
*/
}

void CBEANDlg::OnBnClickedCodeSort()
{
	// TODO: Add your control notification handler code here
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == NULL || ((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == INVALID_HANDLE_VALUE)
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(L":   ");
		//return;
	}

	//for (INT i = 0; i < 100; i++)
	//	memset(&m_CodeSort[i][0], 0, 22);

	memchr(m_RecBuff, 0, 22);
	m_RecBuffPos = 0;
	m_ReprintBEAN = 0;
	
/*	BYTE RB[] = { 0, 4, 28, 0x25, 0xfe, 0x7f, 0x00, 0x10, 0x80, 0x0b, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x24, 0x98, 0xcc, 0x1, 0x8d, 0x87, 0x7e, 0x40 };
	BYTE RD[] = { 0, 4, 28, 0x23, 0x13, 0xd6, 0x4a, 0xa9, 0xFF, 0xFF, 0x00, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x25, 0x62, 0xd2, 0x0, 0x00, 0x00, 0xd7, 0x7e };
	BYTE RF[] = { 0, 4, 28, 0x24, 0x98, 0xcc, 0x01, 0x8d, 0x87, 0x7e, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x25, 0x62, 0xd2, 0x0, 0x00, 0x00, 0xd7, 0x7e };

	for (BYTE k = 0; k < 3; k++)
	{
		if (k == 1)
		{
			memcpy(RB, RD, sizeof(RD));
		}
		if (k == 2)
		{
			memcpy(RB, RF, sizeof(RF));

		}
		for (BYTE i = 0; i < RB[2]; i++)
		{
			if (i != 0 && (((INT)(i / 20)) * 20) == i)
			{
				m_RecBuffPos = 0;
				if (m_RecBuff[(m_RecBuff[2] & 0x0F) + 4] == 0x7e)
				{
					m_RecBuff[1] = m_RecBuff[(m_RecBuff[2] & 0x0F) + 3];
					AddToCodeSort();
					PrintBEANLog();
				}
				else
				{
					BYTE a = 0;
					CString s, s1;
					for (; a < 22; a++)
					{
						s1.Format(_T("%x "), m_RecBuff[a]);
						s += s1;
					}
					PrintLog(s);
				}
			}

			m_RecBuff[m_RecBuffPos + 2] = RB[i + 3];
			m_RecBuffPos++;

		}
		if (RB[2] < 62)
		{
			m_RecBuffPos = 0;
			if (m_RecBuff[(m_RecBuff[2] & 0x0F) + 4] == 0x7e)
			{
				m_RecBuff[1] = m_RecBuff[(m_RecBuff[2] & 0x0F) + 3];
				AddToCodeSort();
				PrintBEANLog();
			}
			else
			{
				BYTE a = 0;
				CString s, s1;
				for (; a < 22; a++)
				{
					s1.Format(_T("%x "), m_RecBuff[a]);
					s += s1;
				}
				PrintLog(s);
			}
		}
	}

	CString s, s1;
	WCHAR DBS[100];
	//swprintf_s(DBS, L" %x, %x, %x, %x, %x, %x, %x, %x, %x, %x\n", m_RecBuff[0], m_RecBuff[1], m_RecBuff[2], m_RecBuff[3], m_RecBuff[4], m_RecBuff[5], m_RecBuff[6], m_RecBuff[7], m_RecBuff[8], m_RecBuff[9], m_RecBuff[10]);
	swprintf_s(DBS, L"%d, %x, %d, %x, %d, %x\n", m_CodeSort[0][0], m_CodeSort[0][2], m_CodeSort[1][0], m_CodeSort[1][2], m_CodeSort[2][0], m_CodeSort[2][2]);
	OutputDebugString(DBS);
	
	*/


	OpenBEANFile();

	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 4;
	INT32 ret = 0;
	CString str;

	pwbuff[3] = 0x43;	// 0x43 = 0b01000011, 8 bit timer, 1:16 prescaler.
	//	GetDlgItem(IDC_TMR0L)->GetWindowTextW(str);
	//	if (swscanf_s(LPCTSTR(str), L"%d", &ret) != 1)
	pwbuff[4] = 75;		// 1200/16 = 75

	//	INT32 ret = 0;
	//	str = "75";

//		WCHAR DBS[100];
//		swprintf_s(DBS, L" %d \n", m_RecBuff[2]);
//		OutputDebugString(DBS);

	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}

}

BOOL CBEANDlg::GetNum(CString str, PBYTE ret)
{
	if (str.GetLength() > 2)
	{
		//		OutputDebugString(L"Err\n");
		return (FALSE);
	}
	//	int
	if (swscanf_s(LPCTSTR(str), L"%x", ret) == 1)
		return (TRUE);
	else
		return (FALSE);
}

BOOL CBEANDlg::ParseBEANCmd(BYTE * pwbuff)
{
	CString sCmd;
	GetDlgItem(IDC_BEANCMDBOX)->GetWindowTextW(sCmd);
//	OutputDebugString(sCmd);

	INT StrLength = sCmd.GetLength(), i = 0, b = 0;
//	WCHAR DBS[100];
//	swprintf_s(DBS, L"StrLength = %d", StrLength);
//	OutputDebugString(DBS);
	if (StrLength == 0)
	{
		PrintLog(L"    !");
		return 1;
	}
	CString sByte;
	while (i < StrLength)
	{
		sByte = sCmd.Mid(i, 2);

		if (GetNum(sByte, &pwbuff[b++]) == FALSE)
		{
			WCHAR DBS[100];
			swprintf_s(DBS, L"Parse error for %S", sByte);
//			OutputDebugString(DBS);
			PrintLog(DBS);
			return 1;
		}
		if (i == 0 && ((pwbuff[b - 1] & 0x0F) + 2) * 3 != StrLength + 1)
		{
			WCHAR DBS[100];
			swprintf_s(DBS, L"   ML (%x)       (ML + 2), %x", (pwbuff[b - 1] & 0x0F) + 2, (StrLength + 1) / 3);
			PrintLog(DBS);
//			OutputDebugString(DBS);
			return 1;
		}
		WCHAR DBS[100];
		swprintf_s(DBS, L"- %x", pwbuff[b - 1]);
		OutputDebugString(DBS);
		i += 3;
	}

	return 0;
}

void CBEANDlg::OnBnClickedButton1()
{
	// TODO: Add your control notification handler code here
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == NULL || ((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == INVALID_HANDLE_VALUE)
	{
//		((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(L":   ");
		//		return;
	}


	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 5;	//CMD_SEND_BEAN_CMD

	CString sPar;
	GetDlgItem(IDC_REPBEAN)->GetWindowTextW(sPar);
	INT ret;
	if (swscanf_s(LPCTSTR(sPar), L"%d", &ret) != 1)
	{
		PrintLog(L"    - ");
		return;
	}
	pwbuff[3] = ret;

	GetDlgItem(IDC_WAITBTWSEND)->GetWindowTextW(sPar);
	if (swscanf_s(LPCTSTR(sPar), L"%d", &ret) != 1)
	{
		PrintLog(L"    ");
		return;
	}
	pwbuff[4] = ret;


	if (ParseBEANCmd(&pwbuff[5]))
		return;
		
	WCHAR DBS[200];
		swprintf_s(DBS, L"pwbuff = %x %x %x %x %x %x %x %x\n", pwbuff[3], pwbuff[4], pwbuff[5], pwbuff[6], pwbuff[7], pwbuff[8], pwbuff[9], pwbuff[10]);
		OutputDebugString(DBS);

//	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		//		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}
}
