// DoI2CCmd.cpp : implementation file
//

#include "stdafx.h"
#include "SVRmeterMFC.h"
#include "DoI2CCmd.h"
#include "afxdialogex.h"
#include "SVRmeterMFCDlg.h"


// CDoI2CCmd dialog

IMPLEMENT_DYNAMIC(CDoI2CCmd, CDialog)

CDoI2CCmd::CDoI2CCmd(CWnd* pParent /*=NULL*/)
	: CDialog(CDoI2CCmd::IDD, pParent)
{
	m_IsTimeSync = TS_NOTS;
}

CDoI2CCmd::~CDoI2CCmd()
{
}

void CDoI2CCmd::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CDoI2CCmd, CDialog)
	ON_BN_CLICKED(IDC_SEND, &CDoI2CCmd::OnBnClickedSend)
	ON_BN_CLICKED(IDC_SYNCTIME, &CDoI2CCmd::OnBnClickedSynctime)
	ON_BN_CLICKED(IDC_GETTIME, &CDoI2CCmd::OnBnClickedGettime)
END_MESSAGE_MAP()


// CDoI2CCmd message handlers

void CDoI2CCmd::PrintLog(LPCTSTR logstr, BOOL bPrintTime, BOOL bPrintNewString)
{
	((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(logstr, bPrintTime, bPrintNewString);
}

BOOL CDoI2CCmd::GetNum(CString str, PBYTE ret)
{
	if (str.GetLength() > 4)
	{
		//		OutputDebugString(L"Err\n");
		return (FALSE);
	}
	//	int
	if (swscanf_s(LPCTSTR(str), L"%x", ret) == 1)
		return (TRUE);
	else
		return (FALSE);
}

void CDoI2CCmd::OnBnClickedSend()
{
	// TODO:     
	CString sCmd, sByte;
	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 0x12;		// Do I2C Cmd
	WCHAR DBS[100];

	GetDlgItem(IDC_CMD)->GetWindowTextW(sCmd);
	INT SpacePos1 = 0, SpacePos2 = 0, i = 3;
	while ((SpacePos1 = sCmd.Find(L" ", SpacePos2)) > 0)
	{
		sByte = sCmd.Mid(SpacePos2, SpacePos1 - SpacePos2);
		if (sByte == (WCHAR)L"RD")
			pwbuff[i++] = 0xFF;

		if (sByte.StringLength(sByte) == 2)
		{
			if (GetNum(sByte, &pwbuff[i++]) == FALSE)
			{
				swprintf_s(DBS, L"Parse error for %S", sByte);
				PrintLog(DBS);
			}
		}
		SpacePos2 = SpacePos1 + 1;
	}
	sByte = sCmd.Mid(SpacePos2, sCmd.StringLength(sCmd) - SpacePos2);
	if (sByte == (WCHAR)L"RD")
		pwbuff[i++] = 0xFF;
	if (sByte.StringLength(sByte) == 2)
	{
		if (GetNum(sByte, &pwbuff[i++]) == FALSE)
		{
			swprintf_s(DBS, L"Parse error for %S", sByte);
			PrintLog(DBS);
		}
	}

	swprintf_s(DBS, L"%x, %x, %x, %x, %x", pwbuff[3], pwbuff[4], pwbuff[5], pwbuff[6], pwbuff[7]);
	PrintLog(DBS);

	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}

}

void CDoI2CCmd::DoI2CCmdResults()
{
	WCHAR DBS[100];
	swprintf_s(DBS, L"%x, Cmd Output: TX: %x, RX: %x, Value: %x", m_RecBuff[1], m_RecBuff[2], m_RecBuff[3], m_RecBuff[4]);
	PrintLog(DBS);
}


void CDoI2CCmd::OnBnClickedSynctime()
{
	// TODO: Add your control notification handler code here
	CString sCmd, sByte;
	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;

	SYSTEMTIME time;
	GetLocalTime(&time);

	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 0x12;		// Do I2C Cmd
	pwbuff[3] = 0x42;		// Do I2C Cmd
	pwbuff[4] = 0x01;		// Do I2C Cmd
	pwbuff[5] = time.wDay;

	m_IsTimeSync = TS_DAY;

	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}
}

void CDoI2CCmd::TimeSyncRes()
{
	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	SYSTEMTIME time;
	GetLocalTime(&time);
	CString Err;
	switch (m_IsTimeSync)
	{
	case TS_DAY:
		pwbuff[4] = 0x02;		// Hour
		pwbuff[5] = time.wHour;
		m_IsTimeSync = TS_HOUR;
		Err = " ";
		break;
	case TS_HOUR:
		pwbuff[4] = 0x03;		// Min
		pwbuff[5] = time.wMinute;
		m_IsTimeSync = TS_MIN;
		Err = " ";
		break;
	case TS_MIN:
		pwbuff[4] = 0x04;		// Sec
		pwbuff[5] = time.wSecond;
		m_IsTimeSync = TS_SEC;
		Err = " ";
		break;
	case TS_SEC:
		pwbuff[4] = 0x01;		// Day
		pwbuff[5] = 0xFF;
		m_IsTimeSync = TS_NOTS;
		Err = " ";
		break;
	case TS_READDAY:
		pwbuff[4] = 0x02;		// Day
		pwbuff[5] = 0xFF;
		m_IsTimeSync = TS_READHOUR;
		m_TimeSync.wDay = m_RecBuff[4];
		Err = " ";
		break;
	case TS_READHOUR:
		pwbuff[4] = 0x03;		
		pwbuff[5] = 0xFF;
		m_IsTimeSync = TS_READMIN;
		m_TimeSync.wHour = m_RecBuff[4];
		Err = " ";
		break;
	case TS_READMIN:
		pwbuff[4] = 0x04;		
		pwbuff[5] = 0xFF;
		m_IsTimeSync = TS_READSEC;
		m_TimeSync.wMinute = m_RecBuff[4];
		Err = " ";
		break;
	case TS_READSEC:
		m_IsTimeSync = TS_NOTS;
		m_TimeSync.wSecond = m_RecBuff[4];
		Err = " ";
		break;

	}
	if (m_IsTimeSync != TS_NOTS)
	{
		if (!m_RecBuff[2] && !m_RecBuff[3])
		{
			if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
			{
				((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
			}
		}
		else
		{
			WCHAR DBS[100];
			swprintf_s(DBS, L": %s, TX: %x, RX: %x, Value: %x", Err, m_RecBuff[2], m_RecBuff[3], m_RecBuff[4]);
			m_IsTimeSync = TS_NOTS;
			PrintLog(DBS);
		}
	}
	else
	{
		WCHAR DBS[100];
		swprintf_s(DBS, L" : %d - %d:%d:%d", m_TimeSync.wDay, m_TimeSync.wHour, m_TimeSync.wMinute, m_TimeSync.wSecond);
		m_IsTimeSync = TS_NOTS;
		PrintLog(DBS);
	}
	//if (m_IsTimeSync == TS_SEC)
}


void CDoI2CCmd::OnBnClickedGettime()
{
	// TODO: Add your control notification handler code here
	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;

	SYSTEMTIME time;
	GetLocalTime(&time);

	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 0x12;		// Do I2C Cmd
	pwbuff[3] = 0x42;		// Address
	pwbuff[4] = 0x01;		// Day
	pwbuff[5] = 0xFF;

	m_IsTimeSync = TS_READDAY;

	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}
}
