
// SVRmeterMFCDlg.cpp :  
//

#include "stdafx.h"
#include "SVRmeterMFC.h"
#include "SVRmeterMFCDlg.h"
#include "afxdialogex.h"
#include <hidsdi.h>
#include <SetupAPI.h>
#include <stdlib.h>
#include <malloc.h>
#define INITGUID 
#include <Devpkey.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


//   CAboutDlg      

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

//   
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    //  DDX/DDV

// 
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


//   CSVRmeterMFCDlg



CSVRmeterMFCDlg::CSVRmeterMFCDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSVRmeterMFCDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_I2CMem.m_pMainDlg = this;
	m_BEANDlg.m_pMainDlg = this;
	m_RWI2CParams.m_pMainDlg = this;
	m_DoI2CCmd.m_pMainDlg = this;
	m_BEANCmd.m_pMainDlg = this;
}

void CSVRmeterMFCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB1, m_Tab);
	DDX_Control(pDX, IDC_CONNECT, m_BtnConnect);
	DDX_Control(pDX, IDC_LOG, m_Log);
	DDX_Control(pDX, IDC_READSTATUS, m_ReadStatus);
	DDX_Control(pDX, IDC_WRITESTATUS, m_WriteStatus);
}

BEGIN_MESSAGE_MAP(CSVRmeterMFCDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_START_BOOTLDR, &CSVRmeterMFCDlg::OnBnClickedStartBootldr)
	ON_NOTIFY(NM_CLICK, IDC_TAB1, &CSVRmeterMFCDlg::OnClickTab1)
	ON_BN_CLICKED(IDC_CONNECT, &CSVRmeterMFCDlg::OnBnClickedConnect)
	ON_BN_CLICKED(IDC_BUTTON4, &CSVRmeterMFCDlg::OnBnClickedButton4)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDOK, &CSVRmeterMFCDlg::OnBnClickedOk)
	ON_MESSAGE(WM_KICKIDLE, OnKickIdle)
	ON_BN_CLICKED(IDC_CANCELRW, &CSVRmeterMFCDlg::OnBnClickedCancelrw)
	ON_BN_CLICKED(IDC_GETREADRES, &CSVRmeterMFCDlg::OnBnClickedGetreadres)
END_MESSAGE_MAP()


//   CSVRmeterMFCDlg

BOOL CSVRmeterMFCDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	//   " ..."   .

	// IDM_ABOUTBOX      .
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	//      .     ,
	//        
	SetIcon(m_hIcon, TRUE);			//  
	SetIcon(m_hIcon, FALSE);		//  

	// TODO:   
	m_I2CMem.Create(IDD_TABI2CMEM, &m_Tab);

	TCITEM tabI2CMem;
	tabI2CMem.mask = TCIF_TEXT | TCIF_PARAM;
	tabI2CMem.lParam = (LPARAM)&m_I2CMem;
	tabI2CMem.pszText = _T("I2C Mem Read/Write");
	m_Tab.InsertItem(0, &tabI2CMem);

	CRect rcItem;
	m_Tab.GetItemRect(0, &rcItem);
	//	char DBS[100];
	//	sprintf_s (DBS, "%d, %d, %d, %d", rcItem.left, rcItem.top, rcItem.right, rcItem.bottom);
	//	OutputDebugStringA(DBS);
	m_I2CMem.SetWindowPos(NULL, rcItem.left, rcItem.bottom + 1, 0, 0, SWP_NOSIZE | SWP_NOZORDER);

	m_DoI2CCmd.Create(IDD_DOI2CCMD, &m_Tab);
	TCITEM tabI2CCmd;
	tabI2CCmd.mask = TCIF_TEXT | TCIF_PARAM;
	tabI2CCmd.lParam = (LPARAM)&m_DoI2CCmd;
	tabI2CCmd.pszText = _T("Do Any I2C Cmd");
	m_Tab.InsertItem(1, &tabI2CCmd);

	m_Tab.GetItemRect(0, &rcItem);
	m_DoI2CCmd.SetWindowPos(NULL, rcItem.left, rcItem.bottom + 1, 0, 0, SWP_NOSIZE | SWP_NOZORDER);

	m_RWI2CParams.Create(IDD_RWPARAMETERS, &m_Tab);
	TCITEM tabRWI2CParams;
	tabRWI2CParams.mask = TCIF_TEXT | TCIF_PARAM;
	tabRWI2CParams.lParam = (LPARAM)&m_RWI2CParams;
	tabRWI2CParams.pszText = _T("RW I2C Params");
	m_Tab.InsertItem(2, &tabRWI2CParams);

	m_Tab.GetItemRect(0, &rcItem);
	m_RWI2CParams.SetWindowPos(NULL, rcItem.left, rcItem.bottom + 1, 0, 0, SWP_NOSIZE | SWP_NOZORDER);

	// *** BEAN Tab Init ***
	m_BEANDlg.Create(IDD_BEANDLG, &m_Tab);

	TCITEM tabBEANDlg;
	tabBEANDlg.mask = TCIF_TEXT | TCIF_PARAM;
	tabBEANDlg.lParam = (LPARAM)&m_BEANDlg;
	tabBEANDlg.pszText = _T("BEAN");
	m_Tab.InsertItem(3, &tabBEANDlg);

	m_Tab.GetItemRect(0, &rcItem);
	m_BEANDlg.SetWindowPos(NULL, rcItem.left, rcItem.bottom + 1, 0, 0, SWP_NOSIZE | SWP_NOZORDER);

	m_BEANDlg.m_T0CON.SetWindowTextW(L"43");
	m_BEANDlg.m_TMR0L.SetWindowTextW(L"75");
	m_BEANDlg.GetDlgItem(IDC_REPBEAN)->SetWindowTextW(L"1");
	m_BEANDlg.GetDlgItem(IDC_WAITBTWSEND)->SetWindowTextW(L"10");

	// *** BEANCmd Tab ***
	m_BEANCmd.Create(IDD_BEANCMD, &m_Tab);

	TCITEM tabBEANCmd;
	tabBEANCmd.mask = TCIF_TEXT | TCIF_PARAM;
	tabBEANCmd.lParam = (LPARAM)&m_BEANCmd;
	tabBEANCmd.pszText = _T("BEAN Cmd");
	m_Tab.InsertItem(4, &tabBEANCmd);

	m_Tab.GetItemRect(0, &rcItem);
	m_BEANCmd.SetWindowPos(NULL, rcItem.left, rcItem.bottom + 1, 0, 0, SWP_NOSIZE | SWP_NOZORDER);

	// *** Tab Show/Hide ***
	m_I2CMem.ShowWindow(SW_SHOW);
	m_DoI2CCmd.ShowWindow(SW_HIDE);
	m_BEANDlg.ShowWindow(SW_HIDE);
	m_BEANCmd.ShowWindow(SW_HIDE);

	((CButton *)m_I2CMem.GetDlgItem(IDC_READTOX55))->SetCheck(1);
	m_I2CMem.GetDlgItem(IDC_DELAYMS)->SetWindowTextW(L"10");

	m_RWI2CParams.GetDlgItem(IDC_I2CHOLDTMR)->SetWindowTextW(L"255");

	//RWParam(0, NULL, 0);

	m_hUSBDev = NULL;

	m_hReadEvent = CreateEvent(NULL, TRUE, FALSE, L"USBReadCompEvent");
	if (m_hReadEvent == NULL)
	{
		WCHAR DBS[30];
		swprintf_s(DBS, L"CreateEvent for Read Event error: %d \n", GetLastError());
		PrintLog(DBS);
	}
	m_hWriteEvent = CreateEvent(NULL, TRUE, FALSE, L"USBWriteCompEvent");
	if (m_hWriteEvent == NULL)
	{
		WCHAR DBS[30];
		swprintf_s(DBS, L"CreateEvent for Write Event error: %d", GetLastError());
		PrintLog(DBS);
	}


	PrintLog(L"Started/");
	CFileException e;
	TCHAR* pszFileName = _T("C:\\Users\\fedor\\OneDrive\\Avto\\\\Projects\\SVRmeterMFC\\Params.txt");
	if (!m_fParFile.Open(pszFileName, CFile::modeReadWrite, &e))
	{
		CString Err;
		Err.Format(_T("    %d"), e.m_cause);
		PrintLog(Err);
	}
	char cAddrH[5], cAddrL[5];
	INT ret;
	m_fParFile.Read(cAddrH, 4);
	cAddrH[4] = '\0';
	m_fParFile.Seek(2, CFile::current);
	m_fParFile.Read(cAddrL, 4);
	cAddrL[4] = '\0';
	//OutputDebugStringA(cAddrL);
	CString s;
	if (sscanf_s(cAddrH, "0x%x", &ret) == 1)
	{
		m_I2CMem.m_AddrHStart = ret;
		s.Format(_T("0x%x"), ret);
		m_I2CMem.GetDlgItem(IDC_ADDRHSTART)->SetWindowTextW(s);
	}
	if (sscanf_s(cAddrL, "0x%x", &ret) == 1)
	{
		m_I2CMem.m_AddrLStart = ret;
		s.Format(_T("0x%x"), ret);
		m_I2CMem.GetDlgItem(IDC_ADDRLSTART)->SetWindowTextW(s);
	}
	return TRUE;  //   TRUE,      
}

void CSVRmeterMFCDlg::RWParam(BYTE Param, LPCTSTR data, BOOL Read)
{
	WCHAR buff[MAX_PATH];
	memset(buff, 0, MAX_PATH);
	::GetModuleFileName(NULL, buff, sizeof(buff));
	CString strFolder = buff;
	strFolder = strFolder.Left(strFolder.ReverseFind(_T('\\')) + 1);
	HANDLE hParamFile = CreateFile(strFolder + L"SVRMeter.ini",
		GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL,        // no SECURITY_ATTRIBUTES structure
		OPEN_EXISTING, // No special create flags
		0,   // Open device as non-overlapped so we can get data
		NULL);       // No template file
	WCHAR DB[100];
	swprintf_s(DB, L"CreateFile (ini): %d \n", GetLastError());
	OutputDebugString(DB);

	if (!ReadFile(hParamFile, buff, MAX_PATH, NULL, NULL))
	{
		swprintf_s(DB, L"ReadFile (ini): %d \n", GetLastError());
		OutputDebugString(DB);
		return;
	}
}

BOOL CSVRmeterMFCDlg::USBWrite(VOID)
{
	ZeroMemory(&m_USBWriteOvl, sizeof(OVERLAPPED));

	m_USBWriteOvl.hEvent = m_hWriteEvent;

	if (m_hWriteEvent == NULL)
	{
		PrintLog(L"WriteEvent handle == NULL!");
		return FALSE;
	}

	WCHAR DBS[50];
	if (WriteFile(m_hUSBDev, (LPCVOID)m_bwrbuff, 65, NULL, &m_USBWriteOvl) == 0)
	{
		DWORD err = GetLastError();
		if (err != ERROR_IO_PENDING)
		{
			swprintf_s(DBS, L"WriteFile Err: %d \n", err);
			PrintLog(DBS);
			OutputDebugString(DBS);
			return FALSE;
		}
	}

	return TRUE;
}

BOOL CSVRmeterMFCDlg::USBRead(VOID)
{
	ZeroMemory(&m_brdbuff, 65);
	ZeroMemory(&m_USBReadOvl, sizeof(OVERLAPPED));

	if (m_hReadEvent == NULL)
	{
		PrintLog(L"ReadEvent handle == NULL!");
		return FALSE;
	}
	
	m_USBReadOvl.hEvent = m_hReadEvent;

	WCHAR DBS[50];
	if (ReadFile(m_hUSBDev, m_brdbuff, 65, NULL, &m_USBReadOvl) == 0)
	{
		DWORD err = GetLastError();
		if (err != ERROR_IO_PENDING)
		{
			swprintf_s(DBS, L"ReadFileEx Error: %d \n", GetLastError());
			OutputDebugString(DBS);
			return FALSE;
		}
	}
	return TRUE;

}

void CSVRmeterMFCDlg::PrintLog(LPCTSTR logstr, BOOL bPrintTime, BOOL bPrintNewString)
{
	SYSTEMTIME time;
	GetLocalTime(&time);
	m_Log.SetSel(-1, -1);
	WCHAR Log[900];
	if (bPrintTime && bPrintNewString)
		swprintf_s(Log, L"%d:%d:%d - %s\n", time.wHour, time.wMinute, time.wSecond, logstr);
	if (bPrintTime)
		swprintf_s(Log, L"%d:%d:%d - %s", time.wHour, time.wMinute, time.wSecond, logstr);
	if (bPrintNewString)
		swprintf_s(Log, L"%s\n", logstr);
	if (!bPrintTime && !bPrintNewString)
		swprintf_s(Log, L"%s", logstr);
	m_Log.ReplaceSel(Log);

}

void CSVRmeterMFCDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

//            ,
//    .    MFC,     ,
//      .

void CSVRmeterMFCDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); //    

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		//      
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		//  
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

//          
//   .
HCURSOR CSVRmeterMFCDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

VOID CALLBACK CSVRmeterMFCDlg::USBFileIOCompletionRoutine(DWORD dwErrorCode, DWORD dwNumberOfBytesTransfered, LPOVERLAPPED lpOverlapped)
{

}

void CSVRmeterMFCDlg::OnBnClickedStartBootldr()
{
	// TODO:     
	//OutputDebugStringA("-- Button Pressed! --\n");
	UINT nDevIndex = 0;
	char DB[100];


	DWORD size = 100;


//	WCHAR* SVRpath = L"\\\\?\\hid#vid_04d8&pid_0042#6&3ae3eaba&1&0000#{4d1e55b2-f16f-11cf-88cb-001111000030}";
	WCHAR* SVRpath = L"\\\\?\\hid#vid_04d8&pid_003f#6&94490fa&0&0000#{4d1e55b2-f16f-11cf-88cb-001111000030}";

	OutputDebugString(SVRpath);
	OutputDebugStringA("\n");

	HANDLE hSVR;
/*	hSVR = CreateFile(SVRpath,
		GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL,        // no SECURITY_ATTRIBUTES structure
		OPEN_EXISTING, // No special create flags
		FILE_FLAG_OVERLAPPED,   // Open device as non-overlapped so we can get data
		NULL);       // No template file
		*/
	hSVR = CreateFile(SVRpath,
		GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL,        // no SECURITY_ATTRIBUTES structure
		OPEN_EXISTING, // No special create flags
		FILE_FLAG_OVERLAPPED,   // Open device as non-overlapped so we can get data
		NULL);       // No template file
		
	if (hSVR == INVALID_HANDLE_VALUE)
	{
		sprintf_s(DB, "CreateFile: %d \n", GetLastError());
		OutputDebugStringA(DB);
	}

	m_bwrbuff[0] = 0x0;
	m_bwrbuff[1] = 0x80;

	ZeroMemory(&m_USBWriteOvl, sizeof(OVERLAPPED));


	if (WriteFileEx(m_hUSBDev, (LPCVOID)m_bwrbuff, 65, &m_USBWriteOvl, USBIOCompRoutine) == FALSE)
	{
		sprintf_s(DB, "WriteFile Err: %d \n", GetLastError());
		OutputDebugStringA(DB);
	}
/*	else
	{
		sprintf_s(DB, "NumBytesWritten: %d \n", size);
		OutputDebugStringA(DB);
	}*/

/*	BYTE prb[65];
	ZeroMemory(prb, 65);
	*/
	
	CloseHandle(hSVR);

}


/*
void CSVRmeterMFCDlg::OnSelchangeI2ccmdlist()
{
	// TODO: Add your control notification handler code here
	CString strItem;
	m_List.GetText(m_List.GetCurSel(), strItem);
	m_Cmd.SetWindowTextW(LPCTSTR(strItem));
}


void CSVRmeterMFCDlg::OnClickedWrite()
{
	// TODO: Add your control notification handler code here
	
		m_DataToWrite.SetReadOnly((BOOL)!m_Write.GetCheck());
	
}


void CSVRmeterMFCDlg::OnChangeWritedata()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
	CString text;
//	m_DataToWrite.GetWindowTextW(text);
	//text.fo
}


void CSVRmeterMFCDlg::OnClickedReadcontiniously()
{
	// TODO: Add your control notification handler code here
	if (m_ReadCont.GetCheck())
		m_ButtonRead.SetWindowTextW(L"");
	else
		m_ButtonRead.SetWindowTextW(L"");

}


void CSVRmeterMFCDlg::OnClickedButtonread()
{
	// TODO: Add your control notification handler code here
}
*/

void CSVRmeterMFCDlg::OnClickTab1(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here
	m_DoI2CCmd.ShowWindow(SW_HIDE);
	m_I2CMem.ShowWindow(SW_HIDE);
	m_RWI2CParams.ShowWindow(SW_HIDE);
	m_BEANDlg.ShowWindow(SW_HIDE);
	m_BEANCmd.ShowWindow(SW_HIDE);

	for (int i = 0; i<4; i++)
	{
		m_Tab.HighlightItem(i, FALSE);
	}
	switch (m_Tab.GetCurSel())
	{
		case 0: 
			m_I2CMem.ShowWindow(SW_SHOW);
			break;
		case 1: 
			m_DoI2CCmd.ShowWindow(SW_SHOW);
			break;
		case 2:
			m_RWI2CParams.ShowWindow(SW_SHOW);
			break;
		case 3:
			m_BEANDlg.ShowWindow(SW_SHOW);
			break;
		case 4:
			m_BEANCmd.ShowWindow(SW_SHOW);
			break;
	}
	m_Tab.HighlightItem(m_Tab.GetCurSel(), TRUE);
	
	*pResult = 0;
}


void CSVRmeterMFCDlg::OnBnClickedConnect()
{
	// TODO:     
	if (m_hUSBDev != NULL && m_hUSBDev != INVALID_HANDLE_VALUE)
	{
		CloseHandle(m_hUSBDev);
		m_hUSBDev = NULL;
	}

	//   
	WCHAR* SVRpath = L"\\\\?\\hid#vid_04d8&pid_003f#6&94490fa&0&0000#{4d1e55b2-f16f-11cf-88cb-001111000030}";
	//   
	//WCHAR* SVRpath = L"\\\\?\\hid#vid_04d8&pid_003f#6&94490fa&0&0000#{4d1e55b2-f16f-11cf-88cb-001111000030}";
	//PrintLog(SVRpath);

	m_hUSBDev = CreateFile(SVRpath,
		GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL,        // no SECURITY_ATTRIBUTES structure
		OPEN_EXISTING, // No special create flags
//		0,
		FILE_FLAG_OVERLAPPED,   // Open device as non-overlapped so we can get data
		NULL);       // No template file

	WCHAR DB[100];
		swprintf_s(DB, L"CreateFile: %d", GetLastError());
		PrintLog(DB);
}


void CSVRmeterMFCDlg::OnBnClickedButton4()
{
	// TODO:     
	//OutputDebugStringA("-- Button Pressed! --\n");
	GUID HIDGUID;
	HDEVINFO DevInfo;
	SP_DEVICE_INTERFACE_DATA DevIntData;
	UINT nDevIndex = 0;
	char DB[100];


	HidD_GetHidGuid(&HIDGUID);
	DevInfo = SetupDiGetClassDevs(&HIDGUID, NULL, NULL, (DIGCF_PRESENT | DIGCF_DEVICEINTERFACE));
	if (DevInfo == INVALID_HANDLE_VALUE)
	{
		sprintf_s(DB, "SetupDiGetClassDevs: %d \n", GetLastError());
		OutputDebugStringA(DB);
	}
	DWORD size = 100;
	ZeroMemory(&DevIntData, sizeof(SP_DEVICE_INTERFACE_DATA));
	DevIntData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);

	SP_DEVICE_INTERFACE_DETAIL_DATA *pDevIntDet;
	pDevIntDet = (SP_DEVICE_INTERFACE_DETAIL_DATA*)malloc(300);

	while (SetupDiEnumDeviceInterfaces(DevInfo, NULL, &HIDGUID, nDevIndex, &DevIntData))
	{
		OutputDebugStringA("-- In While --");
		nDevIndex++;
		
		/*if (SetupDiGetDeviceInterfaceProperty(
		DevInfo,
		&DevIntData,
		&DEVPKEY_DeviceInterface_FriendlyName,
		&proptype,
		(PBYTE)buff,
		100,
		&size,
		0))
		{

		//sprintf_s(buff, "%d --", pRIDL[nDevices].dwType);
		//_tprintf(TEXT("    Device Manufacturer: \"%ls\"\n"), buff);
		OutputDebugStringW(buff);
		OutputDebugStringW(L"\n");
		}
		else
		{
		sprintf_s(DB, "-- SetupDiGetDeviceProperty: %d \n", GetLastError());
		OutputDebugStringA(DB);

		}*/
	
		ZeroMemory(pDevIntDet, sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA));
		pDevIntDet->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
		if (SetupDiGetDeviceInterfaceDetail(DevInfo, &DevIntData, pDevIntDet, 300, &size, NULL))
		{
			OutputDebugStringW(pDevIntDet->DevicePath);
			OutputDebugStringW(L"\n");
			//StrCpyW(DevPath, pDevIntDet->DevicePath);
		}
		else
		{
			sprintf_s(DB, "-- SetupDiGetDeviceInterfaceDetail: %d \n", GetLastError());
			OutputDebugStringA(DB);

		}
	}

	sprintf_s(DB, "-- SetupDiEnumDeviceInterfaces: %d \n", GetLastError());
	OutputDebugStringA(DB);
	free(pDevIntDet);
	
	BYTE *pwbuff = m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x23;	// 0
	pwbuff[2] = 0x4;	// 1
	pwbuff[3] = 0x0;	// 2
	pwbuff[4] = 8;		// 3
	if (USBWrite())
	{
		USBRead();
	}

/*	DWORD ReadSignal = WaitForSingleObject(m_hReadEvent, INFINITE);
	if (ReadSignal == WAIT_OBJECT_0)
	{
		WCHAR DBS[100];
		swprintf_s(DBS, L"2: %x, 3: %x, 4: %x, 5: %x", m_brdbuff[2], m_brdbuff[3], m_brdbuff[4], m_brdbuff[5]);
		PrintLog(DBS);
	}*/

}


void CSVRmeterMFCDlg::CloseUSBDev()
{
	OutputDebugStringA("CloseUSBDev -- ");
	if (m_hUSBDev != NULL && m_hUSBDev != INVALID_HANDLE_VALUE)
	{
		HRESULT res = CloseHandle(m_hUSBDev);
		char DB[100];
		sprintf_s(DB, "CloseHandle: %d \n", res);
		OutputDebugStringA(DB);
		m_hUSBDev = NULL;
	}

}

void CSVRmeterMFCDlg::WriteParams()
{
	OutputDebugString(L"Close I2C Mem\n");
	CString s;
	INT ret = 0;
	char str[10];
	m_fParFile.Seek(0, CFile::begin);
	m_I2CMem.GetDlgItem(IDC_ADDRHSTART)->GetWindowTextW(s);
	if (swscanf_s(LPCTSTR(s), L"0x%x", &ret) == 1)
	{
		sprintf_s(str, "0x%02x", ret);
		OutputDebugStringA(str);
		m_fParFile.Write(str, 4);
	}
	m_I2CMem.GetDlgItem(IDC_ADDRLSTART)->GetWindowTextW(s);
	if (swscanf_s(LPCTSTR(s), L"0x%x", &ret) == 1)
	{
		sprintf_s(str, "\r\n0x%02x", ret);
		OutputDebugStringA(str);
		m_fParFile.Write(str, 6);
	}
}

void CSVRmeterMFCDlg::OnClose()
{
	// TODO:        
	CloseUSBDev();
	WriteParams();
	CDialog::OnClose();
}


void CSVRmeterMFCDlg::OnBnClickedOk()
{
	// TODO:     
	CloseUSBDev();
	WriteParams();
	CDialog::OnOK();
}

LRESULT CSVRmeterMFCDlg::OnKickIdle(WPARAM, LPARAM)
{
	WCHAR s[100], DBS[50];
	DWORD bytes;
	GetOverlappedResultEx(m_hWriteEvent, &m_USBWriteOvl, &bytes, 0, FALSE);
	DWORD WriteSignal = WaitForSingleObject(m_hWriteEvent, 0);
	swprintf_s(s, L"GetOvRes %d, Wait %d, Error %d ", GetLastError(), WaitForSingleObject(m_hWriteEvent, 0), GetLastError());
	if (WriteSignal == WAIT_OBJECT_0)
	{
//		PrintLog(L"Write Finished! ");
		ResetEvent(m_hWriteEvent);
	}
	m_WriteStatus.SetWindowTextW(s);

	DWORD ReadSignal = WaitForSingleObject(m_hReadEvent, 0);
	if (ReadSignal == WAIT_OBJECT_0)
	{
//		swprintf_s(DBS, L"Read Finished!, m_brdbuff[1]: %d", m_brdbuff[1]);
//		PrintLog(DBS);

		ResetEvent(m_hReadEvent);

		if (m_brdbuff[1] != 0)
		{
			switch (m_brdbuff[1])
			{
			case 1:		// CMD_BEAN
			case 2:		// CMD_BEAN_DIG
			case 3:		// CMD_BEAN_CODE
			case 4:		// CMD_CODE_SORT
				CopyMemory(m_BEANDlg.bRdBuff, m_brdbuff, 65);
				m_BEANDlg.GetBEANResults();
				USBRead();
				break;
			case 0x10:	// CMD_I2C_READMEM
				CopyMemory(m_I2CMem.m_bRdBuff, m_brdbuff, 65);
				m_I2CMem.GetI2CResults();
				break;
			case 0x11:	// CMD_I2C_TESTINOUT
				CopyMemory(m_RWI2CParams.m_bRdBuff, m_brdbuff, 65);
//				if (m_brdbuff[2] == 0x1)
					m_RWI2CParams.GetI2CResults();
		//		USBRead();
				break;
			case 0x12:	// DO_I2C_CMD
				CopyMemory(m_DoI2CCmd.m_RecBuff, m_brdbuff, 65);
				if (m_DoI2CCmd.m_IsTimeSync)
					m_DoI2CCmd.TimeSyncRes();
				else
					m_DoI2CCmd.DoI2CCmdResults();
				break;
			case 0x24:
			{
						 WCHAR DBS[100];
						 swprintf_s(DBS, L"2: %x, 3: %x, 4: %x, 5: %x", m_brdbuff[2], m_brdbuff[3], m_brdbuff[4], m_brdbuff[5]);
						 PrintLog(DBS);
			}
				break;
			default:
				break;
			}
		}

	}
	GetOverlappedResultEx(m_hReadEvent, &m_USBReadOvl, &bytes, 0, FALSE);
	swprintf_s(s, L"GetOvRes %d, Wait %d, Error %d, bts: %d ", GetLastError(), WaitForSingleObject(m_hReadEvent, 0), GetLastError(), bytes);

	m_ReadStatus.SetWindowTextW(s);


	// your code here
	return FALSE;
}

VOID CALLBACK USBIOCompRoutine(DWORD dwErrorCode, DWORD dwNumberOfBytesTransfered, LPOVERLAPPED lpOverlapped)
{
	WCHAR DBS[100];
	swprintf_s(DBS, L"USBIOComplite: %d, %d \n", dwErrorCode, dwNumberOfBytesTransfered);
	return;
}


void CSVRmeterMFCDlg::OnBnClickedCancelrw()
{
	// TODO:     
	if (CHECKUSBHANDLE)
		CancelIo(m_hUSBDev);
}


void CSVRmeterMFCDlg::OnBnClickedGetreadres()
{
	WCHAR DBS[100];
	swprintf_s(DBS, L" 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x", m_brdbuff[0], m_brdbuff[1], m_brdbuff[2], m_brdbuff[3], m_brdbuff[4], m_brdbuff[5], m_brdbuff[6], m_brdbuff[7], m_brdbuff[8], m_brdbuff[9], m_brdbuff[10], m_brdbuff[11]);
	PrintLog(DBS);
}



