// I2CMem.cpp : implementation file
//

#include "stdafx.h"
#include "SVRmeterMFC.h"
#include "I2CMem.h"
#include "afxdialogex.h"
#include "SVRmeterMFCDlg.h"


// CI2CMem dialog

IMPLEMENT_DYNAMIC(CI2CMem, CDialog)

CI2CMem::CI2CMem(CWnd* pParent /*=NULL*/)
	: CDialog(CI2CMem::IDD, pParent)
{
	m_ReadCount = 0;
}

CI2CMem::~CI2CMem()
{
}

void CI2CMem::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//	DDX_Radio(pDX, IDC_READTOX55, m_ReadTo);
	DDX_Control(pDX, IDC_FILETOLOG, m_FileToLog);
}


BEGIN_MESSAGE_MAP(CI2CMem, CDialog)
	ON_BN_CLICKED(IDC_READ, &CI2CMem::OnClickedRead)
	ON_BN_CLICKED(IDC_OPENFILE, &CI2CMem::OnBnClickedOpenfile)
	ON_WM_CLOSE()
END_MESSAGE_MAP()


// CI2CMem message handlers

BOOL CI2CMem::GetNum(CString str, PBYTE ret)
{
	if (str.GetLength() > 4)
	{
//		OutputDebugString(L"Err\n");
		return (FALSE);
	}
//	int
	if (swscanf_s(LPCTSTR(str), L"0x%x", ret) == 1)
		return (TRUE);
	else
		return (FALSE);
}

void CI2CMem::PrintLog(LPCTSTR logstr, BOOL bPrintTime = 1, BOOL bPrintNewString = 1)
{
	((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(logstr, bPrintTime, bPrintNewString);
}

void CI2CMem::OnClickedRead()
{
	// TODO: Add your control notification handler code here
	BYTE i = 0;
	m_bRdBuff[4] = 0x0d;
	m_bRdBuff[5] = 0xcc;
	m_bRdBuff[6] = 0xbb;
	m_bRdBuff[7] = 0xaa;
	m_bRdBuff[8] = 0xB3;

	CString s1, spins;
	BYTE TEB, day, hour;
	BYTE min;
	BYTE EngSt;
	BYTE BinSt;
	BYTE pins;
	double Ubatt = 0;
	double Teng = 0;


	if ((m_bRdBuff[i + 4] & 0xF8) == 0x38 || (m_bRdBuff[i + 4] & 0xF8) == 0x28 || (m_bRdBuff[i + 4] & 0xF8) == 0x18 || (m_bRdBuff[i + 4] & 0xF8) == 0x8)
	{
		TEB = (m_bRdBuff[i + 4] & 0x10);
		day = ((m_bRdBuff[i + 4] & 0x7) << 5) | ((m_bRdBuff[i + 4 + 1] & 0xF8) >> 3);
		hour = ((m_bRdBuff[i + 4 + 1] & 0x7) << 2) | ((m_bRdBuff[i + 4 + 2] & 0xC0) >> 6);
		EngSt = (m_bRdBuff[i + 4 + 2] & 0x38) >> 3;
		BinSt = (m_bRdBuff[i + 4 + 2] & 0x7);
		s1.Format(_T("%s %d	%02d:00:00, %d - %d, (%02x, %02x, %02x) %.2f  (%02x), %s, %.2f  (%02x)"), ((m_bRdBuff[i + 4] & 0x20) ? L"  " : L""), day, hour, EngSt, BinSt, m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], Ubatt, m_bRdBuff[i + 4 + 3], (TEB ? L" " : L""), Teng, m_bRdBuff[i + 4 + 4]);
	}
	// NEW ERR/ ALL OK
	if ((m_bRdBuff[i + 4] & 0xFE) == 0x2)
	{
		hour = ((m_bRdBuff[i + 4] & 0x1) << 4) | ((m_bRdBuff[i + 4 + 1] & 0xF0) >> 4);
		min = ((m_bRdBuff[i + 4 + 1] & 0xF) << 2) | ((m_bRdBuff[i + 4 + 2] & 0xC0) >> 6);
		EngSt = (m_bRdBuff[i + 4 + 2] & 0x38) >> 3;
		BinSt = (m_bRdBuff[i + 4 + 2] & 0x7);
		s1.Format(_T("   	%02d:%02d:00, %d - %d, (%02x, %02x, %02x) %.2f  (%02x),    , %.2f  (%02x)"), hour, min, EngSt, BinSt, m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], Ubatt, m_bRdBuff[i + 4 + 3], Teng, m_bRdBuff[i + 4 + 4]);
	}
	// TEB High <-> Low format
	if ((m_bRdBuff[i + 4] & 0xFE) == 0)
	{
		hour = ((m_bRdBuff[i + 4 + 1] & 0xF8) >> 3);
		min = ((m_bRdBuff[i + 4 + 1] & 0x7) << 3) | ((m_bRdBuff[i + 4 + 2] & 0xE0) >> 5);
		TEB = (m_bRdBuff[i + 4] & 0x1);
		s1.Format(_T("   	%02d:%02d:00,      , (%02x, %02x, %02x) %.2f  (%02x), %s, %.2f  (%02x)"), hour, min, m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], Ubatt, m_bRdBuff[i + 4 + 3], (TEB ? L" " : L""), Teng, m_bRdBuff[i + 4 + 4]);
	}


	if (m_bRdBuff[i + 4] & 0x80)	// Pins Format
	{
		hour = ((m_bRdBuff[i + 4] & 0x7C) >> 2);
		min = ((m_bRdBuff[i + 4] & 0x3) << 4) | ((m_bRdBuff[i + 4 + 1] & 0xF0) >> 4);
		EngSt = (m_bRdBuff[i + 4 + 1] & 0xE) >> 1;
		BinSt = ((m_bRdBuff[i + 4 + 1] & 0x1) << 2) | ((m_bRdBuff[i + 4 + 2] & 0xC0) >> 6);
		pins = (m_bRdBuff[i + 4 + 2] & 0x3F);
		Ubatt = (UBATT_R1 + UBATT_R2) * ((float)m_bRdBuff[i + 4 + 3]) * (5.0 / 512.0) / UBATT_R2;
		Teng = 512 + (((LONG)m_bRdBuff[i + 4 + 4]) << 1);
		Teng = ((Teng * (TENG_R1 + TENG_R2)) - (1023.0 * TENG_R2)) / (1023.0 - Teng);

		s1.Format(_T("   	%02d:%02d:00, %d - %d, '"), hour, min, EngSt, BinSt);

		if (pins & 0x20)		// 210 - IG
		{
			s1 += "210 ";
		}
		if (pins & 0x10)
		{
			s1 += "25 ";
		}
		if (pins & 0x8)
		{
			s1 += "1819 ";
		}
		if (pins & 0x4)
		{
			s1 += "23 ";
		}
		if (pins & 0x2)
		{
			s1 += "14-16 ";
		}
		if (pins & 0x1)
		{
			s1 += "21 ";
		}

		spins.Format(_T("' (%02x, %02x, %02x), %.2f  (%02x), %.2f  (%02x)"), m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], Ubatt, m_bRdBuff[i + 4 + 3], Teng, m_bRdBuff[i + 4 + 4]);
		s1 += spins;
		//s1.Format(_T("%x	%x	%x	%x	%x\n"), m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], m_bRdBuff[i + 4 + 3], m_bRdBuff[i + 4 + 4]);		// 1 - CmdInPr, 2 - DataLenght, 3 - Error code

	}

	OutputDebugString(LPCTSTR(s1));

	/*
	union
	{
		struct 
		{
			BYTE d[5];
		} D;
		struct 
		{
			BYTE a:5;
			BYTE day : 8;
			BYTE hour : 5;
			BYTE EngSt : 3;
			BYTE BinSt : 3;
			BYTE Ubatt : 8;
			BYTE TEB : 1;
			BYTE Teng : 7;
		} vars ;
	} OffUn;

	OffUn.D.d[0] = 0x72;
	OffUn.D.d[1] = 0x22;
	OffUn.D.d[2] = 0x8F;
	OffUn.D.d[3] = 0x1E;
	OffUn.D.d[4] = 0xDA;

	*/
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == NULL || ((CSVRmeterMFCDlg*)m_pMainDlg)->m_hUSBDev == INVALID_HANDLE_VALUE)
	{
		PrintLog(L":   ");
		return;
	}

	OpenI2CFile();

	WCHAR DBS[100];

	BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;
	pwbuff[0] = 0x0;
	pwbuff[1] = 0x21;
	pwbuff[2] = 0x10;
	CString str;
	((CEdit *)GetDlgItem(IDC_ADDRHSTART)) ->GetWindowTextW(str);

	if (!GetNum(str, &pwbuff[3]))
	{
		PrintLog(L"AddrH   (   ,   0xHH)!");
		return;
	}
	m_AddrHStart = pwbuff[3];
	GetDlgItem(IDC_ADDRLSTART)->GetWindowTextW(str);
	if (!GetNum(str, &pwbuff[4]))
	{
		PrintLog(L"AddrL   (   ,   0xHH)!");
		return;
	}
	m_AddrLStart = pwbuff[4];
	pwbuff[5] = 30;
	
	if (((CButton *)GetDlgItem(IDC_READTOX55))->GetCheck())
	{
		m_x55 = 1;
	}
	if (((CButton *)GetDlgItem(IDC_READTOADDRHL))->GetCheck())
	{
		m_x55 = 0x0;

		GetDlgItem(IDC_ADDRHSTOP)->GetWindowTextW(str);
		if (!GetNum(str, &m_AddrHStop))
		{
			PrintLog(L"AddrH Stop   (   ,   0xHH)!");
			return;
		}
		GetDlgItem(IDC_ADDRLSTOP)->GetWindowTextW(str);
		if (!GetNum(str, &m_AddrLStop))
		{
			PrintLog(L"AddrL Stop   (   ,   0xHH)!");
			return;
		}
	}
	/*
	GetDlgItem(IDC_DELAYMS)->GetWindowTextW(str);
	if (swscanf_s(LPCTSTR(str), L"%d", &pwbuff[8]) != 1)
	{
		PrintLog(L"Delay Ms   (   ,   0 - 256)!");
		return;
	}
	*/
	swprintf_s(DBS, L" %d, %d, %d, %d, %d, %d \n", pwbuff[3], pwbuff[4], pwbuff[5], m_x55, pwbuff[7], pwbuff[8]);
	OutputDebugString(DBS);

	//OutputDebugString(L"AAAA");

	//   
	if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
	{
		((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
	}

}

void CI2CMem::OpenI2CFile()
{
	//if (((CButton *)GetDlgItem(IDC_LOGTOFILE))->GetCheck())
	{
		CString sI2CFileName;
		m_FileToLog.GetWindowText(sI2CFileName);
		m_hI2CLogFile = CreateFile(sI2CFileName,
			GENERIC_READ | GENERIC_WRITE,
			FILE_SHARE_READ | FILE_SHARE_WRITE,
			NULL,        // no SECURITY_ATTRIBUTES structure
			OPEN_ALWAYS, // No special create flags
			0,   // Open device as non-overlapped so we can get data
			NULL);       // No template file

		DWORD err = GetLastError();
		if (err != 0 && !(err == 183 && MessageBox(L"  . ?", NULL, MB_ICONEXCLAMATION | MB_YESNO) == IDYES))
		{
			WCHAR DBS[30];
			swprintf_s(DBS, L"Open Log File err: %d", err);
			((CSVRmeterMFCDlg*)m_pMainDlg)->PrintLog(DBS);
			if (m_hI2CLogFile != INVALID_HANDLE_VALUE)
			{
				CloseHandle(m_hI2CLogFile);
				m_hI2CLogFile = NULL;
			}
		}
		else
		{
			SYSTEMTIME time;
			GetLocalTime(&time);
			CHAR DBS[50];

			sprintf_s(DBS, "Log Started: %d:%d:%d\r\n", time.wHour, time.wMinute, time.wSecond);
			WriteFile(m_hI2CLogFile, DBS, strlen(DBS)*sizeof(CHAR), NULL, NULL);
		}
	}
	//else
	{
		//m_hI2CLogFile = NULL;
	}


}

#define PINS_FORMAT	1
#define OFF_FORMAT	2
#define ERR_FORMAT	3

void CI2CMem::GetI2CResults()
{
	CString scr, s1, spins;
	CStringA file;
	INT x5 = m_AddrHStart * 256 + m_AddrLStart;
	x5 = x5 - (((INT)(x5 / 5)) * 5);
//	INT Format;
	BYTE day, hour, min, BinSt, EngSt, pins, TEB;
	double Ubatt, Teng;
	OutputDebugString(L"I2CMemResults");
	//if (m_ReadCount >= 5)
	//	return;
	switch (m_bRdBuff[1])
	{
	case 0x10:	// CMD_I2C_READMEM

		union
		{
			struct
			{
				BYTE AddrL;
				BYTE AddrH;
			};
			UINT16 Addr;
		} Start, Stop;
		Start.AddrH = m_AddrHStart;
		Start.AddrL = m_AddrLStart;
		Stop.AddrH = m_AddrHStop;
		Stop.AddrL = m_AddrLStop;

		if (m_bRdBuff[3])
		{
			s1.Format(_T("Error: %x"), m_bRdBuff[3]);
			scr += s1;
			s1.Format(_T("Error: %x"), m_bRdBuff[3]);
			file += s1;
		}
		else
		{
//			scr.Format(_T("NumOfBytes: %d\n"), m_bRdBuff[2]);
			file = "";
			for (BYTE i = 0; i < m_bRdBuff[2]; i += 5)
			{
				s1.Format(_T("%02x	%02x	%02x	%02x	%02x"), m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], m_bRdBuff[i + 4 + 3], m_bRdBuff[i + 4 + 4]);
				// Reset detected
				if ((m_bRdBuff[i + 4] & 0xFF) == 0x07)
				{ 
					CString sReason;
					switch (m_bRdBuff[i + 4 + 1])
					{
					case 1:
						sReason = "POR (Power On Reset)";
						break;
					case 2:
						sReason = "BOR (Brown-out Reset)";
						break;
					case 3:
						sReason = "WDT reset";
						break;
					case 4:
						sReason = "WDT sleep reset";
						break;
					case 5:
						sReason = "MCLR Sleep";
						break;
					case 6:
						sReason = "MCLR Reset";
						break;
					}
					s1.Format(_T("RESET Detected. Reason: %s (%02x, %02x, %02x, %02x, %02x)"), sReason, m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], m_bRdBuff[i + 4 + 3], m_bRdBuff[i + 4 + 4]);
				}
				Ubatt = (UBATT_R1 + UBATT_R2) * ((float)m_bRdBuff[i + 4 + 3]) * (5.0 / 512.0) / UBATT_R2;
				Teng = 512 + (((LONG)m_bRdBuff[i + 4 + 4]) << 1);
				Teng = ((Teng * (TENG_R1 + TENG_R2)) - (1023.0 * TENG_R2)) / (1023.0 - Teng);

				// OFF (0x38) or ERR (0x18)
				if ((m_bRdBuff[i + 4] & 0xF8) == 0x38 || (m_bRdBuff[i + 4] & 0xF8) == 0x28 || (m_bRdBuff[i + 4] & 0xF8) == 0x18 || (m_bRdBuff[i + 4] & 0xF8) == 0x8)
				{
					TEB = (m_bRdBuff[i + 4] & 0x10);
					day = ((m_bRdBuff[i + 4] & 0x7) << 5) | ((m_bRdBuff[i + 4 + 1] & 0xF8) >> 3);
					hour = ((m_bRdBuff[i + 4 + 1] & 0x7) << 2) | ((m_bRdBuff[i + 4 + 2] & 0xC0) >> 6);
					EngSt = (m_bRdBuff[i + 4 + 2] & 0x38) >> 3;
					BinSt = (m_bRdBuff[i + 4 + 2] & 0x7);
					s1.Format(_T("	%s %d	%02d:00:00, %d - %d, (%02x, %02x, %02x) %.2f  (%02x), %s, %.2f  (%02x)"), ((m_bRdBuff[i + 4] & 0x20) ? L"OFF":L" "), day, hour, EngSt, BinSt, m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], Ubatt, m_bRdBuff[i + 4 + 3], (TEB ? L" " : L""), Teng, m_bRdBuff[i + 4 + 4]);
				}
				// NEW ERR/ ALL OK
				if ((m_bRdBuff[i + 4] & 0xFE) == 0x2)
				{
					hour = ((m_bRdBuff[i + 4] & 0x1) << 4) | ((m_bRdBuff[i + 4 + 1] & 0xF0) >> 4);
					min = ((m_bRdBuff[i + 4 + 1] & 0xF) << 2) | ((m_bRdBuff[i + 4 + 2] & 0xC0) >> 6);
					EngSt = (m_bRdBuff[i + 4 + 2] & 0x38) >> 3;
					BinSt = (m_bRdBuff[i + 4 + 2] & 0x7);
					s1.Format(_T("NEW ERR/OK	%02d:%02d:00, %d - %d, (%02x, %02x, %02x), %.2f  (%02x)"), hour, min, EngSt, BinSt, m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], Teng, m_bRdBuff[i + 4 + 4]);
				}
		
				// TEB High <-> Low format
				if ((m_bRdBuff[i + 4] & 0xFF) == 1)
				{
					hour = ((m_bRdBuff[i + 4 + 1] & 0xF8) >> 3);
					min = ((m_bRdBuff[i + 4 + 1] & 0x7) << 3) | ((m_bRdBuff[i + 4 + 2] & 0xE0) >> 5);
					TEB = ((m_bRdBuff[i + 4 + 2] & 0x10) >> 4);
					s1.Format(_T("%s	%02d:%02d:00,      , (%02x, %02x, %02x) %.2f  (%02x), %s, %.2f  (%02x)"), (TEB ? L"TEB Low-HIGH" : L"TEB High-LOW"), hour, min, m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], Ubatt, m_bRdBuff[i + 4 + 3], (TEB ? L" ": L""), Teng, m_bRdBuff[i + 4 + 4]);
				}

				if ((m_bRdBuff[i + 4] & 0xFF) == 0)
				{
					hour = ((m_bRdBuff[i + 4 + 1] & 0xF8) >> 3);
					min = ((m_bRdBuff[i + 4 + 1] & 0x7) << 3) | ((m_bRdBuff[i + 4 + 2] & 0xE0) >> 5);
					EngSt = (m_bRdBuff[i + 4 + 2] & 0x1C) >> 2;
					BinSt = ((m_bRdBuff[i + 4 + 2] & 0x3) << 1) | ((m_bRdBuff[i + 4 + 3] & 0x80) >> 7);
					s1.Format(_T("ST VOLT		%02d:%02d:00, %d - %d, (%02x, %02x, %02x) %.2f  (%02x),    , %.2f  (%02x)"), hour, min, EngSt, BinSt, m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], Ubatt, m_bRdBuff[i + 4 + 3], Teng, m_bRdBuff[i + 4 + 4]);

				}

				if (m_bRdBuff[i + 4] & 0x80)	// Pins Format
				{
					hour = ((m_bRdBuff[i + 4] & 0x7C) >> 2);
					min = ((m_bRdBuff[i + 4] & 0x3) << 4) | ((m_bRdBuff[i + 4 + 1] & 0xF0) >> 4);
					EngSt = (m_bRdBuff[i + 4 + 1] & 0xE) >> 1;
					BinSt = ((m_bRdBuff[i + 4 + 1] & 0x1) << 2) | ((m_bRdBuff[i + 4 + 2] & 0xC0) >> 6);
					pins = (m_bRdBuff[i + 4 + 2] & 0x3F);
					Ubatt = (UBATT_R1 + UBATT_R2) * ((float)m_bRdBuff[i + 4 + 3]) * (5.0 / 512.0) / UBATT_R2;
					Teng = 512 + (((LONG)m_bRdBuff[i + 4 + 4]) << 1);
					Teng = ((Teng * (TENG_R1 + TENG_R2)) - (1023.0 * TENG_R2)) / (1023.0 - Teng);

					s1.Format(_T("PINS		%02d:%02d:00, %d - %d, '"), hour, min, EngSt, BinSt);

					if (pins & 0x20)		// 210 - IG
					{
						s1 += "210 ";
					}
					if (pins & 0x10)
					{
						s1 += "25 ";
					}
					if (pins & 0x8)
					{
						s1 += "1819 ";
					}
					if (pins & 0x4)
					{
						s1 += "23 ";
					}
					if (pins & 0x2)
					{
						s1 += "14-16 ";
					}
					if (pins & 0x1)
					{
						s1 += "21 ";
					}
					
					spins.Format(_T("' (%02x, %02x, %02x), %.2f  (%02x), %.2f  (%02x)"), m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], Ubatt, m_bRdBuff[i + 4 + 3], Teng, m_bRdBuff[i + 4 + 4]);
					s1 += spins;
					//s1.Format(_T("%x	%x	%x	%x	%x\n"), m_bRdBuff[i + 4], m_bRdBuff[i + 4 + 1], m_bRdBuff[i + 4 + 2], m_bRdBuff[i + 4 + 3], m_bRdBuff[i + 4 + 4]);		// 1 - CmdInPr, 2 - DataLenght, 3 - Error code

				}
				if (m_bRdBuff[i + 4] == 0x55 && m_x55)	// STOP byte
				{
					Start.Addr += i;
					CString s;
					s.Format(_T("0x%x"), Start.AddrH);
					GetDlgItem(IDC_ADDRHSTART)->SetWindowTextW(s);
					s.Format(_T("0x%x"), Start.AddrL);
					GetDlgItem(IDC_ADDRLSTART)->SetWindowTextW(s);

					m_x55 = 2;
					break;
				}

				scr += s1;
				file += s1;
				
				s1.Format(_T("\n"));
				scr += s1;
				s1.Format(_T("\r\n"));
				file += s1;
				
			}

			Start.Addr += m_bRdBuff[2];

			m_AddrHStart = Start.AddrH;
			m_AddrLStart = Start.AddrL;

			WCHAR DBS[300];
			swprintf_s(DBS, L"addHStart = %d, addrLStart = %d, addstart = %d, addstop = %d\n", Start.AddrH, Start.AddrL, Start.Addr, Stop.Addr);
			OutputDebugString(DBS);

			BYTE *pwbuff = ((CSVRmeterMFCDlg*)m_pMainDlg)->m_bwrbuff;

			pwbuff[0] = 0x0;
			pwbuff[1] = 0x21;
			pwbuff[2] = 0x10;
			pwbuff[3] = Start.AddrH;
			pwbuff[4] = Start.AddrL;

			if (m_x55 == 1)
			{
				pwbuff[5] = 30;
				if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
				{
					((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
				}
			}
			if (m_x55 == 0)
			{
				if (Stop.Addr > Start.Addr)
				{
					pwbuff[5] = ((Stop.Addr - Start.Addr) > 30 ? 30 : (Stop.Addr - Start.Addr));
					if (((CSVRmeterMFCDlg*)m_pMainDlg)->USBWrite())
					{
						((CSVRmeterMFCDlg*)m_pMainDlg)->USBRead();
					}
				}
			}
		}

		if (((CButton *)GetDlgItem(IDC_LOGTOSCREEN))->GetCheck())
			PrintLog(LPCTSTR(scr), 0, 0);

		if (m_hI2CLogFile != INVALID_HANDLE_VALUE && m_hI2CLogFile != NULL)
		{
			CHAR str[1000];
			sprintf_s(str, "%s", file);
			OutputDebugString(L"Write to FILE\n");
			WriteFile(m_hI2CLogFile, str, strlen(str), NULL, NULL);
		}

		break;
	default:
		break;
	}
}

void CI2CMem::OnBnClickedOpenfile()
{
	// TODO:     
	CFileDialog dlgFile(TRUE, NULL, NULL, 6UL, NULL, NULL, 0UL, 1);

	dlgFile.DoModal();
	CString strPathname = dlgFile.GetPathName();
	m_FileToLog.SetWindowText(strPathname);
}


void CI2CMem::OnClose()
{
	// TODO: Add your message handler code here and/or call default

	CDialog::OnClose();
}
