/********************************************************************
 Software License Agreement:

 The software supplied herewith by Microchip Technology Incorporated
 (the "Company") for its PIC(R) Microcontroller is intended and
 supplied to you, the Company's customer, for use solely and
 exclusively on Microchip PIC Microcontroller products. The
 software is owned by the Company and/or its supplier, and is
 protected under applicable copyright laws. All rights are reserved.
 Any use in violation of the foregoing restrictions may subject the
 user to criminal sanctions under applicable laws, as well as to
 civil liability for the breach of the terms and conditions of this
 license.

 THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,
 WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *******************************************************************/

/** INCLUDES *******************************************************/
#include <usb/usb.h>
#include <usb/usb_device_hid.h>

#include <string.h>

#include <system.h>
#include "BEAN.h"
#include "app_device_custom_hid.h"
#include "../../i2c/i2c_my.h"
#include "../../i2c/i2cCmds.h"

/** VARIABLES ******************************************************/
/* Some processors have a limited range of RAM addresses where the USB module
 * is able to access.  The following section is for those devices.  This section
 * assigns the buffers that need to be used by the USB module into those
 * specific areas.
 */
#if defined(FIXED_ADDRESS_MEMORY)
    #if defined(COMPILER_MPLAB_C18)
        #pragma udata HID_CUSTOM_OUT_DATA_BUFFER = HID_CUSTOM_OUT_DATA_BUFFER_ADDRESS
        unsigned char ReceivedDataBuffer[64];
        #pragma udata HID_CUSTOM_IN_DATA_BUFFER = HID_CUSTOM_IN_DATA_BUFFER_ADDRESS
        unsigned char ToSendDataBuffer[64];
        #pragma udata

    #else defined(__XC8)
        unsigned char ReceivedDataBuffer[64] @ HID_CUSTOM_OUT_DATA_BUFFER_ADDRESS;
        unsigned char ToSendDataBuffer[64] @ HID_CUSTOM_IN_DATA_BUFFER_ADDRESS;
    #endif
#else
    unsigned char ReceivedDataBuffer[64];
    unsigned char ToSendDataBuffer[64];
#endif

volatile USB_HANDLE USBOutHandle;    
volatile USB_HANDLE USBInHandle;

/** FUNCTIONS ******************************************************/

/*********************************************************************
* Function: void APP_DeviceCustomHIDInitialize(void);
*
* Overview: Initializes the Custom HID demo code
*
* PreCondition: None
*
* Input: None
*
* Output: None
*
********************************************************************/
void APP_DeviceCustomHIDInitialize()
{
    //initialize the variable holding the handle for the last
    // transmission
    USBInHandle = 0;

    //enable the HID endpoint
    USBEnableEndpoint(CUSTOM_DEVICE_HID_EP, USB_IN_ENABLED|USB_OUT_ENABLED|USB_HANDSHAKE_ENABLED|USB_DISALLOW_SETUP);

    //Re-arm the OUT endpoint for the next packet
    USBOutHandle = (volatile USB_HANDLE)HIDRxPacket(CUSTOM_DEVICE_HID_EP,(uint8_t*)&ReceivedDataBuffer,64);
}

/*********************************************************************
* Function: void APP_DeviceCustomHIDTasks(void);
*
* Overview: Keeps the Custom HID demo running.
*
* PreCondition: The demo should have been initialized and started via
*   the APP_DeviceCustomHIDInitialize() and APP_DeviceCustomHIDStart() demos
*   respectively.
*
* Input: None
*
* Output: None
*
********************************************************************/
void APP_DeviceCustomHIDTasks()
{   
    //Check if we have received an OUT data packet from the host
    if(HIDRxHandleBusy(USBOutHandle) == false)
    {   
        //We just received a packet of data from the USB host.
        //Check the first uint8_t of the packet to see what command the host
        //application software wants us to fulfill.
        switch(ReceivedDataBuffer[0])				//Look at the data the host sent, to see what kind of application specific command it sent.
        {
            case 0x80:  //Go to bootloader
                asm ("goto 0x001C");
                break;

             case 0x23:
              //  OutRet(ReceivedDataBuffer[1], &ReceivedDataBuffer[2], 0);
                if(!HIDTxHandleBusy(USBInHandle))
                {
/*                    ToSendDataBuffer[0] = 0x24;				//Echo back to the host PC the command we are fulfilling in the first byte.  In this case, the Get Pushbutton State command.
    				//Prepare the USB module to send the data packet to the host
                    pBEANSndBuff[0] =  ReceivedDataBuffer[1];
                    BEANbitPos =  ReceivedDataBuffer[2];
//                    DecrBitPos (ReceivedDataBuffer[3]);
                    ToSendDataBuffer[1] = pBEANSndBuff[0];
                    ToSendDataBuffer[2] = BEANbitPos;
*/
                    BEAN_OUT = !BEAN_OUT;
                    USBInHandle = HIDTxPacket(CUSTOM_DEVICE_HID_EP,(BYTE*)&ToSendDataBuffer[0],64);
                }
                break;
            case 0x21:
                CmdInPr = ReceivedDataBuffer[1];

                // Everithing OFF
                Timer0ONOFF(0, 0);
                IOCBEANIN (0);
                InitBEANVars(0);

                switch (CmdInPr)
                {

                    case CMD_BEAN_CODE:
                    case CMD_CODE_SORT:
//                        tmrl = 0; //256 - 75;
 //                       Timer0ONOFF(1, Tmr0Con, tmrl);
//                        tmrl = ReceivedDataBuffer[3];       // TMR0L register value
                        IOCBEANIN(1); // With IOC
                        break;
                    case CMD_SEND_BEAN_CMD:
                        memcpy(BEANCmdToSend, &ReceivedDataBuffer[4], (ReceivedDataBuffer[4] & 0x0F) + 2);
//                        Tmr2Con = 0b00100011;   // 1:5 - Postscaler
                                                // 1:16 - Prescaler
                                                // 15 ticks = 10 kbit
                        // To start sending we should firstly verify that no transmission in progress
                        BEANFirstByteInSnd = ReceivedDataBuffer[4];
                        BEANNumToSend = ReceivedDataBuffer[2];
                        BEANDelayBtwCmd = ReceivedDataBuffer[3];
                        IOCBEANIN(1); // With IOC
                        Timer0ONOFF(1, TMR0_1TICK * TRM0_NOTR_CONDITION);
                        break;
                    case CMD_I2C_TESTINOUT:
                        if (!HIDTxHandleBusy(USBInHandle))
                        {
                            i2c_init(0);
                            ToSendDataBuffer[0] = CmdInPr;
                            ToSendDataBuffer[1] = ReceivedDataBuffer[2];
                            
                            unsigned char cmd[4];
                            switch (ReceivedDataBuffer[2])
                            {
                        //        ToSendDataBuffer[2] = ReceivedDataBuffer[2];
                                case 0x0:
                                    i2cTestInOut (&ReceivedDataBuffer[1], &ToSendDataBuffer[2]);
                                    break;
                                case 0x1:   // Set i2cHoldTmr
                                    cmd[0] = 0b01000010;
                                    cmd[1] = _I2C_HOLDTMR;
                                    cmd[2] = ReceivedDataBuffer[3];
                                    ToSendDataBuffer[2] = TXCmdToPIC16 (cmd, 3, 10);
                                    break;
                                case 0x2:
                                    cmd[0] = 0b01000010;
                                    cmd[1] = ReceivedDataBuffer[3];
                                    cmd[2] = ReceivedDataBuffer[4];
                                    ToSendDataBuffer[2] = TXCmdToPIC16 (cmd, 3, 10);
                                    break;
                            }
                            USBInHandle = HIDTxPacket(CUSTOM_DEVICE_HID_EP,(BYTE*)&ToSendDataBuffer[0],64);
                            CmdInPr = CMD_NOCMD;
                        }
                        break;


                    case CMD_NOCMD:
                        break;

                    default:
                        break;
                }
                break;
        }
        //Re-arm the OUT endpoint, so we can receive the next OUT data packet 
        //that the host may try to send us.
        USBOutHandle = HIDRxPacket(CUSTOM_DEVICE_HID_EP, (uint8_t*)&ReceivedDataBuffer, 64);

    }

    switch(CmdInPr)
    {
        case CMD_I2C_READMEM:
            if (!HIDTxHandleBusy(USBInHandle))
            {
                            i2c_init(0);
                            ToSendDataBuffer[0] = CmdInPr;
                            ToSendDataBuffer[1] = (ReceivedDataBuffer[4] > 32 ? 32:ReceivedDataBuffer[4]);
                            ToSendDataBuffer[2] = RXNbytes (ReceivedDataBuffer[2], ReceivedDataBuffer[3], ToSendDataBuffer[1], &ToSendDataBuffer[3]);
                            USBInHandle = HIDTxPacket(CUSTOM_DEVICE_HID_EP,(BYTE*)&ToSendDataBuffer[0],64);
                            CmdInPr = CMD_NOCMD;
            }
            break;
        case CMD_I2C_DOCMD:
            if (!HIDTxHandleBusy(USBInHandle))
            {
                            i2c_init(0);
                            ToSendDataBuffer[0] = CmdInPr;
                            i2cDoCmd (&ReceivedDataBuffer[2], &ToSendDataBuffer[1], 20);
                            USBInHandle = HIDTxPacket(CUSTOM_DEVICE_HID_EP,(BYTE*)&ToSendDataBuffer[0],64);
                            CmdInPr = CMD_NOCMD;
                        }
                        break;

        case CMD_SEND_BEAN_CMD:
 /*           if (BEANCmdToSend[0] == 0)  // We already sent everything
            {
                if (BEANNumToSend > 0)
                {
//                BEANFirstByteInSnd = BEANCmdToSend[0];
//                BEANNumToSend = 2 - 1;
                    if (Tmr1Repeat == 0)    // We've not set it yet
                    {
                        // Add num of tries left to the end of received msg to (1) mark it as ours and (2) say to host how many times we shoud sent it
                        if (BEANTrSt == BEAN_TR_RSP)
                        {
                            pBEANSndBuff[pBEANSndBuff[0] + 1] = BEANNumToSend;
                            pBEANSndBuff[0]++;
                        }
                        if (BEANDelayBtwCmd > 3)
                            Tmr1Repeat = (BEANDelayBtwCmd / 4);

//                    char ret = BEANDelayBtwCmd - (Tmr1Repeat * 4);
//                    OutRet (0x40, &ret, 0);

                        switch (BEANDelayBtwCmd - (Tmr1Repeat * 4))
                        {
                            case 0:
                                Timer1ONOFF (1, 0xEA, 0x60);    // 60000
                                break;
                            case 1:
                                Timer1ONOFF (1, 0x3A, 0x98);    // 15000
                                break;
                            case 2:
                                Timer1ONOFF (1, 0x75, 0x30);    // 30000
                                break;
                            case 3:
                                Timer1ONOFF (1, 0xAF, 0xC8);    // 45000
                                break;
                        }
                    }
                }
            }*/
            // break;   // DON'T break, as we can send something to host (if we have something)
        case CMD_BEAN_CODE:
        case CMD_CODE_SORT:
            if(BEANBuffInUse != BEANBuffSent && (!HIDTxHandleBusy(USBInHandle)))
            {
                ToSendDataBuffer[0] = CmdInPr;
        //        Timer0ONOFF(0, 0, 0);
      //          IOCBEANIN (0);

//                if ((BEANBuffPos - TransferInProgress) > 62)
                switch (BEANBuffSent)
                {
                    case 1:
                        memcpy(&ToSendDataBuffer[1], &BEANSndBuff1[0], BEANSndBuff1[0] + 1);
                        break;
                    case 2:
                        memcpy(&ToSendDataBuffer[1], &BEANSndBuff2[0], BEANSndBuff2[0] + 1);
                        break;
                    case 3:
                        memcpy(&ToSendDataBuffer[1], &BEANSndBuff3[0], BEANSndBuff3[0] + 1);
                        break;
                    case 4:
                        memcpy(&ToSendDataBuffer[1], &BEANSndBuff4[0], BEANSndBuff4[0] + 1);
                        break;
                }
//                if (CmdInPr == CMD_SEND_BEAN_CMD)   // We've sent something, add NumTo
                //ToSendDataBuffer[1] = 20;
/*                else
                {
                    ToSendDataBuffer[1] = BEANBuffPos - TransferInProgress;
                    memcpy(&ToSendDataBuffer[2], &BEANSndBuff[TransferInProgress], ToSendDataBuffer[1]);

                    memset((void *)BEANSndBuff, 0, sizeof(BEANSndBuff));

                    InitBEANVars();
  //                  Timer0ONOFF(1, Tmr0Con, tmrl);
                    IOCBEANIN(1);

                }*/
                BEANBuffSent++;
                if (BEANBuffSent > 4)
                    BEANBuffSent = 1;

                USBInHandle = HIDTxPacket(CUSTOM_DEVICE_HID_EP,(BYTE*)&ToSendDataBuffer[0],64);
            }
            break;


        default:
            break;
    }

}

void Timer1ONOFF(unsigned char ON, unsigned char cTMR1H, unsigned char cTMR1L)
{
#if defined (__18F4550)
    if (ON)
    {
        T1CON = 0b01110000;
        TMR1H = cTMR1H;
        TMR1L = cTMR1L;
        PIR1bits.TMR1IF = 0;
        PIE1bits.TMR1IE = 1;
        IPR1bits.TMR1IP = 1;
        T1CONbits.TMR1ON = 1;
    }
    else
        T1CONbits.TMR1ON = 0;
#endif
}

void Tmr1Int()
{
    if (Tmr1Repeat == 0)    // Send
    {
//        char ret = 0xAA;
//        OutRet (0x41, &ret, 0);
        if (BEANNumToSend != 0)
        {
            BEANCmdToSend[0] = BEANFirstByteInSnd;
            if (BEANNumToSend != 0xFF)  // FF means send indefinitely
                BEANNumToSend--;

            if (BEANTrSt == BEAN_NO_TR)
            {
                IOCBEANIN(1); // With IOC
                Timer0ONOFF(1, TMR0_1TICK * TRM0_NOTR_CONDITION);
            }
        }
    }
    else
    {
        Timer1ONOFF (1, 0xEA, 0x60);    // 60000
        Tmr1Repeat--;
    }
//    char ret = Tmr1Repeat;

}
