/*
* Common platform-related definitions
* Copyright (c) 2012 Vladislav Goncharov <vl-g@yandex.ru>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with FFmpeg; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef _system_h_
#define _system_h_

#ifdef WIN32

# include <windows.h>    // CRITICAL_SECTION
# include <crtdbg.h>
# include <malloc.h>     // alloca
# include <emmintrin.h>  // SSE2 inlines
# include <direct.h>     // mkdir

# define _CRTDBG_MAP_ALLOC
# include <crtdbg.h>

#else /* !WIN32 */

# include <pthread.h>
# include <xmmintrin.h>  // SSE2 inlines
# include <sys/stat.h>   // mkdir

# define _ASSERT(x)
# define MAX_PATH    260

#endif /* WIN32 */

#include <locale.h>     // setlocale
#include <stdarg.h>     // va_list
#include <stdio.h>      // snprintf
#include <string.h>     // memset
#include <stdio.h>      // sprintf
#include <stdlib.h>     // rand

#define _USE_MATH_DEFINES
#include <math.h>

#ifdef TARGET_API_MAC_CARBON
#define PTHREAD_MUTEX_TIMED_NP      PTHREAD_MUTEX_NORMAL
#define PTHREAD_MUTEX_RECURSIVE_NP  PTHREAD_MUTEX_RECURSIVE
#define PTHREAD_MUTEX_ERRORCHECK_NP PTHREAD_MUTEX_ERRORCHECK
#define PTHREAD_MUTEX_DEFAULT       PTHREAD_MUTEX_NORMAL
#endif /* TARGET_API_MAC_CARBON */

#ifdef WIN32

// ANSI C vsnprintf() must return total number of chars not number of chars written
static __inline int ansi_vsnprintf(char *buffer, size_t count, const char *fmt, va_list ap)
{
    int rc;
    
    if (count > 0) {
        rc = _vsnprintf(buffer, count - 1, fmt, ap);
        buffer[count - 1] = '\0';
    } else
        rc = -1;

    if (rc < 0) {
        // >= XP only
        rc = _vscprintf(fmt, ap);
    }

    return rc;
}

#define vsnprintf   ansi_vsnprintf

static __inline int snprintf(char *buffer, size_t count, const char *fmt, ...)
{
    int rc;
    va_list ap;
    va_start(ap, fmt);
    
    rc = vsnprintf(buffer, count, fmt, ap);
    
    va_end(ap);
    return rc;
}

#endif /* WIN32 */

#endif
