/*
* SACD Decoder plugin
* Copyright (c) 2011-2012 Maxim V.Anisiutkin <maxim.anisiutkin@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with FFmpeg; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef _SACD_SETUP_H_INCLUDED
#define _SACD_SETUP_H_INCLUDED

#define ASIO_MAXDRVNAMELEN 128
#define ASIO_MAXDRVDATALEN 256
#define ASIO_MAXDRIVERS    64

#define ASIO_HKEY  _T("SOFTWARE\\ASIO")
#define ASIO_CLSID _T("CLSID")
#define ASIO_DESC  _T("Description")

//static const GUID g_guid_cfg_asio_mode = { 0xd3d21b14, 0x68d2, 0x437f, { 0xa9, 0xc6, 0x5b, 0xa7, 0xb1, 0xd6, 0xe, 0x54 } };
//static cfg_int g_cfg_asio_mode(g_guid_cfg_asio_mode, 0);

//static const GUID g_guid_cfg_volume = { 0x9c3dce45, 0x67c2, 0x4221, { 0xa9, 0x1, 0x53, 0x60, 0x44, 0x9e, 0xa, 0x24 } };
//static cfg_int g_cfg_volume(g_guid_cfg_volume, 0);

static const GUID g_guid_cfg_samplerate = { 0xde915fec, 0x5557, 0x4746, { 0x87, 0xbc, 0x6a, 0x6f, 0x99, 0xfe, 0x67, 0x5 } };
static cfg_int g_cfg_samplerate(g_guid_cfg_samplerate, 1);  // 96 kHz by default

//static const GUID g_guid_cfg_converter_mode = { 0x745d7ac3, 0x80c1, 0x41c1, { 0xb9, 0x8, 0xbd, 0x6, 0xd6, 0xa2, 0x87, 0x82 } };
//static cfg_int g_cfg_converter_mode(g_guid_cfg_converter_mode, 0);

static const GUID g_guid_cfg_area = { 0xa93bec29, 0xc34b, 0x4973, { 0xb7, 0x85, 0xea, 0xc8, 0xf8, 0x4e, 0x1d, 0x83 } };
static cfg_int g_cfg_area(g_guid_cfg_area, 0);

static const GUID g_guid_cfg_editable_tags = { 0x480cf6d8, 0x3512, 0x49ae, { 0xb8, 0xef, 0x3f, 0xe1, 0x84, 0x9c, 0xd7, 0x0 } };
static cfg_uint g_cfg_editable_tags(g_guid_cfg_editable_tags, BST_UNCHECKED);

static const GUID g_guid_cfg_emaster = { 0xb9fc1273, 0x2c44, 0x4b00, { 0x93, 0xc3, 0x56, 0x79, 0x79, 0x1a, 0x3a, 0x5f } };
static cfg_uint g_cfg_emaster(g_guid_cfg_emaster, BST_UNCHECKED);

class CSACDPreferences : public CDialogImpl<CSACDPreferences>, public preferences_page_instance {
public:
	static bool in_dsd_mode() {
		//return g_cfg_asio_mode.get_value() > 0 ? true : false;
        return false;
	}

	static int get_asio_mode() {
		//return g_cfg_asio_mode.get_value();
        return 0;
	}

	static int get_volume() {
		//return g_cfg_volume.get_value();
        return 0;
	}

	static int get_samplerate() {
		switch (g_cfg_samplerate.get_value()) {
		case 0:
			return 88200;
		case 1:
			return 96000;
		case 2:
			return 176400;
		case 3:
			return 192000;
		}
		return 44100;
	}

	static int get_converter_mode() {
		//return g_cfg_converter_mode.get_value();
        return 0;
	}

	static int get_area() {
		return g_cfg_area.get_value();
	}

	static bool get_editable_tags() {
		return g_cfg_editable_tags == BST_CHECKED;
	}

	static bool get_emaster() {
		return g_cfg_emaster == BST_CHECKED;
	}

	CSACDPreferences(preferences_page_callback::ptr callback) : m_callback(callback) {
	}

	enum {IDD = IDD_SACD_PREFERENCES};

	t_uint32 get_state() {
		t_uint32 state = preferences_state::resettable;
		if (HasChanged())
			state |= preferences_state::changed;
		return state;
	}

	void apply() {
		//g_cfg_asio_mode = SendDlgItemMessage(IDC_ASIO_MODE_COMBO, CB_GETCURSEL, 0, 0);
		//g_cfg_volume = SendDlgItemMessage(IDC_VOLUME_COMBO, CB_GETCURSEL, 0, 0);
		g_cfg_samplerate = SendDlgItemMessage(IDC_SAMPLERATE_COMBO, CB_GETCURSEL, 0, 0);
		//g_cfg_converter_mode = SendDlgItemMessage(IDC_CONVERTER_MODE_COMBO, CB_GETCURSEL, 0, 0);
		g_cfg_area = SendDlgItemMessage(IDC_AREA_COMBO, CB_GETCURSEL, 0, 0);
		g_cfg_editable_tags = SendDlgItemMessage(IDC_EDITABLE_TAGS, BM_GETCHECK, 0, 0);
		g_cfg_emaster = SendDlgItemMessage(IDC_EMASTER, BM_GETCHECK, 0, 0);
		OnChanged();
	}

	void reset() {
		//g_cfg_asio_mode = 0;
		//SendDlgItemMessage(IDC_ASIO_MODE_COMBO, CB_SETCURSEL, 0, 0);
		//g_cfg_volume = 6;
		//SendDlgItemMessage(IDC_VOLUME_COMBO, CB_SETCURSEL, 6, 0);
		g_cfg_samplerate = 0;
		SendDlgItemMessage(IDC_SAMPLERATE_COMBO, CB_SETCURSEL, 0, 0);
		//g_cfg_converter_mode = 1;
		//SendDlgItemMessage(IDC_CONVERTER_MODE_COMBO, CB_SETCURSEL, 1, 0);
		g_cfg_area = 0;
		SendDlgItemMessage(IDC_AREA_COMBO, CB_SETCURSEL, 0, 0);
		g_cfg_editable_tags = 0;
		SendDlgItemMessage(IDC_EDITABLE_TAGS, BM_SETCHECK, BST_UNCHECKED, 0);
		g_cfg_emaster = 0;
		SendDlgItemMessage(IDC_EMASTER, BM_SETCHECK, BST_UNCHECKED, 0);
		OnChanged();
	}

	BEGIN_MSG_MAP(CDVDAPreferences)
		MSG_WM_INITDIALOG(OnInitDialog)
		//COMMAND_HANDLER_EX(IDC_ASIO_MODE_COMBO, CBN_SELCHANGE, OnAsioModeChange)
		//COMMAND_HANDLER_EX(IDC_VOLUME_COMBO, CBN_SELCHANGE, OnVolumeChange)
		COMMAND_HANDLER_EX(IDC_SAMPLERATE_COMBO, CBN_SELCHANGE, OnSamplerateChange)
		//COMMAND_HANDLER_EX(IDC_CONVERTER_MODE_COMBO, CBN_SELCHANGE, OnConverterModeChange)
		COMMAND_HANDLER_EX(IDC_AREA_COMBO, CBN_SELCHANGE, OnAreaChange)
		COMMAND_HANDLER_EX(IDC_EDITABLE_TAGS, BN_CLICKED, OnEditableTagsChange)
		COMMAND_HANDLER_EX(IDC_EMASTER, BN_CLICKED, OnEMasterChange)
	END_MSG_MAP()

private:
	BOOL OnInitDialog(CWindow, LPARAM) {
		//GetAsioModeList();
		//GetVolumeList();
		GetSamplerateList();
		//GetConverterModeList();
		GetAreaList();
		SendDlgItemMessage(IDC_EDITABLE_TAGS, BM_SETCHECK, g_cfg_editable_tags, 0);
		SendDlgItemMessage(IDC_EMASTER, BM_SETCHECK, g_cfg_emaster, 0);
		OnChanged();
		return TRUE;
	}

	void OnAsioModeChange(UINT, int, CWindow) {
		OnChanged();
	}

	void OnVolumeChange(UINT, int, CWindow) {
		OnChanged();
	}

	void OnSamplerateChange(UINT, int, CWindow) {
		OnChanged();
	}

	void OnConverterModeChange(UINT, int, CWindow) {
		OnChanged();
	}

	void OnAreaChange(UINT, int, CWindow) {
		OnChanged();
	}

	void OnEditableTagsChange(UINT, int, CWindow) {
		OnChanged();
	}

	void OnEMasterChange(UINT, int, CWindow) {
		OnChanged();
	}

	bool HasChanged() {
		/*if (g_cfg_asio_mode.get_value() != SendDlgItemMessage(IDC_ASIO_MODE_COMBO, CB_GETCURSEL, 0, 0)) {
			return true;
		}*/
		/*if (g_cfg_volume.get_value() != SendDlgItemMessage(IDC_VOLUME_COMBO, CB_GETCURSEL, 0, 0)) {
			return true;
		}*/
		if (g_cfg_samplerate.get_value() != SendDlgItemMessage(IDC_SAMPLERATE_COMBO, CB_GETCURSEL, 0, 0)) {
			return true;
		}
		/*if (g_cfg_converter_mode.get_value() != SendDlgItemMessage(IDC_CONVERTER_MODE_COMBO, CB_GETCURSEL, 0, 0)) {
			return true;
		}*/
		if (g_cfg_area.get_value() != SendDlgItemMessage(IDC_AREA_COMBO, CB_GETCURSEL, 0, 0)) {
			return true;
		}
		if (g_cfg_editable_tags.get_value() != SendDlgItemMessage(IDC_EDITABLE_TAGS, BM_GETCHECK, 0, 0)) {
			return true;
		}
		if (g_cfg_emaster.get_value() != SendDlgItemMessage(IDC_EMASTER, BM_GETCHECK, 0, 0)) {
			return true;
		}
		return false;
	}

	void OnChanged() {
		m_callback->on_state_changed();
	}

#if 0
	void GetAsioModeList() {
		SendDlgItemMessage(IDC_ASIO_MODE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("PCM"));
		SendDlgItemMessage(IDC_ASIO_MODE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("DSD"));
		SendDlgItemMessage(IDC_ASIO_MODE_COMBO, CB_SETCURSEL, g_cfg_asio_mode.get_value(), 0);
	}
#endif

#if 0
	void GetVolumeList() {
		SendDlgItemMessage(IDC_VOLUME_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("+0dB"));
		SendDlgItemMessage(IDC_VOLUME_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("+1dB"));
		SendDlgItemMessage(IDC_VOLUME_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("+2dB"));
		SendDlgItemMessage(IDC_VOLUME_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("+3dB"));
		SendDlgItemMessage(IDC_VOLUME_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("+4dB"));
		SendDlgItemMessage(IDC_VOLUME_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("+5dB"));
		SendDlgItemMessage(IDC_VOLUME_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("+6dB"));
		SendDlgItemMessage(IDC_VOLUME_COMBO, CB_SETCURSEL, g_cfg_volume.get_value(), 0);
	}
#endif

	void GetSamplerateList() {
		SendDlgItemMessage(IDC_SAMPLERATE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("88200"));
		SendDlgItemMessage(IDC_SAMPLERATE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("96000"));
		SendDlgItemMessage(IDC_SAMPLERATE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("176400"));
		SendDlgItemMessage(IDC_SAMPLERATE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("192000"));
		SendDlgItemMessage(IDC_SAMPLERATE_COMBO, CB_SETCURSEL, g_cfg_samplerate.get_value(), 0);
	}

#if 0
	void GetConverterModeList() {
		SendDlgItemMessage(IDC_CONVERTER_MODE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("Multistage (Fixed-Point)"));
		SendDlgItemMessage(IDC_CONVERTER_MODE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("Multistage (Floating-Point)"));
		SendDlgItemMessage(IDC_CONVERTER_MODE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("Direct (Floating-Point, 30kHz LF)"));
		SendDlgItemMessage(IDC_CONVERTER_MODE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("Multistage (Double-Precision)"));
		SendDlgItemMessage(IDC_CONVERTER_MODE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("Direct (Double-Precision, 30kHz LF)"));
		SendDlgItemMessage(IDC_CONVERTER_MODE_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("HQ1"));
		SendDlgItemMessage(IDC_CONVERTER_MODE_COMBO, CB_SETCURSEL, g_cfg_converter_mode.get_value(), 0);
	}
#endif

	void GetAreaList() {
		SendDlgItemMessage(IDC_AREA_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("None"));
		SendDlgItemMessage(IDC_AREA_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("Stereo"));
		SendDlgItemMessage(IDC_AREA_COMBO, CB_ADDSTRING, 0, (LPARAM)_T("Multichannel"));
		SendDlgItemMessage(IDC_AREA_COMBO, CB_SETCURSEL, g_cfg_area.get_value(), 0);
	}

	CLSID m_asio_clsid[ASIO_MAXDRIVERS + 1];
	const preferences_page_callback::ptr m_callback;
};

class preferences_page_sacd_t : public preferences_page_impl<CSACDPreferences> {
public:
	const char* get_name() {
		return "SACD";
	}
	GUID get_guid() {
		static const GUID guid = { 0x532b5e38, 0x267, 0x4a2d, { 0xa7, 0x89, 0xb0, 0x88, 0x99, 0xd2, 0xb1, 0x48 } };
		return guid;
	}
	GUID get_parent_guid() {
		return guid_tools;
	}
};

static preferences_page_factory_t<preferences_page_sacd_t> g_preferences_page_sacd_factory;

#endif
