#include <mcp_can.h>
#include <SPI.h>

long unsigned int rxId;
unsigned char len = 0;
unsigned char rxBuf[8];
int value = 0;
int current_volume, new_volume, current_key_position, new_key_position;
int NEXT, PREV, MUTE;

MCP_CAN CAN0(10);

void setup()
{
  Serial.begin(9600);
  if(CAN0.begin(CAN_100KBPS) == CAN_OK) 
    {
      Serial.println("can init ok!!");
    }
  else 
    {
      Serial.println("Can init fail!!");
    }
    
  pinMode(2, INPUT); 

  NEXT = 0;
  PREV = 0;
  MUTE = 0;
  
}

void loop()
{
      
    if(!digitalRead(2))                         
    {
      CAN0.readMsgBuf(&len, rxBuf);              
      rxId = CAN0.getCanId();                    
      
      if (rxId == 0x5c1)
      
      {
        if (rxBuf[0] == 0x13)
        {
          
          new_volume = rxBuf[2];
          
          if (current_volume == 0x01 & new_volume == 0x0f)
          {
            Remote.decrease();
            Remote.clear();
            Serial.print("VOL DOWN");
            Serial.println();
            current_volume = new_volume;
          }
          else
          if (current_volume == 0x0f & new_volume == 0x01)
          {
            Remote.increase();
            Remote.clear();
            Serial.print("VOL UP");
            Serial.println();
            current_volume = new_volume;
          }
          else 
          if ((new_volume < current_volume))
         {
            Remote.decrease();
            Remote.clear();
            Serial.print("VOL DOWN");
            Serial.println();
            current_volume = new_volume;
         } 
          else if (new_volume > current_volume)
         {
            Remote.increase();
            Remote.clear();
            Serial.print("VOL UP");
            Serial.println();
            current_volume = new_volume;
         }
                   
        }
        else
        if (rxBuf[0] == 0x02) 
        {
          NEXT = NEXT + 1; //Фиксируем нажатие кнопки "NEXT"
          if (NEXT > 7)
          {
            Remote.forward();
            Serial.println("NEXT LONG PRESS");
          }
        }
        else
        if (rxBuf[0] == 0x03) 
        {
          PREV = PREV + 1; //Фиксируем нажатие кнопки "PREV"
            if (PREV > 7)
            {
              Remote.rewind();
              Serial.println("PREV LONG PRESS");
            }
          
        }
        else
        if (rxBuf[0] == 0x2b) 
        {
          MUTE = MUTE + 1; //Фиксируем нажатие кнопки "MUTE"
          
          if (MUTE > 7)
          {

            // долгое нажатие MUTE - не могу придумать зачем оно
            
          }
          
        }
        else
        if (rxBuf[0] == 0x00) 
        {
          // NEXT
          if (NEXT != 0) 
          {
            if (NEXT <= 7)
            {
              Remote.next();
              Remote.clear();
              Serial.println("NEXT SHORT PRESS");
            }
            
            NEXT = 0;
            Remote.clear();
          }

          // PREV
          if (PREV != 0) 
          {
            if (PREV <=7)
            {
              Remote.previous();
              Remote.clear();
              Serial.println("PREV SHORT PRESS");
            }
            
            PREV = 0;
            Remote.clear();
          }

          // MUTE
          if (MUTE != 0) 
          {
            if (MUTE <= 7)
            {
              Remote.play_pause();
              Remote.clear();
              Serial.println("MUTE SHORT PRESS");
            }
            
            MUTE = 0;
            Remote.clear();
          }
        }
   
      }
    }
}
