/***************************************************************************
*   Copyright (C) 2009 by Michael Carpenter (malcom2073)                  *
*   mcarpenter@interforcesystems.com                                      *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifndef HD_UNIT_H
#define HD_UNIT_H

#include <QObject>
#include <QString>
#include <QList>
#include <QStringList>
#include <QByteArray>
#include <QPair>
#include <QTimer>
#include <QSettings>

#include "serialCOM.h"

class HdRadioCodes
{
public:
    HdRadioCodes();
    QString getCommandStringFromBytes(QByteArray ba);
    QString getOperationStringFromBytes(QByteArray ba);
    QString getConstantStringFromBytes(QByteArray ba);
    QByteArray getOperationBytesFromString(QString op);
    QByteArray getCommandBytesFromString(QString op);
    QByteArray getConstantBytesFromString(QString op);
    QString getReturnFormat(QString arg);
    QList<QPair<QString,QByteArray> > hdRadioCommandCodes;
    QList<QPair<QString,QByteArray> > hdRadioOperationCodes;
    QList<QPair<QString,QByteArray> > hdRadioConstantCodes;
    QList<QPair<QString,QByteArray> > hdRadioArgs;
    QList<QPair<QString,QString> > hdRadioDataFormat;
};

class HdRadioMessage
{
public:
    HdRadioMessage(QByteArray message,HdRadioCodes *hdCodes);
    QString messageClass;
    QString messageDirection;
    QString messageArg;
    bool valid;

};

/*Copyright (C) 2013 Serge Begger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

class hd_unit : public QObject
{
    Q_OBJECT
public:
    explicit hd_unit(QObject *parent = 0);
    ~hd_unit();
    bool deviceOpen;
    void setFreq(double currFreq);
    int getSNR();
    int getRSSI();
    bool isStereo();


signals:
    void showMessage(QString message);

private slots:
    void serialReadTimer();
    void subChannelTimerTimeout();

private:
    QSettings *mySet;
    serialCOM *serial;
    HdRadioCodes *hdCodes;
    QTimer *serialTimer, *subChannelTimer;
    void parseMessage(QByteArray arr);
    void sendMessage(QByteArray arr);
    QByteArray recvArray;
    bool inMessage;
    bool isFirst;
    int messageCount;
    int currentCount;
    int totalSubChannels;
    int currentSubChannel;
    QStringList subChannelArtist;
    QStringList subChannelTitle;
    QStringList presetFreqList;
};

#endif // HD_UNIT_H
