/*
 * radio.h - FM radio GUI
 *
 * Copyright (C) 2010-2011 Serge Begger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef RADIO_H
#define RADIO_H

#include <QWidget>
#include <QTimer>
#include <QPushButton>
#include <QProcess>
#include <QFile>
#include <QList>
#include <QThread>

#include "hdunit.h"
#include "abstractmmmodule.h"
#include "qcpcsql.h"
#include "qcarpc.h"
#include "qcpcgui.h"

namespace Ui {
    class Radio;
}

class Radio : public abstractmmplugin {
    Q_OBJECT

public:
    Radio(QWidget *parent = 0);
    ~Radio();

public slots:
    void play();
    void stop();
    void pause();
    void next();
    void prev();
    void endTextEdit(QString);

private:
    Ui::Radio *ui;
    gslider *qsSlider;
    hd_unit *hd_tuner;
    QTimer *timer;
    QTimer *scanTimer;
    QTimer *seekTimer;
    numPad *freqPanel;
    qcpcdb *maindb;

    int currStation, timeloop;
    double currFreq, min_freq, max_freq, range, startFreq;
    void init();
    void setThemeIcon();
    void seekStation();
    void startTimer();
    float returnFreq();
    void saveCurrStation(QString name = "");
    void setTunerFreq();

private slots:
    void on_startScanButton_clicked();
    void on_seekUpButton_pressed();
    void on_seekDownButton_pressed();
    void on_setFreqButton_pressed();
    void endTimer();
    void updateGUI();
    void updateUiFreq();
    void setManFreq();
    void startScan();
    void autoSeekStation();
};

#endif // RADIO_H
