#include "hdunit.h"

HdRadioCodes::HdRadioCodes() {

    QByteArray ba;
    ba.append((char)0x01);
    ba.append((char)0x00);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("power",ba));
    ba.clear();
    ba.append((char)0x02);
    ba.append((char)0x00);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("mute",ba));
    ba.clear();
    ba.append((char)0x01);
    ba.append((char)0x01);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("signalstrength",ba));
    ba.clear();
    ba.append((char)0x02);
    ba.append((char)0x01);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("tune",ba));
    ba.clear();
    ba.append((char)0x03);
    ba.append((char)0x01);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("seek",ba));


    ba.clear();
    ba.append((char)0x01);
    ba.append((char)0x02);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdactive",ba));
    ba.clear();
    ba.append((char)0x02);
    ba.append((char)0x02);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdstreamlock",ba));
    ba.clear();
    ba.append((char)0x03);
    ba.append((char)0x02);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdsignalstrength",ba));
    ba.clear();
    ba.append((char)0x04);
    ba.append((char)0x02);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdsubchannel",ba));
    ba.clear();
    ba.append((char)0x05);
    ba.append((char)0x02);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdsubchannelcount",ba));
    ba.clear();
    ba.append((char)0x06);
    ba.append((char)0x02);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdenablehdtuner",ba));
    ba.clear();
    ba.append((char)0x07);
    ba.append((char)0x02);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdtitle",ba));
    ba.clear();
    ba.append((char)0x08);
    ba.append((char)0x02);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdartist",ba));
    ba.clear();
    ba.append((char)0x92);
    ba.append((char)0x02);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdcallsign",ba));
    ba.clear();
    ba.append((char)0x10);
    ba.append((char)0x02);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdstationname",ba));
    //hdRadioCommandCodes.append(QPair<QString,QByteArray>("hduniqueid",QByteArray(0x11,0x02)));
    //hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdapiversion",QByteArray(0x12,0x02)));
    //hdRadioCommandCodes.append(QPair<QString,QByteArray>("hdhwversion",QByteArray(0x13,0x02)));

    ba.clear();
    ba.append((char)0x01);
    ba.append((char)0x03);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("rdsenable",ba));
    ba.clear();
    ba.append((char)0x07);
    ba.append((char)0x03);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("rdsgenre",ba));
    ba.clear();
    ba.append((char)0x08);
    ba.append((char)0x03);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("rdsprogramservice",ba));
    ba.clear();
    ba.append((char)0x09);
    ba.append((char)0x03);
    hdRadioCommandCodes.append(QPair<QString,QByteArray>("rdsradiotext",ba));



    ba.clear();
    ba.append((char)0x00);
    ba.append((char)0x00);
    hdRadioOperationCodes.append(QPair<QString,QByteArray>("set",ba));
    ba.clear();
    ba.append((char)0x01);
    ba.append((char)0x00);
    hdRadioOperationCodes.append(QPair<QString,QByteArray>("get",ba));
    ba.clear();
    ba.append((char)0x02);
    ba.append((char)0x00);
    hdRadioOperationCodes.append(QPair<QString,QByteArray>("reply",ba));

    ba.clear();
    ba.append((char)0x01);
    ba.append((char)0x00);
    ba.append((char)0x00);
    ba.append((char)0x00);
    hdRadioConstantCodes.append(QPair<QString,QByteArray>("up",ba));
    ba.clear();
    ba.append((char)0xFF);
    ba.append((char)0xFF);
    ba.append((char)0xFF);
    ba.append((char)0xFF);
    hdRadioConstantCodes.append(QPair<QString,QByteArray>("down",ba));
    ba.clear();
    ba.append((char)0x01);
    ba.append((char)0x00);
    ba.append((char)0x00);
    ba.append((char)0x00);
    hdRadioConstantCodes.append(QPair<QString,QByteArray>("fm",ba));
    ba.clear();
    ba.append((char)0x00);
    ba.append((char)0x00);
    ba.append((char)0x00);
    ba.append((char)0x00);
    hdRadioConstantCodes.append(QPair<QString,QByteArray>("am",ba));
    ba.clear();
    ba.append((char)0x01);
    ba.append((char)0x00);
    ba.append((char)0x00);
    ba.append((char)0x00);
    hdRadioConstantCodes.append(QPair<QString,QByteArray>("one",ba));
    ba.clear();
    ba.append((char)0x00);
    ba.append((char)0x00);
    ba.append((char)0x00);
    ba.append((char)0x00);
    hdRadioConstantCodes.append(QPair<QString,QByteArray>("zero",ba));

    hdRadioDataFormat.append(QPair<QString,QString>("power","boolean"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdactive","boolean"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdstreamlock","boolean"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdsignalstrength","int"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdsubchannel","bitmask"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdsubchannelcount","bitmask"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdenablehdtuner","boolean"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdtitle","int:string"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdartist","int:string"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdcallsign","string"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdstationname","string"));
    hdRadioDataFormat.append(QPair<QString,QString>("hduniqueid","string"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdapiversion","string"));
    hdRadioDataFormat.append(QPair<QString,QString>("hdhwversion","string"));
    hdRadioDataFormat.append(QPair<QString,QString>("rdsradiotext","string"));
    hdRadioDataFormat.append(QPair<QString,QString>("rdsprogramservice","string"));
    hdRadioDataFormat.append(QPair<QString,QString>("rdsgenre","string"));

}

QString HdRadioCodes::getReturnFormat(QString arg) {
    for (int i=0;i<hdRadioDataFormat.count();i++) {
        if (hdRadioDataFormat[i].first == arg)
            return hdRadioDataFormat[i].second;
    }
    return "";
}

QString HdRadioCodes::getCommandStringFromBytes(QByteArray ba) {
    for (int i=0;i<hdRadioCommandCodes.count();i++) {
        char one = ba[0];
        char two = ba[1];
        QString first = hdRadioCommandCodes[i].first;
        char oneone = hdRadioCommandCodes[i].second[0];
        char twotwo = hdRadioCommandCodes[i].second[1];
        if ((one == 0x09) && (two == 0x03))
            int stop = 1;
        if (ba == hdRadioCommandCodes[i].second)
            return hdRadioCommandCodes[i].first;
    }
    return "";
}

QByteArray HdRadioCodes::getOperationBytesFromString(QString op) {
    for (int i=0;i<hdRadioOperationCodes.count();i++) {
        if (op == hdRadioOperationCodes[i].first)
            return hdRadioOperationCodes[i].second;
    }
    return QByteArray();
}

QByteArray HdRadioCodes::getCommandBytesFromString(QString op) {
    for (int i = 0;i < hdRadioCommandCodes.count(); i++) {
        if (op == hdRadioCommandCodes[i].first)
            return hdRadioCommandCodes[i].second;
    }
    return QByteArray();
}

QString HdRadioCodes::getOperationStringFromBytes(QByteArray ba) {
    for (int i=0;i<hdRadioOperationCodes.count();i++) {
        if (ba == hdRadioOperationCodes[i].second)
            return hdRadioOperationCodes[i].first;
    }
    return "";
}

QString HdRadioCodes::getConstantStringFromBytes(QByteArray ba) {
    for (int i=0;i<hdRadioConstantCodes.count();i++) {
        if (ba == hdRadioConstantCodes[i].second)
            return hdRadioConstantCodes[i].first;
    }
    return "";
}

QByteArray HdRadioCodes::getConstantBytesFromString(QString op) {
    for (int i=0;i<hdRadioConstantCodes.count();i++) {
        if (op == hdRadioConstantCodes[i].first)
            return hdRadioConstantCodes[i].second;
    }
    return QByteArray();
}

HdRadioMessage::HdRadioMessage(QByteArray message,HdRadioCodes *hdCodes) {
        messageClass = "";
        messageDirection = "";
        valid = false;
        if (message[0] == (char)0xA4) {
            valid = true;
            messageClass = hdCodes->getCommandStringFromBytes(message.mid(2,2));
            messageDirection = hdCodes->getOperationStringFromBytes(message.mid(4,2));
            QString retType = hdCodes->getReturnFormat(messageClass);
            if (retType == "boolean") {
                if (message[6] == (char)0x01)
                    messageArg = "true";
                else
                    messageArg = "false";
            } else if (retType == "int:string") {
                messageArg += QString::number(message.at(6)).append(0x24);
                for (int i=14;i<message.length()-1;i++) {
                    messageArg += message[i];
                    //messageArg += QString::number(message.at(6).append(0x24).append(
                }
            } else if (retType == "string") {
                for (int i=10;i<message.length()-1;i++) {
                    //messageArg += QString::number(message.at(6)).append(0x24).append(message.at(i));
                    messageArg += message[i];
                }
            } else if (retType == "bitmask") {
                for (int i=6;i<message.length()-1;i++)
                    messageArg += QString::number(message[i]);
            }
            //if ((message[6] == (char)0x01) && (message[7] == (char)0x00) && (message[8] == (char)0x00) && (message[9] == (char)0x00))
            //{
            //	messageArg = "up";
            //}
        }
}

hd_unit::hd_unit(QObject *parent) :
    QObject(parent) {
    hdCodes = new HdRadioCodes();
    serial = new serialCOM();
    serialTimer = new QTimer(this);
    connect(serialTimer,SIGNAL(timeout()),this,SLOT(serialReadTimer()));

    subChannelTimer = new QTimer(this);
    connect(subChannelTimer,SIGNAL(timeout()),this,SLOT(subChannelTimerTimeout()));

    inMessage = false;
    isFirst = false;
    messageCount = 0;
    currentCount = 0;
    deviceOpen = false;

    mySet = new QSettings("qcarpc", "radio-hd",this);
    mySet->setPath(QSettings::IniFormat,QSettings::UserScope,"qcarpc");
    deviceOpen = serial->OpenPort(mySet->value("serialport").toString().toStdString());
    serial->SetPortSettings(9600,8,'N',0);
    if (deviceOpen) {
        QByteArray ba;
        ba.append(hdCodes->getCommandBytesFromString("power"));
        ba.append(hdCodes->getOperationBytesFromString("set"));
        ba.append(hdCodes->getConstantBytesFromString("up"));
        sendMessage(ba);
        serialTimer->start(10);
    }
}

hd_unit::~hd_unit() {
    if (serial->IsOpen())
        serial->ClosePort();
}

void hd_unit::serialReadTimer() {
    char c;
    if (serial->Read(0,1,0,&c,0))
    {
        if ((unsigned char)c == 0xA4)
        {
            if (inMessage)
            {
                //need to restart message
                currentCount = 0;
                recvArray.clear();
                isFirst = true;
                recvArray.append(c);
            }
            else
            {
                currentCount = 0;
                recvArray.clear();
                inMessage = true;
                isFirst = true;
                recvArray.append(c);
            }
        }
        else
        {
            if (inMessage)
            {
                if (isFirst)
                {
                    messageCount = (int)c;
                    recvArray.append(c);
                    isFirst = false;
                }
                else
                {
                    if (currentCount >= messageCount)
                    {
                        recvArray.append(c);
                        parseMessage(recvArray);
                        inMessage = false;
                        isFirst = false;

                    }
                    else
                    {
                        recvArray.append(c);
                        currentCount ++;
                    }
                }
            }
            else
            {
                //Something's wrong here?
            }
        }
        //recvArray.append(c);
    }

}


void hd_unit::setFreq(double value) {
    QString valueStr = QString::number(value);
    valueStr.replace(".","");
    int valueInt = valueStr.toInt();
    char top = (valueInt >> 8) & 0xFF;
    char bottom = valueInt & 0xFF;
    QByteArray cmd;
    cmd.append(hdCodes->getCommandBytesFromString("tune"));
    cmd.append(hdCodes->getOperationBytesFromString("set"));
    cmd.append(hdCodes->getConstantBytesFromString("fm"));
    cmd.append(bottom);
    cmd.append(top);
    cmd.append((char)0x00);
    cmd.append((char)0x00);
    cmd.append(hdCodes->getConstantBytesFromString("zero"));
    sendMessage(cmd);
    cmd.clear();
    cmd.append((char)0x01);
    cmd.append((char)0x02);
    cmd.append((char)0x01);
    cmd.append((char)0x00);
    sendMessage(cmd);
    cmd.clear();
    cmd.append(hdCodes->getCommandBytesFromString("hdsubchannelcount"));
    cmd.append(hdCodes->getOperationBytesFromString("get"));
    sendMessage(cmd);
}

int hd_unit::getSNR() {

}

int hd_unit::getRSSI() {

}

bool hd_unit::isStereo() {

}

void hd_unit::subChannelTimerTimeout()
{
    QByteArray cmd;
    cmd.append(hdCodes->getCommandBytesFromString("hdsubchannelcount"));
    cmd.append(hdCodes->getOperationBytesFromString("get"));
    sendMessage(cmd);
}

void hd_unit::parseMessage(QByteArray arr) {
    HdRadioMessage tmp(arr,hdCodes);
    if (tmp.valid)
    {
        if (tmp.messageClass == "power")
        {
            if (tmp.messageDirection == "reply")
            {
                if (tmp.messageArg == "up")
                {
                    //Power on!

                }
                else
                {
                    //QMessageBox::information(0,"Wee",tmp.messageArg);
                }
            }
        }
        else if (tmp.messageClass == "tune")
        {
            if (tmp.messageDirection == "reply")
            {
                if (tmp.messageArg != "")
                {
                    //this->setWindowTitle(tmp.messageArg);
                }
            }

        }
        else if (tmp.messageClass == "hdcallsign")
        {
            //ui.hdCallSignLineEdit->setText(QString("Call: ").append(tmp.messageArg));
        }
        else if (tmp.messageClass == "hdtitle")
        {
            int num = tmp.messageArg.split(0x24)[0].toInt();
            QString mes = tmp.messageArg.split(0x24)[1];
            if (subChannelTitle.count() > (num / 2))
            {
                subChannelTitle[num / 2] = mes;
            }
            else
            {
                subChannelTitle.append(mes);
            }
            if ((1 << currentSubChannel) == num)
            {
                //ui.hdTitleLineEdit->setText(QString("Title: ").append(mes));
                emit showMessage("Title " + mes);
            }
            //if (1 << current
        }
        else if (tmp.messageClass == "hdartist")
        {
            int num = tmp.messageArg.split(0x24)[0].toInt();
            QString mes = tmp.messageArg.split(0x24)[1];
            if (subChannelArtist.count() > (num / 2))
            {
                subChannelArtist[num / 2] = mes;
            }
            else
            {
                subChannelArtist.append(mes);
            }
            if ((1 << currentSubChannel) == num)
            {
                emit showMessage("Artist " + mes);
                //ui.hdArtistLineEdit->setText(QString("Artist: ").append(mes));
            }
        }
        else if (tmp.messageClass == "hdactive")
        {
            //this->setWindowTitle(QString("HD Active: ").append(tmp.messageArg));
            if (tmp.messageArg == "true")
            {
                QByteArray cmd;
                cmd.append(hdCodes->getCommandBytesFromString("hdsubchannelcount"));
                cmd.append(hdCodes->getOperationBytesFromString("get"));
                sendMessage(cmd);
            }
            else if (tmp.messageArg == "false")
            {
                QByteArray cmd;
                cmd.append(hdCodes->getCommandBytesFromString("rdsenable"));
                cmd.append(hdCodes->getOperationBytesFromString("set"));
                cmd.append(hdCodes->getConstantBytesFromString("one"));
                sendMessage(cmd);
                emit showMessage("HD not active");
            }
        }
        else if (tmp.messageClass == "rdsradiotext")
        {
            if (tmp.messageDirection == "reply")
            {
                //this->setWindowTitle(tmp.messageArg);
                //ui.radioTextLineEdit->setText(tmp.messageArg);
                emit showMessage("RDS: "+tmp.messageArg);
            }
        }
        else if (tmp.messageClass == "hdstationname")
        {
            //ui.hdStationNameLineEdit->setText(tmp.messageArg);
            emit showMessage("HD station" + tmp.messageArg);
        }
        else if (tmp.messageClass == "hdsubchannelcount")
        {
            totalSubChannels = tmp.messageArg.replace("0","").toInt();
            //ui.subChannelLineEdit->setText(QString("Sub Channels: ").append(tmp.messageArg));
            emit showMessage("HD subchannel count " + tmp.messageArg);
        }
        else if (tmp.messageClass == "rdsprogramservice")
        {
            if (tmp.messageDirection == "reply")
            {
                //this->setWindowTitle(tmp.messageArg);
                //ui.radioProgramLineEdit->setText(tmp.messageArg);
                emit showMessage("RDS: programm " + tmp.messageArg);
            }
        }
        else if (tmp.messageClass == "rdsgenre")
        {
            if (tmp.messageDirection == "reply")
            {
                //this->setWindowTitle(tmp.messageArg);
                //ui.genreLineEdit->setText(tmp.messageArg);
                emit showMessage("RDS: genre "+ tmp.messageArg);
            }
        }
        else if (tmp.messageClass == "hdstreamlock")
        {
            if (tmp.messageArg == "true")
            {
                QByteArray cmd;
                cmd.append(hdCodes->getCommandBytesFromString("hdsubchannelcount"));
                cmd.append(hdCodes->getOperationBytesFromString("get"));
                sendMessage(cmd);
                //ui.lineEdit->setText("Stream Lock: 1");
                subChannelTimer->start(5000);
            }
            else if (tmp.messageArg == "false")
            {
                //ui.lineEdit->setText("Stream Lock: 0");
                subChannelTimer->stop();
            }
        }
    }

}

void hd_unit::sendMessage(QByteArray arr) {
    int csum = 0;
    for (int i=0;i<arr.length();i++)
        csum += arr[i];
    csum += arr.length();
    csum += 0xA4;
    arr.prepend(arr.length());
    arr.prepend(0xA4);
    arr.append((csum % 256));
    serial->Write(arr.data(),arr.length());
}
