#include "hdsetup.h"
#include "ui_hdsetup.h"

hdsetup::hdsetup(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::hdsetup)
{
    ui->setupUi(this);
    qApp->setStyleSheet(themes::instance()->getStyleSheet());
    ui->saveButton->setIcon(QIcon(themes::instance()->getIconFileName("button_back")));
    ui->updateSRbutton->setIcon(QIcon(themes::instance()->getIconFileName("button_update")));

    mySet = new QSettings("qcarpc", "radio-hd",this);
    mySet->setPath(QSettings::IniFormat,QSettings::UserScope,"qcarpc");
    AIDevName = mySet->value("indevname").toString();
    if (AIDevName.isEmpty())
        AIDevName = "default";
    portname = mySet->value("serialport").toString();

    updateSerialDevices();
    updateAIDevice();
}

hdsetup::~hdsetup()
{
    delete ui;
}

void hdsetup::updateSerialDevices() {
    ui->serialComboBox->clear();
    std::vector<std::string> portlist = serialCOM::GetAvailablePorts();
    for (unsigned int k=0; k<portlist.size(); k++) {
        QString p_name = QString::fromStdString(portlist.at(k));
        ui->serialComboBox->addItem(p_name,p_name);
    }
    if (ui->serialComboBox->count() == 0)
        ui->serialComboBox->setItemText(0,"No serial devices");
    if (portname.isEmpty())
        ui->serialComboBox->setCurrentIndex(0);
    else
        ui->serialComboBox->setCurrentIndex(ui->serialComboBox->findText(portname));
}

void hdsetup::updateAIDevice() {
    ui->AIComboBox->clear();
    qcpcmediacoredbus *mm_core = new qcpcmediacoredbus(this);
    QList<qcarpc::devInfo> devList = mm_core->getDevices("input");
    foreach(qcarpc::devInfo dev, devList) {
        ui->AIComboBox->addItem(dev.path,dev.name);
    }
    if (ui->AIComboBox->count() == 0)
        ui->AIComboBox->setItemText(0,"No devices");
    ui->AIComboBox->setCurrentIndex(ui->AIComboBox->findText(AIDevName));
}

void hdsetup::on_updateSRbutton_pressed() {
    updateSerialDevices();
}

void hdsetup::on_AIComboBox_currentIndexChanged(int index) {
    AIDevName = ui->AIComboBox->itemData(index).toString();
}

void hdsetup::on_serialComboBox_currentIndexChanged(int index) {
    portname = ui->serialComboBox->itemData(index).toString();
}

void hdsetup::on_saveButton_pressed() {
    mySet->setValue("indevname",AIDevName);
    mySet->setValue("serialport",portname);
    qApp->quit();
}
