/*
 * **.cpp -
 *
 * Copyright (C) 2010-2012 Serge Begger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "radio.h"
#include "hdsetup.h"
#include <QApplication>

int main(int argc, char *argv[])
{
    QTextCodec::setCodecForCStrings(QTextCodec::codecForLocale());
    QTextCodec::setCodecForTr(QTextCodec::codecForName("UTF-8"));
    if(argc>1) {
        QString command = QString::fromAscii(argv[1]);
        if (command == "about") {
            QTextStream cout(stdout);
            cout << "radio-hd|button_radiohd|multimedia|";
        } else if(command == "run") {
            QApplication a(argc, argv);
            a.setApplicationName("qcarpc_radio_hd");
            Radio radio;
            radio.show();
            return a.exec();
        } else if(command == "setup") {
            QApplication a(argc, argv);
            a.setApplicationName("qcarpc_radio_hd_setup");
            hdsetup setup;
            setup.show();
            return a.exec();
        }
    }
}

