$(document).ready(function() {
	$("#resetButton").click(function() { 
		sendData($("#resetInput").val());
		return false;
	});
	$("#defaultButton").click(function() { 
		parseData($("#dataInput").val());
		$("#dataOut").val($("#dataInput").val());
		return false;
	});
	$("#sendButton").click(function() { 
		sendData($("#dataOut").val());
		return false;
	});
});

function sendData(val) {
	if (val == '') {
		return;
	}
	var url = "?data=" + val;
	//alert(url);
	$.get(url, function(data) {
		//alert(data);
	});
}

function parseData(val) {
	var total = 34;
	var data = val.split(',');
	var value = "";
	if (data.length != total) {
		return;
	}
	for (var i = 0; i < data.length; i++) {
		value = trim(data[i]);
		$("#dataInput" + i).val(value);
		$("#dataInputHex" + i).val("0x" + value.toString(16).toUpperCase());
		updateBin(i, value);
	}
	updateOutput(total);
}

function trim(string) {
	return string.replace(/(^\s+)|(\s+$)/g, "");
}

function changeValue(dir, index, total) {
	var value = parseInt($("#dataInput" + index).val());
	if (dir == 'up') {
		if (value < 255) {
			value ++;
		}
	}
	else {
		if (value > 0) {
			value --;
		}
	}
	$("#dataInput" + index).val(value);
	$("#dataInputHex" + index).val("0x" + value.toString(16).toUpperCase());
	updateBin(index, value);
	updateOutput(total);
}

function updateValue(index, total) {
	var value = parseInt($("#dataInput" + index).val());
	if (isNaN(value)) {
		value = 0;
	}
	if (value > 255) {
		value = 255;
	}
	else if (value < 0) {
		value = 0;
	}
	$("#dataInput" + index).val(value);
	$("#dataInputHex" + index).val("0x" + value.toString(16).toUpperCase());
	updateBin(index, value);
	updateOutput(total);
}

function updateOutput(total) {
	var output = '';
	for (var i = 0; i < total; i++) {
		if (output != '') {
			output += ',';
		}
		output += $("#dataInput" + i).val();
	}
	$("#dataOut").val(output);
	sendData($("#dataOut").val());
}

function updateBin(index, value) {
	var binValue = value.toString(2);
	$("#dataInputBit" + index + "8").attr('checked', (binValue[0] == "1"));
	$("#dataInputBit" + index + "7").attr('checked', (binValue[1] == "1"));
	$("#dataInputBit" + index + "6").attr('checked', (binValue[2] == "1"));
	$("#dataInputBit" + index + "5").attr('checked', (binValue[3] == "1"));
	$("#dataInputBit" + index + "4").attr('checked', (binValue[4] == "1"));
	$("#dataInputBit" + index + "3").attr('checked', (binValue[5] == "1"));
	$("#dataInputBit" + index + "2").attr('checked', (binValue[6] == "1"));
	$("#dataInputBit" + index + "1").attr('checked', (binValue[7] == "1"));
}

function changeBin(index, total) {
	var value = 0;
	if ($("#dataInputBit" + index + "1").is(':checked')) {
		value += 1;
	}
	if ($("#dataInputBit" + index + "2").is(':checked')) {
		value += 2;
	}
	if ($("#dataInputBit" + index + "3").is(':checked')) {
		value += 4;
	}
	if ($("#dataInputBit" + index + "4").is(':checked')) {
		value += 8;
	}
	if ($("#dataInputBit" + index + "5").is(':checked')) {
		value += 16;
	}
	if ($("#dataInputBit" + index + "6").is(':checked')) {
		value += 32;
	}
	if ($("#dataInputBit" + index + "7").is(':checked')) {
		value += 64;
	}
	if ($("#dataInputBit" + index + "8").is(':checked')) {
		value += 128;
	}

	$("#dataInput" + index).val(value);
	$("#dataInputHex" + index).val("0x" + value.toString(16).toUpperCase());
	updateOutput(total);	
}