
// GPS filter memory map interface standard C example

// The text display items
typedef struct _OSDItem{
	short	cx;				// X position (negative = from right edge)
	short	cy;				// Y position (negative = from bottom edge)
	char	szText[64];		// text
}OSDItem;

typedef struct _OSDParams{
	short	ImageWidth;		// width of video
	short	ImageHeight;	// height of video
	short	FontWidth;		// width of font 
	short	FontHeight;		// height of font
	DWORD	FontColor;		// RGB color of font
	char	szFontName[128]; // font name
	BYTE	GPSItem[8];		// GPS display items (index number)
	OSDItem OSD[8];			// Custom text items
} OSDParams;

HANDLE  m_hMapHandle;
OSDParams *pOSD;

// Open the map
void Open()
{
	m_hMapHandle = OpenFileMapping(FILE_MAP_ALL_ACCESS, FALSE, "GPSOSDText");
	if(m_hMapHandle)
		pOSD = (OSDParams *) MapViewOfFile( m_hMapHandle, FILE_MAP_ALL_ACCESS, 0, 0, 0);
}

// Close the map
void Close()
{
	if(m_hMapHandle)
	{
		UnmapViewOfFile((void *)pOSD);
		CloseHandle(m_hMapHandle);
	}
}

// Set a text item
void SetOSDItem(short item, short cx, short cy, char *pszText)
{
	if( item > 7 ) // There are only 8 items
		return;
	if( !pOSD )
		return;
	if( lstrlen(pszText) > 63 )
		return;

	// Set X/Y position
	pOSD->OSD[item].cx = cx;
	pOSD->OSD[item].cy = cy;
	// Copy the text
	lstrcpy(pOSD->OSD[item].szText, pszText);
}
