//----------------------------------------------------------------------------------------------------
// ID Code      : Adjust_customer.h No.0001
// Update Note  :
//
//----------------------------------------------------------------------------------------------------
#ifdef __MAIN__
//----------------------------------------------------------------------------------------------------
// Filter Coefficient Table (Sharpness)
//----------------------------------------------------------------------------------------------------
BYTE code tSU_COEF_0[] =
{
/*
    0x04,0x00,0x03,0x00,0x02,0x00,0x00,0x00,0xFE,0x0F,0xFA,0x0F,0xF6,0x0F,0xF2,0x0F,
    0xEC,0x0F,0xE6,0x0F,0xE0,0x0F,0xD9,0x0F,0xD2,0x0F,0xCA,0x0F,0xC3,0x0F,0xBB,0x0F,
    0xCA,0x0F,0xE0,0x0F,0xF7,0x0F,0x13,0x00,0x31,0x00,0x54,0x00,0x78,0x00,0xA1,0x00,
    0xCB,0x00,0xFA,0x00,0x28,0x01,0x5B,0x01,0x8D,0x01,0xC3,0x01,0xF7,0x01,0x2E,0x02,
    0x79,0x04,0x72,0x04,0x68,0x04,0x55,0x04,0x40,0x04,0x25,0x04,0x07,0x04,0xE2,0x03,
    0xBD,0x03,0x91,0x03,0x65,0x03,0x34,0x03,0x03,0x03,0xCE,0x02,0x99,0x02,0x63,0x02,
    0xB9,0x0F,0xAB,0x0F,0x9F,0x0F,0x98,0x0F,0x91,0x0F,0x8D,0x0F,0x8B,0x0F,0x8B,0x0F,
    0x8C,0x0F,0x8F,0x0F,0x93,0x0F,0x98,0x0F,0x9E,0x0F,0xA5,0x0F,0xAD,0x0F,0xB4,0x0F,
*/
	0xd6, 0x0f, 0xe1, 0x0f, 0xe0, 0x0f, 0xe1, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xdd, 0x0f, 0xdc, 0x0f, 
	0xdb, 0x0f, 0xd9, 0x0f, 0xd7, 0x0f, 0xd7, 0x0f, 0xd5, 0x0f, 0xd6, 0x0f, 0xd5, 0x0f, 0xd7, 0x0f, 
	0x7f, 0x00, 0x94, 0x00, 0xab, 0x00, 0xc5, 0x00, 0xde, 0x00, 0xf9, 0x00, 0x14, 0x01, 0x32, 0x01, 
	0x4e, 0x01, 0x6c, 0x01, 0x88, 0x01, 0xa7, 0x01, 0xc4, 0x01, 0xe2, 0x01, 0xfe, 0x01, 0x1b, 0x02, 
	0x40, 0x03, 0x31, 0x03, 0x2c, 0x03, 0x1f, 0x03, 0x17, 0x03, 0x09, 0x03, 0xfc, 0x02, 0xeb, 0x02, 
	0xda, 0x02, 0xc6, 0x02, 0xb3, 0x02, 0x9b, 0x02, 0x85, 0x02, 0x6b, 0x02, 0x52, 0x02, 0x36, 0x02, 
	0x6b, 0x00, 0x5a, 0x00, 0x49, 0x00, 0x3b, 0x00, 0x2b, 0x00, 0x1e, 0x00, 0x13, 0x00, 0x07, 0x00, 
	0xfd, 0x0f, 0xf5, 0x0f, 0xee, 0x0f, 0xe7, 0x0f, 0xe2, 0x0f, 0xdd, 0x0f, 0xdb, 0x0f, 0xd8, 0x0f, 
};

BYTE code tSU_COEF_1[] =
{
    0xF9,0x0F,0xF9,0x0F,0xF8,0x0F,0xF5,0x0F,0xF3,0x0F,0xF0,0x0F,0xEC,0x0F,0xE8,0x0F,
    0xE2,0x0F,0xDD,0x0F,0xD7,0x0F,0xD1,0x0F,0xCA,0x0F,0xC4,0x0F,0xBE,0x0F,0xB7,0x0F,
    0xF6,0x0F,0x0E,0x00,0x27,0x00,0x45,0x00,0x63,0x00,0x85,0x00,0xA7,0x00,0xCE,0x00,
    0xF6,0x00,0x20,0x01,0x4A,0x01,0x79,0x01,0xA6,0x01,0xD6,0x01,0x04,0x02,0x35,0x02,
    0x2F,0x04,0x28,0x04,0x1F,0x04,0x10,0x04,0xFE,0x03,0xE7,0x03,0xCE,0x03,0xAF,0x03,
    0x8F,0x03,0x69,0x03,0x44,0x03,0x19,0x03,0xEF,0x02,0xC1,0x02,0x93,0x02,0x63,0x02,
    0xE2,0x0F,0xD1,0x0F,0xC2,0x0F,0xB6,0x0F,0xAC,0x0F,0xA4,0x0F,0x9F,0x0F,0x9B,0x0F,
    0x99,0x0F,0x9A,0x0F,0x9B,0x0F,0x9D,0x0F,0xA1,0x0F,0xA5,0x0F,0xAB,0x0F,0xB1,0x0F,
};

BYTE code tSU_COEF_2[] =
{
    0xED,0x0F,0xED,0x0F,0xEB,0x0F,0xE9,0x0F,0xE6,0x0F,0xE3,0x0F,0xDF,0x0F,0xDB,0x0F,
    0xD7,0x0F,0xD2,0x0F,0xCC,0x0F,0xC8,0x0F,0xC3,0x0F,0xBE,0x0F,0xB9,0x0F,0xB5,0x0F,
    0x25,0x00,0x42,0x00,0x5C,0x00,0x7D,0x00,0x9B,0x00,0xBD,0x00,0xDE,0x00,0x03,0x01,
    0x27,0x01,0x4E,0x01,0x74,0x01,0x9B,0x01,0xC2,0x01,0xEB,0x01,0x11,0x02,0x3A,0x02,
    0xDC,0x03,0xCA,0x03,0xC4,0x03,0xB6,0x03,0xA8,0x03,0x94,0x03,0x81,0x03,0x68,0x03,
    0x4E,0x03,0x31,0x03,0x13,0x03,0xF1,0x02,0xD0,0x02,0xAB,0x02,0x88,0x02,0x60,0x02,
    0x12,0x00,0x07,0x00,0xF5,0x0F,0xE4,0x0F,0xD7,0x0F,0xCC,0x0F,0xC2,0x0F,0xBA,0x0F,
    0xB4,0x0F,0xAF,0x0F,0xAD,0x0F,0xAC,0x0F,0xAB,0x0F,0xAC,0x0F,0xAE,0x0F,0xB1,0x0F,
};

BYTE code tSU_COEF_3[] =
{
    0xE0,0x0F,0xE9,0x0F,0xE7,0x0F,0xE7,0x0F,0xE3,0x0F,0xE2,0x0F,0xDE,0x0F,0xDB,0x0F,
    0xD7,0x0F,0xD3,0x0F,0xCF,0x0F,0xCC,0x0F,0xC9,0x0F,0xC6,0x0F,0xC4,0x0F,0xC3,0x0F,
    0x5D,0x00,0x74,0x00,0x8D,0x00,0xAA,0x00,0xC6,0x00,0xE5,0x00,0x04,0x01,0x24,0x01,
    0x44,0x01,0x67,0x01,0x86,0x01,0xA9,0x01,0xCA,0x01,0xED,0x01,0x0D,0x02,0x2E,0x02,
    0x7A,0x03,0x6C,0x03,0x67,0x03,0x5A,0x03,0x50,0x03,0x40,0x03,0x31,0x03,0x1E,0x03,
    0x0B,0x03,0xF3,0x02,0xDD,0x02,0xC2,0x02,0xA7,0x02,0x8A,0x02,0x6D,0x02,0x4D,0x02,
    0x49,0x00,0x37,0x00,0x25,0x00,0x15,0x00,0x07,0x00,0xF9,0x0F,0xED,0x0F,0xE3,0x0F,
    0xDA,0x0F,0xD3,0x0F,0xCE,0x0F,0xC9,0x0F,0xC6,0x0F,0xC3,0x0F,0xC2,0x0F,0xC2,0x0F,
};

BYTE code tSU_COEF_4[] =
{
    0xD6,0x0F,0xE1,0x0F,0xE0,0x0F,0xE1,0x0F,0xE0,0x0F,0xE0,0x0F,0xDD,0x0F,0xDC,0x0F,
    0xDB,0x0F,0xD9,0x0F,0xD7,0x0F,0xD7,0x0F,0xD5,0x0F,0xD6,0x0F,0xD5,0x0F,0xD7,0x0F,
    0x7F,0x00,0x94,0x00,0xAB,0x00,0xC5,0x00,0xDE,0x00,0xF9,0x00,0x14,0x01,0x32,0x01,
    0x4E,0x01,0x6C,0x01,0x88,0x01,0xA7,0x01,0xC4,0x01,0xE2,0x01,0xFE,0x01,0x1B,0x02,
    0x40,0x03,0x31,0x03,0x2C,0x03,0x1F,0x03,0x17,0x03,0x09,0x03,0xFC,0x02,0xEB,0x02,
    0xDA,0x02,0xC6,0x02,0xB3,0x02,0x9B,0x02,0x85,0x02,0x6B,0x02,0x52,0x02,0x36,0x02,
    0x6B,0x00,0x5A,0x00,0x49,0x00,0x3B,0x00,0x2B,0x00,0x1E,0x00,0x13,0x00,0x07,0x00,
    0xFD,0x0F,0xF5,0x0F,0xEE,0x0F,0xE7,0x0F,0xE2,0x0F,0xDD,0x0F,0xDB,0x0F,0xD8,0x0F,
};

code BYTE *tSU_COEF_TABLE[] =
{
    tSU_COEF_0,     tSU_COEF_1,     tSU_COEF_2,     tSU_COEF_3,     tSU_COEF_4,
};


BYTE code tSD_COEF_MID[] = 
{
/*	0x07,0x00, 0x09,0x00, 0x0c,0x00, 0x10,0x00, 0x15,0x00, 0x1b,0x00, 0x24,0x00, 0x2e,0x00, 
	0xe9,0x00, 0x07,0x01, 0x25,0x01, 0x45,0x01, 0x64,0x01, 0x83,0x01, 0xa2,0x01, 0xbe,0x01, 
	0x43,0x02, 0x3f,0x02, 0x37,0x02, 0x2b,0x02, 0x1b,0x02, 0x08,0x02, 0xf2,0x01, 0xda,0x01, 
	0xcc,0x00, 0xb1,0x00, 0x98,0x00, 0x81,0x00, 0x6c,0x00, 0x59,0x00, 0x48,0x00, 0x3a,0x00, 
*/
	0x08,0x00, 0x09,0x00, 0x0c,0x00, 0x10,0x00, 0x15,0x00, 0x1c,0x00, 0x24,0x00, 0x2e,0x00, 
	0xe9,0x00, 0x07,0x01, 0x25,0x01, 0x45,0x01, 0x64,0x01, 0x83,0x01, 0xa2,0x01, 0xbe,0x01, 
	0x43,0x02, 0x3f,0x02, 0x37,0x02, 0x2a,0x02, 0x1b,0x02, 0x08,0x02, 0xf2,0x01, 0xda,0x01, 
	0xcc,0x00, 0xb1,0x00, 0x98,0x00, 0x81,0x00, 0x6c,0x00, 0x59,0x00, 0x48,0x00, 0x3a,0x00, 
};

BYTE code tSD_COEF_BlUR[] = 
{
/*
	0x07,0x00, 0x09,0x00, 0x0c,0x00, 0x10,0x00, 0x15,0x00, 0x1b,0x00, 0x24,0x00, 0x2e,0x00, 
	0xe9,0x00, 0x07,0x01, 0x25,0x01, 0x45,0x01, 0x64,0x01, 0x83,0x01, 0xa2,0x01, 0xbe,0x01, 
	0x43,0x02, 0x3f,0x02, 0x37,0x02, 0x2b,0x02, 0x1b,0x02, 0x08,0x02, 0xf2,0x01, 0xda,0x01, 
	0xcc,0x00, 0xb1,0x00, 0x98,0x00, 0x81,0x00, 0x6c,0x00, 0x59,0x00, 0x48,0x00, 0x3a,0x00, 
*/	
	0x08,0x00, 0x09,0x00, 0x0c,0x00, 0x10,0x00, 0x15,0x00, 0x1c,0x00, 0x24,0x00, 0x2e,0x00, 
	0xe9,0x00, 0x07,0x01, 0x25,0x01, 0x45,0x01, 0x64,0x01, 0x83,0x01, 0xa2,0x01, 0xbe,0x01, 
	0x43,0x02, 0x3f,0x02, 0x37,0x02, 0x2a,0x02, 0x1b,0x02, 0x08,0x02, 0xf2,0x01, 0xda,0x01, 
	0xcc,0x00, 0xb1,0x00, 0x98,0x00, 0x81,0x00, 0x6c,0x00, 0x59,0x00, 0x48,0x00, 0x3a,0x00, 
};

BYTE code tSD_COEF_SHARP[] = 
{
/*
	0x03,0x00, 0x05,0x00, 0x07,0x00, 0x09,0x00, 0x0d,0x00, 0x13,0x00, 0x19,0x00, 0x22,0x00, 
	0xda,0x00, 0xfa,0x00, 0x1c,0x01, 0x3f,0x01, 0x62,0x01, 0x85,0x01, 0xa8,0x01, 0xc9,0x01, 
	0x66,0x02, 0x61,0x02, 0x57,0x02, 0x49,0x02, 0x36,0x02, 0x20,0x02, 0x06,0x02, 0xe9,0x01, 
	0xbc,0x00, 0xa0,0x00, 0x86,0x00, 0x6f,0x00, 0x5b,0x00, 0x49,0x00, 0x39,0x00, 0x2d,0x00, 
*/
	0x04,0x00, 0x05,0x00, 0x07,0x00, 0x09,0x00, 0x0d,0x00, 0x13,0x00, 0x19,0x00, 0x22,0x00, 
	0xda,0x00, 0xfa,0x00, 0x1c,0x01, 0x3f,0x01, 0x62,0x01, 0x85,0x01, 0xa8,0x01, 0xc9,0x01, 
	0x66,0x02, 0x61,0x02, 0x57,0x02, 0x49,0x02, 0x36,0x02, 0x1f,0x02, 0x06,0x02, 0xe8,0x01, 
	0xbc,0x00, 0xa0,0x00, 0x86,0x00, 0x6f,0x00, 0x5b,0x00, 0x49,0x00, 0x39,0x00, 0x2d,0x00, 

};

BYTE code tSD_COEF_2TAP[] = 
{
	0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00,
	0x20,0x00, 0x60,0x00, 0xa0,0x00, 0xE0,0x00, 0x20,0x01, 0x60,0x01, 0xa0,0x01, 0xE0,0x01,
	0xE0,0x03, 0xa0,0x03, 0x60,0x03, 0x20,0x03, 0xE0,0x02, 0xa0,0x02, 0x60,0x02, 0x20,0x02,
	0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00,
};

code BYTE *tSCALE_DOWN_COEF_TABLE[] =
{
    tSD_COEF_MID,     tSD_COEF_BlUR,     tSD_COEF_SHARP,     tSD_COEF_2TAP,
    //tSD_COEF_MID,     tSD_COEF_MID,     tSD_COEF_MID,     tSD_COEF_MID,
};


//----------------------------------------------------------------------------------------------------
// Gamma Table
//----------------------------------------------------------------------------------------------------
#if(_GAMMA_TYPE == _COMPACT_GAMMA_NORMAL_TABLE)

BYTE code tGAMMA_COMPACT1[] =
{
	0x00, 0x03,  //R   1
	0x01, 0xc4,  //R   2
	0x03, 0xc3,  //R   3
	0x05, 0x43,  //R   4
	0x06, 0xc3,  //R   5
	0x08, 0x43,  //R   6
	0x09, 0xc3,  //R   7
	0x0b, 0x43,  //R   8
	0x0c, 0xc3,  //R   9
	0x0e, 0x43,  //R  10
	0x0f, 0xc3,  //R  11
	0x11, 0x43,  //R  12
	0x12, 0xc3,  //R  13
	0x14, 0x43,  //R  14
	0x15, 0xc3,  //R  15
	0x17, 0x43,  //R  16
	0x18, 0xc3,  //R  17
	0x1a, 0x43,  //R  18
	0x1c, 0x03,  //R  19
	0x1d, 0x83,  //R  20
	0x1f, 0x03,  //R  21
	0x20, 0xc3,  //R  22
	0x22, 0x84,  //R  23
	0x24, 0x83,  //R  24
	0x26, 0x43,  //R  25
	0x28, 0x03,  //R  26
	0x29, 0xc3,  //R  27
	0x2b, 0x83,  //R  28
	0x2d, 0x43,  //R  29
	0x2f, 0x03,  //R  30
	0x30, 0xc3,  //R  31
	0x32, 0x83,  //R  32
	0x34, 0x44,  //R  33
	0x36, 0x84,  //R  34
	0x38, 0xc4,  //R  35
	0x3b, 0x04,  //R  36
	0x3d, 0x44,  //R  37
	0x3f, 0x84,  //R  38
	0x41, 0xc4,  //R  39
	0x44, 0x04,  //R  40
	0x46, 0x04,  //R  41
	0x48, 0x44,  //R  42
	0x4a, 0x84,  //R  43
	0x4c, 0xc4,  //R  44
	0x4f, 0x04,  //R  45
	0x51, 0x44,  //R  46
	0x53, 0x84,  //R  47
	0x55, 0xc6,  //R  48
	0x59, 0x04,  //R  49
	0x5b, 0x45,  //R  50
	0x5d, 0xc4,  //R  51
	0x60, 0x05,  //R  52
	0x62, 0x84,  //R  53
	0x64, 0xc5,  //R  54
	0x67, 0x44,  //R  55
	0x69, 0x86,  //R  56
	0x6c, 0x85,  //R  57
	0x6f, 0x05,  //R  58
	0x71, 0x85,  //R  59
	0x74, 0x05,  //R  60
	0x76, 0x85,  //R  61
	0x79, 0x05,  //R  62
	0x7b, 0x86,  //R  63
	0x7e, 0xc6,  //R  64
	0x82, 0x04,  //R  65
	0x84, 0x45,  //R  66
	0x86, 0xc4,  //R  67
	0x89, 0x05,  //R  68
	0x8b, 0x84,  //R  69
	0x8d, 0xc5,  //R  70
	0x90, 0x44,  //R  71
	0x92, 0x85,  //R  72
	0x95, 0x45,  //R  73
	0x97, 0xc5,  //R  74
	0x9a, 0x45,  //R  75
	0x9c, 0xc5,  //R  76
	0x9f, 0x45,  //R  77
	0xa1, 0xc5,  //R  78
	0xa4, 0x45,  //R  79
	0xa6, 0xc4,  //R  80
	0xa9, 0x05,  //R  81
	0xab, 0x85,  //R  82
	0xae, 0x45,  //R  83
	0xb0, 0xc5,  //R  84
	0xb3, 0x85,  //R  85
	0xb6, 0x05,  //R  86
	0xb8, 0xc5,  //R  87
	0xbb, 0x45,  //R  88
	0xbe, 0x04,  //R  89
	0xc0, 0x04,  //R  90
	0xc2, 0x04,  //R  91
	0xc4, 0x04,  //R  92
	0xc6, 0x04,  //R  93
	0xc8, 0x04,  //R  94
	0xca, 0x04,  //R  95
	0xcc, 0x05,  //R  96
	0xce, 0xc4,  //R  97
	0xd1, 0x03,  //R  98
	0xd2, 0xc4,  //R  99
	0xd4, 0xc3,  //R 100
	0xd6, 0x83,  //R 101
	0xd8, 0x03,  //R 102
	0xd9, 0x83,  //R 103
	0xdb, 0x03,  //R 104
	0xdc, 0x83,  //R 105
	0xde, 0x03,  //R 106
	0xdf, 0x83,  //R 107
	0xe1, 0x02,  //R 108
	0xe2, 0x43,  //R 109
	0xe3, 0xc2,  //R 110
	0xe5, 0x03,  //R 111
	0xe6, 0x82,  //R 112
	0xe7, 0xc3,  //R 113
	0xe9, 0x42,  //R 114
	0xea, 0x83,  //R 115
	0xec, 0x02,  //R 116
	0xed, 0x42,  //R 117
	0xee, 0x82,  //R 118
	0xef, 0xc2,  //R 119
	0xf1, 0x02,  //R 120
	0xf2, 0x42,  //R 121
	0xf3, 0x82,  //R 122
	0xf4, 0xc2,  //R 123
	0xf6, 0x04,  //R 124
	0xf8, 0x04,  //R 125
	0xfa, 0x04,  //R 126
	0xfc, 0x04,  //R 127
	0xfe, 0x02,  //R 128
    };
#elif( _GAMMA_TYPE == _FULL_GAMMA_NORMAL_TABLE)

unsigned char code GAMMA_1_R[] = {


	0x00, 0x03, 0x04, 0x01, 0xc4, 0x03, 0x03, 0x84, 0x04, 0x05, 0x83, 0x04,
	0x07, 0x44, 0x04, 0x09, 0x43, 0x04, 0x0b, 0x04, 0x03, 0x0c, 0xc4, 0x04,
	0x0e, 0xc4, 0x03, 0x10, 0x84, 0x04, 0x12, 0x83, 0x04, 0x14, 0x44, 0x04,
	0x16, 0x43, 0x04, 0x18, 0x04, 0x03, 0x19, 0xc4, 0x04, 0x1b, 0xc4, 0x03,
	0x1d, 0x85, 0x05, 0x20, 0x05, 0x04, 0x22, 0x45, 0x04, 0x24, 0x84, 0x04,
	0x26, 0x85, 0x04, 0x28, 0xc4, 0x04, 0x2a, 0xc4, 0x05, 0x2d, 0x04, 0x04,
	0x2f, 0x04, 0x04, 0x31, 0x04, 0x04, 0x33, 0x04, 0x04, 0x35, 0x04, 0x04,
	0x37, 0x04, 0x04, 0x39, 0x04, 0x04, 0x3b, 0x04, 0x04, 0x3d, 0x04, 0x03,
	0x3e, 0xc4, 0x04, 0x40, 0xc4, 0x04, 0x42, 0xc4, 0x04, 0x44, 0xc4, 0x04,
	0x46, 0xc3, 0x04, 0x48, 0x84, 0x04, 0x4a, 0x84, 0x04, 0x4c, 0x83, 0x04,
	0x4e, 0x44, 0x04, 0x50, 0x44, 0x04, 0x52, 0x43, 0x04, 0x54, 0x04, 0x04,
	0x56, 0x04, 0x03, 0x57, 0xc4, 0x04, 0x59, 0xc4, 0x03, 0x5b, 0x84, 0x04,
	0x5d, 0x84, 0x03, 0x5f, 0x44, 0x04, 0x61, 0x44, 0x03, 0x63, 0x04, 0x04,
	0x65, 0x04, 0x03, 0x66, 0xc4, 0x04, 0x68, 0xc3, 0x04, 0x6a, 0x84, 0x04,
	0x6c, 0x83, 0x04, 0x6e, 0x44, 0x03, 0x70, 0x04, 0x04, 0x72, 0x03, 0x04,
	0x73, 0xc4, 0x03, 0x75, 0x84, 0x04, 0x77, 0x83, 0x04, 0x79, 0x44, 0x03,
	0x7b, 0x04, 0x04, 0x7d, 0x03, 0x04, 0x7e, 0xc4, 0x03, 0x80, 0x84, 0x04,
	0x82, 0x83, 0x04, 0x84, 0x44, 0x03, 0x86, 0x04, 0x04, 0x88, 0x03, 0x04,
	0x89, 0xc3, 0x04, 0x8b, 0x84, 0x03, 0x8d, 0x44, 0x04, 0x8f, 0x43, 0x04,
	0x91, 0x03, 0x04, 0x92, 0xc4, 0x03, 0x94, 0x84, 0x03, 0x96, 0x44, 0x04,
	0x98, 0x43, 0x04, 0x9a, 0x03, 0x04, 0x9b, 0xc4, 0x03, 0x9d, 0x84, 0x03,
	0x9f, 0x44, 0x04, 0xa1, 0x43, 0x04, 0xa3, 0x03, 0x04, 0xa4, 0xc4, 0x03,
	0xa6, 0x84, 0x03, 0xa8, 0x44, 0x03, 0xaa, 0x04, 0x04, 0xac, 0x03, 0x04,
	0xad, 0xc3, 0x04, 0xaf, 0x83, 0x04, 0xb1, 0x43, 0x04, 0xb3, 0x04, 0x03,
	0xb4, 0xc4, 0x03, 0xb6, 0x84, 0x03, 0xb8, 0x44, 0x03, 0xba, 0x04, 0x04,
	0xbc, 0x03, 0x04, 0xbd, 0xc3, 0x04, 0xbf, 0x83, 0x04, 0xc1, 0x43, 0x04,
	0xc3, 0x03, 0x04, 0xc4, 0xc3, 0x04, 0xc6, 0x83, 0x04, 0xc8, 0x44, 0x03,
	0xca, 0x04, 0x03, 0xcb, 0xc4, 0x03, 0xcd, 0x84, 0x03, 0xcf, 0x44, 0x03,
	0xd1, 0x04, 0x03, 0xd2, 0xc4, 0x03, 0xd4, 0x84, 0x03, 0xd6, 0x44, 0x03,
	0xd8, 0x04, 0x03, 0xd9, 0xc4, 0x03, 0xdb, 0x84, 0x03, 0xdd, 0x44, 0x03,
	0xdf, 0x04, 0x03, 0xe0, 0xc4, 0x03, 0xe2, 0x84, 0x03, 0xe4, 0x44, 0x03,
	0xe6, 0x04, 0x03, 0xe7, 0xc4, 0x04, 0xe9, 0xc3, 0x04, 0xeb, 0x84, 0x04,

};

unsigned char code GAMMA_1_G[] = {


	0x00, 0x03, 0x04, 0x01, 0xc3, 0x04, 0x03, 0x83, 0x04, 0x05, 0x44, 0x03,
	0x07, 0x04, 0x03, 0x08, 0xc4, 0x04, 0x0a, 0xc3, 0x04, 0x0c, 0x83, 0x04,
	0x0e, 0x44, 0x03, 0x10, 0x04, 0x03, 0x11, 0xc4, 0x04, 0x13, 0xc3, 0x04,
	0x15, 0x83, 0x04, 0x17, 0x44, 0x03, 0x19, 0x04, 0x03, 0x1a, 0xc4, 0x04,
	0x1c, 0xc3, 0x03, 0x1e, 0x43, 0x03, 0x1f, 0xc4, 0x03, 0x21, 0x83, 0x04,
	0x23, 0x43, 0x03, 0x24, 0xc4, 0x03, 0x26, 0x83, 0x04, 0x28, 0x43, 0x04,
	0x2a, 0x03, 0x04, 0x2b, 0xc3, 0x03, 0x2d, 0x44, 0x03, 0x2f, 0x04, 0x03,
	0x30, 0xc4, 0x03, 0x32, 0x84, 0x03, 0x34, 0x44, 0x03, 0x36, 0x04, 0x03,
	0x37, 0xc4, 0x03, 0x39, 0x84, 0x03, 0x3b, 0x44, 0x03, 0x3d, 0x04, 0x03,
	0x3e, 0xc4, 0x03, 0x40, 0x84, 0x03, 0x42, 0x44, 0x03, 0x44, 0x04, 0x03,
	0x45, 0xc4, 0x03, 0x47, 0x84, 0x04, 0x49, 0x83, 0x04, 0x4b, 0x43, 0x04,
	0x4d, 0x03, 0x04, 0x4e, 0xc3, 0x04, 0x50, 0x84, 0x03, 0x52, 0x44, 0x03,
	0x54, 0x04, 0x03, 0x55, 0xc4, 0x03, 0x57, 0x84, 0x04, 0x59, 0x83, 0x04,
	0x5b, 0x43, 0x04, 0x5d, 0x04, 0x03, 0x5e, 0xc4, 0x03, 0x60, 0x84, 0x03,
	0x62, 0x44, 0x04, 0x64, 0x43, 0x04, 0x66, 0x03, 0x04, 0x67, 0xc4, 0x03,
	0x69, 0x84, 0x03, 0x6b, 0x44, 0x04, 0x6d, 0x43, 0x04, 0x6f, 0x04, 0x03,
	0x70, 0xc4, 0x03, 0x72, 0x84, 0x04, 0x74, 0x83, 0x04, 0x76, 0x43, 0x04,
	0x78, 0x04, 0x03, 0x79, 0xc4, 0x04, 0x7b, 0xc3, 0x04, 0x7d, 0x83, 0x04,
	0x7f, 0x44, 0x03, 0x81, 0x04, 0x04, 0x83, 0x03, 0x04, 0x84, 0xc3, 0x04,
	0x86, 0x84, 0x03, 0x88, 0x44, 0x04, 0x8a, 0x43, 0x04, 0x8c, 0x04, 0x03,
	0x8d, 0xc4, 0x03, 0x8f, 0x84, 0x04, 0x91, 0x83, 0x04, 0x93, 0x44, 0x03,
	0x95, 0x04, 0x04, 0x97, 0x03, 0x04, 0x98, 0xc4, 0x03, 0x9a, 0x84, 0x04,
	0x9c, 0x83, 0x04, 0x9e, 0x44, 0x03, 0xa0, 0x04, 0x04, 0xa2, 0x03, 0x04,
	0xa3, 0xc4, 0x03, 0xa5, 0x84, 0x04, 0xa7, 0x83, 0x04, 0xa9, 0x44, 0x03,
	0xab, 0x04, 0x04, 0xad, 0x03, 0x04, 0xae, 0xc4, 0x03, 0xb0, 0x84, 0x04,
	0xb2, 0x83, 0x04, 0xb4, 0x44, 0x03, 0xb6, 0x04, 0x04, 0xb8, 0x03, 0x04,
	0xb9, 0xc4, 0x03, 0xbb, 0x84, 0x04, 0xbd, 0x83, 0x04, 0xbf, 0x44, 0x03,
	0xc1, 0x04, 0x04, 0xc3, 0x03, 0x04, 0xc4, 0xc4, 0x04, 0xc6, 0xc3, 0x04,
	0xc8, 0x84, 0x03, 0xca, 0x44, 0x04, 0xcc, 0x43, 0x04, 0xce, 0x04, 0x03,
	0xcf, 0xc4, 0x04, 0xd1, 0xc3, 0x04, 0xd3, 0x84, 0x04, 0xd5, 0x83, 0x04,
	0xd7, 0x44, 0x03, 0xd9, 0x04, 0x04, 0xdb, 0x03, 0x04, 0xdc, 0xc4, 0x04,
	0xde, 0xc3, 0x04, 0xe0, 0x84, 0x03, 0xe2, 0x44, 0x03, 0xe4, 0x04, 0x04,

};

unsigned char code GAMMA_1_B[] = {

	
	0x00, 0x03, 0x04, 0x01, 0xc4, 0x04, 0x03, 0xc4, 0x04, 0x05, 0xc4, 0x04,
	0x07, 0xc4, 0x04, 0x09, 0xc4, 0x04, 0x0b, 0xc4, 0x04, 0x0d, 0xc4, 0x04,
	0x0f, 0xc4, 0x04, 0x11, 0xc4, 0x04, 0x13, 0xc4, 0x04, 0x15, 0xc4, 0x04,
	0x17, 0xc4, 0x04, 0x19, 0xc4, 0x04, 0x1b, 0xc4, 0x04, 0x1d, 0xc4, 0x04,
	0x1f, 0xc5, 0x04, 0x22, 0x04, 0x04, 0x24, 0x04, 0x04, 0x26, 0x04, 0x04,
	0x28, 0x05, 0x04, 0x2a, 0x44, 0x04, 0x2c, 0x44, 0x04, 0x2e, 0x44, 0x04,
	0x30, 0x44, 0x04, 0x32, 0x44, 0x04, 0x34, 0x44, 0x04, 0x36, 0x44, 0x04,
	0x38, 0x44, 0x05, 0x3a, 0x84, 0x04, 0x3c, 0x84, 0x04, 0x3e, 0x84, 0x04,
	0x40, 0x84, 0x04, 0x42, 0x84, 0x04, 0x44, 0x84, 0x04, 0x46, 0x84, 0x04,
	0x48, 0x84, 0x04, 0x4a, 0x84, 0x04, 0x4c, 0x84, 0x04, 0x4e, 0x84, 0x04,
	0x50, 0x84, 0x04, 0x52, 0x84, 0x04, 0x54, 0x84, 0x04, 0x56, 0x84, 0x04,
	0x58, 0x84, 0x04, 0x5a, 0x84, 0x04, 0x5c, 0x84, 0x04, 0x5e, 0x84, 0x04,
	0x60, 0x84, 0x04, 0x62, 0x84, 0x04, 0x64, 0x84, 0x04, 0x66, 0x84, 0x04,
	0x68, 0x84, 0x04, 0x6a, 0x84, 0x04, 0x6c, 0x84, 0x04, 0x6e, 0x84, 0x04,
	0x70, 0x84, 0x04, 0x72, 0x84, 0x04, 0x74, 0x84, 0x04, 0x76, 0x84, 0x04,
	0x78, 0x84, 0x04, 0x7a, 0x84, 0x04, 0x7c, 0x84, 0x04, 0x7e, 0x84, 0x04,
	0x80, 0x84, 0x04, 0x82, 0x84, 0x04, 0x84, 0x84, 0x04, 0x86, 0x84, 0x04,
	0x88, 0x84, 0x04, 0x8a, 0x84, 0x04, 0x8c, 0x84, 0x04, 0x8e, 0x84, 0x04,
	0x90, 0x84, 0x04, 0x92, 0x84, 0x04, 0x94, 0x84, 0x04, 0x96, 0x84, 0x04,
	0x98, 0x84, 0x04, 0x9a, 0x84, 0x04, 0x9c, 0x84, 0x04, 0x9e, 0x84, 0x04,
	0xa0, 0x84, 0x04, 0xa2, 0x84, 0x04, 0xa4, 0x83, 0x04, 0xa6, 0x44, 0x04,
	0xa8, 0x44, 0x04, 0xaa, 0x44, 0x04, 0xac, 0x44, 0x04, 0xae, 0x44, 0x04,
	0xb0, 0x44, 0x04, 0xb2, 0x44, 0x04, 0xb4, 0x44, 0x04, 0xb6, 0x44, 0x04,
	0xb8, 0x44, 0x04, 0xba, 0x44, 0x04, 0xbc, 0x44, 0x04, 0xbe, 0x44, 0x04,
	0xc0, 0x44, 0x04, 0xc2, 0x44, 0x04, 0xc4, 0x44, 0x04, 0xc6, 0x44, 0x03,
	0xc8, 0x04, 0x04, 0xca, 0x04, 0x04, 0xcc, 0x04, 0x04, 0xce, 0x04, 0x04,
	0xd0, 0x04, 0x04, 0xd2, 0x04, 0x04, 0xd4, 0x04, 0x04, 0xd6, 0x04, 0x04,
	0xd8, 0x04, 0x04, 0xda, 0x04, 0x04, 0xdc, 0x04, 0x04, 0xde, 0x04, 0x04,
	0xe0, 0x04, 0x04, 0xe2, 0x03, 0x04, 0xe3, 0xc4, 0x04, 0xe5, 0xc4, 0x04,
	0xe7, 0xc4, 0x04, 0xe9, 0xc4, 0x04, 0xeb, 0xc4, 0x04, 0xed, 0xc4, 0x04,
	0xef, 0xc4, 0x04, 0xf1, 0xc4, 0x04, 0xf3, 0xc4, 0x04, 0xf5, 0xc4, 0x04,
	0xf7, 0xc4, 0x04, 0xf9, 0xc4, 0x04, 0xfb, 0xc4, 0x04, 0xfd, 0xc4, 0x04,


};

unsigned char code GAMMA_2_R[] = {



    0x00, 0x07, 0x06, 0x03, 0x46, 0x05, 0x06, 0x06, 0x05, 0x08, 0xC5, 0x05,
 	0x0B, 0x45, 0x05, 0x0D, 0xC5, 0x05, 0x10, 0x45, 0x05, 0x12, 0xC5, 0x04,
 	0x15, 0x05, 0x05, 0x17, 0x84, 0x05, 0x19, 0xC5, 0x04, 0x1C, 0x05, 0x05,
 	0x1E, 0x84, 0x05, 0x20, 0xC4, 0x05, 0x23, 0x04, 0x05, 0x25, 0x44, 0x04,
 	0x27, 0x45, 0x04, 0x29, 0x85, 0x04, 0x2B, 0xC4, 0x05, 0x2E, 0x04, 0x04,
 	0x30, 0x05, 0x04, 0x32, 0x44, 0x05, 0x34, 0x84, 0x04, 0x36, 0x85, 0x04,
 	0x38, 0xC4, 0x04, 0x3A, 0xC4, 0x05, 0x3D, 0x04, 0x04, 0x3F, 0x04, 0x05,
 	0x41, 0x44, 0x04, 0x43, 0x44, 0x04, 0x45, 0x44, 0x05, 0x47, 0x84, 0x04,
 	0x49, 0x84, 0x04, 0x4B, 0x84, 0x04, 0x4D, 0x84, 0x04, 0x4F, 0x85, 0x04,
 	0x51, 0xC4, 0x04, 0x53, 0xC4, 0x04, 0x55, 0xC4, 0x04, 0x57, 0xC4, 0x04,
 	0x59, 0xC4, 0x04, 0x5B, 0xC4, 0x04, 0x5D, 0xC4, 0x04, 0x5F, 0xC4, 0x04,
 	0x61, 0xC4, 0x04, 0x63, 0xC4, 0x04, 0x65, 0xC4, 0x04, 0x67, 0xC4, 0x04,
 	0x69, 0xC4, 0x04, 0x6B, 0xC4, 0x04, 0x6D, 0xC4, 0x04, 0x6F, 0xC4, 0x04,
 	0x71, 0xC4, 0x04, 0x73, 0xC4, 0x03, 0x75, 0x84, 0x04, 0x77, 0x84, 0x04,
 	0x79, 0x84, 0x04, 0x7B, 0x84, 0x04, 0x7D, 0x84, 0x04, 0x7F, 0x83, 0x04,
 	0x81, 0x44, 0x04, 0x83, 0x44, 0x04, 0x85, 0x44, 0x03, 0x87, 0x04, 0x04,
 	0x89, 0x04, 0x04, 0x8B, 0x04, 0x04, 0x8D, 0x03, 0x04, 0x8E, 0xC4, 0x04,
 	0x90, 0xC4, 0x04, 0x92, 0xC3, 0x04, 0x94, 0x84, 0x04, 0x96, 0x84, 0x04,
 	0x98, 0x83, 0x04, 0x9A, 0x44, 0x04, 0x9C, 0x44, 0x03, 0x9E, 0x04, 0x04,
 	0xA0, 0x04, 0x03, 0xA1, 0xC4, 0x04, 0xA3, 0xC4, 0x04, 0xA5, 0xC3, 0x04,
 	0xA7, 0x84, 0x04, 0xA9, 0x83, 0x04, 0xAB, 0x44, 0x04, 0xAD, 0x43, 0x04,
 	0xAF, 0x04, 0x04, 0xB1, 0x03, 0x04, 0xB2, 0xC4, 0x04, 0xB4, 0xC3, 0x04,
 	0xB6, 0x84, 0x04, 0xB8, 0x83, 0x04, 0xBA, 0x44, 0x04, 0xBC, 0x43, 0x04,
 	0xBE, 0x04, 0x03, 0xBF, 0xC4, 0x04, 0xC1, 0xC4, 0x03, 0xC3, 0x84, 0x04,
 	0xC5, 0x83, 0x04, 0xC7, 0x44, 0x03, 0xC9, 0x04, 0x04, 0xCB, 0x04, 0x03,
 	0xCC, 0xC4, 0x04, 0xCE, 0xC3, 0x04, 0xD0, 0x84, 0x03, 0xD2, 0x44, 0x04,
 	0xD4, 0x43, 0x04, 0xD6, 0x04, 0x03, 0xD7, 0xC4, 0x04, 0xD9, 0xC3, 0x04,
 	0xDB, 0x84, 0x03, 0xDD, 0x44, 0x04, 0xDF, 0x43, 0x04, 0xE1, 0x04, 0x03,
 	0xE2, 0xC4, 0x03, 0xE4, 0x84, 0x04, 0xE6, 0x83, 0x04, 0xE8, 0x44, 0x03,
 	0xEA, 0x04, 0x04, 0xEC, 0x03, 0x04, 0xED, 0xC3, 0x04, 0xEF, 0x84, 0x03,
 	0xF1, 0x44, 0x04, 0xF3, 0x43, 0x04, 0xF5, 0x03, 0x04, 0xF6, 0xC4, 0x03,
 	0xF8, 0x84, 0x03, 0xFA, 0x44, 0x04, 0xFC, 0x43, 0x04, 0xFE, 0x03, 0x04,


};

unsigned char code GAMMA_2_G[] = {

    0x00, 0x07, 0x06, 0x03, 0x46, 0x05, 0x06, 0x06, 0x05, 0x08, 0xC5, 0x05,
 	0x0B, 0x45, 0x05, 0x0D, 0xC5, 0x05, 0x10, 0x45, 0x05, 0x12, 0xC5, 0x04,
 	0x15, 0x05, 0x05, 0x17, 0x84, 0x05, 0x19, 0xC5, 0x04, 0x1C, 0x05, 0x05,
 	0x1E, 0x84, 0x05, 0x20, 0xC4, 0x05, 0x23, 0x04, 0x05, 0x25, 0x44, 0x04,
 	0x27, 0x45, 0x04, 0x29, 0x85, 0x04, 0x2B, 0xC4, 0x05, 0x2E, 0x04, 0x04,
 	0x30, 0x05, 0x04, 0x32, 0x44, 0x05, 0x34, 0x84, 0x04, 0x36, 0x85, 0x04,
 	0x38, 0xC4, 0x04, 0x3A, 0xC4, 0x05, 0x3D, 0x04, 0x04, 0x3F, 0x04, 0x05,
 	0x41, 0x44, 0x04, 0x43, 0x44, 0x04, 0x45, 0x44, 0x05, 0x47, 0x84, 0x04,
 	0x49, 0x84, 0x04, 0x4B, 0x84, 0x04, 0x4D, 0x84, 0x04, 0x4F, 0x85, 0x04,
 	0x51, 0xC4, 0x04, 0x53, 0xC4, 0x04, 0x55, 0xC4, 0x04, 0x57, 0xC4, 0x04,
 	0x59, 0xC4, 0x04, 0x5B, 0xC4, 0x04, 0x5D, 0xC4, 0x04, 0x5F, 0xC4, 0x04,
 	0x61, 0xC4, 0x04, 0x63, 0xC4, 0x04, 0x65, 0xC4, 0x04, 0x67, 0xC4, 0x04,
 	0x69, 0xC4, 0x04, 0x6B, 0xC4, 0x04, 0x6D, 0xC4, 0x04, 0x6F, 0xC4, 0x04,
 	0x71, 0xC4, 0x04, 0x73, 0xC4, 0x03, 0x75, 0x84, 0x04, 0x77, 0x84, 0x04,
 	0x79, 0x84, 0x04, 0x7B, 0x84, 0x04, 0x7D, 0x84, 0x04, 0x7F, 0x83, 0x04,
 	0x81, 0x44, 0x04, 0x83, 0x44, 0x04, 0x85, 0x44, 0x03, 0x87, 0x04, 0x04,
 	0x89, 0x04, 0x04, 0x8B, 0x04, 0x04, 0x8D, 0x03, 0x04, 0x8E, 0xC4, 0x04,
 	0x90, 0xC4, 0x04, 0x92, 0xC3, 0x04, 0x94, 0x84, 0x04, 0x96, 0x84, 0x04,
 	0x98, 0x83, 0x04, 0x9A, 0x44, 0x04, 0x9C, 0x44, 0x03, 0x9E, 0x04, 0x04,
 	0xA0, 0x04, 0x03, 0xA1, 0xC4, 0x04, 0xA3, 0xC4, 0x04, 0xA5, 0xC3, 0x04,
 	0xA7, 0x84, 0x04, 0xA9, 0x83, 0x04, 0xAB, 0x44, 0x04, 0xAD, 0x43, 0x04,
 	0xAF, 0x04, 0x04, 0xB1, 0x03, 0x04, 0xB2, 0xC4, 0x04, 0xB4, 0xC3, 0x04,
 	0xB6, 0x84, 0x04, 0xB8, 0x83, 0x04, 0xBA, 0x44, 0x04, 0xBC, 0x43, 0x04,
 	0xBE, 0x04, 0x03, 0xBF, 0xC4, 0x04, 0xC1, 0xC4, 0x03, 0xC3, 0x84, 0x04,
 	0xC5, 0x83, 0x04, 0xC7, 0x44, 0x03, 0xC9, 0x04, 0x04, 0xCB, 0x04, 0x03,
 	0xCC, 0xC4, 0x04, 0xCE, 0xC3, 0x04, 0xD0, 0x84, 0x03, 0xD2, 0x44, 0x04,
 	0xD4, 0x43, 0x04, 0xD6, 0x04, 0x03, 0xD7, 0xC4, 0x04, 0xD9, 0xC3, 0x04,
 	0xDB, 0x84, 0x03, 0xDD, 0x44, 0x04, 0xDF, 0x43, 0x04, 0xE1, 0x04, 0x03,
 	0xE2, 0xC4, 0x03, 0xE4, 0x84, 0x04, 0xE6, 0x83, 0x04, 0xE8, 0x44, 0x03,
 	0xEA, 0x04, 0x04, 0xEC, 0x03, 0x04, 0xED, 0xC3, 0x04, 0xEF, 0x84, 0x03,
 	0xF1, 0x44, 0x04, 0xF3, 0x43, 0x04, 0xF5, 0x03, 0x04, 0xF6, 0xC4, 0x03,
 	0xF8, 0x84, 0x03, 0xFA, 0x44, 0x04, 0xFC, 0x43, 0x04, 0xFE, 0x03, 0x04,


};

unsigned char code GAMMA_2_B[] = {

	0x00, 0x07, 0x06, 0x03, 0x46, 0x05, 0x06, 0x06, 0x05, 0x08, 0xC5, 0x05,
 	0x0B, 0x45, 0x05, 0x0D, 0xC5, 0x05, 0x10, 0x45, 0x05, 0x12, 0xC5, 0x04,
 	0x15, 0x05, 0x05, 0x17, 0x84, 0x05, 0x19, 0xC5, 0x04, 0x1C, 0x05, 0x05,
 	0x1E, 0x84, 0x05, 0x20, 0xC4, 0x05, 0x23, 0x04, 0x05, 0x25, 0x44, 0x04,
 	0x27, 0x45, 0x04, 0x29, 0x85, 0x04, 0x2B, 0xC4, 0x05, 0x2E, 0x04, 0x04,
 	0x30, 0x05, 0x04, 0x32, 0x44, 0x05, 0x34, 0x84, 0x04, 0x36, 0x85, 0x04,
 	0x38, 0xC4, 0x04, 0x3A, 0xC4, 0x05, 0x3D, 0x04, 0x04, 0x3F, 0x04, 0x05,
 	0x41, 0x44, 0x04, 0x43, 0x44, 0x04, 0x45, 0x44, 0x05, 0x47, 0x84, 0x04,
 	0x49, 0x84, 0x04, 0x4B, 0x84, 0x04, 0x4D, 0x84, 0x04, 0x4F, 0x85, 0x04,
 	0x51, 0xC4, 0x04, 0x53, 0xC4, 0x04, 0x55, 0xC4, 0x04, 0x57, 0xC4, 0x04,
 	0x59, 0xC4, 0x04, 0x5B, 0xC4, 0x04, 0x5D, 0xC4, 0x04, 0x5F, 0xC4, 0x04,
 	0x61, 0xC4, 0x04, 0x63, 0xC4, 0x04, 0x65, 0xC4, 0x04, 0x67, 0xC4, 0x04,
 	0x69, 0xC4, 0x04, 0x6B, 0xC4, 0x04, 0x6D, 0xC4, 0x04, 0x6F, 0xC4, 0x04,
 	0x71, 0xC4, 0x04, 0x73, 0xC4, 0x03, 0x75, 0x84, 0x04, 0x77, 0x84, 0x04,
 	0x79, 0x84, 0x04, 0x7B, 0x84, 0x04, 0x7D, 0x84, 0x04, 0x7F, 0x83, 0x04,
 	0x81, 0x44, 0x04, 0x83, 0x44, 0x04, 0x85, 0x44, 0x03, 0x87, 0x04, 0x04,
 	0x89, 0x04, 0x04, 0x8B, 0x04, 0x04, 0x8D, 0x03, 0x04, 0x8E, 0xC4, 0x04,
 	0x90, 0xC4, 0x04, 0x92, 0xC3, 0x04, 0x94, 0x84, 0x04, 0x96, 0x84, 0x04,
 	0x98, 0x83, 0x04, 0x9A, 0x44, 0x04, 0x9C, 0x44, 0x03, 0x9E, 0x04, 0x04,
 	0xA0, 0x04, 0x03, 0xA1, 0xC4, 0x04, 0xA3, 0xC4, 0x04, 0xA5, 0xC3, 0x04,
 	0xA7, 0x84, 0x04, 0xA9, 0x83, 0x04, 0xAB, 0x44, 0x04, 0xAD, 0x43, 0x04,
 	0xAF, 0x04, 0x04, 0xB1, 0x03, 0x04, 0xB2, 0xC4, 0x04, 0xB4, 0xC3, 0x04,
 	0xB6, 0x84, 0x04, 0xB8, 0x83, 0x04, 0xBA, 0x44, 0x04, 0xBC, 0x43, 0x04,
 	0xBE, 0x04, 0x03, 0xBF, 0xC4, 0x04, 0xC1, 0xC4, 0x03, 0xC3, 0x84, 0x04,
 	0xC5, 0x83, 0x04, 0xC7, 0x44, 0x03, 0xC9, 0x04, 0x04, 0xCB, 0x04, 0x03,
 	0xCC, 0xC4, 0x04, 0xCE, 0xC3, 0x04, 0xD0, 0x84, 0x03, 0xD2, 0x44, 0x04,
 	0xD4, 0x43, 0x04, 0xD6, 0x04, 0x03, 0xD7, 0xC4, 0x04, 0xD9, 0xC3, 0x04,
 	0xDB, 0x84, 0x03, 0xDD, 0x44, 0x04, 0xDF, 0x43, 0x04, 0xE1, 0x04, 0x03,
 	0xE2, 0xC4, 0x03, 0xE4, 0x84, 0x04, 0xE6, 0x83, 0x04, 0xE8, 0x44, 0x03,
 	0xEA, 0x04, 0x04, 0xEC, 0x03, 0x04, 0xED, 0xC3, 0x04, 0xEF, 0x84, 0x03,
 	0xF1, 0x44, 0x04, 0xF3, 0x43, 0x04, 0xF5, 0x03, 0x04, 0xF6, 0xC4, 0x03,
 	0xF8, 0x84, 0x03, 0xFA, 0x44, 0x04, 0xFC, 0x43, 0x04, 0xFE, 0x03, 0x04,

};

unsigned char code GAMMA_3_R[] = {

	0x00, 0x01, 0x02, 0x00, 0xC2, 0x02, 0x01, 0xC2, 0x02, 0x02, 0xC3, 0x02,
  	0x04, 0x02, 0x03, 0x05, 0x42, 0x03, 0x06, 0x83, 0x02, 0x07, 0xC3, 0x03,
 	0x09, 0x42, 0x03, 0x0A, 0x83, 0x03, 0x0C, 0x03, 0x03, 0x0D, 0x83, 0x03,
 	0x0F, 0x03, 0x03, 0x10, 0x83, 0x03, 0x12, 0x03, 0x03, 0x13, 0x83, 0x03,
 	0x15, 0x04, 0x03, 0x16, 0xC3, 0x03, 0x18, 0x43, 0x04, 0x1A, 0x03, 0x03,
 	0x1B, 0x84, 0x03, 0x1D, 0x43, 0x04, 0x1F, 0x03, 0x03, 0x20, 0x84, 0x03,
 	0x22, 0x44, 0x03, 0x24, 0x04, 0x03, 0x25, 0xC4, 0x03, 0x27, 0x84, 0x03,
 	0x29, 0x44, 0x03, 0x2B, 0x04, 0x03, 0x2C, 0xC4, 0x04, 0x2E, 0xC3, 0x04,
 	0x30, 0x83, 0x04, 0x32, 0x44, 0x03, 0x34, 0x04, 0x04, 0x36, 0x04, 0x03,
 	0x37, 0xC4, 0x04, 0x39, 0xC3, 0x04, 0x3B, 0x84, 0x04, 0x3D, 0x84, 0x03,
 	0x3F, 0x44, 0x04, 0x41, 0x44, 0x04, 0x43, 0x43, 0x04, 0x45, 0x04, 0x04,
 	0x47, 0x04, 0x04, 0x49, 0x04, 0x04, 0x4B, 0x04, 0x03, 0x4C, 0xC4, 0x04,
 	0x4E, 0xC4, 0x04, 0x50, 0xC4, 0x04, 0x52, 0xC4, 0x04, 0x54, 0xC4, 0x04,
 	0x56, 0xC4, 0x04, 0x58, 0xC4, 0x04, 0x5A, 0xC4, 0x04, 0x5C, 0xC4, 0x04,
 	0x5E, 0xC4, 0x05, 0x61, 0x04, 0x04, 0x63, 0x04, 0x04, 0x65, 0x04, 0x04,
 	0x67, 0x04, 0x04, 0x69, 0x04, 0x05, 0x6B, 0x44, 0x04, 0x6D, 0x44, 0x04,
 	0x6F, 0x44, 0x05, 0x71, 0x84, 0x04, 0x73, 0x84, 0x04, 0x75, 0x85, 0x04,
 	0x77, 0xC4, 0x04, 0x79, 0xC5, 0x04, 0x7C, 0x04, 0x04, 0x7E, 0x05, 0x04,
 	0x80, 0x44, 0x04, 0x82, 0x45, 0x04, 0x84, 0x84, 0x05, 0x86, 0xC4, 0x04,
 	0x88, 0xC5, 0x04, 0x8B, 0x04, 0x05, 0x8D, 0x44, 0x04, 0x8F, 0x45, 0x04,
 	0x91, 0x84, 0x05, 0x93, 0xC4, 0x05, 0x96, 0x04, 0x04, 0x98, 0x05, 0x04,
 	0x9A, 0x45, 0x04, 0x9C, 0x84, 0x05, 0x9E, 0xC4, 0x05, 0xA1, 0x04, 0x05,
 	0xA3, 0x44, 0x04, 0xA5, 0x45, 0x04, 0xA7, 0x85, 0x04, 0xA9, 0xC5, 0x04,
 	0xAC, 0x05, 0x04, 0xAE, 0x45, 0x04, 0xB0, 0x85, 0x04, 0xB2, 0xC5, 0x04,
 	0xB5, 0x05, 0x04, 0xB7, 0x45, 0x04, 0xB9, 0x85, 0x05, 0xBC, 0x04, 0x05,
 	0xBE, 0x44, 0x05, 0xC0, 0x84, 0x05, 0xC2, 0xC5, 0x04, 0xC5, 0x05, 0x04,
 	0xC7, 0x45, 0x05, 0xC9, 0xC4, 0x05, 0xCC, 0x04, 0x05, 0xCE, 0x45, 0x04,
 	0xD0, 0x85, 0x05, 0xD3, 0x04, 0x05, 0xD5, 0x45, 0x04, 0xD7, 0x85, 0x05,
 	0xDA, 0x04, 0x05, 0xDC, 0x45, 0x04, 0xDE, 0x85, 0x05, 0xE1, 0x04, 0x05,
 	0xE3, 0x45, 0x04, 0xE5, 0x85, 0x05, 0xE8, 0x05, 0x04, 0xEA, 0x45, 0x05,
 	0xEC, 0xC4, 0x05, 0xEF, 0x05, 0x05, 0xF1, 0x84, 0x05, 0xF3, 0xC5, 0x05,
 	0xF6, 0x45, 0x04, 0xF8, 0x85, 0x05, 0xFB, 0x05, 0x04, 0xFD, 0x45, 0x05,


};

unsigned char code GAMMA_3_G[] = {



	0x00, 0x01, 0x02, 0x00, 0xC2, 0x02, 0x01, 0xC2, 0x02, 0x02, 0xC3, 0x02,
  	0x04, 0x02, 0x03, 0x05, 0x42, 0x03, 0x06, 0x83, 0x02, 0x07, 0xC3, 0x03,
 	0x09, 0x42, 0x03, 0x0A, 0x83, 0x03, 0x0C, 0x03, 0x03, 0x0D, 0x83, 0x03,
 	0x0F, 0x03, 0x03, 0x10, 0x83, 0x03, 0x12, 0x03, 0x03, 0x13, 0x83, 0x03,
 	0x15, 0x04, 0x03, 0x16, 0xC3, 0x03, 0x18, 0x43, 0x04, 0x1A, 0x03, 0x03,
 	0x1B, 0x84, 0x03, 0x1D, 0x43, 0x04, 0x1F, 0x03, 0x03, 0x20, 0x84, 0x03,
 	0x22, 0x44, 0x03, 0x24, 0x04, 0x03, 0x25, 0xC4, 0x03, 0x27, 0x84, 0x03,
 	0x29, 0x44, 0x03, 0x2B, 0x04, 0x03, 0x2C, 0xC4, 0x04, 0x2E, 0xC3, 0x04,
 	0x30, 0x83, 0x04, 0x32, 0x44, 0x03, 0x34, 0x04, 0x04, 0x36, 0x04, 0x03,
 	0x37, 0xC4, 0x04, 0x39, 0xC3, 0x04, 0x3B, 0x84, 0x04, 0x3D, 0x84, 0x03,
 	0x3F, 0x44, 0x04, 0x41, 0x44, 0x04, 0x43, 0x43, 0x04, 0x45, 0x04, 0x04,
 	0x47, 0x04, 0x04, 0x49, 0x04, 0x04, 0x4B, 0x04, 0x03, 0x4C, 0xC4, 0x04,
 	0x4E, 0xC4, 0x04, 0x50, 0xC4, 0x04, 0x52, 0xC4, 0x04, 0x54, 0xC4, 0x04,
 	0x56, 0xC4, 0x04, 0x58, 0xC4, 0x04, 0x5A, 0xC4, 0x04, 0x5C, 0xC4, 0x04,
 	0x5E, 0xC4, 0x05, 0x61, 0x04, 0x04, 0x63, 0x04, 0x04, 0x65, 0x04, 0x04,
 	0x67, 0x04, 0x04, 0x69, 0x04, 0x05, 0x6B, 0x44, 0x04, 0x6D, 0x44, 0x04,
 	0x6F, 0x44, 0x05, 0x71, 0x84, 0x04, 0x73, 0x84, 0x04, 0x75, 0x85, 0x04,
 	0x77, 0xC4, 0x04, 0x79, 0xC5, 0x04, 0x7C, 0x04, 0x04, 0x7E, 0x05, 0x04,
 	0x80, 0x44, 0x04, 0x82, 0x45, 0x04, 0x84, 0x84, 0x05, 0x86, 0xC4, 0x04,
 	0x88, 0xC5, 0x04, 0x8B, 0x04, 0x05, 0x8D, 0x44, 0x04, 0x8F, 0x45, 0x04,
 	0x91, 0x84, 0x05, 0x93, 0xC4, 0x05, 0x96, 0x04, 0x04, 0x98, 0x05, 0x04,
 	0x9A, 0x45, 0x04, 0x9C, 0x84, 0x05, 0x9E, 0xC4, 0x05, 0xA1, 0x04, 0x05,
 	0xA3, 0x44, 0x04, 0xA5, 0x45, 0x04, 0xA7, 0x85, 0x04, 0xA9, 0xC5, 0x04,
 	0xAC, 0x05, 0x04, 0xAE, 0x45, 0x04, 0xB0, 0x85, 0x04, 0xB2, 0xC5, 0x04,
 	0xB5, 0x05, 0x04, 0xB7, 0x45, 0x04, 0xB9, 0x85, 0x05, 0xBC, 0x04, 0x05,
 	0xBE, 0x44, 0x05, 0xC0, 0x84, 0x05, 0xC2, 0xC5, 0x04, 0xC5, 0x05, 0x04,
 	0xC7, 0x45, 0x05, 0xC9, 0xC4, 0x05, 0xCC, 0x04, 0x05, 0xCE, 0x45, 0x04,
 	0xD0, 0x85, 0x05, 0xD3, 0x04, 0x05, 0xD5, 0x45, 0x04, 0xD7, 0x85, 0x05,
 	0xDA, 0x04, 0x05, 0xDC, 0x45, 0x04, 0xDE, 0x85, 0x05, 0xE1, 0x04, 0x05,
 	0xE3, 0x45, 0x04, 0xE5, 0x85, 0x05, 0xE8, 0x05, 0x04, 0xEA, 0x45, 0x05,
 	0xEC, 0xC4, 0x05, 0xEF, 0x05, 0x05, 0xF1, 0x84, 0x05, 0xF3, 0xC5, 0x05,
 	0xF6, 0x45, 0x04, 0xF8, 0x85, 0x05, 0xFB, 0x05, 0x04, 0xFD, 0x45, 0x05,


};

unsigned char code GAMMA_3_B[] = {


	0x00, 0x01, 0x02, 0x00, 0xC2, 0x02, 0x01, 0xC2, 0x02, 0x02, 0xC3, 0x02,
  	0x04, 0x02, 0x03, 0x05, 0x42, 0x03, 0x06, 0x83, 0x02, 0x07, 0xC3, 0x03,
 	0x09, 0x42, 0x03, 0x0A, 0x83, 0x03, 0x0C, 0x03, 0x03, 0x0D, 0x83, 0x03,
 	0x0F, 0x03, 0x03, 0x10, 0x83, 0x03, 0x12, 0x03, 0x03, 0x13, 0x83, 0x03,
 	0x15, 0x04, 0x03, 0x16, 0xC3, 0x03, 0x18, 0x43, 0x04, 0x1A, 0x03, 0x03,
 	0x1B, 0x84, 0x03, 0x1D, 0x43, 0x04, 0x1F, 0x03, 0x03, 0x20, 0x84, 0x03,
 	0x22, 0x44, 0x03, 0x24, 0x04, 0x03, 0x25, 0xC4, 0x03, 0x27, 0x84, 0x03,
 	0x29, 0x44, 0x03, 0x2B, 0x04, 0x03, 0x2C, 0xC4, 0x04, 0x2E, 0xC3, 0x04,
 	0x30, 0x83, 0x04, 0x32, 0x44, 0x03, 0x34, 0x04, 0x04, 0x36, 0x04, 0x03,
 	0x37, 0xC4, 0x04, 0x39, 0xC3, 0x04, 0x3B, 0x84, 0x04, 0x3D, 0x84, 0x03,
 	0x3F, 0x44, 0x04, 0x41, 0x44, 0x04, 0x43, 0x43, 0x04, 0x45, 0x04, 0x04,
 	0x47, 0x04, 0x04, 0x49, 0x04, 0x04, 0x4B, 0x04, 0x03, 0x4C, 0xC4, 0x04,
 	0x4E, 0xC4, 0x04, 0x50, 0xC4, 0x04, 0x52, 0xC4, 0x04, 0x54, 0xC4, 0x04,
 	0x56, 0xC4, 0x04, 0x58, 0xC4, 0x04, 0x5A, 0xC4, 0x04, 0x5C, 0xC4, 0x04,
 	0x5E, 0xC4, 0x05, 0x61, 0x04, 0x04, 0x63, 0x04, 0x04, 0x65, 0x04, 0x04,
 	0x67, 0x04, 0x04, 0x69, 0x04, 0x05, 0x6B, 0x44, 0x04, 0x6D, 0x44, 0x04,
 	0x6F, 0x44, 0x05, 0x71, 0x84, 0x04, 0x73, 0x84, 0x04, 0x75, 0x85, 0x04,
 	0x77, 0xC4, 0x04, 0x79, 0xC5, 0x04, 0x7C, 0x04, 0x04, 0x7E, 0x05, 0x04,
 	0x80, 0x44, 0x04, 0x82, 0x45, 0x04, 0x84, 0x84, 0x05, 0x86, 0xC4, 0x04,
 	0x88, 0xC5, 0x04, 0x8B, 0x04, 0x05, 0x8D, 0x44, 0x04, 0x8F, 0x45, 0x04,
 	0x91, 0x84, 0x05, 0x93, 0xC4, 0x05, 0x96, 0x04, 0x04, 0x98, 0x05, 0x04,
 	0x9A, 0x45, 0x04, 0x9C, 0x84, 0x05, 0x9E, 0xC4, 0x05, 0xA1, 0x04, 0x05,
 	0xA3, 0x44, 0x04, 0xA5, 0x45, 0x04, 0xA7, 0x85, 0x04, 0xA9, 0xC5, 0x04,
 	0xAC, 0x05, 0x04, 0xAE, 0x45, 0x04, 0xB0, 0x85, 0x04, 0xB2, 0xC5, 0x04,
 	0xB5, 0x05, 0x04, 0xB7, 0x45, 0x04, 0xB9, 0x85, 0x05, 0xBC, 0x04, 0x05,
 	0xBE, 0x44, 0x05, 0xC0, 0x84, 0x05, 0xC2, 0xC5, 0x04, 0xC5, 0x05, 0x04,
 	0xC7, 0x45, 0x05, 0xC9, 0xC4, 0x05, 0xCC, 0x04, 0x05, 0xCE, 0x45, 0x04,
 	0xD0, 0x85, 0x05, 0xD3, 0x04, 0x05, 0xD5, 0x45, 0x04, 0xD7, 0x85, 0x05,
 	0xDA, 0x04, 0x05, 0xDC, 0x45, 0x04, 0xDE, 0x85, 0x05, 0xE1, 0x04, 0x05,
 	0xE3, 0x45, 0x04, 0xE5, 0x85, 0x05, 0xE8, 0x05, 0x04, 0xEA, 0x45, 0x05,
 	0xEC, 0xC4, 0x05, 0xEF, 0x05, 0x05, 0xF1, 0x84, 0x05, 0xF3, 0xC5, 0x05,
 	0xF6, 0x45, 0x04, 0xF8, 0x85, 0x05, 0xFB, 0x05, 0x04, 0xFD, 0x45, 0x05,

};

#elif( _GAMMA_TYPE == _FULL_GAMMA_COMPRESS_TABLE2)

unsigned char code GAMMA_1_R[] = {

	0x0, 0x3, 0x98, 0x79, 0x87, 0x98, 0x87, 0x98, 0x79, 0x88, 
	0x79, 0x87, 0x98, 0x87, 0x98, 0x79, 0x88, 0x7a, 0x88, 0x79, 
	0x78, 0x89, 0x78, 0x88, 0x97, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x79, 0x88, 0x88, 0x88, 0x87, 0x98, 0x88, 
	0x87, 0x98, 0x88, 0x87, 0x98, 0x88, 0x79, 0x88, 0x79, 0x88, 
	0x79, 0x88, 0x79, 0x88, 0x79, 0x87, 0x98, 0x87, 0x98, 0x79, 
	0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 
	0x98, 0x79, 0x87, 0x97, 0x98, 0x79, 0x87, 0x97, 0x98, 0x79, 
	0x79, 0x87, 0x97, 0x98, 0x79, 0x79, 0x87, 0x97, 0x98, 0x79, 
	0x79, 0x79, 0x87, 0x97, 0x97, 0x97, 0x98, 0x79, 0x79, 0x79, 
	0x79, 0x87, 0x97, 0x97, 0x97, 0x97, 0x97, 0x97, 0x98, 0x79, 
	0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 
	0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x87, 0x98, 

};

unsigned char code GAMMA_1_G[] = {

	0x0, 0x3, 0x97, 0x97, 0x98, 0x79, 0x79, 0x87, 0x97, 0x98, 
	0x79, 0x79, 0x87, 0x97, 0x98, 0x79, 0x79, 0x87, 0x88, 0x89, 
	0x78, 0x97, 0x89, 0x78, 0x97, 0x97, 0x97, 0x89, 0x79, 0x79, 
	0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 
	0x79, 0x79, 0x79, 0x87, 0x97, 0x97, 0x97, 0x98, 0x79, 0x79, 
	0x79, 0x79, 0x87, 0x97, 0x98, 0x79, 0x79, 0x79, 0x87, 0x97, 
	0x98, 0x79, 0x79, 0x87, 0x98, 0x79, 0x79, 0x87, 0x97, 0x98, 
	0x79, 0x87, 0x97, 0x98, 0x79, 0x87, 0x97, 0x98, 0x79, 0x87, 
	0x98, 0x79, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 
	0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 
	0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 
	0x87, 0x98, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 
	0x87, 0x98, 0x79, 0x87, 0x98, 0x87, 0x98, 0x79, 0x79, 

};

unsigned char code GAMMA_1_B[] = {

	0x0, 0x3, 0x98, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x89, 0x78, 0x88, 
	0x88, 0x89, 0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x97, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x87, 0x98, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x79, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x87, 0x98, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 


};

unsigned char code GAMMA_2_R[] = {



	0x0, 0x7, 0x78, 0x79, 0x78, 0x88, 0x88, 0x88, 0x88, 0x79, 
	0x87, 0x98, 0x79, 0x87, 0x97, 0x97, 0x97, 0x89, 0x79, 0x78, 
	0x97, 0x89, 0x78, 0x97, 0x89, 0x78, 0x88, 0x97, 0x88, 0x97, 
	0x88, 0x88, 0x97, 0x88, 0x88, 0x88, 0x89, 0x78, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x79, 0x88, 0x88, 0x88, 0x88, 
	0x87, 0x98, 0x88, 0x88, 0x79, 0x88, 0x88, 0x87, 0x98, 0x88, 
	0x87, 0x98, 0x88, 0x87, 0x98, 0x88, 0x79, 0x88, 0x79, 0x88, 
	0x87, 0x98, 0x87, 0x98, 0x87, 0x98, 0x87, 0x98, 0x87, 0x98, 
	0x87, 0x98, 0x87, 0x98, 0x79, 0x88, 0x79, 0x87, 0x98, 0x79, 
	0x88, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 
	0x79, 0x87, 0x98, 0x79, 0x79, 0x87, 0x98, 0x79, 0x87, 0x97, 
	0x98, 0x79, 0x87, 0x97, 0x98, 0x79, 0x79, 0x87, 0x97, 


};

unsigned char code GAMMA_2_G[] = {

	0x0, 0x7, 0x78, 0x79, 0x78, 0x88, 0x88, 0x88, 0x88, 0x79, 
	0x87, 0x98, 0x79, 0x87, 0x97, 0x97, 0x97, 0x89, 0x79, 0x78, 
	0x97, 0x89, 0x78, 0x97, 0x89, 0x78, 0x88, 0x97, 0x88, 0x97, 
	0x88, 0x88, 0x97, 0x88, 0x88, 0x88, 0x89, 0x78, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x79, 0x88, 0x88, 0x88, 0x88, 
	0x87, 0x98, 0x88, 0x88, 0x79, 0x88, 0x88, 0x87, 0x98, 0x88, 
	0x87, 0x98, 0x88, 0x87, 0x98, 0x88, 0x79, 0x88, 0x79, 0x88, 
	0x87, 0x98, 0x87, 0x98, 0x87, 0x98, 0x87, 0x98, 0x87, 0x98, 
	0x87, 0x98, 0x87, 0x98, 0x79, 0x88, 0x79, 0x87, 0x98, 0x79, 
	0x88, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 
	0x79, 0x87, 0x98, 0x79, 0x79, 0x87, 0x98, 0x79, 0x87, 0x97, 
	0x98, 0x79, 0x87, 0x97, 0x98, 0x79, 0x79, 0x87, 0x97, 


};

unsigned char code GAMMA_2_B[] = {

	0x0, 0x7, 0x78, 0x79, 0x78, 0x88, 0x88, 0x88, 0x88, 0x79, 
	0x87, 0x98, 0x79, 0x87, 0x97, 0x97, 0x97, 0x89, 0x79, 0x78, 
	0x97, 0x89, 0x78, 0x97, 0x89, 0x78, 0x88, 0x97, 0x88, 0x97, 
	0x88, 0x88, 0x97, 0x88, 0x88, 0x88, 0x89, 0x78, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x79, 0x88, 0x88, 0x88, 0x88, 
	0x87, 0x98, 0x88, 0x88, 0x79, 0x88, 0x88, 0x87, 0x98, 0x88, 
	0x87, 0x98, 0x88, 0x87, 0x98, 0x88, 0x79, 0x88, 0x79, 0x88, 
	0x87, 0x98, 0x87, 0x98, 0x87, 0x98, 0x87, 0x98, 0x87, 0x98, 
	0x87, 0x98, 0x87, 0x98, 0x79, 0x88, 0x79, 0x87, 0x98, 0x79, 
	0x88, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 
	0x79, 0x87, 0x98, 0x79, 0x79, 0x87, 0x98, 0x79, 0x87, 0x97, 
	0x98, 0x79, 0x87, 0x97, 0x98, 0x79, 0x79, 0x87, 0x97, 


};

unsigned char code GAMMA_3_R[] = {

	0x0, 0x1, 0x98, 0x88, 0x89, 0x78, 0x97, 0x98, 0x79, 0x87, 
	0x98, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x89, 0x78, 0x88, 
	0x97, 0x89, 0x78, 0x97, 0x89, 0x79, 0x79, 0x79, 0x79, 0x79, 
	0x79, 0x79, 0x87, 0x97, 0x98, 0x79, 0x88, 0x79, 0x87, 0x98, 
	0x88, 0x79, 0x88, 0x87, 0x98, 0x88, 0x88, 0x88, 0x79, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x97, 0x88, 
	0x88, 0x88, 0x88, 0x97, 0x88, 0x88, 0x97, 0x88, 0x89, 0x78, 
	0x89, 0x78, 0x89, 0x78, 0x89, 0x78, 0x97, 0x89, 0x78, 0x97, 
	0x89, 0x78, 0x97, 0x97, 0x89, 0x79, 0x78, 0x97, 0x97, 0x97, 
	0x89, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 
	0x87, 0x97, 0x97, 0x98, 0x79, 0x79, 0x87, 0x97, 0x98, 0x79, 
	0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x88, 
	0x79, 0x87, 0x98, 0x87, 0x98, 0x88, 0x79, 0x88, 0x79, 
		
};

unsigned char code GAMMA_3_G[] = {

	0x0, 0x1, 0x98, 0x88, 0x89, 0x78, 0x97, 0x98, 0x79, 0x87, 
	0x98, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x89, 0x78, 0x88, 
	0x97, 0x89, 0x78, 0x97, 0x89, 0x79, 0x79, 0x79, 0x79, 0x79, 
	0x79, 0x79, 0x87, 0x97, 0x98, 0x79, 0x88, 0x79, 0x87, 0x98, 
	0x88, 0x79, 0x88, 0x87, 0x98, 0x88, 0x88, 0x88, 0x79, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x97, 0x88, 
	0x88, 0x88, 0x88, 0x97, 0x88, 0x88, 0x97, 0x88, 0x89, 0x78, 
	0x89, 0x78, 0x89, 0x78, 0x89, 0x78, 0x97, 0x89, 0x78, 0x97, 
	0x89, 0x78, 0x97, 0x97, 0x89, 0x79, 0x78, 0x97, 0x97, 0x97, 
	0x89, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 
	0x87, 0x97, 0x97, 0x98, 0x79, 0x79, 0x87, 0x97, 0x98, 0x79, 
	0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x88, 
	0x79, 0x87, 0x98, 0x87, 0x98, 0x88, 0x79, 0x88, 0x79, 

};

unsigned char code GAMMA_3_B[] = {

	0x0, 0x1, 0x98, 0x88, 0x89, 0x78, 0x97, 0x98, 0x79, 0x87, 
	0x98, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x89, 0x78, 0x88, 
	0x97, 0x89, 0x78, 0x97, 0x89, 0x79, 0x79, 0x79, 0x79, 0x79, 
	0x79, 0x79, 0x87, 0x97, 0x98, 0x79, 0x88, 0x79, 0x87, 0x98, 
	0x88, 0x79, 0x88, 0x87, 0x98, 0x88, 0x88, 0x88, 0x79, 0x88, 
	0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x97, 0x88, 
	0x88, 0x88, 0x88, 0x97, 0x88, 0x88, 0x97, 0x88, 0x89, 0x78, 
	0x89, 0x78, 0x89, 0x78, 0x89, 0x78, 0x97, 0x89, 0x78, 0x97, 
	0x89, 0x78, 0x97, 0x97, 0x89, 0x79, 0x78, 0x97, 0x97, 0x97, 
	0x89, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 
	0x87, 0x97, 0x97, 0x98, 0x79, 0x79, 0x87, 0x97, 0x98, 0x79, 
	0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x87, 0x98, 0x79, 0x88, 
	0x79, 0x87, 0x98, 0x87, 0x98, 0x88, 0x79, 0x88, 0x79, 

};


#endif
//ICM customer data
//RUC : coordinate of R of U center line
//RVC : coordinate of R of V center line
//RUR : coordinate of R of U right line
//RVR : coordinate of R of V right line
//RUL : coordinate of R of U left line
//RVL : coordinate of R of V left line
SWORD code Video_TempUV1[5][6] = 
{//     {RUC, RVC, RUR, RVR, RUL, RVL}       
 /*R*/  {255, 510, 356, 309, 36, 510},
 /*G*/  {-510, 0 , -464, 92, -464, -92},
 /*B*/  {255, -510, 139, -510, 310, -400},
 /*Y*/  {-255, 510, -195, 510, -310, 400},
 /*C*/  {-255, -510, -310, -400, -139, -510},   
};


SWORD code Graphic_TempUV1[3][6] = 
{
 /*R*/  {255,  510, 437, 146, -170, 510},
 /*G*/  {-510, 0  , -340, 340, -340, -340},
 /*B*/  {255, -510, -170, -510, 355, -310},   
};

//DUS : Delta U when range smaller than 8
//DVS : Delta V when range smaller than 8
//DUL : Delta U when range larger than 8
//DVL : Delta V when range larger than 8
SWORD code TempUV2[15][4] =
{//             { DUS,  DVS,         DUL,    DVL}   
/*R_center*/    { 64-8, -128+16,  -128+16,   -48},
/*R_right*/	    { 64-8, -128+16,  -64+8,  128-16},
/*R_left*/	    {128-16, -48,     -128+16,   -48},

/*G_center*/	{64-8,  128-16,   64-8,   -128+16},
/*G_right*/	    {64-8,  128-16,   -64+8,   -128+16},
/*G_left*/	    {-64+8, 128-16,   64-8,   -128+16},

/*B_center*/    {-128+16, 48,    64-8,   128-16},
/*B_right*/   	{-128+16, 48,    128-16,  48},
/*B_left*/	    {-64+8, -128+16, 64-8, 128-16},

/*Y_center*/	{128-16,  -48,  -64+8,  -128+16},
/*Y_right*/  	{128-16,  -48,  -128+16,  -48},
/*Y_left*/	    {64-8,  128-16, -64+8, -128+16},

/*C_center*/	{-64+8, 128-16, 128-16,  48},
/*C_right*/	    {-64+8, 128-16, 64-8, -128+16},
/*C_left*/	    {-128+16, 48, 128-16, 48},
};


#else
extern code BYTE *tSU_COEF_TABLE[];
extern code BYTE *tSCALE_DOWN_COEF_TABLE[];

extern BYTE code tGAMMA_COMPACT1[];

extern unsigned char code GAMMA_1_R[];
extern unsigned char code GAMMA_1_G[];
extern unsigned char code GAMMA_1_B[];

extern unsigned char code GAMMA_2_R[];
extern unsigned char code GAMMA_2_G[];
extern unsigned char code GAMMA_2_B[];

extern unsigned char code GAMMA_3_R[];
extern unsigned char code GAMMA_3_G[];
extern unsigned char code GAMMA_3_B[];

extern SWORD code Video_TempUV1[5][6] ;
extern SWORD code Graphic_TempUV1[3][6];
extern SWORD code TempUV2[15][4];
#endif

//--------------------------------------------------
// Definitions of Contrast Range (Real Value)
//--------------------------------------------------
#define _CONTRAST_MAX                   178
#define _CONTRAST_MIN                   78


//----------------------------------------------------------------------------------------------------

#ifdef _ADJUST_CUSTOMER_C
//--------------------------------------------------
// Function Prototypes
//--------------------------------------------------
void CAdjustBrightness(void);
void CAdjustContrast(void);
void CAdjustYpbprhue(BYTE uchue);
void CAdjustYpbprSaturation(BYTE ucYPbPrSaturation);
#if(_AdjustCustomerColorMode==_ENABLE)
void CAdjustCustomerColorMode(void);
#endif
void CVideoSetSaturation(BYTE ucValue);
void CVideoSetContrast(BYTE ucValue);
void CAdjustSetHueUVDelta(BYTE color, BYTE select);
void CAdjustPeakingFilter(SBYTE ucPeaking);
void CAdjustPeakingCoding(void);
void CAdjustBacklight(void);
void CAdjustHueSatSet(BYTE color, SWORD TempU1, SWORD TempU2, SWORD TempV1, SWORD TempV2);
void CAdjustGammaTable(BYTE index);

#if(sRGB_Color_Enhance == _ENABLE)
void CAdjustSaturationHue(BYTE  ucValue, BOOL bSaturationIndex);
INT16 CAdjustCosine(INT16 fDegree);
INT16 CAdjustSine(INT16 fDegree);
void CAdjustMatrixMultiply(INT16 (*arrayA)[3], INT16 (*arrayB)[3], INT16 (*arrayC)[3]);
#endif

#if 0//(_SCAN_TYPE==_SEQUENTIAL_SCAN)
void CVideoFrameSync(void);
#endif

void CAdjustPeakingFilter(SBYTE ucPeaking);//eric 20070523
#else
//--------------------------------------------------
// Extern Function Prototypes
//--------------------------------------------------
//extern void CAdjustGamma(BYTE ucGammaTableType, BYTE *pGammaTableArrayR, BYTE *pGammaTableArrayG, BYTE *pGammaTableArrayB);
//extern void CAdjustSharpness(void);
extern void CAdjustPeakingFilter(SBYTE ucPeaking);//eric 20070523
extern void CAdjustBrightness(void);
extern void CAdjustContrast(void);
extern void CAdjustYpbprhue(BYTE uchue);
extern void CAdjustYpbprSaturation(BYTE ucYPbPrSaturation);
#if(_AdjustCustomerColorMode==_ENABLE)
extern void CAdjustCustomerColorMode(void);
#endif
extern void CVideoSetSaturation(BYTE ucValue);
extern void CVideoSetContrast(BYTE ucValue);
extern void CAdjustSetHueUVDelta(BYTE color, BYTE select);
extern void CAdjustPeakingCoding(void);
extern void CAdjustBacklight(void);
extern void CAdjustHueSatSet(BYTE color, SWORD TempU1, SWORD TempU2, SWORD TempV1, SWORD TempV2);
extern void CAdjustGammaTable(BYTE index);

#if(sRGB_Color_Enhance == _ENABLE)
extern void CAdjustSaturationHue(BYTE  ucValue, BOOL bSaturationIndex);
#endif

#if 0//(_SCAN_TYPE==_SEQUENTIAL_SCAN)
extern void CVideoFrameSync(void);
#endif

#endif


void CAdjustMZHueSat(BYTE color);
int CAdjustColorGammaCal(BYTE color, BYTE n);


