unit MyPION;

interface

  Uses Classes, Windows, SysUtils, Controls, MyClasses, MyControls, MyUtils,
       JPEG, ExtCtrls, Forms, MySource;

type

  PJPEGFrame  = ^TJPEGFrame;
  TJPEGFrame = packed record
    SizeOf    : integer;
    Lenght    : integer;
    Index     : integer;
    FrameSize : integer;
    Data      : array[0..0] of char;
  end;


  TMyPIONThread = class(TThread)
    private
      FMappHandle : THandle;
      FMappName   : string;
      FFrame      : TJPEGImage;
      FCamera     : string;
      FOnRegraw   : TThreadMethod;
      procedure SetCamera(ACamera:string);
    protected
      procedure Execute;override;
    public
      constructor Create(CreateSuspended: Boolean);
      destructor Destroy;override;
      property Camera   : string read FCamera write SetCamera;
      property Frame    : TJPEGImage read FFrame;
      property OnRedraw : TThreadMethod read FOnRegraw write FOnRegraw;
  end;

  TMyPIONCamera = class;

  TMyPIONFrame = class(TCustomControl)
    private
      FMyPIONCamera : TMyPIONCamera;
      FJPG          : TJPEGImage;
    protected
      procedure Paint;override;
    public
      constructor Create(AOwner:TComponent);override;
      property JPG  : TJPEGImage read FJPG;
  end;

  TMyPIONCamera = Class(TMyControl)
    private
      FPION   : TMyPIONThread;
      FCamera : array [0..16] of TCombineStringPart;
      procedure OnRedrawFrame;
    protected
      function GetControlClass : TMyControlClasses; override;
      procedure OnChangedSource(Sender:TMyClass); override;
    public
      procedure Init(XMLNode : OleVariant);override;
      function GetValueOf(Param:string):OleVariant; override;
      procedure SetValueOf(Param:string; Value:OleVariant); override;
      constructor Create(AOwner:TComponent);override;
      destructor Destroy;override;
  end;

implementation

{ TMyPIONThread }

procedure TMyPIONThread.SetCamera(ACamera:string);
begin

  if FCamera <> ACamera then
    begin
      FMappName := PChar(Format('Global\F%s', [NameToHex(ACamera)]));
      FCamera   := ACamera;
    end;

end;

procedure TMyPIONThread.Execute;
var
  JPEGBuffer  : PJPEGFrame;
  JPEGStream  : TMemoryStream;
  mtx         : THandle;
  OldIndex    : integer;
begin

  JPEGStream  := nil;
  OldIndex    := -1;
  CreateMutex(nil, false, 'PionLock');

  while not Terminated do
    begin

      Sleep(100);

      if FMappName = '' then
        continue;

      FMappHandle := OpenFileMapping(FILE_MAP_READ, true, PChar(FMappName));
      if (FMappHandle = INVALID_HANDLE_VALUE) or (FMappHandle=0) then
        continue;

      mtx := OpenMutex(MUTEX_ALL_ACCESS, false, 'PionLock');
      if (mtx<>0) then
        begin

          WaitForSingleObject(mtx,INFINITE);
          
          JPEGBuffer  := MapViewOfFile(FMappHandle, FILE_MAP_READ, 0, 0, 0);

          if Assigned(JPEGBuffer) and (OldIndex<>JPEGBuffer^.Index) then
            try

              JPEGStream  := TMemoryStream.Create;
              JPEGStream.SetSize(JPEGBuffer^.FrameSize);
              move(pointer(@JPEGBuffer^.Data[0])^, JPEGStream.Memory^, JPEGBuffer^.FrameSize);

              try

                FFrame.LoadFromStream(JPEGStream);

                if not Application.Terminated and Assigned(FOnRegraw) then
                  Synchronize(FOnRegraw);

              except
              end;

            finally
              JPEGStream.Free;
              UnmapViewOfFile(JPEGBuffer);
            end;

          ReleaseMutex(mtx);

        end;

      CloseHandle(FMappHandle);

      FMappHandle := INVALID_HANDLE_VALUE;

    end;

end;

constructor TMyPIONThread.Create(CreateSuspended: Boolean);
begin
  inherited;

  FCamera     := '';
  FMappHandle := INVALID_HANDLE_VALUE;
  FFrame      := TJPEGImage.Create;

end;


destructor TMyPIONThread.Destroy;
begin

  FFrame.Free;
  inherited;

end;

{TMyPIONFrame}
procedure TMyPIONFrame.Paint;
begin

  try

    if not FJPG.Empty then
      Canvas.StretchDraw(Rect(0,0,width,height),FJPG);

  except
  end;

end;

constructor TMyPIONFrame.Create(AOwner:TComponent);
begin

  inherited;

  FMyPIONCamera   := TMyPIONCamera(AOwner);
  FJPG            := TJPEGImage.Create;

end;

{ TMyPIONCamera }

function TMyPIONCamera.GetControlClass : TMyControlClasses;
begin

  result  := TMyPIONFrame;

end;

function TMyPIONCamera.GetValueOf(Param:string):OleVariant;
begin

  Param := UpperCase(Trim(Param));

  if Param='CAMERA' then
    result  := FPION.Camera
  else
    result  := inherited GetValueOf(Param);

end;

procedure TMyPIONCamera.OnChangedSource(Sender: TMyClass);
begin
  inherited;

  try
    FPION.Camera  := MakeValueFromCombineString(DataSource, FCamera);
  except
  end;
  
end;


procedure TMyPIONCamera.Init(XMLNode : OleVariant);
begin

  inherited;

  try

    ParseCombineString(XMLNode.getAttribute['camera'], FCamera);

    FPION.Camera  := MakeValueFromCombineString(DataSource, FCamera);
    
  except
  end;

end;


procedure TMyPIONCamera.SetValueOf(Param:string; Value:OleVariant);
begin

  Param := UpperCase(Trim(Param));

  if Param='CAMERA' then
    FPION.Camera  := Value
  else
    inherited SetValueOf(Param, Value);

end;

procedure TMyPIONCamera.OnRedrawFrame;
begin

  if not Application.Terminated and Assigned(TMyPIONFrame(Control).FJPG) and Control.Parent.Visible then
    begin
      TMyPIONFrame(Control).FJPG.Free;
      TMyPIONFrame(Control).FJPG  := TJPEGImage.Create;
      TMyPIONFrame(Control).FJPG.Assign(FPION.Frame);
      InvalidateRect(TMyPIONFrame(Control).Handle, nil, false);
    end

end;

constructor TMyPIONCamera.Create(AOwner: TComponent);
begin
  inherited;

  FPION   := TMyPIONThread.Create(false);
  FPION.OnRedraw  := OnRedrawFrame;
  ClearCombineString(FCamera);

end;

destructor TMyPIONCamera.Destroy;
begin

  FPION.Free;

  inherited;
  
end;

end.
