/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

typedef enum {
	TRACE_ENTRY      = 1,
	TRACE_EXIT       = 2,
	TRACE_INTERNAL   = 3,
	TRACE_ERROR      = 4,
	TRACE_EXIT_ERROR = 5
} SmlTraceType;

void  smlTrace      (SmlTraceType type, const gchar *message, ...);
void* smlTryMalloc0 (gsize n_bytes, GError **error);
void  smlSafeFree   (gpointer *address);
void  smlSafeCFree  (gchar **address);

const char *smlErrorTypeGetMessage(SmlErrorType type);

/** Solaris g_strdup_vprintf crashes on NULL strings.
 * Therefore a macro was introduced to sanitize string parameters.
 */
#define VA_STRING(param) param?param:"NULL"

#ifndef HAVE_GLIB_GCHECKSUM_H

gchar* sml_ds_tool_get_md5 (const gchar *data, gsize length, GError **error);

#endif

