/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#ifndef _TESTS_SUPPORT_H
#define _TESTS_SUPPORT_H

#include <config.h>

#include <check.h>
#include <libsyncml/sml_support.h>
#include <libsyncml/sml_parse.h>
#include <libsyncml/data_sync_api/sml_data_sync_change_item_internals.h>

void configure_environment();
void cleanup_environment();
char *setup_testbed(char *fkt_name);
void destroy_testbed(char *path);
void create_case(Suite *s, const char *name, TFun function);
SmlParser *start_parser(const char *data, GError **error);
int sml_sleep(int64_t nanoseconds);

#ifdef THREAD_SAFE_CHECK

	#define sml_fail_unless(expr, ...);\
		{\
			int _result = expr;\
			fail_unless(_result, ## __VA_ARGS__);\
			if (!_result) smlAssertMsg(0, g_strdup_printf(__VA_ARGS__));\
		}

#else

	/* If check is earlier than 0.9.7 then it is not thread safe. */

	extern GStaticMutex __libsyncml_check_mutex;

	#define sml_fail_unless(expr, ...);\
		{\
			int _result = expr;\
			g_static_mutex_lock(&__libsyncml_check_mutex);\
			fail_unless(_result, ## __VA_ARGS__);\
			g_static_mutex_unlock(&__libsyncml_check_mutex);\
		}
			/* disabled to avoid unwanted aborts
			 * if (!_result) smlAssertMsg(0, g_strdup_printf(__VA_ARGS__));\
			 */

	
#endif /* THREAD_SAFE_CHECK */

/* setup test cases */

#define SML_TESTCASE_START(x)	\
	const char *_unittest = (#x);	\
	struct sml_testcase_s sml_testcase[] = {

#define SML_TESTCASE_ADD(x) { (#x), x },

#define SML_TESTCASE_END			\
	{ NULL, NULL }				\
	};					\
						\
int main(int argc, char **argv)			\
{						\
        return sml_testsuite(argc, argv, _unittest, sml_testcase);	\
}

struct sml_testcase_s {
	const char *name;
	TFun func;
};


int sml_testsuite(
		int argc,
		char **argv,
		const char *unittest,
		struct sml_testcase_s *tc);

/* create and configure a datastore */

#define _SET_DATASTORE_RX_PREF(cttype,verct) \
	{ \
		GError *gerror = NULL; \
		SmlDevInfContentType *ct = NULL; \
		ct = sml_dev_inf_content_type_new(cttype, verct, &gerror); \
		sml_fail_unless(ct != NULL, "%s", gerror?gerror->message:"No GError set."); \
		sml_fail_unless(sml_dev_inf_data_store_set_rx_pref(datastore, ct, &gerror), "%s", gerror?gerror->message:"No GError set."); \
		g_object_unref(ct); \
		ct = NULL; \
	}

#define _SET_DATASTORE_TX_PREF(cttype,verct) \
	{ \
		GError *gerror = NULL; \
		SmlDevInfContentType *ct = NULL; \
		ct = sml_dev_inf_content_type_new(cttype, verct, &gerror); \
		sml_fail_unless(ct != NULL, "%s", gerror?gerror->message:"No GError set."); \
		sml_fail_unless(sml_dev_inf_data_store_set_tx_pref(datastore, ct, &gerror), "%s", gerror?gerror->message:"No GError set."); \
		g_object_unref(ct); \
		ct = NULL; \
	}

#define GET_ERROR_MESSAGE(error) error?error->message:"No GError set."

#define TEST_DATA_SYNC_CHANGE_ITEM __test_change_item
#define	TEST_DATA_SYNC_CHANGE_ITEM_NEW(type,uid,data,size,ct) \
	{ \
		SmlDataSyncChangeItem *TEST_DATA_SYNC_CHANGE_ITEM = sml_data_sync_change_item_new(); \
		sml_fail_unless(TEST_DATA_SYNC_CHANGE_ITEM != NULL, "Cannot create new SmlDataSyncChangeItem object."); \
		SmlLocation *_t_loc = sml_location_new(); \
		sml_fail_unless(_t_loc != NULL, "Cannot create new SmlLocation object."); \
		sml_location_set_uri(_t_loc, uid); \
		sml_fail_unless(sml_data_sync_change_item_set_location(TEST_DATA_SYNC_CHANGE_ITEM, _t_loc, &error), "%s", error?error->message:"No GError set."); \
		sml_fail_unless(error == NULL, NULL); \
		if (data) \
			sml_data_sync_change_item_set_data(TEST_DATA_SYNC_CHANGE_ITEM, data, size, &error); \
		sml_fail_unless(error == NULL, NULL); \
		sml_data_sync_change_item_set_content_type(TEST_DATA_SYNC_CHANGE_ITEM, ct, &error); \
		sml_fail_unless(error == NULL, NULL); \
		sml_data_sync_change_item_set_action(TEST_DATA_SYNC_CHANGE_ITEM, type);
#define TEST_DATA_SYNC_CHANGE_ITEM_FREE() \
		g_object_unref(TEST_DATA_SYNC_CHANGE_ITEM); \
	}


#endif // _TESTS_SUPPORT_H
