/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#include "tests/support.h"

#include <libsyncml/syncml.h>
#include <libsyncml/sml_error_internals.h>

START_TEST (error_create)
{
	setup_testbed(NULL);
	
	GError *error = NULL;
	g_set_error(&error, SML_ERROR, SML_ERROR_GENERIC, "test%i", 1);
	sml_fail_unless(error != NULL, NULL);
	sml_fail_unless(error->code == SML_ERROR_GENERIC, "Unexpected error code %d.", error->code);
	sml_fail_unless(!strcmp(error->message, "test1"), "unexpected error message %s", error->message);
	
	SML_ERROR_FREE(error);
	sml_fail_unless(error == NULL, NULL);
}
END_TEST

START_TEST (error_create_null)
{
	setup_testbed(NULL);
	
	SML_SET_ERROR(NULL, SML_ERROR_GENERIC, "test%i", 1);
}
END_TEST

START_TEST (error_free_null)
{
	setup_testbed(NULL);

	GError *error = NULL;
	SML_ERROR_FREE(error);
}
END_TEST

START_TEST (error_free_null2)
{
	setup_testbed(NULL);
	
	GError *error = NULL;
	SML_ERROR_FREE(error);
}
END_TEST

START_TEST (error_free)
{
	setup_testbed(NULL);
	
	GError *error = NULL;
	SML_SET_ERROR(&error, SML_ERROR_GENERIC, "test");
	sml_fail_unless(error != NULL, NULL);
	SML_ERROR_FREE(error);
	sml_fail_unless(error == NULL, NULL);
}
END_TEST

START_TEST (error_set_null)
{
	setup_testbed(NULL);
	
	SML_SET_ERROR(NULL, SML_NO_ERROR, NULL);

}
END_TEST

START_TEST (error_duplicate_null)
{
	setup_testbed(NULL);
	
	GError *duplicate = g_error_copy(NULL);
	sml_fail_unless(duplicate == NULL, NULL);
}
END_TEST

START_TEST (error_class)
{
	setup_testbed(NULL);
	
	sml_fail_unless(smlErrorGetClass(NULL) == SML_ERRORCLASS_SUCCESS, NULL);
	
	GError *error = NULL;
	sml_fail_unless(smlErrorGetClass(&error) == SML_ERRORCLASS_SUCCESS, NULL);
	
	SML_SET_ERROR(&error, SML_NO_ERROR, "test%i", 1);
	sml_fail_unless(smlErrorGetClass(&error) == SML_ERRORCLASS_SUCCESS, NULL);
	SML_ERROR_FREE(error);
	
	SML_SET_ERROR(&error, SML_ERROR_SEE_OTHER_RETRY, "test%i", 1);
	sml_fail_unless(smlErrorGetClass(&error) == SML_ERRORCLASS_RETRY, NULL);
	SML_ERROR_FREE(error);
	
	SML_SET_ERROR(&error, SML_ERROR_GENERIC, "test%i", 1);
	sml_fail_unless(smlErrorGetClass(&error) == SML_ERRORCLASS_FATAL, NULL);
	SML_ERROR_FREE(error);
	
	sml_fail_unless(error == NULL, NULL);
}
END_TEST

@SML_TESTCASE_CODE@

