/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#include "tests/support.h"

#include <libsyncml/dev_inf_api/sml_dev_inf_prop_param.h>

START_TEST (dev_inf_prop_param_create)
{
	setup_testbed(NULL);

	SmlDevInfPropParam *propParam = sml_dev_inf_prop_param_new();
	sml_fail_unless(propParam != NULL, NULL);
	g_object_unref(propParam);
}
END_TEST

START_TEST (dev_inf_prop_param_empty_set)
{
	setup_testbed(NULL);

	GError *error = NULL;
	SmlDevInfPropParam *propParam = sml_dev_inf_prop_param_new();
	sml_fail_unless(propParam != NULL, NULL);

	/* enforce parameter name */

	sml_fail_unless(sml_dev_inf_prop_param_set_param_name(propParam, NULL, &error) == FALSE, "A parameter must have a name.");
	sml_fail_unless(error != NULL, "The error must be set if an error appears.");
	g_error_free(error);
	error = NULL;

	sml_fail_unless(sml_dev_inf_prop_param_set_param_name(propParam, "", &error) == FALSE, "A parameter must have a name.");
	sml_fail_unless(error != NULL, "The error must be set if an error appears.");
	g_error_free(error);
	error = NULL;

	sml_fail_unless(sml_dev_inf_prop_param_set_param_name(propParam, NULL, &error) == FALSE, "A parameter must have a name.");
	sml_fail_unless(error != NULL, "The error must be set if an error appears.");
	g_error_free(error);
	error = NULL;

	/* test the normal properties */

	sml_fail_unless(sml_dev_inf_prop_param_set_data_type(propParam, NULL, &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_set_data_type(propParam, "", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_set_data_type(propParam, NULL, &error), "%s", error?error->message:"No GError set.");

	sml_fail_unless(sml_dev_inf_prop_param_set_display_name(propParam, NULL, &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_set_display_name(propParam, "", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_set_display_name(propParam, NULL, &error), "%s", error?error->message:"No GError set.");

	/* ValEnums does not accept empty values */

	sml_fail_unless(sml_dev_inf_prop_param_add_val_enum(propParam, NULL, &error) == FALSE, "ValEnums must be not empty.");
	sml_fail_unless(error != NULL, "The error must be set if an error appears.");
	g_error_free(error);
	error = NULL;

	sml_fail_unless(sml_dev_inf_prop_param_add_val_enum(propParam, "", &error) == FALSE, "ValEnums must be not empty.");
	sml_fail_unless(error != NULL, "The error must be set if an error appears.");
	g_error_free(error);
	error = NULL;

	sml_fail_unless(sml_dev_inf_prop_param_add_val_enum(propParam, NULL, &error) == FALSE, "ValEnums must be not empty.");
	sml_fail_unless(error != NULL, "The error must be set if an error appears.");
	g_error_free(error);
	error = NULL;

	g_object_unref(propParam);
}
END_TEST

START_TEST (dev_inf_prop_param_empty_get)
{
	setup_testbed(NULL);

	GError *error = NULL;
	SmlDevInfPropParam *propParam = sml_dev_inf_prop_param_new();
	sml_fail_unless(propParam != NULL, NULL);

	/* enforce parameter name */

	sml_fail_unless(sml_dev_inf_prop_param_get_param_name(propParam) == NULL, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_set_param_name(propParam, NULL, &error) == FALSE, "The parameter name must be set.");
	sml_fail_unless(error != NULL, "The error must be set if an error appears.");
	g_error_free(error);
	error = NULL;

	sml_fail_unless(sml_dev_inf_prop_param_get_param_name(propParam) == NULL, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_set_param_name(propParam, "", &error) == FALSE, "The parameter name must be set.");
	sml_fail_unless(error != NULL, "The error must be set if an error appears.");
	g_error_free(error);
	error = NULL;

	sml_fail_unless(sml_dev_inf_prop_param_get_param_name(propParam) == NULL, NULL);

	/* test the normal properties */

	sml_fail_unless(sml_dev_inf_prop_param_get_data_type(propParam) == NULL, NULL);
	sml_fail_unless(sml_dev_inf_prop_param_set_data_type(propParam, NULL, &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_get_data_type(propParam) == NULL, NULL);
	sml_fail_unless(sml_dev_inf_prop_param_set_data_type(propParam, "", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_get_data_type(propParam) == NULL, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_get_display_name(propParam) == NULL, NULL);
	sml_fail_unless(sml_dev_inf_prop_param_set_display_name(propParam, NULL, &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_get_display_name(propParam) == NULL, NULL);
	sml_fail_unless(sml_dev_inf_prop_param_set_display_name(propParam, "", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_get_display_name(propParam) == NULL, NULL);

	/* ValEnums does not accept empty values */

	sml_fail_unless(sml_dev_inf_prop_param_num_val_enums(propParam) == 0, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_add_val_enum(propParam, NULL, &error) == FALSE, "The parameter name must be set.");
	sml_fail_unless(error != NULL, "The error must be set if an error appears.");
	g_error_free(error);
	error = NULL;

	sml_fail_unless(sml_dev_inf_prop_param_num_val_enums(propParam) == 0, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_add_val_enum(propParam, "", &error) == FALSE, "The parameter name must be set.");
	sml_fail_unless(error != NULL, "The error must be set if an error appears.");
	g_error_free(error);
	error = NULL;

	sml_fail_unless(sml_dev_inf_prop_param_num_val_enums(propParam) == 0, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_add_val_enum(propParam, "value", &error), "%s", error?error->message:"No GError set.");

	sml_fail_unless(sml_dev_inf_prop_param_num_val_enums(propParam) == 1, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_add_val_enum(propParam, NULL, &error) == FALSE, "The parameter name must be set.");
	sml_fail_unless(error != NULL, "The error must be set if an error appears.");
	g_error_free(error);
	error = NULL;

	sml_fail_unless(sml_dev_inf_prop_param_num_val_enums(propParam) == 1, NULL);

	g_object_unref(propParam);
}
END_TEST

START_TEST (dev_inf_prop_param_filled_set)
{
	setup_testbed(NULL);

	GError *error = NULL;
	SmlDevInfPropParam *propParam = sml_dev_inf_prop_param_new();
	sml_fail_unless(propParam != NULL, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_set_param_name(propParam, "property parameter name", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_set_data_type(propParam, "property parameter data type", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_set_display_name(propParam, "property parameter display name", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_add_val_enum(propParam, "property parameter first value of enumeration", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_add_val_enum(propParam, "property parameter second value of enumeration", &error), "%s", error?error->message:"No GError set.");

	g_object_unref(propParam);
}
END_TEST

START_TEST (dev_inf_prop_param_filled_get)
{
	setup_testbed(NULL);

	GError *error = NULL;
	SmlDevInfPropParam *propParam = sml_dev_inf_prop_param_new();
	sml_fail_unless(propParam != NULL, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_get_param_name(propParam) == NULL, NULL);
	sml_fail_unless(sml_dev_inf_prop_param_set_param_name(propParam, "test_1", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_get_param_name(propParam) != NULL, NULL);
	sml_fail_unless(strcmp(sml_dev_inf_prop_param_get_param_name(propParam), "test_1") == 0, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_get_data_type(propParam) == NULL, NULL);
	sml_fail_unless(sml_dev_inf_prop_param_set_data_type(propParam, "test_2", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_get_data_type(propParam) != NULL, NULL);
	sml_fail_unless(strcmp(sml_dev_inf_prop_param_get_data_type(propParam), "test_2") == 0, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_get_display_name(propParam) == NULL, NULL);
	sml_fail_unless(sml_dev_inf_prop_param_set_display_name(propParam, "test_3", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_get_display_name(propParam) != NULL, NULL);
	sml_fail_unless(strcmp(sml_dev_inf_prop_param_get_display_name(propParam), "test_3") == 0, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_num_val_enums(propParam) == 0, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_add_val_enum(propParam, "test_4", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_num_val_enums(propParam) == 1, NULL);
	sml_fail_unless(sml_dev_inf_prop_param_get_nth_val_enum(propParam, 0) != NULL, NULL);
	sml_fail_unless(strcmp(sml_dev_inf_prop_param_get_nth_val_enum(propParam, 0), "test_4") == 0, NULL);

	sml_fail_unless(sml_dev_inf_prop_param_add_val_enum(propParam, "test_5", &error), "%s", error?error->message:"No GError set.");
	sml_fail_unless(sml_dev_inf_prop_param_num_val_enums(propParam) == 2, NULL);
	sml_fail_unless(sml_dev_inf_prop_param_get_nth_val_enum(propParam, 0) != NULL, NULL);
	sml_fail_unless(strcmp(sml_dev_inf_prop_param_get_nth_val_enum(propParam, 0), "test_4") == 0, NULL);
	sml_fail_unless(sml_dev_inf_prop_param_get_nth_val_enum(propParam, 1) != NULL, NULL);
	sml_fail_unless(strcmp(sml_dev_inf_prop_param_get_nth_val_enum(propParam, 1), "test_5") == 0, NULL);

	g_object_unref(propParam);
}
END_TEST

START_TEST (dev_inf_prop_param_references)
{
	setup_testbed(NULL);

	GError *error = NULL;
	SmlDevInfPropParam *propParam = sml_dev_inf_prop_param_new();
	sml_fail_unless(propParam != NULL, "Cannot create SmlDevInfPropParam.");
	sml_fail_unless(sml_dev_inf_prop_param_set_param_name(propParam, "test name", &error), "%s", error?error->message:"No GError set.");

	g_object_ref(propParam);

	sml_fail_unless(sml_dev_inf_prop_param_get_param_name(propParam) != NULL, "The property parameter name was not set.");

	g_object_unref(propParam);

	sml_fail_unless(sml_dev_inf_prop_param_get_param_name(propParam) != NULL, "The property parameter name is already cleaned up.");

	g_object_unref(propParam);
}
END_TEST

@SML_TESTCASE_CODE@

