/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#include "tests/support.h"

#include <libsyncml/dev_inf_api/sml_dev_inf_content_type.h>

START_TEST (dev_inf_content_type_create)
{
	setup_testbed(NULL);

	GError *error = NULL;
	SmlDevInfContentType *ct = sml_dev_inf_content_type_new(NULL, NULL, &error);
	sml_fail_unless(ct != NULL, "%s", error?error->message:"No GError set.");
	g_object_unref(ct);

	ct = sml_dev_inf_content_type_new("text/plain", NULL, &error);
	sml_fail_unless(ct != NULL, "%s", error?error->message:"No GError set.");
	g_object_unref(ct);
	
	ct = sml_dev_inf_content_type_new(NULL, "2.1", &error);
	sml_fail_unless(ct != NULL, "%s", error?error->message:"No GError set.");
	g_object_unref(ct);
	
	ct = sml_dev_inf_content_type_new("text/x-vCalendar", "1.0", &error);
	sml_fail_unless(ct != NULL, "%s", error?error->message:"No GError set.");
	g_object_unref(ct);
}
END_TEST

START_TEST (dev_inf_content_type_empty_get)
{
	setup_testbed(NULL);

	GError *error = NULL;
	SmlDevInfContentType *ct = sml_dev_inf_content_type_new(NULL, NULL, &error);
	sml_fail_unless(ct != NULL, "%s", error?error->message:"No GError set.");

	sml_fail_unless(sml_dev_inf_content_type_get_cttype(ct) == NULL, NULL);
	sml_fail_unless(sml_dev_inf_content_type_get_verct(ct) == NULL, NULL);

	g_object_unref(ct);
}
END_TEST

START_TEST (dev_inf_content_type_filled_get)
{
	setup_testbed(NULL);

	GError *error = NULL;
	SmlDevInfContentType *ct = sml_dev_inf_content_type_new("text/x-vCalendar", "1.0", &error);
	sml_fail_unless(ct != NULL, "%s", error?error->message:"No GError set.");

	sml_fail_unless(sml_dev_inf_content_type_get_cttype(ct) != NULL, NULL);
	sml_fail_unless(sml_dev_inf_content_type_get_verct(ct) != NULL, NULL);

	g_object_unref(ct);
}
END_TEST

START_TEST (dev_inf_content_type_references)
{
	setup_testbed(NULL);

	GError *error = NULL;
	SmlDevInfContentType *ct = sml_dev_inf_content_type_new("text/x-vCalendar", "1.0", &error);
	sml_fail_unless(ct != NULL, "%s", error?error->message:"No GError set.");

	g_object_ref(ct);

	sml_fail_unless(sml_dev_inf_content_type_get_cttype(ct) != NULL, NULL);
	sml_fail_unless(sml_dev_inf_content_type_get_verct(ct) != NULL, NULL);

	g_object_unref(ct);

	sml_fail_unless(sml_dev_inf_content_type_get_cttype(ct) != NULL, NULL);
	sml_fail_unless(sml_dev_inf_content_type_get_verct(ct) != NULL, NULL);

	g_object_unref(ct);
}
END_TEST

@SML_TESTCASE_CODE@

