/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _OBEX_SERVER_INTERNALS_H_
#define _OBEX_SERVER_INTERNALS_H_

#include "obex_bluetooth.h"
#include <openobex/obex.h>

#include <config.h>

#define STREAM_CHUNK 4096

typedef struct SmlTransportObexServerEnv {
	SmlTransportConnectionType type;
	SmlTransport *tsp;
	gchar *path;
	uint16_t port;
#ifdef ENABLE_BLUETOOTH
	bdaddr_t *bdaddr;
#endif
	gchar *irda_service;
	
	obex_t *handle;

	GSource *source;
	GSourceFuncs *functions;
	
	uint32_t lastConId;
} SmlTransportObexServerEnv;

typedef struct SmlLinkObexServerEnv {
	SmlLink *link;
	SmlTransportObexServerEnv *env;
	uint32_t conid;
	obex_t *handle;
	uint8_t *stream_chunk;
	gboolean destroy;
	gboolean disconnect;
	GSource *source;
	GError *error;
	SmlTransportData *send_data;
} SmlLinkObexServerEnv;

gboolean smlTransportObexServerNew (SmlTransport *tsp, GError **error);

#endif //_OBEX_SERVER_INTERNALS_H_
