/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _HTTP_SERVER_INTERNALS_H_
#define _HTTP_SERVER_INTERNALS_H_

#include <config.h>
 
#include <libsoup/soup-uri.h>
#include <libsoup/soup-server.h>
#ifdef HAVE_LIBSOUP22
#include <libsoup/soup-server-message.h>
#else
#include <libsoup/soup-message.h>
#endif

typedef struct SmlTransportHttpServerEnv {
#ifdef HAVE_LIBSOUP22
	SoupUri *uri;
#else
	SoupURI *uri;
#endif
	SoupServer *server;
	SmlTransport *tsp;
	guint16 port;
	char *url;
	char *ssl_cert;
	char *ssl_key;

	/* session protection via ResponseURI */
	GHashTable *sessionToUri;
	GHashTable *uriToLink;
} SmlTransportHttpServerEnv;

typedef struct SmlLinkHttpServerEnv {
	SoupMessage *msg;
	SmlTransportHttpServerEnv *env;
	SmlSession *session;
	char *url;
	SmlLink *link;
} SmlLinkHttpServerEnv;

gboolean smlTransportHttpServerNew (SmlTransport *tsp, GError **error);

#endif //_HTTP_SERVER_INTERNALS_H_
