/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#ifndef _SML_SUPPORT_H_
#define _SML_SUPPORT_H_

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>

extern GPrivate* thread_id;

/*! @ingroup SmlDebugAPI
 * @brief The type of the trace */
typedef enum {
	/** Used when entering a function. This will indent the callgraph */
	TRACE_ENTRY      = 1,
	/** Used when exiting a function. This will unindent the callgraph */
	TRACE_EXIT       = 2,
	/** Used for traces inside a function. Does not indent. */
	TRACE_INTERNAL   = 3,
	/** Used for reporting errors. Does not ident. */
	TRACE_ERROR      = 4,
	/** Used when exiting a function with a error. This will unindent the callgraph */
	TRACE_EXIT_ERROR = 5
} SmlTraceType;

/** Solaris g_strdup_vprintf crashes on NULL strings.
 * Therefore a macro was introduced to sanitize string parameters.
 */
#define VA_STRING(param) param?param:"NULL"

void smlLog           (const gchar *logname, const gchar *data, gsize size);
void smlTrace         (SmlTraceType type, const gchar *message, ...);
gchar* smlPrintBinary (const gchar *data, gsize len);
gchar* smlPrintHex    (const gchar *data, gsize len);
gchar* smlRandStr     (gsize maxlength, gboolean exact);
void* smlTryMalloc0   (gsize n_bytes, GError **error);

void smlSafeFree  (gpointer *address);
void smlSafeCFree (gchar **address);

#if defined(sun) && defined(__SVR4)
#define __FUNCTION__ __func__
#endif

#define smlAssert(x) if (!(x)) { fprintf(stderr, "%s:%i:E:%s: Assertion \"" #x "\" failed\n", __FILE__, __LINE__, __FUNCTION__); abort();}
#define smlAssertMsg(x, msg) if (!(x)) { fprintf(stderr, "%s:%i:E:%s: %s\n", __FILE__, __LINE__, __FUNCTION__, msg); abort();}
#define segfault_me char **blablabla = NULL; *blablabla = "test";

#endif //_SML_SUPPORT_H_
